/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.IntegrationTestBase;
import org.apache.hadoop.hbase.IntegrationTestDDLMasterFailover;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestIntegrationTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestIntegrationTestBase.class);

    @Test
    public void testMonkeyPropertiesParsing() {
        Configuration conf = new Configuration(false);
        conf.set("batch.restart.rs.ratio", "0.85");
        conf.set("move.regions.max.time", "60000");
        conf.set("hbase.rootdir", "/foo/bar/baz");
        Properties props = new Properties();
        IntegrationTestDDLMasterFailover testBase = new IntegrationTestDDLMasterFailover();
        Assert.assertEquals((long)0L, (long)props.size());
        IntegrationTestBase.loadMonkeyProperties(props, conf);
        Assert.assertEquals((long)2L, (long)props.size());
        Assert.assertEquals((Object)"0.85", (Object)props.getProperty("batch.restart.rs.ratio"));
        Assert.assertEquals((Object)"60000", (Object)props.getProperty("move.regions.max.time"));
    }
}

