/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.compress;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Comparator;
import java.util.NavigableSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.compress.ByteBuffDecompressionCodec;
import org.apache.hadoop.hbase.io.compress.ByteBuffDecompressor;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.DoNotPool;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hbase.thirdparty.com.google.common.cache.CacheBuilder;
import org.apache.hbase.thirdparty.com.google.common.cache.CacheLoader;
import org.apache.hbase.thirdparty.com.google.common.cache.LoadingCache;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class CodecPool {
    private static final Logger LOG = LoggerFactory.getLogger(CodecPool.class);
    private static final ConcurrentMap<Class<Compressor>, NavigableSet<Compressor>> COMPRESSOR_POOL = new ConcurrentHashMap<Class<Compressor>, NavigableSet<Compressor>>();
    private static final ConcurrentMap<Class<Decompressor>, NavigableSet<Decompressor>> DECOMPRESSOR_POOL = new ConcurrentHashMap<Class<Decompressor>, NavigableSet<Decompressor>>();
    private static final ConcurrentMap<Class<ByteBuffDecompressor>, NavigableSet<ByteBuffDecompressor>> BYTE_BUFF_DECOMPRESSOR_POOL = new ConcurrentHashMap<Class<ByteBuffDecompressor>, NavigableSet<ByteBuffDecompressor>>();
    @Nullable
    private static LoadingCache<Class<Compressor>, AtomicInteger> compressorCounts = null;
    @Nullable
    private static LoadingCache<Class<Decompressor>, AtomicInteger> decompressorCounts = null;

    private static <T> LoadingCache<Class<T>, AtomicInteger> createCache() {
        return CacheBuilder.newBuilder().build(new CacheLoader<Class<T>, AtomicInteger>(){

            @Override
            public AtomicInteger load(Class<T> key) throws Exception {
                return new AtomicInteger();
            }
        });
    }

    static void initLeaseCounting() {
        compressorCounts = CodecPool.createCache();
        decompressorCounts = CodecPool.createCache();
    }

    private static <T> T borrow(ConcurrentMap<Class<T>, NavigableSet<T>> pool, Class<? extends T> codecClass) {
        if (codecClass == null) {
            return null;
        }
        NavigableSet codecSet = (NavigableSet)pool.get(codecClass);
        if (codecSet != null) {
            return (T)codecSet.pollFirst();
        }
        return null;
    }

    private static <T> boolean payback(ConcurrentMap<Class<T>, NavigableSet<T>> pool, T codec) {
        if (codec != null) {
            Class codecClass = ReflectionUtils.getClass(codec);
            Set codecSet = pool.computeIfAbsent(codecClass, k -> new ConcurrentSkipListSet<Object>(Comparator.comparingInt(System::identityHashCode)));
            return codecSet.add(codec);
        }
        return false;
    }

    private static <T> int getLeaseCount(LoadingCache<Class<T>, AtomicInteger> usageCounts, Class<? extends T> codecClass) {
        return usageCounts.getUnchecked(codecClass).get();
    }

    private static <T> void updateLeaseCount(LoadingCache<Class<T>, AtomicInteger> usageCounts, T codec, int delta) {
        if (codec != null && usageCounts != null) {
            Class codecClass = ReflectionUtils.getClass(codec);
            usageCounts.getUnchecked(codecClass).addAndGet(delta);
        }
    }

    public static Compressor getCompressor(CompressionCodec codec, Configuration conf) {
        Compressor compressor = (Compressor)CodecPool.borrow(COMPRESSOR_POOL, codec.getCompressorType());
        if (compressor == null) {
            compressor = codec.createCompressor();
            LOG.info("Got brand-new compressor [" + codec.getDefaultExtension() + "]");
        } else {
            compressor.reinit(conf);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Got recycled compressor");
            }
        }
        if (compressor != null && !compressor.getClass().isAnnotationPresent(DoNotPool.class)) {
            CodecPool.updateLeaseCount(compressorCounts, compressor, 1);
        }
        return compressor;
    }

    public static Compressor getCompressor(CompressionCodec codec) {
        return CodecPool.getCompressor(codec, null);
    }

    public static Decompressor getDecompressor(CompressionCodec codec) {
        Decompressor decompressor = (Decompressor)CodecPool.borrow(DECOMPRESSOR_POOL, codec.getDecompressorType());
        if (decompressor == null) {
            decompressor = codec.createDecompressor();
            LOG.debug("Got brand-new Decompressor [{}]", (Object)decompressor.getClass().getName());
        } else {
            LOG.debug("Got recycled Decompressor [{}]", (Object)decompressor.getClass().getName());
        }
        if (decompressor != null && !decompressor.getClass().isAnnotationPresent(DoNotPool.class)) {
            CodecPool.updateLeaseCount(decompressorCounts, decompressor, 1);
        }
        return decompressor;
    }

    public static ByteBuffDecompressor getByteBuffDecompressor(ByteBuffDecompressionCodec codec) {
        ByteBuffDecompressor decompressor = CodecPool.borrow(BYTE_BUFF_DECOMPRESSOR_POOL, codec.getByteBuffDecompressorType());
        if (decompressor == null) {
            decompressor = codec.createByteBuffDecompressor();
            LOG.debug("Got brand-new ByteBuffDecompressor [{}]", (Object)decompressor.getClass().getName());
        } else {
            LOG.debug("Got recycled ByteBuffDecompressor [{}]", (Object)decompressor.getClass().getName());
        }
        return decompressor;
    }

    public static void returnCompressor(Compressor compressor) {
        if (compressor == null) {
            return;
        }
        if (compressor.getClass().isAnnotationPresent(DoNotPool.class)) {
            compressor.end();
            return;
        }
        compressor.reset();
        if (CodecPool.payback(COMPRESSOR_POOL, compressor)) {
            CodecPool.updateLeaseCount(compressorCounts, compressor, -1);
        }
    }

    public static void returnDecompressor(Decompressor decompressor) {
        if (decompressor == null) {
            return;
        }
        if (decompressor.getClass().isAnnotationPresent(DoNotPool.class)) {
            decompressor.end();
            return;
        }
        decompressor.reset();
        if (CodecPool.payback(DECOMPRESSOR_POOL, decompressor)) {
            CodecPool.updateLeaseCount(decompressorCounts, decompressor, -1);
        }
    }

    public static void returnByteBuffDecompressor(ByteBuffDecompressor decompressor) {
        if (decompressor == null) {
            return;
        }
        if (decompressor.getClass().isAnnotationPresent(DoNotPool.class)) {
            return;
        }
        CodecPool.payback(BYTE_BUFF_DECOMPRESSOR_POOL, decompressor);
    }

    static int getLeasedCompressorsCount(@Nullable CompressionCodec codec) {
        if (compressorCounts == null) {
            throw new IllegalStateException("initLeaseCounting() not called to set up lease counting");
        }
        return codec == null ? 0 : CodecPool.getLeaseCount(compressorCounts, codec.getCompressorType());
    }

    static int getLeasedDecompressorsCount(@Nullable CompressionCodec codec) {
        if (decompressorCounts == null) {
            throw new IllegalStateException("initLeaseCounting() not called to set up lease counting");
        }
        return codec == null ? 0 : CodecPool.getLeaseCount(decompressorCounts, codec.getDecompressorType());
    }
}

