/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.compress.aircompressor;

import io.airlift.compress.lz4.Lz4Compressor;
import io.airlift.compress.lz4.Lz4Decompressor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.compress.CompressionUtil;
import org.apache.hadoop.hbase.io.compress.aircompressor.HadoopCompressor;
import org.apache.hadoop.hbase.io.compress.aircompressor.HadoopDecompressor;
import org.apache.hadoop.io.compress.BlockCompressorStream;
import org.apache.hadoop.io.compress.BlockDecompressorStream;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class Lz4Codec
implements Configurable,
CompressionCodec {
    public static final String LZ4_BUFFER_SIZE_KEY = "hbase.io.compress.lz4.buffersize";
    private Configuration conf = new Configuration();
    private int bufferSize = Lz4Codec.getBufferSize(this.conf);

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        this.bufferSize = Lz4Codec.getBufferSize(conf);
    }

    public Compressor createCompressor() {
        return new HadoopLz4Compressor();
    }

    public Decompressor createDecompressor() {
        return new HadoopLz4Decompressor();
    }

    public CompressionInputStream createInputStream(InputStream in) throws IOException {
        return this.createInputStream(in, this.createDecompressor());
    }

    public CompressionInputStream createInputStream(InputStream in, Decompressor d) throws IOException {
        return new BlockDecompressorStream(in, d, this.bufferSize);
    }

    public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
        return this.createOutputStream(out, this.createCompressor());
    }

    public CompressionOutputStream createOutputStream(OutputStream out, Compressor c) throws IOException {
        return new BlockCompressorStream(out, c, this.bufferSize, CompressionUtil.compressionOverhead((int)this.bufferSize));
    }

    public Class<? extends Compressor> getCompressorType() {
        return HadoopLz4Compressor.class;
    }

    public Class<? extends Decompressor> getDecompressorType() {
        return HadoopLz4Decompressor.class;
    }

    public String getDefaultExtension() {
        return ".lz4";
    }

    static int getBufferSize(Configuration conf) {
        return conf.getInt(LZ4_BUFFER_SIZE_KEY, conf.getInt("io.compression.codec.lz4.buffersize", 262144));
    }

    @InterfaceAudience.Private
    public class HadoopLz4Decompressor
    extends HadoopDecompressor<Lz4Decompressor> {
        HadoopLz4Decompressor(Lz4Decompressor decompressor) {
            super(decompressor, Lz4Codec.getBufferSize(Lz4Codec.this.conf));
        }

        HadoopLz4Decompressor() {
            this(new Lz4Decompressor());
        }
    }

    @InterfaceAudience.Private
    public class HadoopLz4Compressor
    extends HadoopCompressor<Lz4Compressor> {
        HadoopLz4Compressor(Lz4Compressor compressor) {
            super(compressor, Lz4Codec.getBufferSize(Lz4Codec.this.conf));
        }

        HadoopLz4Compressor() {
            this(new Lz4Compressor());
        }

        @Override
        int getLevel(Configuration conf) {
            return 0;
        }

        @Override
        int getBufferSize(Configuration conf) {
            return Lz4Codec.getBufferSize(conf);
        }
    }
}

