/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ArrayBackedTag;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.Export;
import org.apache.hadoop.hbase.mapreduce.ExportUtils;
import org.apache.hadoop.hbase.mapreduce.Import;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.regionserver.RegionScannerImpl;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.VerySlowMapReduceTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.LauncherSecurityManager;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={VerySlowMapReduceTests.class, MediumTests.class})
public class TestImportExport {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestImportExport.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestImportExport.class);
    protected static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final byte[] ROW1 = Bytes.toBytesBinary((String)"\\x32row1");
    private static final byte[] ROW2 = Bytes.toBytesBinary((String)"\\x32row2");
    private static final byte[] ROW3 = Bytes.toBytesBinary((String)"\\x32row3");
    private static final String FAMILYA_STRING = "a";
    private static final String FAMILYB_STRING = "b";
    private static final byte[] FAMILYA = Bytes.toBytes((String)"a");
    private static final byte[] FAMILYB = Bytes.toBytes((String)"b");
    private static final byte[] QUAL = Bytes.toBytes((String)"q");
    private static final String OUTPUT_DIR = "outputdir";
    private static String FQ_OUTPUT_DIR;
    private static final String EXPORT_BATCH_SIZE = "100";
    private static final long now;
    private final TableName EXPORT_TABLE = TableName.valueOf((String)"export_table");
    private final TableName IMPORT_TABLE = TableName.valueOf((String)"import_table");
    public static final byte TEST_TAG_TYPE = 65;
    public static final String TEST_ATTR = "source_op";
    public static final String TEST_TAG = "test_tag";
    @Rule
    public final TestName name = new TestName();

    @BeforeClass
    public static void beforeClass() throws Throwable {
        UTIL.getConfiguration().setInt("hbase.regionserver.metahandler.count", 10);
        UTIL.startMiniCluster();
        FQ_OUTPUT_DIR = new Path(OUTPUT_DIR).makeQualified(FileSystem.get((Configuration)UTIL.getConfiguration())).toString();
    }

    @AfterClass
    public static void afterClass() throws Throwable {
        UTIL.shutdownMiniCluster();
    }

    @Before
    public void announce() {
        LOG.info("Running " + this.name.getMethodName());
    }

    @After
    public void cleanup() throws Throwable {
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        fs.delete(new Path(OUTPUT_DIR), true);
        if (UTIL.getAdmin().tableExists(this.EXPORT_TABLE)) {
            UTIL.deleteTable(this.EXPORT_TABLE);
        }
        if (UTIL.getAdmin().tableExists(this.IMPORT_TABLE)) {
            UTIL.deleteTable(this.IMPORT_TABLE);
        }
    }

    protected boolean runExport(String[] args) throws Throwable {
        int status = ToolRunner.run((Configuration)new Configuration(UTIL.getConfiguration()), (Tool)new Export(), (String[])args);
        return status == 0;
    }

    protected void runExportMain(String[] args) throws Throwable {
        Export.main((String[])args);
    }

    boolean runImport(String[] args) throws Throwable {
        int status = ToolRunner.run((Configuration)new Configuration(UTIL.getConfiguration()), (Tool)new Import(), (String[])args);
        return status == 0;
    }

    @Test
    public void testSimpleCase() throws Throwable {
        try (Table t = UTIL.createTable(TableName.valueOf((String)this.name.getMethodName()), FAMILYA, 3);){
            Put p = new Put(ROW1);
            p.addColumn(FAMILYA, QUAL, now, QUAL);
            p.addColumn(FAMILYA, QUAL, now + 1L, QUAL);
            p.addColumn(FAMILYA, QUAL, now + 2L, QUAL);
            t.put(p);
            p = new Put(ROW2);
            p.addColumn(FAMILYA, QUAL, now, QUAL);
            p.addColumn(FAMILYA, QUAL, now + 1L, QUAL);
            p.addColumn(FAMILYA, QUAL, now + 2L, QUAL);
            t.put(p);
            p = new Put(ROW3);
            p.addColumn(FAMILYA, QUAL, now, QUAL);
            p.addColumn(FAMILYA, QUAL, now + 1L, QUAL);
            p.addColumn(FAMILYA, QUAL, now + 2L, QUAL);
            t.put(p);
        }
        String[] args = new String[]{"-Dhbase.mapreduce.scan.row.start=\\x32row1", "-Dhbase.mapreduce.scan.row.stop=\\x32row3", this.name.getMethodName(), FQ_OUTPUT_DIR, "1000"};
        Assert.assertTrue((boolean)this.runExport(args));
        String IMPORT_TABLE = this.name.getMethodName() + "import";
        try (Table t = UTIL.createTable(TableName.valueOf((String)IMPORT_TABLE), FAMILYB, 3);){
            args = new String[]{"-DHBASE_IMPORTER_RENAME_CFS=a:b", IMPORT_TABLE, FQ_OUTPUT_DIR};
            Assert.assertTrue((boolean)this.runImport(args));
            Get g = new Get(ROW1);
            g.setMaxVersions();
            Result r = t.get(g);
            Assert.assertEquals((long)3L, (long)r.size());
            g = new Get(ROW2);
            g.setMaxVersions();
            r = t.get(g);
            Assert.assertEquals((long)3L, (long)r.size());
            g = new Get(ROW3);
            r = t.get(g);
            Assert.assertEquals((long)0L, (long)r.size());
        }
    }

    @Test
    public void testMetaExport() throws Throwable {
        String[] args = new String[]{TableName.META_TABLE_NAME.getNameAsString(), FQ_OUTPUT_DIR, "1", "0", "0"};
        Assert.assertTrue((boolean)this.runExport(args));
    }

    @Test
    public void testImport94Table() throws Throwable {
        String name = "exportedTableIn94Format";
        URL url = TestImportExport.class.getResource("exportedTableIn94Format");
        File f = new File(url.toURI());
        if (!f.exists()) {
            LOG.warn("FAILED TO FIND " + f + "; skipping out on test");
            return;
        }
        Assert.assertTrue((boolean)f.exists());
        LOG.info("FILE=" + f);
        Path importPath = new Path(f.toURI());
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        fs.copyFromLocalFile(importPath, new Path(FQ_OUTPUT_DIR + "/" + "exportedTableIn94Format"));
        String IMPORT_TABLE = "exportedTableIn94Format";
        try (Table t = UTIL.createTable(TableName.valueOf((String)IMPORT_TABLE), Bytes.toBytes((String)"f1"), 3);){
            String[] args = new String[]{"-Dhbase.import.version=0.94", IMPORT_TABLE, FQ_OUTPUT_DIR};
            Assert.assertTrue((boolean)this.runImport(args));
            Assert.assertEquals((long)5L, (long)UTIL.countRows(t));
        }
    }

    @Test
    public void testExportScannerBatching() throws Throwable {
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILYA).setMaxVersions(1).build()).build();
        UTIL.getAdmin().createTable(desc);
        try (Table t = UTIL.getConnection().getTable(desc.getTableName());){
            Put p = new Put(ROW1);
            p.addColumn(FAMILYA, QUAL, now, QUAL);
            p.addColumn(FAMILYA, QUAL, now + 1L, QUAL);
            p.addColumn(FAMILYA, QUAL, now + 2L, QUAL);
            p.addColumn(FAMILYA, QUAL, now + 3L, QUAL);
            p.addColumn(FAMILYA, QUAL, now + 4L, QUAL);
            t.put(p);
            String[] args = new String[]{"-Dhbase.export.scanner.batch=100", this.name.getMethodName(), FQ_OUTPUT_DIR};
            Assert.assertTrue((boolean)this.runExport(args));
            FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
            fs.delete(new Path(FQ_OUTPUT_DIR), true);
        }
    }

    @Test
    public void testWithDeletes() throws Throwable {
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILYA).setMaxVersions(5).setKeepDeletedCells(KeepDeletedCells.TRUE).build()).build();
        UTIL.getAdmin().createTable(desc);
        try (Table t = UTIL.getConnection().getTable(desc.getTableName());){
            Put p = new Put(ROW1);
            p.addColumn(FAMILYA, QUAL, now, QUAL);
            p.addColumn(FAMILYA, QUAL, now + 1L, QUAL);
            p.addColumn(FAMILYA, QUAL, now + 2L, QUAL);
            p.addColumn(FAMILYA, QUAL, now + 3L, QUAL);
            p.addColumn(FAMILYA, QUAL, now + 4L, QUAL);
            t.put(p);
            Delete d = new Delete(ROW1, now + 3L);
            t.delete(d);
            d = new Delete(ROW1);
            d.addColumns(FAMILYA, QUAL, now + 2L);
            t.delete(d);
        }
        String[] args = new String[]{"-Dhbase.mapreduce.include.deleted.rows=true", this.name.getMethodName(), FQ_OUTPUT_DIR, "1000"};
        Assert.assertTrue((boolean)this.runExport(args));
        String IMPORT_TABLE = this.name.getMethodName() + "import";
        desc = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)IMPORT_TABLE)).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILYA).setMaxVersions(5).setKeepDeletedCells(KeepDeletedCells.TRUE).build()).build();
        UTIL.getAdmin().createTable(desc);
        try (Table t = UTIL.getConnection().getTable(desc.getTableName());){
            args = new String[]{IMPORT_TABLE, FQ_OUTPUT_DIR};
            Assert.assertTrue((boolean)this.runImport(args));
            Scan s = new Scan();
            s.setMaxVersions();
            s.setRaw(true);
            ResultScanner scanner = t.getScanner(s);
            Result r = scanner.next();
            Cell[] res = r.rawCells();
            Assert.assertTrue((boolean)PrivateCellUtil.isDeleteFamily((Cell)res[0]));
            Assert.assertEquals((long)(now + 4L), (long)res[1].getTimestamp());
            Assert.assertEquals((long)(now + 3L), (long)res[2].getTimestamp());
            Assert.assertTrue((boolean)CellUtil.isDelete((Cell)res[3]));
            Assert.assertEquals((long)(now + 2L), (long)res[4].getTimestamp());
            Assert.assertEquals((long)(now + 1L), (long)res[5].getTimestamp());
            Assert.assertEquals((long)now, (long)res[6].getTimestamp());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithMultipleDeleteFamilyMarkersOfSameRowSameFamily() throws Throwable {
        TableName exportTable = TableName.valueOf((String)this.name.getMethodName());
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILYA).setMaxVersions(5).setKeepDeletedCells(KeepDeletedCells.TRUE).build()).build();
        UTIL.getAdmin().createTable(desc);
        Table exportT = UTIL.getConnection().getTable(exportTable);
        Put p = new Put(ROW1);
        p.addColumn(FAMILYA, QUAL, now, QUAL);
        exportT.put(p);
        Delete d = new Delete(ROW1, now + 3L);
        exportT.delete(d);
        p = new Put(ROW1);
        p.addColumn(FAMILYA, QUAL, now + 5L, "s".getBytes());
        exportT.put(p);
        d = new Delete(ROW1, now + 7L);
        exportT.delete(d);
        String[] args = new String[]{"-Dhbase.mapreduce.include.deleted.rows=true", exportTable.getNameAsString(), FQ_OUTPUT_DIR, "1000"};
        Assert.assertTrue((boolean)this.runExport(args));
        String importTable = this.name.getMethodName() + "import";
        desc = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)importTable)).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILYA).setMaxVersions(5).setKeepDeletedCells(KeepDeletedCells.TRUE).build()).build();
        UTIL.getAdmin().createTable(desc);
        Table importT = UTIL.getConnection().getTable(TableName.valueOf((String)importTable));
        args = new String[]{importTable, FQ_OUTPUT_DIR};
        Assert.assertTrue((boolean)this.runImport(args));
        Scan s = new Scan();
        s.setMaxVersions();
        s.setRaw(true);
        ResultScanner importedTScanner = importT.getScanner(s);
        Result importedTResult = importedTScanner.next();
        ResultScanner exportedTScanner = exportT.getScanner(s);
        Result exportedTResult = exportedTScanner.next();
        try {
            Result.compareResults((Result)exportedTResult, (Result)importedTResult);
        }
        catch (Throwable e) {
            Assert.fail((String)("Original and imported tables data comparision failed with error:" + e.getMessage()));
        }
        finally {
            exportT.close();
            importT.close();
        }
    }

    @Test
    public void testWithFilter() throws Throwable {
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILYA).setMaxVersions(5).build()).build();
        UTIL.getAdmin().createTable(desc);
        Table exportTable = UTIL.getConnection().getTable(desc.getTableName());
        Put p1 = new Put(ROW1);
        p1.addColumn(FAMILYA, QUAL, now, QUAL);
        p1.addColumn(FAMILYA, QUAL, now + 1L, QUAL);
        p1.addColumn(FAMILYA, QUAL, now + 2L, QUAL);
        p1.addColumn(FAMILYA, QUAL, now + 3L, QUAL);
        p1.addColumn(FAMILYA, QUAL, now + 4L, QUAL);
        Put p2 = new Put(ROW2);
        p2.addColumn(FAMILYA, QUAL, now, QUAL);
        exportTable.put(Arrays.asList(p1, p2));
        String[] args = new String[]{this.name.getMethodName(), FQ_OUTPUT_DIR, "1000"};
        Assert.assertTrue((boolean)this.runExport(args));
        String IMPORT_TABLE = this.name.getMethodName() + "import";
        desc = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)IMPORT_TABLE)).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILYA).setMaxVersions(5).build()).build();
        UTIL.getAdmin().createTable(desc);
        Table importTable = UTIL.getConnection().getTable(desc.getTableName());
        args = new String[]{"-Dimport.filter.class=" + PrefixFilter.class.getName(), "-Dimport.filter.args=" + Bytes.toString((byte[])ROW1), IMPORT_TABLE, FQ_OUTPUT_DIR, "1000"};
        Assert.assertTrue((boolean)this.runImport(args));
        PrefixFilter filter = new PrefixFilter(ROW1);
        int count = this.getCount(exportTable, (Filter)filter);
        Assert.assertEquals((String)"Unexpected row count between export and import tables", (long)count, (long)this.getCount(importTable, null));
        args = new String[]{"-Dimport.filter.class=" + Filter.class.getName(), "-Dimport.filter.args=" + Bytes.toString((byte[])ROW1) + "", this.name.getMethodName(), FQ_OUTPUT_DIR, "1000"};
        Assert.assertFalse((boolean)this.runImport(args));
        exportTable.close();
        importTable.close();
    }

    @Test
    public void testBulkImportAndLargeResult() throws Throwable {
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILYA).setMaxVersions(5).build()).build();
        UTIL.getAdmin().createTable(desc);
        Table exportTable = UTIL.getConnection().getTable(desc.getTableName());
        Put p1 = new Put(ROW1);
        p1.addColumn(FAMILYA, QUAL, now, QUAL);
        Put p2 = new Put(ROW2);
        p2.addColumn(FAMILYA, QUAL, now, QUAL);
        exportTable.put(Arrays.asList(p1, p2));
        String[] args = new String[]{this.name.getMethodName(), FQ_OUTPUT_DIR, "1000"};
        Assert.assertTrue((boolean)this.runExport(args));
        String IMPORT_TABLE = this.name.getMethodName() + "import";
        desc = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)IMPORT_TABLE)).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILYA).setMaxVersions(5).build()).build();
        UTIL.getAdmin().createTable(desc);
        String O_OUTPUT_DIR = new Path("outputdir1").makeQualified(FileSystem.get((Configuration)UTIL.getConfiguration())).toString();
        args = new String[]{"-Dimport.bulk.output=" + O_OUTPUT_DIR, "-Dimport.bulk.hasLargeResult=true", IMPORT_TABLE, FQ_OUTPUT_DIR, "1000"};
        Assert.assertTrue((boolean)this.runImport(args));
    }

    private int getCount(Table table, Filter filter) throws IOException {
        Scan scan = new Scan();
        scan.setFilter(filter);
        ResultScanner results = table.getScanner(scan);
        int count = 0;
        for (Result res : results) {
            count += res.size();
        }
        results.close();
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testImportMain() throws Throwable {
        PrintStream oldPrintStream = System.err;
        SecurityManager SECURITY_MANAGER = System.getSecurityManager();
        LauncherSecurityManager newSecurityManager = new LauncherSecurityManager();
        System.setSecurityManager((SecurityManager)newSecurityManager);
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        String[] args = new String[]{};
        System.setErr(new PrintStream(data));
        try {
            System.setErr(new PrintStream(data));
            Import.main((String[])args);
            Assert.fail((String)"should be SecurityException");
        }
        catch (SecurityException e) {
            Assert.assertEquals((long)-1L, (long)newSecurityManager.getExitCode());
            Assert.assertTrue((boolean)data.toString().contains("Wrong number of arguments:"));
            Assert.assertTrue((boolean)data.toString().contains("-Dimport.bulk.output=/path/for/output"));
            Assert.assertTrue((boolean)data.toString().contains("-Dimport.filter.class=<name of filter class>"));
            Assert.assertTrue((boolean)data.toString().contains("-Dimport.bulk.output=/path/for/output"));
            Assert.assertTrue((boolean)data.toString().contains("-Dmapreduce.reduce.speculative=false"));
        }
        finally {
            System.setErr(oldPrintStream);
            System.setSecurityManager(SECURITY_MANAGER);
        }
    }

    @Test
    public void testExportScan() throws Exception {
        int version = 100;
        long startTime = EnvironmentEdgeManager.currentTime();
        long endTime = startTime + 1L;
        String prefix = "row";
        String label_0 = "label_0";
        String label_1 = "label_1";
        String[] args = new String[]{"table", "outputDir", String.valueOf(version), String.valueOf(startTime), String.valueOf(endTime), prefix};
        Scan scan = ExportUtils.getScanFromCommandLine((Configuration)UTIL.getConfiguration(), (String[])args);
        Assert.assertEquals((long)version, (long)scan.getMaxVersions());
        Assert.assertEquals((long)startTime, (long)scan.getTimeRange().getMin());
        Assert.assertEquals((long)endTime, (long)scan.getTimeRange().getMax());
        Assert.assertEquals((Object)true, (Object)(scan.getFilter() instanceof PrefixFilter));
        Assert.assertEquals((long)0L, (long)Bytes.compareTo((byte[])((PrefixFilter)scan.getFilter()).getPrefix(), (byte[])Bytes.toBytesBinary((String)prefix)));
        String[] argsWithLabels = new String[]{"-D hbase.export.visibility.labels=" + label_0 + "," + label_1, "table", "outputDir", String.valueOf(version), String.valueOf(startTime), String.valueOf(endTime), prefix};
        Configuration conf = new Configuration(UTIL.getConfiguration());
        String[] otherArgs = new GenericOptionsParser(conf, argsWithLabels).getRemainingArgs();
        Scan scanWithLabels = ExportUtils.getScanFromCommandLine((Configuration)conf, (String[])otherArgs);
        Assert.assertEquals((long)version, (long)scanWithLabels.getMaxVersions());
        Assert.assertEquals((long)startTime, (long)scanWithLabels.getTimeRange().getMin());
        Assert.assertEquals((long)endTime, (long)scanWithLabels.getTimeRange().getMax());
        Assert.assertEquals((Object)true, (Object)(scanWithLabels.getFilter() instanceof PrefixFilter));
        Assert.assertEquals((long)0L, (long)Bytes.compareTo((byte[])((PrefixFilter)scanWithLabels.getFilter()).getPrefix(), (byte[])Bytes.toBytesBinary((String)prefix)));
        Assert.assertEquals((long)2L, (long)scanWithLabels.getAuthorizations().getLabels().size());
        Assert.assertEquals((Object)label_0, scanWithLabels.getAuthorizations().getLabels().get(0));
        Assert.assertEquals((Object)label_1, scanWithLabels.getAuthorizations().getLabels().get(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportMain() throws Throwable {
        PrintStream oldPrintStream = System.err;
        SecurityManager SECURITY_MANAGER = System.getSecurityManager();
        LauncherSecurityManager newSecurityManager = new LauncherSecurityManager();
        System.setSecurityManager((SecurityManager)newSecurityManager);
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        String[] args = new String[]{};
        System.setErr(new PrintStream(data));
        try {
            System.setErr(new PrintStream(data));
            this.runExportMain(args);
            Assert.fail((String)"should be SecurityException");
        }
        catch (SecurityException e) {
            Assert.assertEquals((long)-1L, (long)newSecurityManager.getExitCode());
            String errMsg = data.toString();
            Assert.assertTrue((boolean)errMsg.contains("Wrong number of arguments:"));
            Assert.assertTrue((boolean)errMsg.contains("Usage: Export [-D <property=value>]* <tablename> <outputdir> [<versions> [<starttime> [<endtime>]] [^[regex pattern] or [Prefix] to filter]]"));
            Assert.assertTrue((boolean)errMsg.contains("-D hbase.mapreduce.scan.column.family=<family1>,<family2>, ..."));
            Assert.assertTrue((boolean)errMsg.contains("-D hbase.mapreduce.include.deleted.rows=true"));
            Assert.assertTrue((boolean)errMsg.contains("-D hbase.client.scanner.caching=100"));
            Assert.assertTrue((boolean)errMsg.contains("-D hbase.export.scanner.batch=10"));
            Assert.assertTrue((boolean)errMsg.contains("-D hbase.export.scanner.caching=100"));
        }
        finally {
            System.setErr(oldPrintStream);
            System.setSecurityManager(SECURITY_MANAGER);
        }
    }

    @Test
    public void testKeyValueImporter() throws Throwable {
        Import.KeyValueImporter importer = new Import.KeyValueImporter();
        Configuration configuration = new Configuration();
        Mapper.Context ctx = (Mapper.Context)Mockito.mock(Mapper.Context.class);
        Mockito.when((Object)ctx.getConfiguration()).thenReturn((Object)configuration);
        ((Mapper.Context)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                ImmutableBytesWritable writer = (ImmutableBytesWritable)invocation.getArgument(0);
                KeyValue key = (KeyValue)invocation.getArgument(1);
                Assert.assertEquals((Object)"Key", (Object)Bytes.toString((byte[])writer.get()));
                Assert.assertEquals((Object)"row", (Object)Bytes.toString((byte[])CellUtil.cloneRow((Cell)key)));
                return null;
            }
        }).when((Object)ctx)).write(ArgumentMatchers.any(), ArgumentMatchers.any());
        importer.setup(ctx);
        Result value = (Result)Mockito.mock(Result.class);
        KeyValue[] keys = new KeyValue[]{new KeyValue(Bytes.toBytes((String)"row"), Bytes.toBytes((String)"family"), Bytes.toBytes((String)"qualifier"), Bytes.toBytes((String)"value")), new KeyValue(Bytes.toBytes((String)"row"), Bytes.toBytes((String)"family"), Bytes.toBytes((String)"qualifier"), Bytes.toBytes((String)"value1"))};
        Mockito.when((Object)value.rawCells()).thenReturn((Object)keys);
        importer.map(new ImmutableBytesWritable(Bytes.toBytes((String)"Key")), value, ctx);
    }

    @Test
    public void testAddFilterAndArguments() throws IOException {
        Configuration configuration = new Configuration();
        ArrayList<String> args = new ArrayList<String>();
        args.add("param1");
        args.add("param2");
        Import.addFilterAndArguments((Configuration)configuration, FilterBase.class, args);
        Assert.assertEquals((Object)"org.apache.hadoop.hbase.filter.FilterBase", (Object)configuration.get("import.filter.class"));
        Assert.assertEquals((Object)"param1,param2", (Object)configuration.get("import.filter.args"));
    }

    @Test
    public void testDurability() throws Throwable {
        String exportTableName = this.name.getMethodName() + "export";
        try (Table exportTable = UTIL.createTable(TableName.valueOf((String)exportTableName), FAMILYA, 3);){
            Put put = new Put(ROW1);
            put.addColumn(FAMILYA, QUAL, now, QUAL);
            put.addColumn(FAMILYA, QUAL, now + 1L, QUAL);
            put.addColumn(FAMILYA, QUAL, now + 2L, QUAL);
            exportTable.put(put);
            put = new Put(ROW2);
            put.addColumn(FAMILYA, QUAL, now, QUAL);
            put.addColumn(FAMILYA, QUAL, now + 1L, QUAL);
            put.addColumn(FAMILYA, QUAL, now + 2L, QUAL);
            exportTable.put(put);
            String[] args = new String[]{exportTableName, FQ_OUTPUT_DIR, "1000"};
            Assert.assertTrue((boolean)this.runExport(args));
            String importTableName = this.name.getMethodName() + "import1";
            Table importTable = UTIL.createTable(TableName.valueOf((String)importTableName), FAMILYA, 3);
            RegionInfo region = ((HRegion)((JVMClusterUtil.RegionServerThread)UTIL.getHBaseCluster().getRegionServerThreads().get(0)).getRegionServer().getRegions(importTable.getName()).get(0)).getRegionInfo();
            TableWALActionListener walListener = new TableWALActionListener(region);
            WAL wal = UTIL.getMiniHBaseCluster().getRegionServer(0).getWAL(region);
            wal.registerWALActionsListener((WALActionsListener)walListener);
            args = new String[]{"-Dimport.wal.durability=" + Durability.SKIP_WAL.name(), importTableName, FQ_OUTPUT_DIR};
            Assert.assertTrue((boolean)this.runImport(args));
            Assert.assertTrue((!walListener.isWALVisited() ? 1 : 0) != 0);
            Assert.assertTrue((this.getCount(importTable, null) == 2 ? 1 : 0) != 0);
            importTableName = this.name.getMethodName() + "import2";
            importTable = UTIL.createTable(TableName.valueOf((String)importTableName), FAMILYA, 3);
            region = ((HRegion)((JVMClusterUtil.RegionServerThread)UTIL.getHBaseCluster().getRegionServerThreads().get(0)).getRegionServer().getRegions(importTable.getName()).get(0)).getRegionInfo();
            wal = UTIL.getMiniHBaseCluster().getRegionServer(0).getWAL(region);
            walListener = new TableWALActionListener(region);
            wal.registerWALActionsListener((WALActionsListener)walListener);
            args = new String[]{importTableName, FQ_OUTPUT_DIR};
            Assert.assertTrue((boolean)this.runImport(args));
            Assert.assertTrue((boolean)walListener.isWALVisited());
            Assert.assertTrue((this.getCount(importTable, null) == 2 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testTagsAddition() throws Throwable {
        TableName exportTable = TableName.valueOf((String)this.name.getMethodName());
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)exportTable).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILYA).setMaxVersions(5).setKeepDeletedCells(KeepDeletedCells.TRUE).build()).setCoprocessor(MetadataController.class.getName()).build();
        UTIL.getAdmin().createTable(desc);
        Table exportT = UTIL.getConnection().getTable(exportTable);
        Put p = new Put(ROW1);
        p.addColumn(FAMILYA, QUAL, now, QUAL);
        exportT.put(p);
        Delete d = new Delete(ROW1, now + 3L);
        d.setAttribute(TEST_ATTR, Bytes.toBytes((String)TEST_TAG));
        exportT.delete(d);
        String[] args = new String[]{"-Dhbase.mapreduce.include.deleted.rows=true", "-Dhbase.client.rpc.codec=org.apache.hadoop.hbase.codec.KeyValueCodecWithTags", exportTable.getNameAsString(), FQ_OUTPUT_DIR, "1000"};
        Assert.assertTrue((boolean)this.runExport(args));
        this.checkWhetherTagExists(exportTable, true);
        TableName importTable = TableName.valueOf((String)"importWithTestTagsAddition");
        TableDescriptor importTableDesc = TableDescriptorBuilder.newBuilder((TableName)importTable).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILYA).setMaxVersions(5).setKeepDeletedCells(KeepDeletedCells.TRUE).build()).setCoprocessor(MetadataController.class.getName()).build();
        UTIL.getAdmin().createTable(importTableDesc);
        args = new String[]{"-Dhbase.client.rpc.codec=org.apache.hadoop.hbase.codec.KeyValueCodecWithTags", importTable.getNameAsString(), FQ_OUTPUT_DIR};
        Assert.assertTrue((boolean)this.runImport(args));
        this.checkWhetherTagExists(importTable, true);
    }

    private void checkWhetherTagExists(TableName table, boolean tagExists) throws IOException {
        ArrayList values = new ArrayList();
        for (HRegion region : UTIL.getHBaseCluster().getRegions(table)) {
            Scan scan = new Scan();
            scan.setRaw(true);
            scan.readAllVersions();
            scan.withStartRow(ROW1);
            RegionScannerImpl scanner = region.getScanner(scan);
            scanner.next(values);
            if (values.isEmpty()) continue;
            break;
        }
        boolean deleteFound = false;
        for (Cell cell : values) {
            if (!PrivateCellUtil.isDelete((byte)cell.getType().getCode())) continue;
            deleteFound = true;
            List tags = PrivateCellUtil.getTags((Cell)cell);
            if (tagExists) {
                Assert.assertEquals((long)1L, (long)tags.size());
                for (Tag tag : tags) {
                    Assert.assertEquals((Object)TEST_TAG, (Object)Tag.getValueAsString((Tag)tag));
                }
                continue;
            }
            Assert.assertEquals((long)0L, (long)tags.size());
        }
        Assert.assertTrue((boolean)deleteFound);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTagsWithEmptyCodec() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TableDescriptor tableDesc = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILYA).setMaxVersions(5).setKeepDeletedCells(KeepDeletedCells.TRUE).build()).setCoprocessor(MetadataController.class.getName()).build();
        UTIL.getAdmin().createTable(tableDesc);
        Configuration conf = new Configuration(UTIL.getConfiguration());
        conf.set("hbase.client.rpc.codec", "");
        conf.set("hbase.client.default.rpc.codec", "");
        try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
             Table table = connection.getTable(tableName);){
            Result result;
            Put p = new Put(ROW1);
            p.addColumn(FAMILYA, QUAL, now, QUAL);
            table.put(p);
            Delete d = new Delete(ROW1, now + 3L);
            d.setAttribute(TEST_ATTR, Bytes.toBytes((String)TEST_TAG));
            table.delete(d);
            Scan scan = new Scan().withStartRow(ROW1).setRaw(true);
            ResultScanner scanner = table.getScanner(scan);
            int count = 0;
            while ((result = scanner.next()) != null) {
                List cells = result.listCells();
                Assert.assertEquals((long)2L, (long)cells.size());
                Cell cell = (Cell)cells.get(0);
                Assert.assertTrue((boolean)CellUtil.isDelete((Cell)cell));
                List tags = PrivateCellUtil.getTags((Cell)cell);
                Assert.assertEquals((long)0L, (long)tags.size());
                ++count;
            }
            Assert.assertEquals((long)1L, (long)count);
        }
        finally {
            UTIL.deleteTable(tableName);
        }
    }

    static {
        now = EnvironmentEdgeManager.currentTime();
    }

    public static class MetadataController
    implements RegionCoprocessor,
    RegionObserver {
        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void preBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
            if (((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion().getRegionInfo().getTable().isSystemTable()) {
                return;
            }
            for (int i = 0; i < miniBatchOp.size(); ++i) {
                byte[] sourceOpAttr;
                Mutation m = (Mutation)miniBatchOp.getOperation(i);
                if (!(m instanceof Delete) || (sourceOpAttr = m.getAttribute(TestImportExport.TEST_ATTR)) == null) continue;
                ArrayBackedTag sourceOpTag = new ArrayBackedTag(65, sourceOpAttr);
                ArrayList<Cell> updatedCells = new ArrayList<Cell>();
                CellScanner cellScanner = m.cellScanner();
                while (cellScanner.advance()) {
                    Cell cell = cellScanner.current();
                    List tags = PrivateCellUtil.getTags((Cell)cell);
                    tags.add(sourceOpTag);
                    Cell updatedCell = PrivateCellUtil.createCell((Cell)cell, (List)tags);
                    updatedCells.add(updatedCell);
                }
                m.getFamilyCellMap().clear();
                for (Cell cell : updatedCells) {
                    Delete d = (Delete)m;
                    d.add(cell);
                }
            }
        }
    }

    private static class TableWALActionListener
    implements WALActionsListener {
        private RegionInfo regionInfo;
        private boolean isVisited = false;

        public TableWALActionListener(RegionInfo region) {
            this.regionInfo = region;
        }

        public void visitLogEntryBeforeWrite(RegionInfo info, WALKey logKey, WALEdit logEdit) {
            if (logKey.getTableName().getNameAsString().equalsIgnoreCase(this.regionInfo.getTable().getNameAsString()) && !logEdit.isMetaEdit()) {
                this.isVisited = true;
            }
        }

        public boolean isWALVisited() {
            return this.isVisited;
        }
    }
}

