/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.util.Arrays;
import java.util.function.BooleanSupplier;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.mapreduce.HashTable;
import org.apache.hadoop.hbase.mapreduce.SyncTable;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MapReduceTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.mapreduce.Counters;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MapReduceTests.class, LargeTests.class})
public class TestSyncTable {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSyncTable.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestSyncTable.class);
    private static final HBaseTestingUtility UTIL1 = new HBaseTestingUtility();
    private static final HBaseTestingUtility UTIL2 = new HBaseTestingUtility();
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void beforeClass() throws Exception {
        UTIL1.startMiniCluster(3);
        UTIL2.startMiniCluster(3);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        UTIL2.shutdownMiniCluster();
        UTIL1.shutdownMiniCluster();
    }

    private static byte[][] generateSplits(int numRows, int numRegions) {
        byte[][] splitRows = new byte[numRegions - 1][];
        for (int i = 1; i < numRegions; ++i) {
            splitRows[i - 1] = Bytes.toBytes((int)(numRows * i / numRegions));
        }
        return splitRows;
    }

    private void testSyncTable(HBaseTestingUtility source, HBaseTestingUtility target, String ... options) throws Exception {
        TableName sourceTableName = TableName.valueOf((String)(this.name.getMethodName() + "_source"));
        TableName targetTableName = TableName.valueOf((String)(this.name.getMethodName() + "_target"));
        Path testDir = source.getDataTestDirOnTestFS(this.name.getMethodName());
        this.writeTestData(source, sourceTableName, target, targetTableName, new long[0]);
        this.hashSourceTable(source, sourceTableName, testDir, new String[0]);
        Counters syncCounters = this.syncTables(target.getConfiguration(), sourceTableName, targetTableName, testDir, options);
        this.assertEqualTables(90, source, sourceTableName, target, targetTableName, false);
        Assert.assertEquals((long)60L, (long)syncCounters.findCounter((Enum)SyncTable.SyncMapper.Counter.ROWSWITHDIFFS).getValue());
        Assert.assertEquals((long)10L, (long)syncCounters.findCounter((Enum)SyncTable.SyncMapper.Counter.SOURCEMISSINGROWS).getValue());
        Assert.assertEquals((long)10L, (long)syncCounters.findCounter((Enum)SyncTable.SyncMapper.Counter.TARGETMISSINGROWS).getValue());
        Assert.assertEquals((long)50L, (long)syncCounters.findCounter((Enum)SyncTable.SyncMapper.Counter.SOURCEMISSINGCELLS).getValue());
        Assert.assertEquals((long)50L, (long)syncCounters.findCounter((Enum)SyncTable.SyncMapper.Counter.TARGETMISSINGCELLS).getValue());
        Assert.assertEquals((long)20L, (long)syncCounters.findCounter((Enum)SyncTable.SyncMapper.Counter.DIFFERENTCELLVALUES).getValue());
        source.deleteTable(sourceTableName);
        target.deleteTable(targetTableName);
    }

    @Test
    public void testSyncTable() throws Exception {
        this.testSyncTable(UTIL1, UTIL1, new String[0]);
    }

    @Test
    public void testSyncTableToPeerCluster() throws Exception {
        this.testSyncTable(UTIL1, UTIL2, "--sourcezkcluster=" + UTIL1.getClusterKey());
    }

    @Test
    public void testSyncTableFromSourceToPeerCluster() throws Exception {
        this.testSyncTable(UTIL2, UTIL1, "--sourcezkcluster=" + UTIL2.getClusterKey(), "--targetzkcluster=" + UTIL1.getClusterKey());
    }

    @Test
    public void testSyncTableDoDeletesFalse() throws Exception {
        TableName sourceTableName = TableName.valueOf((String)(this.name.getMethodName() + "_source"));
        TableName targetTableName = TableName.valueOf((String)(this.name.getMethodName() + "_target"));
        Path testDir = UTIL1.getDataTestDirOnTestFS(this.name.getMethodName());
        this.writeTestData(UTIL1, sourceTableName, UTIL1, targetTableName, new long[0]);
        this.hashSourceTable(UTIL1, sourceTableName, testDir, new String[0]);
        Counters syncCounters = this.syncTables(UTIL1.getConfiguration(), sourceTableName, targetTableName, testDir, "--doDeletes=false");
        this.assertTargetDoDeletesFalse(100, UTIL1, sourceTableName, UTIL1, targetTableName);
        Assert.assertEquals((long)60L, (long)syncCounters.findCounter((Enum)SyncTable.SyncMapper.Counter.ROWSWITHDIFFS).getValue());
        Assert.assertEquals((long)10L, (long)syncCounters.findCounter((Enum)SyncTable.SyncMapper.Counter.SOURCEMISSINGROWS).getValue());
        Assert.assertEquals((long)10L, (long)syncCounters.findCounter((Enum)SyncTable.SyncMapper.Counter.TARGETMISSINGROWS).getValue());
        Assert.assertEquals((long)50L, (long)syncCounters.findCounter((Enum)SyncTable.SyncMapper.Counter.SOURCEMISSINGCELLS).getValue());
        Assert.assertEquals((long)50L, (long)syncCounters.findCounter((Enum)SyncTable.SyncMapper.Counter.TARGETMISSINGCELLS).getValue());
        Assert.assertEquals((long)20L, (long)syncCounters.findCounter((Enum)SyncTable.SyncMapper.Counter.DIFFERENTCELLVALUES).getValue());
        UTIL1.deleteTable(sourceTableName);
        UTIL1.deleteTable(targetTableName);
    }

    @Test
    public void testSyncTableDoPutsFalse() throws Exception {
        TableName sourceTableName = TableName.valueOf((String)(this.name.getMethodName() + "_source"));
        TableName targetTableName = TableName.valueOf((String)(this.name.getMethodName() + "_target"));
        Path testDir = UTIL2.getDataTestDirOnTestFS(this.name.getMethodName());
        this.writeTestData(UTIL2, sourceTableName, UTIL2, targetTableName, new long[0]);
        this.hashSourceTable(UTIL2, sourceTableName, testDir, new String[0]);
        Counters syncCounters = this.syncTables(UTIL2.getConfiguration(), sourceTableName, targetTableName, testDir, "--doPuts=false");
        this.assertTargetDoPutsFalse(70, UTIL2, sourceTableName, UTIL2, targetTableName);
        Assert.assertEquals((long)60L, (long)syncCounters.findCounter((Enum)SyncTable.SyncMapper.Counter.ROWSWITHDIFFS).getValue());
        Assert.assertEquals((long)10L, (long)syncCounters.findCounter((Enum)SyncTable.SyncMapper.Counter.SOURCEMISSINGROWS).getValue());
        Assert.assertEquals((long)10L, (long)syncCounters.findCounter((Enum)SyncTable.SyncMapper.Counter.TARGETMISSINGROWS).getValue());
        Assert.assertEquals((long)50L, (long)syncCounters.findCounter((Enum)SyncTable.SyncMapper.Counter.SOURCEMISSINGCELLS).getValue());
        Assert.assertEquals((long)50L, (long)syncCounters.findCounter((Enum)SyncTable.SyncMapper.Counter.TARGETMISSINGCELLS).getValue());
        Assert.assertEquals((long)20L, (long)syncCounters.findCounter((Enum)SyncTable.SyncMapper.Counter.DIFFERENTCELLVALUES).getValue());
        UTIL2.deleteTable(sourceTableName);
        UTIL2.deleteTable(targetTableName);
    }

    @Test
    public void testSyncTableIgnoreTimestampsTrue() throws Exception {
        TableName sourceTableName = TableName.valueOf((String)(this.name.getMethodName() + "_source"));
        TableName targetTableName = TableName.valueOf((String)(this.name.getMethodName() + "_target"));
        Path testDir = UTIL1.getDataTestDirOnTestFS(this.name.getMethodName());
        long current = EnvironmentEdgeManager.currentTime();
        this.writeTestData(UTIL1, sourceTableName, UTIL2, targetTableName, current - 1000L, current);
        this.hashSourceTable(UTIL1, sourceTableName, testDir, "--ignoreTimestamps=true");
        Counters syncCounters = this.syncTables(UTIL2.getConfiguration(), sourceTableName, targetTableName, testDir, "--ignoreTimestamps=true", "--sourcezkcluster=" + UTIL1.getClusterKey());
        this.assertEqualTables(90, UTIL1, sourceTableName, UTIL2, targetTableName, true);
        Assert.assertEquals((long)50L, (long)syncCounters.findCounter((Enum)SyncTable.SyncMapper.Counter.ROWSWITHDIFFS).getValue());
        Assert.assertEquals((long)10L, (long)syncCounters.findCounter((Enum)SyncTable.SyncMapper.Counter.SOURCEMISSINGROWS).getValue());
        Assert.assertEquals((long)10L, (long)syncCounters.findCounter((Enum)SyncTable.SyncMapper.Counter.TARGETMISSINGROWS).getValue());
        Assert.assertEquals((long)30L, (long)syncCounters.findCounter((Enum)SyncTable.SyncMapper.Counter.SOURCEMISSINGCELLS).getValue());
        Assert.assertEquals((long)30L, (long)syncCounters.findCounter((Enum)SyncTable.SyncMapper.Counter.TARGETMISSINGCELLS).getValue());
        Assert.assertEquals((long)20L, (long)syncCounters.findCounter((Enum)SyncTable.SyncMapper.Counter.DIFFERENTCELLVALUES).getValue());
        UTIL1.deleteTable(sourceTableName);
        UTIL2.deleteTable(targetTableName);
    }

    private void assertCellEquals(Cell sourceCell, Cell targetCell, BooleanSupplier checkTimestamp) {
        Assert.assertTrue((String)("Rows don't match, source: " + sourceCell + ", target: " + targetCell), (boolean)CellUtil.matchingRows((Cell)sourceCell, (Cell)targetCell));
        Assert.assertTrue((String)("Families don't match, source: " + sourceCell + ", target: " + targetCell), (boolean)CellUtil.matchingFamily((Cell)sourceCell, (Cell)targetCell));
        Assert.assertTrue((String)("Qualifiers don't match, source: " + sourceCell + ", target: " + targetCell), (boolean)CellUtil.matchingQualifier((Cell)sourceCell, (Cell)targetCell));
        if (checkTimestamp.getAsBoolean()) {
            Assert.assertTrue((String)("Timestamps don't match, source: " + sourceCell + ", target: " + targetCell), (boolean)CellUtil.matchingTimestamp((Cell)sourceCell, (Cell)targetCell));
        }
        Assert.assertTrue((String)("Values don't match, source: " + sourceCell + ", target: " + targetCell), (boolean)CellUtil.matchingValue((Cell)sourceCell, (Cell)targetCell));
    }

    private void assertEqualTables(int expectedRows, HBaseTestingUtility sourceCluster, TableName sourceTableName, HBaseTestingUtility targetCluster, TableName targetTableName, boolean ignoreTimestamps) throws Exception {
        try (Table sourceTable = sourceCluster.getConnection().getTable(sourceTableName);
             Table targetTable = targetCluster.getConnection().getTable(targetTableName);
             ResultScanner sourceScanner = sourceTable.getScanner(new Scan());
             ResultScanner targetScanner = targetTable.getScanner(new Scan());){
            Result targetRow;
            for (int i = 0; i < expectedRows; ++i) {
                Object[] targetCells;
                Object[] sourceCells;
                Result sourceRow = sourceScanner.next();
                Result targetRow2 = targetScanner.next();
                LOG.debug("SOURCE row: " + (sourceRow == null ? "null" : Integer.valueOf(Bytes.toInt((byte[])sourceRow.getRow()))) + " cells:" + sourceRow);
                LOG.debug("TARGET row: " + (targetRow2 == null ? "null" : Integer.valueOf(Bytes.toInt((byte[])targetRow2.getRow()))) + " cells:" + targetRow2);
                if (sourceRow == null) {
                    Assert.fail((String)("Expected " + expectedRows + " source rows but only found " + i));
                }
                if (targetRow2 == null) {
                    Assert.fail((String)("Expected " + expectedRows + " target rows but only found " + i));
                }
                if ((sourceCells = sourceRow.rawCells()).length != (targetCells = targetRow2.rawCells()).length) {
                    LOG.debug("Source cells: " + Arrays.toString(sourceCells));
                    LOG.debug("Target cells: " + Arrays.toString(targetCells));
                    Assert.fail((String)("Row " + Bytes.toInt((byte[])sourceRow.getRow()) + " has " + sourceCells.length + " cells in source table but " + targetCells.length + " cells in target table"));
                }
                for (int j = 0; j < sourceCells.length; ++j) {
                    Object sourceCell = sourceCells[j];
                    Cell targetCell = targetCells[j];
                    this.assertCellEquals((Cell)sourceCell, targetCell, () -> !ignoreTimestamps);
                }
            }
            Result sourceRow = sourceScanner.next();
            if (sourceRow != null) {
                Assert.fail((String)("Source table has more than " + expectedRows + " rows.  Next row: " + Bytes.toInt((byte[])sourceRow.getRow())));
            }
            if ((targetRow = targetScanner.next()) != null) {
                Assert.fail((String)("Target table has more than " + expectedRows + " rows.  Next row: " + Bytes.toInt((byte[])targetRow.getRow())));
            }
        }
    }

    private void assertTargetDoDeletesFalse(int expectedRows, HBaseTestingUtility sourceCluster, TableName sourceTableName, HBaseTestingUtility targetCluster, TableName targetTableName) throws Exception {
        try (Table sourceTable = sourceCluster.getConnection().getTable(sourceTableName);
             Table targetTable = targetCluster.getConnection().getTable(targetTableName);
             ResultScanner sourceScanner = sourceTable.getScanner(new Scan());
             ResultScanner targetScanner = targetTable.getScanner(new Scan());){
            Result targetRow = targetScanner.next();
            Result sourceRow = sourceScanner.next();
            int rowsCount = 0;
            while (targetRow != null) {
                ++rowsCount;
                if (Bytes.toInt((byte[])sourceRow.getRow()) != Bytes.toInt((byte[])targetRow.getRow())) {
                    targetRow = targetScanner.next();
                    continue;
                }
                LOG.debug("SOURCE row: " + (sourceRow == null ? "null" : Integer.valueOf(Bytes.toInt((byte[])sourceRow.getRow()))) + " cells:" + sourceRow);
                LOG.debug("TARGET row: " + (targetRow == null ? "null" : Integer.valueOf(Bytes.toInt((byte[])targetRow.getRow()))) + " cells:" + targetRow);
                Object[] sourceCells = sourceRow.rawCells();
                Object[] targetCells = targetRow.rawCells();
                int targetRowKey = Bytes.toInt((byte[])targetRow.getRow());
                if (targetRowKey >= 70 && targetRowKey < 80) {
                    if (sourceCells.length == targetCells.length) {
                        LOG.debug("Source cells: " + Arrays.toString(sourceCells));
                        LOG.debug("Target cells: " + Arrays.toString(targetCells));
                        Assert.fail((String)("Row " + targetRowKey + " should have more cells in target than in source"));
                    }
                } else if (sourceCells.length != targetCells.length) {
                    LOG.debug("Source cells: " + Arrays.toString(sourceCells));
                    LOG.debug("Target cells: " + Arrays.toString(targetCells));
                    Assert.fail((String)("Row " + Bytes.toInt((byte[])sourceRow.getRow()) + " has " + sourceCells.length + " cells in source table but " + targetCells.length + " cells in target table"));
                }
                for (int j = 0; j < sourceCells.length; ++j) {
                    Object sourceCell = sourceCells[j];
                    Cell targetCell = targetCells[j];
                    this.assertCellEquals((Cell)sourceCell, targetCell, () -> targetRowKey < 80 && targetRowKey >= 90);
                }
                targetRow = targetScanner.next();
                sourceRow = sourceScanner.next();
            }
            Assert.assertEquals((String)"Target expected rows does not match.", (long)expectedRows, (long)rowsCount);
        }
    }

    private void assertTargetDoPutsFalse(int expectedRows, HBaseTestingUtility sourceCluster, TableName sourceTableName, HBaseTestingUtility targetCluster, TableName targetTableName) throws Exception {
        try (Table sourceTable = sourceCluster.getConnection().getTable(sourceTableName);
             Table targetTable = targetCluster.getConnection().getTable(targetTableName);
             ResultScanner sourceScanner = sourceTable.getScanner(new Scan());
             ResultScanner targetScanner = targetTable.getScanner(new Scan());){
            Result targetRow = targetScanner.next();
            Result sourceRow = sourceScanner.next();
            int rowsCount = 0;
            while (targetRow != null) {
                Object targetCell;
                Object sourceCell;
                int j;
                if (Bytes.toInt((byte[])sourceRow.getRow()) != Bytes.toInt((byte[])targetRow.getRow())) {
                    sourceRow = sourceScanner.next();
                    continue;
                }
                LOG.debug("SOURCE row: " + (sourceRow == null ? "null" : Integer.valueOf(Bytes.toInt((byte[])sourceRow.getRow()))) + " cells:" + sourceRow);
                LOG.debug("TARGET row: " + (targetRow == null ? "null" : Integer.valueOf(Bytes.toInt((byte[])targetRow.getRow()))) + " cells:" + targetRow);
                LOG.debug("rowsCount: " + rowsCount);
                Object[] sourceCells = sourceRow.rawCells();
                Object[] targetCells = targetRow.rawCells();
                int targetRowKey = Bytes.toInt((byte[])targetRow.getRow());
                if (targetRowKey >= 40 && targetRowKey < 60) {
                    LOG.debug("Source cells: " + Arrays.toString(sourceCells));
                    LOG.debug("Target cells: " + Arrays.toString(targetCells));
                    Assert.fail((String)"There shouldn't exist any rows between 40 and 60, since Puts are disabled and Deletes are enabled.");
                } else if (targetRowKey >= 60 && targetRowKey < 70) {
                    if (sourceCells.length == targetCells.length) {
                        LOG.debug("Source cells: " + Arrays.toString(sourceCells));
                        LOG.debug("Target cells: " + Arrays.toString(targetCells));
                        Assert.fail((String)("Row " + Bytes.toInt((byte[])sourceRow.getRow()) + " shouldn't have same number of cells."));
                    }
                } else if (targetRowKey >= 80 && targetRowKey < 90) {
                    LOG.debug("Source cells: " + Arrays.toString(sourceCells));
                    LOG.debug("Target cells: " + Arrays.toString(targetCells));
                    Assert.fail((String)"There should be no rows between 80 and 90 on target, as these had different timestamps and should had been deleted.");
                } else if (targetRowKey >= 90 && targetRowKey < 100) {
                    for (j = 0; j < sourceCells.length; ++j) {
                        sourceCell = sourceCells[j];
                        targetCell = targetCells[j];
                        if (!CellUtil.matchingValue((Cell)sourceCell, (Cell)targetCell)) continue;
                        Assert.fail((String)("Cells values should not match for rows between 90 and 100. Target row id: " + Bytes.toInt((byte[])targetRow.getRow())));
                    }
                } else {
                    for (j = 0; j < sourceCells.length; ++j) {
                        sourceCell = sourceCells[j];
                        targetCell = targetCells[j];
                        this.assertCellEquals((Cell)sourceCell, (Cell)targetCell, () -> true);
                    }
                }
                ++rowsCount;
                targetRow = targetScanner.next();
                sourceRow = sourceScanner.next();
            }
            Assert.assertEquals((String)"Target expected rows does not match.", (long)expectedRows, (long)rowsCount);
        }
    }

    private Counters syncTables(Configuration conf, TableName sourceTableName, TableName targetTableName, Path testDir, String ... options) throws Exception {
        SyncTable syncTable = new SyncTable(conf);
        String[] args = Arrays.copyOf(options, options.length + 3);
        args[options.length] = testDir.toString();
        args[options.length + 1] = sourceTableName.getNameAsString();
        args[options.length + 2] = targetTableName.getNameAsString();
        int code = syncTable.run(args);
        Assert.assertEquals((String)"sync table job failed", (long)0L, (long)code);
        LOG.info("Sync tables completed");
        return syncTable.counters;
    }

    private void hashSourceTable(HBaseTestingUtility sourceCluster, TableName sourceTableName, Path testDir, String ... options) throws Exception {
        int numHashFiles = 3;
        long batchSize = 100L;
        int scanBatch = 1;
        HashTable hashTable = new HashTable(sourceCluster.getConfiguration());
        String[] args = Arrays.copyOf(options, options.length + 5);
        args[options.length] = "--batchsize=" + batchSize;
        args[options.length + 1] = "--numhashfiles=" + numHashFiles;
        args[options.length + 2] = "--scanbatch=" + scanBatch;
        args[options.length + 3] = sourceTableName.getNameAsString();
        args[options.length + 4] = testDir.toString();
        int code = hashTable.run(args);
        Assert.assertEquals((String)"hash table job failed", (long)0L, (long)code);
        FileSystem fs = sourceCluster.getTestFileSystem();
        HashTable.TableHash tableHash = HashTable.TableHash.read((Configuration)fs.getConf(), (Path)testDir);
        Assert.assertEquals((Object)sourceTableName.getNameAsString(), (Object)tableHash.tableName);
        Assert.assertEquals((long)batchSize, (long)tableHash.batchSize);
        Assert.assertEquals((long)numHashFiles, (long)tableHash.numHashFiles);
        Assert.assertEquals((long)(numHashFiles - 1), (long)tableHash.partitions.size());
        LOG.info("Hash table completed");
    }

    private void writeTestData(HBaseTestingUtility sourceCluster, TableName sourceTableName, HBaseTestingUtility targetCluster, TableName targetTableName, long ... timestamps) throws Exception {
        byte[] family = Bytes.toBytes((String)"family");
        byte[] column1 = Bytes.toBytes((String)"c1");
        byte[] column2 = Bytes.toBytes((String)"c2");
        byte[] value1 = Bytes.toBytes((String)"val1");
        byte[] value2 = Bytes.toBytes((String)"val2");
        byte[] value3 = Bytes.toBytes((String)"val3");
        int numRows = 100;
        int sourceRegions = 10;
        int targetRegions = 6;
        if (ArrayUtils.isEmpty((long[])timestamps)) {
            long current = EnvironmentEdgeManager.currentTime();
            timestamps = new long[]{current, current};
        }
        try (Table sourceTable = sourceCluster.createTable(sourceTableName, family, TestSyncTable.generateSplits(numRows, sourceRegions));
             Table targetTable = targetCluster.createTable(targetTableName, family, TestSyncTable.generateSplits(numRows, targetRegions));){
            Put put;
            Put targetPut;
            Put sourcePut;
            int rowIndex;
            for (rowIndex = 0; rowIndex < 40; ++rowIndex) {
                sourcePut = new Put(Bytes.toBytes((int)rowIndex));
                sourcePut.addColumn(family, column1, timestamps[0], value1);
                sourcePut.addColumn(family, column2, timestamps[0], value2);
                sourceTable.put(sourcePut);
                targetPut = new Put(Bytes.toBytes((int)rowIndex));
                targetPut.addColumn(family, column1, timestamps[1], value1);
                targetPut.addColumn(family, column2, timestamps[1], value2);
                targetTable.put(targetPut);
            }
            while (rowIndex < 50) {
                put = new Put(Bytes.toBytes((int)rowIndex));
                put.addColumn(family, column1, timestamps[0], value1);
                put.addColumn(family, column2, timestamps[0], value2);
                sourceTable.put(put);
                ++rowIndex;
            }
            while (rowIndex < 60) {
                put = new Put(Bytes.toBytes((int)rowIndex));
                put.addColumn(family, column1, timestamps[1], value1);
                put.addColumn(family, column2, timestamps[1], value2);
                targetTable.put(put);
                ++rowIndex;
            }
            while (rowIndex < 70) {
                sourcePut = new Put(Bytes.toBytes((int)rowIndex));
                sourcePut.addColumn(family, column1, timestamps[0], value1);
                sourcePut.addColumn(family, column2, timestamps[0], value2);
                sourceTable.put(sourcePut);
                targetPut = new Put(Bytes.toBytes((int)rowIndex));
                targetPut.addColumn(family, column1, timestamps[1], value1);
                targetTable.put(targetPut);
                ++rowIndex;
            }
            while (rowIndex < 80) {
                sourcePut = new Put(Bytes.toBytes((int)rowIndex));
                sourcePut.addColumn(family, column1, timestamps[0], value1);
                sourceTable.put(sourcePut);
                targetPut = new Put(Bytes.toBytes((int)rowIndex));
                targetPut.addColumn(family, column1, timestamps[1], value1);
                targetPut.addColumn(family, column2, timestamps[1], value2);
                targetTable.put(targetPut);
                ++rowIndex;
            }
            while (rowIndex < 90) {
                sourcePut = new Put(Bytes.toBytes((int)rowIndex));
                sourcePut.addColumn(family, column1, timestamps[0], column1);
                sourcePut.addColumn(family, column2, timestamps[0], value2);
                sourceTable.put(sourcePut);
                targetPut = new Put(Bytes.toBytes((int)rowIndex));
                targetPut.addColumn(family, column1, timestamps[1] + 1L, column1);
                targetPut.addColumn(family, column2, timestamps[1] - 1L, value2);
                targetTable.put(targetPut);
                ++rowIndex;
            }
            while (rowIndex < numRows) {
                sourcePut = new Put(Bytes.toBytes((int)rowIndex));
                sourcePut.addColumn(family, column1, timestamps[0], value1);
                sourcePut.addColumn(family, column2, timestamps[0], value2);
                sourceTable.put(sourcePut);
                targetPut = new Put(Bytes.toBytes((int)rowIndex));
                targetPut.addColumn(family, column1, timestamps[1], value3);
                targetPut.addColumn(family, column2, timestamps[1], value3);
                targetTable.put(targetPut);
                ++rowIndex;
            }
        }
    }
}

