/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop.screen.help;

import org.apache.hadoop.hbase.hbtop.screen.AbstractScreenView;
import org.apache.hadoop.hbase.hbtop.screen.Screen;
import org.apache.hadoop.hbase.hbtop.screen.ScreenView;
import org.apache.hadoop.hbase.hbtop.screen.help.CommandDescription;
import org.apache.hadoop.hbase.hbtop.screen.help.HelpScreenPresenter;
import org.apache.hadoop.hbase.hbtop.terminal.KeyPress;
import org.apache.hadoop.hbase.hbtop.terminal.Terminal;
import org.apache.hadoop.hbase.hbtop.terminal.TerminalPrinter;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class HelpScreenView
extends AbstractScreenView {
    private static final int SCREEN_DESCRIPTION_START_ROW = 0;
    private static final int COMMAND_DESCRIPTION_START_ROW = 3;
    private final HelpScreenPresenter helpScreenPresenter;

    public HelpScreenView(Screen screen, Terminal terminal, long refreshDelay, ScreenView nextScreenView) {
        super(screen, terminal);
        this.helpScreenPresenter = new HelpScreenPresenter(this, refreshDelay, nextScreenView);
    }

    @Override
    public void init() {
        this.helpScreenPresenter.init();
    }

    @Override
    public ScreenView handleKeyPress(KeyPress keyPress) {
        return this.helpScreenPresenter.transitionToNextScreen();
    }

    public void showHelpScreen(long refreshDelay, CommandDescription[] commandDescriptions) {
        this.showScreenDescription(refreshDelay);
        TerminalPrinter printer = this.getTerminalPrinter(3);
        for (CommandDescription commandDescription : commandDescriptions) {
            this.showCommandDescription(printer, commandDescription);
        }
        printer.endOfLine();
        printer.print("Press any key to continue").endOfLine();
    }

    private void showScreenDescription(long refreshDelay) {
        TerminalPrinter printer = this.getTerminalPrinter(0);
        printer.startBold().print("Help for Interactive Commands").stopBold().endOfLine();
        printer.print("Refresh delay: ").startBold().print((double)refreshDelay / 1000.0).stopBold().endOfLine();
    }

    private void showCommandDescription(TerminalPrinter terminalPrinter, CommandDescription commandDescription) {
        terminalPrinter.print("  ");
        boolean first = true;
        for (String key : commandDescription.getKeys()) {
            if (first) {
                first = false;
            } else {
                terminalPrinter.print(",");
            }
            terminalPrinter.startBold().print(key).stopBold();
        }
        terminalPrinter.printFormat(": %s", commandDescription.getDescription()).endOfLine();
    }
}

