/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseServerException;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.RetryImmediatelyException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Action;
import org.apache.hadoop.hbase.client.AsyncProcess;
import org.apache.hadoop.hbase.client.AsyncProcessTask;
import org.apache.hadoop.hbase.client.AsyncRequestFuture;
import org.apache.hadoop.hbase.client.BatchErrors;
import org.apache.hadoop.hbase.client.CancellableRegionServerCallable;
import org.apache.hadoop.hbase.client.ConnectionImplementation;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.DelayingRunner;
import org.apache.hadoop.hbase.client.MetricsConnection;
import org.apache.hadoop.hbase.client.MultiAction;
import org.apache.hadoop.hbase.client.MultiResponse;
import org.apache.hadoop.hbase.client.MultiServerCallable;
import org.apache.hadoop.hbase.client.OperationTimeoutExceededException;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.RetryingTimeTracker;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.ServerStatisticTracker;
import org.apache.hadoop.hbase.client.backoff.ServerStatistics;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.exceptions.ClientExceptionsUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class AsyncRequestFutureImpl<CResult>
implements AsyncRequestFuture {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncRequestFutureImpl.class);
    private RetryingTimeTracker tracker;
    private final Batch.Callback<CResult> callback;
    private final BatchErrors errors;
    private final ConnectionImplementation.ServerErrorTracker errorsByServer;
    private final ExecutorService pool;
    private final Set<CancellableRegionServerCallable> callsInProgress;
    private final TableName tableName;
    private final AtomicLong actionsInProgress = new AtomicLong(-1L);
    private final Object replicaResultLock = new Object();
    private final Object[] results;
    private final int[] replicaGetIndices;
    private final boolean hasAnyReplicaGets;
    private final long nonceGroup;
    private final CancellableRegionServerCallable currentCallable;
    private final int operationTimeout;
    private final int rpcTimeout;
    private final AsyncProcess asyncProcess;

    public AsyncRequestFutureImpl(AsyncProcessTask task, List<Action> actions, long nonceGroup, AsyncProcess asyncProcess) {
        this.pool = task.getPool();
        this.callback = task.getCallback();
        this.nonceGroup = nonceGroup;
        this.tableName = task.getTableName();
        this.actionsInProgress.set(actions.size());
        if (task.getResults() == null) {
            this.results = task.getNeedResults() ? new Object[actions.size()] : null;
        } else {
            if (task.getResults().length != actions.size()) {
                throw new AssertionError((Object)"results.length");
            }
            this.results = task.getResults();
            for (int i = 0; i != this.results.length; ++i) {
                this.results[i] = null;
            }
        }
        ArrayList<Integer> replicaGetIndices = null;
        boolean hasAnyReplicaGets = false;
        if (this.results != null) {
            boolean hasAnyNonReplicaReqs = false;
            int posInList = 0;
            for (Action action : actions) {
                boolean isReplicaGet = AsyncProcess.isReplicaGet(action.getAction());
                if (isReplicaGet) {
                    hasAnyReplicaGets = true;
                    if (hasAnyNonReplicaReqs) {
                        if (replicaGetIndices == null) {
                            replicaGetIndices = new ArrayList<Integer>(actions.size() - 1);
                        }
                        replicaGetIndices.add(posInList);
                    }
                } else if (!hasAnyNonReplicaReqs) {
                    hasAnyNonReplicaReqs = true;
                    if (posInList > 0) {
                        replicaGetIndices = new ArrayList(actions.size() - 1);
                        for (int i = 0; i < posInList; ++i) {
                            replicaGetIndices.add(i);
                        }
                    }
                }
                ++posInList;
            }
        }
        this.hasAnyReplicaGets = hasAnyReplicaGets;
        if (replicaGetIndices != null) {
            this.replicaGetIndices = new int[replicaGetIndices.size()];
            int i = 0;
            for (Integer el : replicaGetIndices) {
                this.replicaGetIndices[i++] = el;
            }
        } else {
            this.replicaGetIndices = null;
        }
        this.callsInProgress = !hasAnyReplicaGets ? null : Collections.newSetFromMap(new ConcurrentHashMap());
        this.asyncProcess = asyncProcess;
        this.errorsByServer = this.createServerErrorTracker();
        this.errors = new BatchErrors();
        this.operationTimeout = task.getOperationTimeout();
        this.rpcTimeout = task.getRpcTimeout();
        this.currentCallable = task.getCallable();
        if (task.getCallable() == null) {
            this.tracker = new RetryingTimeTracker().start();
        }
    }

    protected Set<CancellableRegionServerCallable> getCallsInProgress() {
        return this.callsInProgress;
    }

    SingleServerRequestRunnable createSingleServerRequest(MultiAction multiAction, int numAttempt, ServerName server, Set<CancellableRegionServerCallable> callsInProgress) {
        return new SingleServerRequestRunnable(multiAction, numAttempt, server, callsInProgress);
    }

    private boolean isOperationTimeoutExceeded() {
        RetryingTimeTracker currentTracker;
        if (this.tracker != null) {
            currentTracker = this.tracker;
        } else if (this.currentCallable != null && this.currentCallable.getTracker() != null) {
            currentTracker = this.currentCallable.getTracker();
        } else {
            return false;
        }
        currentTracker.start();
        return currentTracker.getRemainingTime(this.operationTimeout) == 1;
    }

    void groupAndSendMultiAction(List<Action> currentActions, int numAttempt) {
        boolean hasUnknown;
        byte[] regionName;
        HRegionLocation loc;
        HashMap<ServerName, MultiAction> actionsByServer = new HashMap<ServerName, MultiAction>();
        boolean isReplica = false;
        ArrayList<Action> unknownReplicaActions = null;
        ArrayList<Action> locateRegionFailedActions = null;
        for (Action action : currentActions) {
            boolean isReplicaAction;
            if (this.isOperationTimeoutExceeded()) {
                actionsByServer.clear();
                this.failIncompleteActionsWithOpTimeout(currentActions, locateRegionFailedActions, numAttempt);
                return;
            }
            RegionLocations locs = this.findAllLocationsOrFail(action, true);
            if (locs == null) {
                if (locateRegionFailedActions == null) {
                    locateRegionFailedActions = new ArrayList<Action>(1);
                }
                locateRegionFailedActions.add(action);
                continue;
            }
            boolean bl = isReplicaAction = !RegionReplicaUtil.isDefaultReplica(action.getReplicaId());
            if (isReplica && !isReplicaAction) {
                throw new AssertionError((Object)"Replica and non-replica actions in the same retry");
            }
            isReplica = isReplicaAction;
            loc = locs.getRegionLocation(action.getReplicaId());
            if (loc == null || loc.getServerName() == null) {
                if (isReplica) {
                    if (unknownReplicaActions == null) {
                        unknownReplicaActions = new ArrayList<Action>(1);
                    }
                    unknownReplicaActions.add(action);
                    continue;
                }
                this.manageLocationError(action, null);
                if (locateRegionFailedActions == null) {
                    locateRegionFailedActions = new ArrayList(1);
                }
                locateRegionFailedActions.add(action);
                continue;
            }
            regionName = loc.getRegionInfo().getRegionName();
            AsyncProcess.addAction(loc.getServerName(), regionName, action, actionsByServer, this.nonceGroup);
        }
        boolean doStartReplica = numAttempt == 1 && !isReplica && this.hasAnyReplicaGets;
        boolean bl = hasUnknown = unknownReplicaActions != null && !unknownReplicaActions.isEmpty();
        if (!actionsByServer.isEmpty()) {
            this.sendMultiAction(actionsByServer, numAttempt, doStartReplica && !hasUnknown ? currentActions : null, numAttempt > 1 && !hasUnknown);
        }
        if (hasUnknown) {
            actionsByServer = new HashMap();
            for (Action action : unknownReplicaActions) {
                loc = this.getReplicaLocationOrFail(action);
                if (loc == null) continue;
                regionName = loc.getRegionInfo().getRegionName();
                AsyncProcess.addAction(loc.getServerName(), regionName, action, actionsByServer, this.nonceGroup);
            }
            if (!actionsByServer.isEmpty()) {
                this.sendMultiAction(actionsByServer, numAttempt, doStartReplica ? currentActions : null, true);
            }
        }
    }

    private HRegionLocation getReplicaLocationOrFail(Action action) {
        int replicaId = action.getReplicaId();
        RegionLocations locs = this.findAllLocationsOrFail(action, true);
        if (locs == null) {
            return null;
        }
        HRegionLocation loc = locs.getRegionLocation(replicaId);
        if (loc == null || loc.getServerName() == null) {
            locs = this.findAllLocationsOrFail(action, false);
            if (locs == null) {
                return null;
            }
            loc = locs.getRegionLocation(replicaId);
        }
        if (loc == null || loc.getServerName() == null) {
            this.manageLocationError(action, null);
            return null;
        }
        return loc;
    }

    private void manageLocationError(Action action, Exception ex) {
        String msg = "Cannot get replica " + action.getReplicaId() + " location for " + action.getAction();
        LOG.error(msg);
        if (ex == null) {
            ex = new IOException(msg);
        }
        this.manageError(action.getOriginalIndex(), action.getAction(), Retry.NO_LOCATION_PROBLEM, ex, null);
    }

    private RegionLocations findAllLocationsOrFail(Action action, boolean useCache) {
        if (action.getAction() == null) {
            throw new IllegalArgumentException("#" + this.asyncProcess.id + ", row cannot be null");
        }
        RegionLocations loc = null;
        try {
            loc = this.asyncProcess.connection.locateRegion(this.tableName, action.getAction().getRow(), useCache, true, action.getReplicaId());
        }
        catch (IOException ex) {
            this.manageLocationError(action, ex);
        }
        return loc;
    }

    private void failIncompleteActionsWithOpTimeout(List<Action> actions, List<Action> locateRegionFailedActions, int numAttempt) {
        String message = numAttempt == 1 ? "Operation timeout exceeded during resolution of region locations, prior to executing any actions." : "Operation timeout exceeded during re-resolution of region locations on retry " + (numAttempt - 1) + ".";
        message = message + " Meta may be slow or operation timeout too short for batch size or retries.";
        OperationTimeoutExceededException exception = new OperationTimeoutExceededException(message);
        for (Action actionToFail : actions) {
            boolean actionAlreadyFailed = locateRegionFailedActions != null && locateRegionFailedActions.stream().anyMatch(failedAction -> failedAction.getOriginalIndex() == actionToFail.getOriginalIndex() && failedAction.getReplicaId() == actionToFail.getReplicaId());
            if (actionAlreadyFailed) continue;
            this.manageLocationError(actionToFail, (Exception)((Object)exception));
        }
    }

    void sendMultiAction(Map<ServerName, MultiAction> actionsByServer, int numAttempt, List<Action> actionsForReplicaThread, boolean reuseThread) {
        boolean clearServerCache = true;
        int actionsRemaining = actionsByServer.size();
        for (Map.Entry<ServerName, MultiAction> e : actionsByServer.entrySet()) {
            MultiAction multiAction;
            ServerName server = e.getKey();
            Collection<Runnable> runnables = this.getNewMultiActionRunnable(server, multiAction = e.getValue(), numAttempt);
            if (runnables.size() > actionsRemaining) {
                actionsRemaining = runnables.size();
            }
            for (Runnable runnable : runnables) {
                if (--actionsRemaining == 0 && reuseThread && numAttempt % 15 != 0) {
                    runnable.run();
                    continue;
                }
                try {
                    this.pool.execute(runnable);
                }
                catch (Throwable t) {
                    if (t instanceof RejectedExecutionException) {
                        LOG.warn("id=" + this.asyncProcess.id + ", task rejected by pool. Unexpected. Server=" + server.getServerName(), t);
                        clearServerCache = false;
                    } else {
                        LOG.warn("Caught unexpected exception/error: ", t);
                    }
                    this.asyncProcess.decTaskCounters(multiAction.getRegions(), server);
                    this.receiveGlobalFailure(multiAction, server, numAttempt, t, clearServerCache);
                }
            }
        }
        if (actionsForReplicaThread != null) {
            this.startWaitingForReplicaCalls(actionsForReplicaThread);
        }
    }

    private Collection<? extends Runnable> getNewMultiActionRunnable(ServerName server, MultiAction multiAction, int numAttempt) {
        if (this.asyncProcess.connection.getStatisticsTracker() == null) {
            if (this.asyncProcess.connection.getConnectionMetrics() != null) {
                this.asyncProcess.connection.getConnectionMetrics().incrNormalRunners();
            }
            this.asyncProcess.incTaskCounters(multiAction.getRegions(), server);
            SingleServerRequestRunnable runnable = this.createSingleServerRequest(multiAction, numAttempt, server, this.callsInProgress);
            return Collections.singletonList(runnable);
        }
        HashMap<Long, DelayingRunner> actions = new HashMap<Long, DelayingRunner>(multiAction.size());
        for (Map.Entry<byte[], List<Action>> e : multiAction.actions.entrySet()) {
            Long backoff = this.getBackoff(server, e.getKey());
            DelayingRunner runner = (DelayingRunner)actions.get(backoff);
            if (runner == null) {
                actions.put(backoff, new DelayingRunner(backoff, e));
                continue;
            }
            runner.add(e);
        }
        ArrayList<SingleServerRequestRunnable> toReturn = new ArrayList<SingleServerRequestRunnable>(actions.size());
        for (DelayingRunner runner : actions.values()) {
            this.asyncProcess.incTaskCounters(runner.getActions().getRegions(), server);
            Runnable runnable = this.createSingleServerRequest(runner.getActions(), numAttempt, server, this.callsInProgress);
            if (runner.getSleepTime() > 0L) {
                runner.setRunner(runnable);
                runnable = runner;
                if (this.asyncProcess.connection.getConnectionMetrics() != null) {
                    this.asyncProcess.connection.getConnectionMetrics().incrDelayRunnersAndUpdateDelayInterval(runner.getSleepTime());
                }
            } else if (this.asyncProcess.connection.getConnectionMetrics() != null) {
                this.asyncProcess.connection.getConnectionMetrics().incrNormalRunners();
            }
            toReturn.add((SingleServerRequestRunnable)runnable);
        }
        return toReturn;
    }

    private Long getBackoff(ServerName server, byte[] regionName) {
        ServerStatisticTracker tracker = this.asyncProcess.connection.getStatisticsTracker();
        ServerStatistics stats = tracker.getStats(server);
        return this.asyncProcess.connection.getBackoffPolicy().getBackoffTime(server, regionName, stats);
    }

    private void startWaitingForReplicaCalls(List<Action> actionsForReplicaThread) {
        long startTime = EnvironmentEdgeManager.currentTime();
        ReplicaCallIssuingRunnable replicaRunnable = new ReplicaCallIssuingRunnable(actionsForReplicaThread, startTime);
        if (this.asyncProcess.primaryCallTimeoutMicroseconds == 0L) {
            replicaRunnable.run();
        } else {
            try {
                this.pool.execute(replicaRunnable);
            }
            catch (RejectedExecutionException ree) {
                LOG.warn("id=" + this.asyncProcess.id + " replica task rejected by pool; no replica calls", (Throwable)ree);
            }
        }
    }

    Retry manageError(int originalIndex, Row row, Retry canRetry, Throwable throwable, ServerName server) {
        if (canRetry == Retry.YES && throwable != null && throwable instanceof DoNotRetryIOException) {
            canRetry = Retry.NO_NOT_RETRIABLE;
        }
        if (canRetry != Retry.YES) {
            this.setError(originalIndex, row, throwable, server);
        } else if (this.isActionComplete(originalIndex, row)) {
            canRetry = Retry.NO_OTHER_SUCCEEDED;
        }
        return canRetry;
    }

    private void failAll(MultiAction actions, ServerName server, int numAttempt, Throwable throwable) {
        int failed = 0;
        for (Map.Entry<byte[], List<Action>> e : actions.actions.entrySet()) {
            for (Action action : e.getValue()) {
                this.setError(action.getOriginalIndex(), action.getAction(), throwable, server);
                ++failed;
            }
        }
        this.logNoResubmit(server, numAttempt, actions.size(), throwable, failed, 0);
    }

    private void receiveGlobalFailure(MultiAction rsActions, ServerName server, int numAttempt, Throwable t, boolean clearServerCache) {
        Retry canRetry;
        this.errorsByServer.reportServerError(server);
        Retry retry = canRetry = this.errorsByServer.canTryMore(numAttempt) ? Retry.YES : Retry.NO_RETRIES_EXHAUSTED;
        if (clearServerCache) {
            this.cleanServerCache(server, t);
        }
        int failed = 0;
        int stopped = 0;
        ArrayList<Action> toReplay = new ArrayList<Action>();
        for (Map.Entry<byte[], List<Action>> e : rsActions.actions.entrySet()) {
            byte[] regionName = e.getKey();
            byte[] row = e.getValue().get(0).getAction().getRow();
            if (clearServerCache) {
                this.updateCachedLocations(server, regionName, row, ClientExceptionsUtil.isMetaClearingException(t) ? null : t);
            }
            for (Action action : e.getValue()) {
                Retry retry2 = this.manageError(action.getOriginalIndex(), action.getAction(), canRetry, t, server);
                if (retry2 == Retry.YES) {
                    toReplay.add(action);
                    continue;
                }
                if (retry2 == Retry.NO_OTHER_SUCCEEDED) {
                    ++stopped;
                    continue;
                }
                ++failed;
            }
        }
        if (toReplay.isEmpty()) {
            this.logNoResubmit(server, numAttempt, rsActions.size(), t, failed, stopped);
        } else {
            this.resubmit(server, toReplay, numAttempt, rsActions.size(), t);
        }
    }

    private void resubmit(ServerName oldServer, List<Action> toReplay, int numAttempt, int failureCount, Throwable throwable) {
        int nextAttemptNumber;
        boolean retryImmediately = throwable instanceof RetryImmediatelyException;
        int n = nextAttemptNumber = retryImmediately ? numAttempt : numAttempt + 1;
        long backOffTime = retryImmediately ? 0L : (HBaseServerException.isServerOverloaded(throwable) ? this.errorsByServer.calculateBackoffTime(oldServer, this.asyncProcess.connectionConfiguration.getPauseMillisForServerOverloaded()) : this.errorsByServer.calculateBackoffTime(oldServer, this.asyncProcess.connectionConfiguration.getPauseMillis()));
        MetricsConnection metrics = this.asyncProcess.connection.getConnectionMetrics();
        if (metrics != null && HBaseServerException.isServerOverloaded(throwable)) {
            metrics.incrementServerOverloadedBackoffTime(backOffTime, TimeUnit.MILLISECONDS);
        }
        if (numAttempt > this.asyncProcess.startLogErrorsCnt) {
            LOG.info(this.createLog(numAttempt, failureCount, toReplay.size(), oldServer, throwable, backOffTime, true, null, -1, -1));
        }
        try {
            if (backOffTime > 0L) {
                Thread.sleep(backOffTime);
            }
        }
        catch (InterruptedException e) {
            LOG.warn("#" + this.asyncProcess.id + ", not sent: " + toReplay.size() + " operations, " + oldServer, (Throwable)e);
            Thread.currentThread().interrupt();
            return;
        }
        this.groupAndSendMultiAction(toReplay, nextAttemptNumber);
    }

    private void logNoResubmit(ServerName oldServer, int numAttempt, int failureCount, Throwable throwable, int failed, int stopped) {
        if (failureCount != 0 || numAttempt > this.asyncProcess.startLogErrorsCnt + 1) {
            String timeStr = new Date(this.errorsByServer.getStartTrackingTime()).toString();
            String logMessage = this.createLog(numAttempt, failureCount, 0, oldServer, throwable, -1L, false, timeStr, failed, stopped);
            if (failed != 0) {
                LOG.warn(logMessage);
            } else {
                LOG.info(logMessage);
            }
        }
    }

    private void receiveMultiAction(MultiAction multiAction, ServerName server, MultiResponse responses, int numAttempt) {
        assert (responses != null);
        this.updateStats(server, responses);
        Map<byte[], MultiResponse.RegionResult> results = responses.getResults();
        ArrayList<Action> toReplay = new ArrayList<Action>();
        Throwable lastException = null;
        int failureCount = 0;
        int failed = 0;
        int stopped = 0;
        Retry retry = null;
        for (Map.Entry<byte[], List<Action>> regionEntry : multiAction.actions.entrySet()) {
            byte[] regionName = regionEntry.getKey();
            Throwable regionException = responses.getExceptions().get(regionName);
            if (regionException != null) {
                this.cleanServerCache(server, regionException);
            }
            Map regionResults = results.containsKey(regionName) ? results.get((Object)regionName).result : Collections.emptyMap();
            boolean regionFailureRegistered = false;
            for (Action sentAction : regionEntry.getValue()) {
                Object result = regionResults.get(sentAction.getOriginalIndex());
                if (result == null) {
                    if (regionException == null) {
                        LOG.error("Server sent us neither results nor exceptions for " + Bytes.toStringBinary((byte[])regionName) + ", numAttempt:" + numAttempt);
                        regionException = new RuntimeException("Invalid response");
                    }
                    result = regionException;
                }
                if (result instanceof Throwable) {
                    Throwable actionException = (Throwable)result;
                    Row row = sentAction.getAction();
                    Throwable throwable = lastException = regionException != null ? regionException : ClientExceptionsUtil.findException(actionException);
                    if (!regionFailureRegistered) {
                        regionFailureRegistered = true;
                        this.updateCachedLocations(server, regionName, row.getRow(), actionException);
                    }
                    if (retry == null) {
                        this.errorsByServer.reportServerError(server);
                        retry = this.errorsByServer.canTryMore(numAttempt) ? Retry.YES : Retry.NO_RETRIES_EXHAUSTED;
                    }
                    ++failureCount;
                    switch (this.manageError(sentAction.getOriginalIndex(), row, retry, actionException, server)) {
                        case YES: {
                            toReplay.add(sentAction);
                            break;
                        }
                        case NO_OTHER_SUCCEEDED: {
                            ++stopped;
                            break;
                        }
                        default: {
                            ++failed;
                            break;
                        }
                    }
                    continue;
                }
                this.invokeCallBack(regionName, sentAction.getAction().getRow(), result);
                this.setResult(sentAction, result);
            }
        }
        if (toReplay.isEmpty()) {
            this.logNoResubmit(server, numAttempt, failureCount, lastException, failed, stopped);
        } else {
            this.resubmit(server, toReplay, numAttempt, failureCount, lastException);
        }
    }

    private void updateCachedLocations(ServerName server, byte[] regionName, byte[] row, Throwable rowException) {
        if (this.tableName == null) {
            return;
        }
        try {
            this.asyncProcess.connection.updateCachedLocations(this.tableName, regionName, row, rowException, server);
        }
        catch (Throwable ex) {
            LOG.error("Couldn't update cached region locations: " + ex);
        }
    }

    private void invokeCallBack(byte[] regionName, byte[] row, CResult result) {
        if (this.callback != null) {
            try {
                this.callback.update(regionName, row, result);
            }
            catch (Throwable t) {
                LOG.error("User callback threw an exception for " + Bytes.toStringBinary((byte[])regionName) + ", ignoring", t);
            }
        }
    }

    private void cleanServerCache(ServerName server, Throwable regionException) {
        if (this.tableName == null && ClientExceptionsUtil.isMetaClearingException(regionException)) {
            MetricsConnection metrics = this.asyncProcess.connection.getConnectionMetrics();
            if (metrics != null) {
                metrics.incrCacheDroppingExceptions(regionException);
            }
            this.asyncProcess.connection.clearCaches(server);
        }
    }

    protected void updateStats(ServerName server, MultiResponse resp) {
        ConnectionUtils.updateStats(Optional.ofNullable(this.asyncProcess.connection.getStatisticsTracker()), Optional.ofNullable(this.asyncProcess.connection.getConnectionMetrics()), server, resp);
    }

    private String createLog(int numAttempt, int failureCount, int replaySize, ServerName sn, Throwable error, long backOffTime, boolean willRetry, String startTime, int failed, int stopped) {
        StringBuilder sb = new StringBuilder();
        sb.append("id=").append(this.asyncProcess.id).append(", table=").append(this.tableName).append(", attempt=").append(numAttempt).append("/").append(this.asyncProcess.numTries).append(", ");
        if (failureCount > 0 || error != null) {
            sb.append("failureCount=").append(failureCount).append("ops").append(", last exception=").append(error);
        } else {
            sb.append("succeeded");
        }
        sb.append(" on ").append(sn).append(", tracking started ").append(startTime);
        if (willRetry) {
            sb.append(", retrying after=").append(backOffTime).append("ms").append(", operationsToReplay=").append(replaySize);
        } else if (failureCount > 0) {
            if (stopped > 0) {
                sb.append("; NOT retrying, stopped=").append(stopped).append(" because successful operation on other replica");
            }
            if (failed > 0) {
                sb.append("; NOT retrying, failed=").append(failed).append(" -- final attempt!");
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setResult(Action action, Object result) {
        if (result == null) {
            throw new RuntimeException("Result cannot be null");
        }
        boolean isStale = !RegionReplicaUtil.isDefaultReplica(action.getReplicaId());
        int index = action.getOriginalIndex();
        if (this.results == null) {
            this.decActionCounter(index);
            return;
        }
        ReplicaResultState state = this.trySetResultSimple(index, action.getAction(), false, result, null, isStale);
        if (state == null) {
            return;
        }
        Object object = state;
        synchronized (object) {
            if (state.callCount == 0) {
                return;
            }
            state.callCount = 0;
        }
        object = this.replicaResultLock;
        synchronized (object) {
            if (this.results[index] != state) {
                throw new AssertionError((Object)"We set the callCount but someone else replaced the result");
            }
            this.updateResult(index, result);
        }
        this.decActionCounter(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setError(int index, Row row, Throwable throwable, ServerName server) {
        if (this.results == null) {
            this.errors.add(throwable, row, server);
            this.decActionCounter(index);
            return;
        }
        ReplicaResultState state = this.trySetResultSimple(index, row, true, throwable, server, false);
        if (state == null) {
            return;
        }
        BatchErrors target = null;
        boolean isActionDone = false;
        Object object = state;
        synchronized (object) {
            switch (state.callCount) {
                case 0: {
                    return;
                }
                case 1: {
                    target = this.errors;
                    isActionDone = true;
                    break;
                }
                default: {
                    assert (state.callCount > 1);
                    if (state.replicaErrors == null) {
                        state.replicaErrors = new BatchErrors();
                    }
                    target = state.replicaErrors;
                }
            }
            --state.callCount;
        }
        target.add(throwable, row, server);
        if (isActionDone) {
            if (state.replicaErrors != null) {
                this.errors.merge(state.replicaErrors);
            }
            object = this.replicaResultLock;
            synchronized (object) {
                if (this.results[index] != state) {
                    throw new AssertionError((Object)"We set the callCount but someone else replaced the result");
                }
                this.updateResult(index, throwable);
            }
            this.decActionCounter(index);
        }
    }

    private boolean isActionComplete(int index, Row row) {
        if (!AsyncProcess.isReplicaGet(row)) {
            return false;
        }
        Object resObj = this.results[index];
        return resObj != null && (!(resObj instanceof ReplicaResultState) || ((ReplicaResultState)resObj).callCount == 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReplicaResultState trySetResultSimple(int index, Row row, boolean isError, Object result, ServerName server, boolean isFromReplica) {
        ReplicaResultState rrs;
        Object resObj = null;
        if (!AsyncProcess.isReplicaGet(row)) {
            if (isFromReplica) {
                throw new AssertionError((Object)("Unexpected stale result for " + row));
            }
            this.updateResult(index, result);
        } else {
            Object object = this.replicaResultLock;
            synchronized (object) {
                resObj = this.results[index];
                if (resObj == null) {
                    if (isFromReplica) {
                        throw new AssertionError((Object)("Unexpected stale result for " + row));
                    }
                    this.updateResult(index, result);
                }
            }
        }
        ReplicaResultState replicaResultState = rrs = resObj instanceof ReplicaResultState ? (ReplicaResultState)resObj : null;
        if (rrs == null && isError) {
            this.errors.add((Throwable)result, row, server);
        }
        if (resObj == null) {
            this.decActionCounter(index);
            return null;
        }
        return rrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decActionCounter(int index) {
        long actionsRemaining = this.actionsInProgress.decrementAndGet();
        if (actionsRemaining < 0L) {
            String error = this.buildDetailedErrorMsg("Incorrect actions in progress", index);
            throw new AssertionError((Object)error);
        }
        if (actionsRemaining == 0L) {
            AtomicLong atomicLong = this.actionsInProgress;
            synchronized (atomicLong) {
                this.actionsInProgress.notifyAll();
            }
        }
    }

    private String buildDetailedErrorMsg(String string, int index) {
        int i;
        StringBuilder error = new StringBuilder(128);
        error.append(string).append("; called for ").append(index).append(", actionsInProgress ").append(this.actionsInProgress.get()).append("; replica gets: ");
        if (this.replicaGetIndices != null) {
            for (i = 0; i < this.replicaGetIndices.length; ++i) {
                error.append(this.replicaGetIndices[i]).append(", ");
            }
        } else {
            error.append(this.hasAnyReplicaGets ? "all" : "none");
        }
        error.append("; results ");
        if (this.results != null) {
            for (i = 0; i < this.results.length; ++i) {
                Object o = this.results[i];
                error.append(o == null ? "null" : o.toString()).append(", ");
            }
        }
        return error.toString();
    }

    @Override
    public void waitUntilDone() throws InterruptedIOException {
        try {
            if (this.operationTimeout > 0) {
                long cutoff = (EnvironmentEdgeManager.currentTime() + (long)this.operationTimeout) * 1000L;
                if (!this.waitUntilDone(cutoff)) {
                    throw new SocketTimeoutException("time out before the actionsInProgress changed to zero");
                }
            } else {
                this.waitUntilDone(Long.MAX_VALUE);
            }
        }
        catch (InterruptedException iex) {
            throw new InterruptedIOException(iex.getMessage());
        }
        finally {
            if (this.callsInProgress != null) {
                for (CancellableRegionServerCallable clb : this.callsInProgress) {
                    clb.cancel();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitUntilDone(long cutoff) throws InterruptedException {
        long currentInProgress;
        boolean hasWait = cutoff != Long.MAX_VALUE;
        long lastLog = EnvironmentEdgeManager.currentTime();
        while (0L != (currentInProgress = this.actionsInProgress.get())) {
            long now = EnvironmentEdgeManager.currentTime();
            if (hasWait && now * 1000L > cutoff) {
                return false;
            }
            if (!hasWait && now > lastLog + 10000L) {
                lastLog = now;
                LOG.info("#" + this.asyncProcess.id + ", waiting for " + currentInProgress + "  actions to finish on table: " + this.tableName);
            }
            AtomicLong atomicLong = this.actionsInProgress;
            synchronized (atomicLong) {
                if (this.actionsInProgress.get() == 0L) {
                    break;
                }
                if (!hasWait) {
                    this.actionsInProgress.wait(10L);
                } else {
                    long waitMicroSecond = Math.min(100000L, cutoff - now * 1000L);
                    TimeUnit.MICROSECONDS.timedWait(this.actionsInProgress, waitMicroSecond);
                }
            }
        }
        return true;
    }

    @Override
    public boolean hasError() {
        return this.errors.hasErrors();
    }

    @Override
    public List<? extends Row> getFailedOperations() {
        return this.errors.actions;
    }

    @Override
    public RetriesExhaustedWithDetailsException getErrors() {
        return this.errors.makeException(this.asyncProcess.logBatchErrorDetails);
    }

    @Override
    public Object[] getResults() throws InterruptedIOException {
        this.waitUntilDone();
        return this.results;
    }

    private ConnectionImplementation.ServerErrorTracker createServerErrorTracker() {
        return new ConnectionImplementation.ServerErrorTracker(this.asyncProcess.serverTrackerTimeout, this.asyncProcess.numTries);
    }

    private MultiServerCallable createCallable(ServerName server, TableName tableName, MultiAction multi) {
        return new MultiServerCallable(this.asyncProcess.connection, tableName, server, multi, this.asyncProcess.rpcFactory.newController(), this.rpcTimeout, this.tracker, multi.getPriority());
    }

    private void updateResult(int index, Object result) {
        Object current = this.results[index];
        if (current != null && LOG.isDebugEnabled()) {
            LOG.debug("The result is assigned repeatedly! current:" + current + ", new:" + result);
        }
        this.results[index] = result;
    }

    long getNumberOfActionsInProgress() {
        return this.actionsInProgress.get();
    }

    static /* synthetic */ CancellableRegionServerCallable access$1000(AsyncRequestFutureImpl x0) {
        return x0.currentCallable;
    }

    static /* synthetic */ TableName access$1100(AsyncRequestFutureImpl x0) {
        return x0.tableName;
    }

    static /* synthetic */ MultiServerCallable access$1200(AsyncRequestFutureImpl x0, ServerName x1, TableName x2, MultiAction x3) {
        return x0.createCallable(x1, x2, x3);
    }

    static /* synthetic */ int access$1300(AsyncRequestFutureImpl x0) {
        return x0.rpcTimeout;
    }

    static /* synthetic */ int access$1400(AsyncRequestFutureImpl x0) {
        return x0.operationTimeout;
    }

    static /* synthetic */ void access$1500(AsyncRequestFutureImpl x0, MultiAction x1, ServerName x2, int x3, Throwable x4) {
        x0.failAll(x1, x2, x3, x4);
    }

    static /* synthetic */ void access$1600(AsyncRequestFutureImpl x0, MultiAction x1, ServerName x2, int x3, Throwable x4, boolean x5) {
        x0.receiveGlobalFailure(x1, x2, x3, x4, x5);
    }

    static /* synthetic */ void access$1700(AsyncRequestFutureImpl x0, MultiAction x1, ServerName x2, MultiResponse x3, int x4) {
        x0.receiveMultiAction(x1, x2, x3, x4);
    }

    static /* synthetic */ void access$1800(AsyncRequestFutureImpl x0, int x1) {
        x0.decActionCounter(x1);
    }

    private static class ReplicaResultState {
        int callCount;
        BatchErrors replicaErrors = null;

        public ReplicaResultState(int callCount) {
            this.callCount = callCount;
        }

        public String toString() {
            return "[call count " + this.callCount + "; errors " + this.replicaErrors + "]";
        }
    }

    public static enum Retry {
        YES,
        NO_LOCATION_PROBLEM,
        NO_NOT_RETRIABLE,
        NO_RETRIES_EXHAUSTED,
        NO_OTHER_SUCCEEDED;

    }

    final class SingleServerRequestRunnable
    implements Runnable {
        private final MultiAction multiAction;
        private final int numAttempt;
        private final ServerName server;
        private final Set<CancellableRegionServerCallable> callsInProgress;

        SingleServerRequestRunnable(MultiAction multiAction, int numAttempt, ServerName server, Set<CancellableRegionServerCallable> callsInProgress) {
            this.multiAction = multiAction;
            this.numAttempt = numAttempt;
            this.server = server;
            this.callsInProgress = callsInProgress;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private final class ReplicaCallIssuingRunnable
    implements Runnable {
        private final long startTime;
        private final List<Action> initialActions;

        public ReplicaCallIssuingRunnable(List<Action> initialActions, long startTime) {
            this.initialActions = initialActions;
            this.startTime = startTime;
        }

        @Override
        public void run() {
            boolean done = false;
            if (((AsyncRequestFutureImpl)AsyncRequestFutureImpl.this).asyncProcess.primaryCallTimeoutMicroseconds > 0L) {
                try {
                    done = AsyncRequestFutureImpl.this.waitUntilDone(this.startTime * 1000L + ((AsyncRequestFutureImpl)AsyncRequestFutureImpl.this).asyncProcess.primaryCallTimeoutMicroseconds);
                }
                catch (InterruptedException ex) {
                    LOG.error("Replica thread interrupted - no replica calls {}", (Object)ex.getMessage());
                    return;
                }
            }
            if (done) {
                return;
            }
            HashMap<Object, MultiAction> actionsByServer = new HashMap<ServerName, MultiAction>();
            ArrayList<Action> unknownLocActions = new ArrayList<Action>();
            if (AsyncRequestFutureImpl.this.replicaGetIndices == null) {
                for (int i = 0; i < AsyncRequestFutureImpl.this.results.length; ++i) {
                    this.addReplicaActions(i, actionsByServer, unknownLocActions);
                }
            } else {
                for (int replicaGetIndice : AsyncRequestFutureImpl.this.replicaGetIndices) {
                    this.addReplicaActions(replicaGetIndice, actionsByServer, unknownLocActions);
                }
            }
            if (!actionsByServer.isEmpty()) {
                AsyncRequestFutureImpl.this.sendMultiAction(actionsByServer, 1, null, unknownLocActions.isEmpty());
            }
            if (!unknownLocActions.isEmpty()) {
                actionsByServer = new HashMap();
                for (Action action : unknownLocActions) {
                    this.addReplicaActionsAgain(action, actionsByServer);
                }
                if (!actionsByServer.isEmpty()) {
                    AsyncRequestFutureImpl.this.sendMultiAction(actionsByServer, 1, null, true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addReplicaActions(int index, Map<ServerName, MultiAction> actionsByServer, List<Action> unknownReplicaActions) {
            if (AsyncRequestFutureImpl.this.results[index] != null) {
                return;
            }
            Action action = this.initialActions.get(index);
            RegionLocations loc = AsyncRequestFutureImpl.this.findAllLocationsOrFail(action, true);
            if (loc == null) {
                return;
            }
            HRegionLocation[] locs = loc.getRegionLocations();
            if (locs.length == 1) {
                LOG.warn("No replicas found for {}", (Object)action.getAction());
                return;
            }
            Object object = AsyncRequestFutureImpl.this.replicaResultLock;
            synchronized (object) {
                if (AsyncRequestFutureImpl.this.results[index] != null) {
                    return;
                }
                AsyncRequestFutureImpl.this.updateResult(index, new ReplicaResultState(locs.length));
            }
            for (int i = 1; i < locs.length; ++i) {
                Action replicaAction = new Action(action, i);
                if (locs[i] != null) {
                    AsyncRequestFutureImpl.this.asyncProcess;
                    AsyncProcess.addAction(locs[i].getServerName(), locs[i].getRegionInfo().getRegionName(), replicaAction, actionsByServer, AsyncRequestFutureImpl.this.nonceGroup);
                    continue;
                }
                unknownReplicaActions.add(replicaAction);
            }
        }

        private void addReplicaActionsAgain(Action action, Map<ServerName, MultiAction> actionsByServer) {
            if (action.getReplicaId() == 0) {
                throw new AssertionError((Object)"Cannot have default replica here");
            }
            HRegionLocation loc = AsyncRequestFutureImpl.this.getReplicaLocationOrFail(action);
            if (loc == null) {
                return;
            }
            AsyncRequestFutureImpl.this.asyncProcess;
            AsyncProcess.addAction(loc.getServerName(), loc.getRegionInfo().getRegionName(), action, actionsByServer, AsyncRequestFutureImpl.this.nonceGroup);
        }
    }
}

