/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public final class BalanceResponse {
    private final boolean balancerRan;
    private final int movesCalculated;
    private final int movesExecuted;

    public static Builder newBuilder() {
        return new Builder();
    }

    private BalanceResponse(boolean balancerRan, int movesCalculated, int movesExecuted) {
        this.balancerRan = balancerRan;
        this.movesCalculated = movesCalculated;
        this.movesExecuted = movesExecuted;
    }

    public boolean isBalancerRan() {
        return this.balancerRan;
    }

    public int getMovesCalculated() {
        return this.movesCalculated;
    }

    public int getMovesExecuted() {
        return this.movesExecuted;
    }

    @InterfaceAudience.Private
    public static final class Builder {
        private boolean balancerRan;
        private int movesCalculated;
        private int movesExecuted;

        private Builder() {
        }

        public Builder setBalancerRan(boolean balancerRan) {
            this.balancerRan = balancerRan;
            return this;
        }

        public Builder setMovesCalculated(int movesCalculated) {
            this.movesCalculated = movesCalculated;
            return this;
        }

        public Builder setMovesExecuted(int movesExecuted) {
            this.movesExecuted = movesExecuted;
            return this;
        }

        public BalanceResponse build() {
            return new BalanceResponse(this.balancerRan, this.movesCalculated, this.movesExecuted);
        }
    }
}

