/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.testclassification.IntegrationTests;
import org.apache.yetus.audience.InterfaceAudience;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;
import org.junit.runner.Description;
import org.junit.runner.notification.RunListener;

@InterfaceAudience.Private
@RunListener.ThreadSafe
public class HBaseClassTestRuleChecker
extends RunListener {
    public void testStarted(Description description) throws Exception {
        Category[] categories = (Category[])description.getTestClass().getAnnotationsByType(Category.class);
        if (categories.length == 1) {
            for (AnnotatedElement annotatedElement : categories[0].value()) {
                if (annotatedElement != IntegrationTests.class) continue;
                return;
            }
        }
        for (AnnotatedElement annotatedElement : description.getTestClass().getFields()) {
            if (!Modifier.isStatic(((Field)annotatedElement).getModifiers()) || ((Field)annotatedElement).getType() != HBaseClassTestRule.class || !((AccessibleObject)annotatedElement).isAnnotationPresent(ClassRule.class)) continue;
            HBaseClassTestRule timeout = (HBaseClassTestRule)((Field)annotatedElement).get(null);
            Assert.assertEquals((String)("The HBaseClassTestRule ClassRule in " + description.getTestClass().getName() + " is for " + timeout.getClazz().getName()), (Object)description.getTestClass(), timeout.getClazz());
            return;
        }
        Assert.fail((String)("No HBaseClassTestRule ClassRule for " + description.getTestClass().getName()));
    }
}

