/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.hbase.ArrayBackedTag;
import org.apache.hadoop.hbase.ByteBufferKeyValue;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hbase.thirdparty.com.google.common.primitives.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
@SuppressWarnings(value={"RV_ABSOLUTE_VALUE_OF_RANDOM_INT"}, justification="Should probably fix")
public class RedundantKVGenerator {
    static byte[] DEFAULT_COMMON_PREFIX = new byte[0];
    static int DEFAULT_NUMBER_OF_ROW_PREFIXES = 10;
    static int DEFAULT_AVERAGE_PREFIX_LENGTH = 6;
    static int DEFAULT_PREFIX_LENGTH_VARIANCE = 3;
    static int DEFAULT_AVERAGE_SUFFIX_LENGTH = 3;
    static int DEFAULT_SUFFIX_LENGTH_VARIANCE = 3;
    static int DEFAULT_NUMBER_OF_ROW = 500;
    static float DEFAULT_CHANCE_FOR_SAME_QUALIFIER = 0.5f;
    static float DEFAULT_CHANCE_FOR_SIMILIAR_QUALIFIER = 0.4f;
    static int DEFAULT_AVERAGE_QUALIFIER_LENGTH = 9;
    static int DEFAULT_QUALIFIER_LENGTH_VARIANCE = 3;
    static int DEFAULT_COLUMN_FAMILY_LENGTH = 9;
    static int DEFAULT_VALUE_LENGTH = 8;
    static float DEFAULT_CHANCE_FOR_ZERO_VALUE = 0.5f;
    static int DEFAULT_BASE_TIMESTAMP_DIVIDE = 1000000;
    static int DEFAULT_TIMESTAMP_DIFF_SIZE = 100000000;
    private Random randomizer;
    private byte[] commonPrefix;
    private int numberOfRowPrefixes;
    private int averagePrefixLength;
    private int prefixLengthVariance;
    private int averageSuffixLength;
    private int suffixLengthVariance;
    private int numberOfRows;
    private byte[] family;
    private float chanceForSameQualifier;
    private float chanceForSimilarQualifier;
    private int averageQualifierLength;
    private int qualifierLengthVariance;
    private int columnFamilyLength;
    private int valueLength;
    private float chanceForZeroValue;
    private int baseTimestampDivide;
    private int timestampDiffSize;

    public RedundantKVGenerator() {
        this(new Random(42L), DEFAULT_NUMBER_OF_ROW_PREFIXES, DEFAULT_AVERAGE_PREFIX_LENGTH, DEFAULT_PREFIX_LENGTH_VARIANCE, DEFAULT_AVERAGE_SUFFIX_LENGTH, DEFAULT_SUFFIX_LENGTH_VARIANCE, DEFAULT_NUMBER_OF_ROW, DEFAULT_CHANCE_FOR_SAME_QUALIFIER, DEFAULT_CHANCE_FOR_SIMILIAR_QUALIFIER, DEFAULT_AVERAGE_QUALIFIER_LENGTH, DEFAULT_QUALIFIER_LENGTH_VARIANCE, DEFAULT_COLUMN_FAMILY_LENGTH, DEFAULT_VALUE_LENGTH, DEFAULT_CHANCE_FOR_ZERO_VALUE, DEFAULT_BASE_TIMESTAMP_DIVIDE, DEFAULT_TIMESTAMP_DIFF_SIZE);
    }

    public RedundantKVGenerator(Random randomizer, int numberOfRowPrefixes, int averagePrefixLength, int prefixLengthVariance, int averageSuffixLength, int suffixLengthVariance, int numberOfRows, float chanceForSameQualifier, float chanceForSimiliarQualifier, int averageQualifierLength, int qualifierLengthVariance, int columnFamilyLength, int valueLength, float chanceForZeroValue, int baseTimestampDivide, int timestampDiffSize) {
        this.randomizer = randomizer;
        this.commonPrefix = DEFAULT_COMMON_PREFIX;
        this.numberOfRowPrefixes = numberOfRowPrefixes;
        this.averagePrefixLength = averagePrefixLength;
        this.prefixLengthVariance = prefixLengthVariance;
        this.averageSuffixLength = averageSuffixLength;
        this.suffixLengthVariance = suffixLengthVariance;
        this.numberOfRows = numberOfRows;
        this.chanceForSameQualifier = chanceForSameQualifier;
        this.chanceForSimilarQualifier = chanceForSimiliarQualifier;
        this.averageQualifierLength = averageQualifierLength;
        this.qualifierLengthVariance = qualifierLengthVariance;
        this.columnFamilyLength = columnFamilyLength;
        this.valueLength = valueLength;
        this.chanceForZeroValue = chanceForZeroValue;
        this.baseTimestampDivide = baseTimestampDivide;
        this.timestampDiffSize = timestampDiffSize;
    }

    private List<byte[]> generateRows() {
        ArrayList<byte[]> prefixes = new ArrayList<byte[]>();
        prefixes.add(new byte[0]);
        for (int i = 1; i < this.numberOfRowPrefixes; ++i) {
            int prefixLength = this.averagePrefixLength;
            byte[] newPrefix = new byte[prefixLength += this.randomizer.nextInt(2 * this.prefixLengthVariance + 1) - this.prefixLengthVariance];
            this.randomizer.nextBytes(newPrefix);
            prefixes.add(newPrefix);
        }
        ArrayList<byte[]> rows = new ArrayList<byte[]>();
        for (int i = 0; i < this.numberOfRows; ++i) {
            int suffixLength = this.averageSuffixLength;
            int randomPrefix = this.randomizer.nextInt(prefixes.size());
            byte[] row = new byte[((byte[])prefixes.get(randomPrefix)).length + (suffixLength += this.randomizer.nextInt(2 * this.suffixLengthVariance + 1) - this.suffixLengthVariance)];
            byte[] rowWithCommonPrefix = Bytes.concat((byte[][])new byte[][]{this.commonPrefix, row});
            rows.add(rowWithCommonPrefix);
        }
        return rows;
    }

    public List<KeyValue> generateTestKeyValues(int howMany) {
        return this.generateTestKeyValues(howMany, false);
    }

    public List<KeyValue> generateTestKeyValues(int howMany, boolean useTags) {
        ArrayList<KeyValue> result = new ArrayList<KeyValue>();
        List<byte[]> rows = this.generateRows();
        HashMap rowsToQualifier = new HashMap();
        if (this.family == null) {
            this.family = new byte[this.columnFamilyLength];
            this.randomizer.nextBytes(this.family);
        }
        long baseTimestamp = this.randomizer.nextInt(Integer.MAX_VALUE) / this.baseTimestampDivide;
        byte[] value = new byte[this.valueLength];
        for (int i = 0; i < howMany; ++i) {
            byte[] qualifier;
            long timestamp = baseTimestamp;
            if (this.timestampDiffSize > 0) {
                timestamp += (long)this.randomizer.nextInt(this.timestampDiffSize);
            }
            Integer rowId = this.randomizer.nextInt(rows.size());
            byte[] row = rows.get(rowId);
            float qualifierChance = this.randomizer.nextFloat();
            if (!rowsToQualifier.containsKey(rowId) || qualifierChance > this.chanceForSameQualifier + this.chanceForSimilarQualifier) {
                int qualifierLength = this.averageQualifierLength;
                qualifier = new byte[qualifierLength += this.randomizer.nextInt(2 * this.qualifierLengthVariance + 1) - this.qualifierLengthVariance];
                this.randomizer.nextBytes(qualifier);
                if (!rowsToQualifier.containsKey(rowId)) {
                    rowsToQualifier.put(rowId, new ArrayList());
                }
                ((List)rowsToQualifier.get(rowId)).add(qualifier);
            } else if (qualifierChance > this.chanceForSameQualifier) {
                List previousQualifiers = (List)rowsToQualifier.get(rowId);
                byte[] originalQualifier = (byte[])previousQualifiers.get(this.randomizer.nextInt(previousQualifiers.size()));
                qualifier = new byte[originalQualifier.length];
                int commonPrefix = this.randomizer.nextInt(qualifier.length);
                System.arraycopy(originalQualifier, 0, qualifier, 0, commonPrefix);
                for (int j = commonPrefix; j < qualifier.length; ++j) {
                    qualifier[j] = (byte)(this.randomizer.nextInt() & 0xFF);
                }
                ((List)rowsToQualifier.get(rowId)).add(qualifier);
            } else {
                List previousQualifiers = (List)rowsToQualifier.get(rowId);
                qualifier = (byte[])previousQualifiers.get(this.randomizer.nextInt(previousQualifiers.size()));
            }
            if (this.randomizer.nextFloat() < this.chanceForZeroValue) {
                Arrays.fill(value, (byte)0);
            } else {
                this.randomizer.nextBytes(value);
            }
            if (useTags) {
                result.add(new KeyValue(row, this.family, qualifier, timestamp, value, new Tag[]{new ArrayBackedTag(1, "value1")}));
                continue;
            }
            result.add(new KeyValue(row, this.family, qualifier, timestamp, value));
        }
        result.sort((Comparator<KeyValue>)CellComparator.getInstance());
        return result;
    }

    public List<Cell> generateTestExtendedOffheapKeyValues(int howMany, boolean useTags) {
        ArrayList<Cell> result = new ArrayList<Cell>();
        List<byte[]> rows = this.generateRows();
        HashMap rowsToQualifier = new HashMap();
        if (this.family == null) {
            this.family = new byte[this.columnFamilyLength];
            this.randomizer.nextBytes(this.family);
        }
        long baseTimestamp = this.randomizer.nextInt(Integer.MAX_VALUE) / this.baseTimestampDivide;
        byte[] value = new byte[this.valueLength];
        for (int i = 0; i < howMany; ++i) {
            ExtendedOffheapKeyValue offheapKV;
            ByteBuffer offheapKVBB;
            KeyValue keyValue;
            List previousQualifiers;
            byte[] qualifier;
            long timestamp = baseTimestamp;
            if (this.timestampDiffSize > 0) {
                timestamp += (long)this.randomizer.nextInt(this.timestampDiffSize);
            }
            Integer rowId = this.randomizer.nextInt(rows.size());
            byte[] row = rows.get(rowId);
            float qualifierChance = this.randomizer.nextFloat();
            if (!rowsToQualifier.containsKey(rowId) || qualifierChance > this.chanceForSameQualifier + this.chanceForSimilarQualifier) {
                int qualifierLength = this.averageQualifierLength;
                qualifier = new byte[qualifierLength += this.randomizer.nextInt(2 * this.qualifierLengthVariance + 1) - this.qualifierLengthVariance];
                this.randomizer.nextBytes(qualifier);
                if (!rowsToQualifier.containsKey(rowId)) {
                    rowsToQualifier.put(rowId, new ArrayList());
                }
                ((List)rowsToQualifier.get(rowId)).add(qualifier);
            } else if (qualifierChance > this.chanceForSameQualifier) {
                previousQualifiers = (List)rowsToQualifier.get(rowId);
                byte[] originalQualifier = (byte[])previousQualifiers.get(this.randomizer.nextInt(previousQualifiers.size()));
                qualifier = new byte[originalQualifier.length];
                int commonPrefix = this.randomizer.nextInt(qualifier.length);
                System.arraycopy(originalQualifier, 0, qualifier, 0, commonPrefix);
                for (int j = commonPrefix; j < qualifier.length; ++j) {
                    qualifier[j] = (byte)(this.randomizer.nextInt() & 0xFF);
                }
                ((List)rowsToQualifier.get(rowId)).add(qualifier);
            } else {
                previousQualifiers = (List)rowsToQualifier.get(rowId);
                qualifier = (byte[])previousQualifiers.get(this.randomizer.nextInt(previousQualifiers.size()));
            }
            if (this.randomizer.nextFloat() < this.chanceForZeroValue) {
                Arrays.fill(value, (byte)0);
            } else {
                this.randomizer.nextBytes(value);
            }
            if (useTags) {
                keyValue = new KeyValue(row, this.family, qualifier, timestamp, value, new Tag[]{new ArrayBackedTag(1, "value1")});
                offheapKVBB = ByteBuffer.allocateDirect(keyValue.getLength());
                ByteBufferUtils.copyFromArrayToBuffer((ByteBuffer)offheapKVBB, (byte[])keyValue.getBuffer(), (int)keyValue.getOffset(), (int)keyValue.getLength());
                offheapKV = new ExtendedOffheapKeyValue(offheapKVBB, 0, keyValue.getLength(), 0L);
                result.add((Cell)offheapKV);
                continue;
            }
            keyValue = new KeyValue(row, this.family, qualifier, timestamp, value);
            offheapKVBB = ByteBuffer.allocateDirect(keyValue.getLength());
            ByteBufferUtils.copyFromArrayToBuffer((ByteBuffer)offheapKVBB, (byte[])keyValue.getBuffer(), (int)keyValue.getOffset(), (int)keyValue.getLength());
            offheapKV = new ExtendedOffheapKeyValue(offheapKVBB, 0, keyValue.getLength(), 0L);
            result.add((Cell)offheapKV);
        }
        result.sort((Comparator<Cell>)CellComparator.getInstance());
        return result;
    }

    public static ByteBuffer convertKvToByteBuffer(List<KeyValue> keyValues, boolean includesMemstoreTS) {
        int totalSize = 0;
        for (KeyValue kv : keyValues) {
            totalSize += kv.getLength();
            if (!includesMemstoreTS) continue;
            totalSize += WritableUtils.getVIntSize((long)kv.getSequenceId());
        }
        ByteBuffer result = ByteBuffer.allocate(totalSize);
        for (KeyValue kv : keyValues) {
            result.put(kv.getBuffer(), kv.getOffset(), kv.getLength());
            if (!includesMemstoreTS) continue;
            ByteBufferUtils.writeVLong((ByteBuffer)result, (long)kv.getSequenceId());
        }
        return result;
    }

    public RedundantKVGenerator setFamily(byte[] family) {
        this.family = family;
        this.columnFamilyLength = family.length;
        return this;
    }

    static class ExtendedOffheapKeyValue
    extends ByteBufferKeyValue {
        public ExtendedOffheapKeyValue(ByteBuffer buf, int offset, int length, long seqId) {
            super(buf, offset, length, seqId);
        }

        public byte[] getRowArray() {
            throw new IllegalArgumentException("getRowArray operation is not allowed");
        }

        public int getRowOffset() {
            throw new IllegalArgumentException("getRowOffset operation is not allowed");
        }

        public byte[] getFamilyArray() {
            throw new IllegalArgumentException("getFamilyArray operation is not allowed");
        }

        public int getFamilyOffset() {
            throw new IllegalArgumentException("getFamilyOffset operation is not allowed");
        }

        public byte[] getQualifierArray() {
            throw new IllegalArgumentException("getQualifierArray operation is not allowed");
        }

        public int getQualifierOffset() {
            throw new IllegalArgumentException("getQualifierOffset operation is not allowed");
        }

        public byte[] getValueArray() {
            throw new IllegalArgumentException("getValueArray operation is not allowed");
        }

        public int getValueOffset() {
            throw new IllegalArgumentException("getValueOffset operation is not allowed");
        }

        public byte[] getTagsArray() {
            throw new IllegalArgumentException("getTagsArray operation is not allowed");
        }

        public int getTagsOffset() {
            throw new IllegalArgumentException("getTagsOffset operation is not allowed");
        }
    }
}

