/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.security.token.block;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.util.EnumSet;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;

@InterfaceAudience.Private
public class BlockTokenIdentifier
extends TokenIdentifier {
    static final Text KIND_NAME = new Text("HDFS_BLOCK_TOKEN");
    private long expiryDate;
    private int keyId;
    private String userId;
    private String blockPoolId;
    private long blockId;
    private final EnumSet<AccessMode> modes;
    private byte[] handshakeMsg;
    private byte[] cache = null;

    public BlockTokenIdentifier() {
        this(null, null, 0L, EnumSet.noneOf(AccessMode.class));
    }

    public BlockTokenIdentifier(String userId, String bpid, long blockId, EnumSet<AccessMode> modes) {
        this.userId = userId;
        this.blockPoolId = bpid;
        this.blockId = blockId;
        this.modes = modes == null ? EnumSet.noneOf(AccessMode.class) : modes;
        this.handshakeMsg = new byte[0];
    }

    public Text getKind() {
        return KIND_NAME;
    }

    public UserGroupInformation getUser() {
        if (this.userId == null || "".equals(this.userId)) {
            String user = this.blockPoolId + ":" + Long.toString(this.blockId);
            return UserGroupInformation.createRemoteUser((String)user);
        }
        return UserGroupInformation.createRemoteUser((String)this.userId);
    }

    public long getExpiryDate() {
        return this.expiryDate;
    }

    public void setExpiryDate(long expiryDate) {
        this.cache = null;
        this.expiryDate = expiryDate;
    }

    public int getKeyId() {
        return this.keyId;
    }

    public void setKeyId(int keyId) {
        this.cache = null;
        this.keyId = keyId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getBlockPoolId() {
        return this.blockPoolId;
    }

    public long getBlockId() {
        return this.blockId;
    }

    public EnumSet<AccessMode> getAccessModes() {
        return this.modes;
    }

    public byte[] getHandshakeMsg() {
        return this.handshakeMsg;
    }

    public void setHandshakeMsg(byte[] bytes) {
        this.cache = null;
        this.handshakeMsg = bytes;
    }

    public String toString() {
        return "block_token_identifier (expiryDate=" + this.getExpiryDate() + ", keyId=" + this.getKeyId() + ", userId=" + this.getUserId() + ", blockPoolId=" + this.getBlockPoolId() + ", blockId=" + this.getBlockId() + ", access modes=" + this.getAccessModes() + ")";
    }

    static boolean isEqual(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof BlockTokenIdentifier) {
            BlockTokenIdentifier that = (BlockTokenIdentifier)((Object)obj);
            return this.expiryDate == that.expiryDate && this.keyId == that.keyId && BlockTokenIdentifier.isEqual(this.userId, that.userId) && BlockTokenIdentifier.isEqual(this.blockPoolId, that.blockPoolId) && this.blockId == that.blockId && BlockTokenIdentifier.isEqual(this.modes, that.modes);
        }
        return false;
    }

    public int hashCode() {
        return (int)this.expiryDate ^ this.keyId ^ (int)this.blockId ^ this.modes.hashCode() ^ (this.userId == null ? 0 : this.userId.hashCode()) ^ (this.blockPoolId == null ? 0 : this.blockPoolId.hashCode());
    }

    public void readFields(DataInput in) throws IOException {
        this.cache = null;
        if (in instanceof DataInputStream) {
            DataInputStream dis = (DataInputStream)in;
            this.cache = IOUtils.readFullyToByteArray((DataInput)dis);
            dis.reset();
        }
        this.expiryDate = WritableUtils.readVLong((DataInput)in);
        this.keyId = WritableUtils.readVInt((DataInput)in);
        this.userId = WritableUtils.readString((DataInput)in);
        this.blockPoolId = WritableUtils.readString((DataInput)in);
        this.blockId = WritableUtils.readVLong((DataInput)in);
        int length = WritableUtils.readVIntInRange((DataInput)in, (int)0, (int)((AccessMode[])AccessMode.class.getEnumConstants()).length);
        for (int i = 0; i < length; ++i) {
            this.modes.add((AccessMode)WritableUtils.readEnum((DataInput)in, AccessMode.class));
        }
        try {
            int handshakeMsgLen = WritableUtils.readVInt((DataInput)in);
            if (handshakeMsgLen != 0) {
                this.handshakeMsg = new byte[handshakeMsgLen];
                in.readFully(this.handshakeMsg);
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    public void write(DataOutput out) throws IOException {
        WritableUtils.writeVLong((DataOutput)out, (long)this.expiryDate);
        WritableUtils.writeVInt((DataOutput)out, (int)this.keyId);
        WritableUtils.writeString((DataOutput)out, (String)this.userId);
        WritableUtils.writeString((DataOutput)out, (String)this.blockPoolId);
        WritableUtils.writeVLong((DataOutput)out, (long)this.blockId);
        WritableUtils.writeVInt((DataOutput)out, (int)this.modes.size());
        for (AccessMode aMode : this.modes) {
            WritableUtils.writeEnum((DataOutput)out, (Enum)aMode);
        }
        if (this.handshakeMsg != null && this.handshakeMsg.length > 0) {
            WritableUtils.writeVInt((DataOutput)out, (int)this.handshakeMsg.length);
            out.write(this.handshakeMsg);
        }
    }

    public byte[] getBytes() {
        if (this.cache == null) {
            this.cache = super.getBytes();
        }
        return this.cache;
    }

    @InterfaceAudience.Private
    public static class Renewer
    extends Token.TrivialRenewer {
        protected Text getKind() {
            return KIND_NAME;
        }
    }

    public static enum AccessMode {
        READ,
        WRITE,
        COPY,
        REPLACE;

    }
}

