/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.util.concurrent.atomic.LongAdder;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class BloomFilterMetrics {
    private final LongAdder eligibleRequests = new LongAdder();
    private final LongAdder requests = new LongAdder();
    private final LongAdder negativeResults = new LongAdder();

    public void incrementRequests(boolean passed) {
        this.requests.increment();
        if (!passed) {
            this.negativeResults.increment();
        }
    }

    public void incrementEligible() {
        this.eligibleRequests.increment();
    }

    public long getRequestsCount() {
        return this.requests.sum();
    }

    public long getNegativeResultsCount() {
        return this.negativeResults.sum();
    }

    public long getEligibleRequestsCount() {
        return this.eligibleRequests.sum();
    }
}

