/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.SortedSet;
import java.util.concurrent.atomic.LongAdder;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.StoreFileComparators;
import org.apache.hadoop.hbase.regionserver.StoreFileReader;
import org.apache.hadoop.hbase.regionserver.querymatcher.ScanQueryMatcher;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"Phoenix"})
@InterfaceStability.Evolving
public class StoreFileScanner
implements KeyValueScanner {
    private final StoreFileReader reader;
    private final HFileScanner hfs;
    private Cell cur = null;
    private boolean closed = false;
    private boolean realSeekDone;
    private boolean delayedReseek;
    private Cell delayedSeekKV;
    private final boolean enforceMVCC;
    private final boolean hasMVCCInfo;
    private boolean stopSkippingKVsIfNextRow = false;
    private static LongAdder seekCount;
    private final boolean canOptimizeForNonNullColumn;
    private final long readPt;
    private final long scannerOrder;

    public StoreFileScanner(StoreFileReader reader, HFileScanner hfs, boolean useMVCC, boolean hasMVCC, long readPt, long scannerOrder, boolean canOptimizeForNonNullColumn) {
        this.readPt = readPt;
        this.reader = reader;
        this.hfs = hfs;
        this.enforceMVCC = useMVCC;
        this.hasMVCCInfo = hasMVCC;
        this.scannerOrder = scannerOrder;
        this.canOptimizeForNonNullColumn = canOptimizeForNonNullColumn;
        this.reader.incrementRefCount();
    }

    public static List<StoreFileScanner> getScannersForStoreFiles(Collection<HStoreFile> files, boolean cacheBlocks, boolean usePread, boolean isCompaction, boolean useDropBehind, long readPt) throws IOException {
        return StoreFileScanner.getScannersForStoreFiles(files, cacheBlocks, usePread, isCompaction, useDropBehind, null, readPt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<StoreFileScanner> getScannersForStoreFiles(Collection<HStoreFile> files, boolean cacheBlocks, boolean usePread, boolean isCompaction, boolean canUseDrop, ScanQueryMatcher matcher, long readPt) throws IOException {
        if (files.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<StoreFileScanner> scanners = new ArrayList<StoreFileScanner>(files.size());
        boolean canOptimizeForNonNullColumn = matcher != null ? !matcher.hasNullColumnInQuery() : false;
        PriorityQueue<HStoreFile> sortedFiles = new PriorityQueue<HStoreFile>(files.size(), StoreFileComparators.SEQ_ID);
        for (HStoreFile file : files) {
            file.initReader();
            sortedFiles.add(file);
        }
        boolean succ = false;
        try {
            int n = files.size();
            for (int i = 0; i < n; ++i) {
                HStoreFile sf = (HStoreFile)sortedFiles.remove();
                StoreFileScanner scanner = usePread ? sf.getPreadScanner(cacheBlocks, readPt, i, canOptimizeForNonNullColumn) : sf.getStreamScanner(canUseDrop, cacheBlocks, isCompaction, readPt, i, canOptimizeForNonNullColumn);
                scanners.add(scanner);
            }
            succ = true;
        }
        finally {
            if (!succ) {
                for (StoreFileScanner scanner : scanners) {
                    scanner.close();
                }
            }
        }
        return scanners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<StoreFileScanner> getScannersForCompaction(Collection<HStoreFile> files, boolean canUseDropBehind, long readPt) throws IOException {
        ArrayList<StoreFileScanner> scanners = new ArrayList<StoreFileScanner>(files.size());
        ArrayList<HStoreFile> sortedFiles = new ArrayList<HStoreFile>(files);
        Collections.sort(sortedFiles, StoreFileComparators.SEQ_ID);
        boolean succ = false;
        try {
            int n = sortedFiles.size();
            for (int i = 0; i < n; ++i) {
                scanners.add(((HStoreFile)sortedFiles.get(i)).getStreamScanner(canUseDropBehind, false, true, readPt, i, false));
            }
            succ = true;
        }
        finally {
            if (!succ) {
                for (StoreFileScanner scanner : scanners) {
                    scanner.close();
                }
            }
        }
        return scanners;
    }

    public String toString() {
        return "StoreFileScanner[" + this.hfs.toString() + ", cur=" + this.cur + "]";
    }

    @Override
    public Cell peek() {
        return this.cur;
    }

    @Override
    public Cell next() throws IOException {
        Cell retKey = this.cur;
        try {
            if (this.cur != null) {
                this.hfs.next();
                this.setCurrentCell(this.hfs.getCell());
                if (this.hasMVCCInfo || this.reader.isBulkLoaded()) {
                    this.skipKVsNewerThanReadpoint();
                }
            }
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw new IOException("Could not iterate " + this, e);
        }
        return retKey;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean seek(Cell key) throws IOException {
        if (seekCount != null) {
            seekCount.increment();
        }
        try {
            try {
                if (!StoreFileScanner.seekAtOrAfter(this.hfs, key)) {
                    this.cur = null;
                    boolean bl = false;
                    return bl;
                }
                this.setCurrentCell(this.hfs.getCell());
                if (!this.hasMVCCInfo && this.reader.isBulkLoaded()) {
                    boolean bl = this.skipKVsNewerThanReadpoint();
                    return bl;
                }
                boolean bl = !this.hasMVCCInfo ? true : this.skipKVsNewerThanReadpoint();
                return bl;
            }
            finally {
                this.realSeekDone = true;
            }
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException ioe) {
            throw new IOException("Could not seek " + this + " to key " + key, ioe);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean reseek(Cell key) throws IOException {
        if (seekCount != null) {
            seekCount.increment();
        }
        try {
            try {
                if (!StoreFileScanner.reseekAtOrAfter(this.hfs, key)) {
                    this.cur = null;
                    boolean bl = false;
                    return bl;
                }
                this.setCurrentCell(this.hfs.getCell());
                if (!this.hasMVCCInfo && this.reader.isBulkLoaded()) {
                    boolean bl = this.skipKVsNewerThanReadpoint();
                    return bl;
                }
                boolean bl = !this.hasMVCCInfo ? true : this.skipKVsNewerThanReadpoint();
                return bl;
            }
            finally {
                this.realSeekDone = true;
            }
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException ioe) {
            throw new IOException("Could not reseek " + this + " to key " + key, ioe);
        }
    }

    protected void setCurrentCell(Cell newVal) throws IOException {
        this.cur = newVal;
        if (this.cur != null && this.reader.isBulkLoaded() && !this.reader.isSkipResetSeqId()) {
            PrivateCellUtil.setSequenceId((Cell)this.cur, (long)this.reader.getSequenceID());
        }
    }

    protected boolean skipKVsNewerThanReadpoint() throws IOException {
        Cell startKV = this.cur;
        while (this.enforceMVCC && this.cur != null && this.cur.getSequenceId() > this.readPt) {
            boolean hasNext = this.hfs.next();
            this.setCurrentCell(this.hfs.getCell());
            if (!hasNext || !this.stopSkippingKVsIfNextRow || this.getComparator().compareRows(this.cur, startKV) <= 0) continue;
            return false;
        }
        return this.cur != null;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.cur = null;
        this.hfs.close();
        if (this.reader != null) {
            this.reader.readCompleted();
        }
        this.closed = true;
    }

    public static boolean seekAtOrAfter(HFileScanner s, Cell k) throws IOException {
        int result = s.seekTo(k);
        if (result < 0) {
            if (result == -2) {
                return true;
            }
            return s.seekTo();
        }
        if (result > 0) {
            return s.next();
        }
        return true;
    }

    static boolean reseekAtOrAfter(HFileScanner s, Cell k) throws IOException {
        int result = s.reseekTo(k);
        if (result <= 0) {
            if (result == -2) {
                return true;
            }
            if (!s.isSeeked()) {
                return s.seekTo();
            }
            return true;
        }
        return s.next();
    }

    @Override
    public long getScannerOrder() {
        return this.scannerOrder;
    }

    @Override
    public boolean requestSeek(Cell kv, boolean forward, boolean useBloom) throws IOException {
        if (kv.getFamilyLength() == 0) {
            useBloom = false;
        }
        boolean haveToSeek = true;
        if (useBloom) {
            if (this.reader.getBloomFilterType() == BloomType.ROWCOL) {
                haveToSeek = this.reader.passesGeneralRowColBloomFilter(kv);
            } else if (this.canOptimizeForNonNullColumn && (PrivateCellUtil.isDeleteFamily((Cell)kv) || PrivateCellUtil.isDeleteFamilyVersion((Cell)kv))) {
                haveToSeek = this.reader.passesDeleteFamilyBloomFilter(kv.getRowArray(), kv.getRowOffset(), kv.getRowLength());
            }
        }
        this.delayedReseek = forward;
        this.delayedSeekKV = kv;
        if (haveToSeek) {
            this.realSeekDone = false;
            long maxTimestampInFile = this.reader.getMaxTimestamp();
            long seekTimestamp = kv.getTimestamp();
            if (seekTimestamp > maxTimestampInFile) {
                this.setCurrentCell(PrivateCellUtil.createFirstOnRowColTS((Cell)kv, (long)maxTimestampInFile));
            } else {
                this.enforceSeek();
            }
            return this.cur != null;
        }
        this.setCurrentCell(PrivateCellUtil.createLastOnRowCol((Cell)kv));
        this.realSeekDone = true;
        return true;
    }

    StoreFileReader getReader() {
        return this.reader;
    }

    CellComparator getComparator() {
        return this.reader.getComparator();
    }

    @Override
    public boolean realSeekDone() {
        return this.realSeekDone;
    }

    @Override
    public void enforceSeek() throws IOException {
        if (this.realSeekDone) {
            return;
        }
        if (this.delayedReseek) {
            this.reseek(this.delayedSeekKV);
        } else {
            this.seek(this.delayedSeekKV);
        }
    }

    @Override
    public boolean isFileScanner() {
        return true;
    }

    @Override
    public Path getFilePath() {
        return this.reader.getHFileReader().getPath();
    }

    static final long getSeekCount() {
        return seekCount.sum();
    }

    static final void instrument() {
        seekCount = new LongAdder();
    }

    @Override
    public boolean shouldUseScanner(Scan scan, HStore store, long oldestUnexpiredTS) {
        byte[] cf = store.getColumnFamilyDescriptor().getName();
        TimeRange timeRange = (TimeRange)scan.getColumnFamilyTimeRange().get(cf);
        if (timeRange == null) {
            timeRange = scan.getTimeRange();
        }
        return this.reader.passesTimerangeFilter(timeRange, oldestUnexpiredTS) && this.reader.passesKeyRangeFilter(scan) && this.reader.passesBloomFilter(scan, (SortedSet)scan.getFamilyMap().get(cf));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean seekToPreviousRow(Cell originalKey) throws IOException {
        try {
            try {
                boolean keepSeeking = false;
                Cell key = originalKey;
                do {
                    boolean resultOfSkipKVs;
                    Cell seekKey = PrivateCellUtil.createFirstOnRow((Cell)key);
                    if (seekCount != null) {
                        seekCount.increment();
                    }
                    if (!this.hfs.seekBefore(seekKey)) {
                        this.cur = null;
                        boolean bl = false;
                        return bl;
                    }
                    Cell curCell = this.hfs.getKey();
                    Cell firstKeyOfPreviousRow = PrivateCellUtil.createFirstOnRow((Cell)curCell);
                    if (seekCount != null) {
                        seekCount.increment();
                    }
                    if (!StoreFileScanner.seekAtOrAfter(this.hfs, firstKeyOfPreviousRow)) {
                        this.cur = null;
                        boolean bl = false;
                        return bl;
                    }
                    this.setCurrentCell(this.hfs.getCell());
                    this.stopSkippingKVsIfNextRow = true;
                    try {
                        resultOfSkipKVs = this.skipKVsNewerThanReadpoint();
                    }
                    finally {
                        this.stopSkippingKVsIfNextRow = false;
                    }
                    if (!resultOfSkipKVs || this.getComparator().compareRows(this.cur, firstKeyOfPreviousRow) > 0) {
                        keepSeeking = true;
                        key = firstKeyOfPreviousRow;
                        continue;
                    }
                    keepSeeking = false;
                } while (keepSeeking);
                boolean bl = true;
                return bl;
            }
            finally {
                this.realSeekDone = true;
            }
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException ioe) {
            throw new IOException("Could not seekToPreviousRow " + this + " to key " + originalKey, ioe);
        }
    }

    @Override
    public boolean seekToLastRow() throws IOException {
        Optional<byte[]> lastRow = this.reader.getLastRowKey();
        if (!lastRow.isPresent()) {
            return false;
        }
        Cell seekKey = PrivateCellUtil.createFirstOnRow((byte[])lastRow.get());
        if (this.seek(seekKey)) {
            return true;
        }
        return this.seekToPreviousRow(seekKey);
    }

    @Override
    public boolean backwardSeek(Cell key) throws IOException {
        this.seek(key);
        if (this.cur == null || this.getComparator().compareRows(this.cur, key) > 0) {
            return this.seekToPreviousRow(key);
        }
        return true;
    }

    @Override
    public Cell getNextIndexedKey() {
        return this.hfs.getNextIndexedKey();
    }

    @Override
    public void shipped() throws IOException {
        this.hfs.shipped();
    }
}

