/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.hbase.util.ObjectPool;
import org.apache.hadoop.hbase.util.SoftObjectPool;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.util.WeakObjectPool;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class IdReadWriteLock<T> {
    private static final int NB_CONCURRENT_LOCKS = 1000;
    private final ObjectPool<T, ReentrantReadWriteLock> lockPool;
    private final ReferenceType refType;

    public IdReadWriteLock() {
        this(ReferenceType.WEAK);
    }

    public IdReadWriteLock(ReferenceType referenceType) {
        this.refType = referenceType;
        switch (referenceType) {
            case SOFT: {
                this.lockPool = new SoftObjectPool(new ObjectPool.ObjectFactory<T, ReentrantReadWriteLock>(){

                    public ReentrantReadWriteLock createObject(T id) {
                        return new ReentrantReadWriteLock();
                    }
                }, 1000);
                break;
            }
            default: {
                this.lockPool = new WeakObjectPool(new ObjectPool.ObjectFactory<T, ReentrantReadWriteLock>(){

                    public ReentrantReadWriteLock createObject(T id) {
                        return new ReentrantReadWriteLock();
                    }
                }, 1000);
            }
        }
    }

    public ReentrantReadWriteLock getLock(T id) {
        this.lockPool.purge();
        ReentrantReadWriteLock readWriteLock = (ReentrantReadWriteLock)this.lockPool.get(id);
        return readWriteLock;
    }

    int purgeAndGetEntryPoolSize() {
        this.gc();
        Threads.sleep((long)200L);
        this.lockPool.purge();
        return this.lockPool.size();
    }

    @SuppressWarnings(value={"DM_GC"}, justification="Intentional")
    private void gc() {
        System.gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForWaiters(T id, int numWaiters) throws InterruptedException {
        while (true) {
            ReentrantReadWriteLock readWriteLock;
            if ((readWriteLock = (ReentrantReadWriteLock)this.lockPool.get(id)) != null) {
                ReentrantReadWriteLock reentrantReadWriteLock = readWriteLock;
                synchronized (reentrantReadWriteLock) {
                    if (readWriteLock.getQueueLength() >= numWaiters) {
                        return;
                    }
                }
            }
            Thread.sleep(50L);
        }
    }

    public ReferenceType getReferenceType() {
        return this.refType;
    }

    public static enum ReferenceType {
        WEAK,
        SOFT;

    }
}

