/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RestoreSnapshotFromClientTestBase;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.Test;

public class RestoreSnapshotFromClientCloneTestBase
extends RestoreSnapshotFromClientTestBase {
    @Test
    public void testCloneSnapshotOfCloned() throws IOException, InterruptedException {
        TableName clonedTableName = TableName.valueOf((String)(this.getValidMethodName() + "-" + EnvironmentEdgeManager.currentTime()));
        this.admin.cloneSnapshot(this.snapshotName0, clonedTableName);
        this.verifyRowCount(TEST_UTIL, clonedTableName, this.snapshot0Rows);
        SnapshotTestingUtils.verifyReplicasCameOnline(clonedTableName, this.admin, this.getNumReplicas());
        this.admin.disableTable(clonedTableName);
        this.admin.snapshot(this.snapshotName2, clonedTableName);
        TEST_UTIL.deleteTable(clonedTableName);
        this.waitCleanerRun();
        this.admin.cloneSnapshot(this.snapshotName2, clonedTableName);
        this.verifyRowCount(TEST_UTIL, clonedTableName, this.snapshot0Rows);
        SnapshotTestingUtils.verifyReplicasCameOnline(clonedTableName, this.admin, this.getNumReplicas());
        TEST_UTIL.deleteTable(clonedTableName);
    }

    @Test
    public void testCloneAndRestoreSnapshot() throws IOException, InterruptedException {
        TEST_UTIL.deleteTable(this.tableName);
        this.waitCleanerRun();
        this.admin.cloneSnapshot(this.snapshotName0, this.tableName);
        this.verifyRowCount(TEST_UTIL, this.tableName, this.snapshot0Rows);
        SnapshotTestingUtils.verifyReplicasCameOnline(this.tableName, this.admin, this.getNumReplicas());
        this.waitCleanerRun();
        this.admin.disableTable(this.tableName);
        this.admin.restoreSnapshot(this.snapshotName0);
        this.admin.enableTable(this.tableName);
        this.verifyRowCount(TEST_UTIL, this.tableName, this.snapshot0Rows);
        SnapshotTestingUtils.verifyReplicasCameOnline(this.tableName, this.admin, this.getNumReplicas());
    }

    private void waitCleanerRun() throws InterruptedException {
        TEST_UTIL.getMiniHBaseCluster().getMaster().getHFileCleaner().choreForTesting();
    }
}

