/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderFactory;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.CompatibilityFactory;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.AsyncRegionLocatorHelper;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.ipc.MetricsHBaseServerSource;
import org.apache.hadoop.hbase.ipc.RpcServerInterface;
import org.apache.hadoop.hbase.logging.Log4jUtils;
import org.apache.hadoop.hbase.metrics.BaseSource;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.test.MetricsAssertHelper;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class, ClientTests.class})
public class TestMultiRespectsLimits {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMultiRespectsLimits.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final MetricsAssertHelper METRICS_ASSERT = (MetricsAssertHelper)CompatibilityFactory.getInstance(MetricsAssertHelper.class);
    private static final byte[] FAMILY = Bytes.toBytes((String)"D");
    public static final int MAX_SIZE = 100;
    private static String LOG_LEVEL;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        LOG_LEVEL = Log4jUtils.getEffectiveLevel((String)AsyncRegionLocatorHelper.class.getName());
        Log4jUtils.setLogLevel((String)AsyncRegionLocatorHelper.class.getName(), (String)"INFO");
        TEST_UTIL.getConfiguration().setLong("hbase.server.scanner.max.result.size", 100L);
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        if (LOG_LEVEL != null) {
            Log4jUtils.setLogLevel((String)AsyncRegionLocatorHelper.class.getName(), (String)LOG_LEVEL);
        }
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testMultiLimits() throws Exception {
        final TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Table t = TEST_UTIL.createTable(tableName, FAMILY);
        TEST_UTIL.loadTable(t, FAMILY, false);
        try (final Admin admin = TEST_UTIL.getAdmin();){
            admin.split(tableName);
            TEST_UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

                public boolean evaluate() throws Exception {
                    return admin.getTableRegions(tableName).size() > 1;
                }
            });
        }
        ArrayList<Get> gets = new ArrayList<Get>(100);
        for (int i = 0; i < 100; ++i) {
            gets.add(new Get(HBaseTestingUtility.ROWS[i]));
        }
        RpcServerInterface rpcServer = TEST_UTIL.getHBaseCluster().getRegionServer(0).getRpcServer();
        MetricsHBaseServerSource s = rpcServer.getMetrics().getMetricsSource();
        long startingExceptions = METRICS_ASSERT.getCounter("exceptions", (BaseSource)s);
        long startingMultiExceptions = METRICS_ASSERT.getCounter("exceptions.multiResponseTooLarge", (BaseSource)s);
        Result[] results = t.get(gets);
        TestCase.assertEquals((int)100, (int)results.length);
        METRICS_ASSERT.assertCounterGt("exceptions", startingExceptions + 25L, (BaseSource)s);
        METRICS_ASSERT.assertCounterGt("exceptions.multiResponseTooLarge", startingMultiExceptions + 25L, (BaseSource)s);
    }

    @Test
    public void testBlockMultiLimits() throws Exception {
        final TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        HTableDescriptor desc = new HTableDescriptor(tableName);
        HColumnDescriptor hcd = new HColumnDescriptor(FAMILY);
        hcd.setDataBlockEncoding(DataBlockEncoding.FAST_DIFF);
        desc.addFamily(hcd);
        TEST_UTIL.getAdmin().createTable((TableDescriptor)desc);
        Table t = TEST_UTIL.getConnection().getTable(tableName);
        final HRegionServer regionServer = TEST_UTIL.getHBaseCluster().getRegionServer(0);
        RpcServerInterface rpcServer = regionServer.getRpcServer();
        MetricsHBaseServerSource s = rpcServer.getMetrics().getMetricsSource();
        long startingExceptions = METRICS_ASSERT.getCounter("exceptions", (BaseSource)s);
        long startingMultiExceptions = METRICS_ASSERT.getCounter("exceptions.multiResponseTooLarge", (BaseSource)s);
        byte[] row = Bytes.toBytes((String)"TEST");
        byte[][] cols = new byte[][]{Bytes.toBytes((String)"0"), Bytes.toBytes((String)"1"), Bytes.toBytes((String)"2"), Bytes.toBytes((String)"3"), Bytes.toBytes((String)"4"), Bytes.toBytes((String)"5")};
        byte[] value = new byte[1];
        Bytes.random((byte[])value);
        for (byte[] col : cols) {
            Put p = new Put(row);
            p.add(CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setRow(row).setFamily(FAMILY).setQualifier(col).setTimestamp(p.getTimestamp()).setType(Cell.Type.Put).setValue(value).build());
            t.put(p);
        }
        try (Admin admin = TEST_UTIL.getAdmin();){
            admin.flush(tableName);
            TEST_UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

                public boolean evaluate() throws Exception {
                    return ((HRegion)regionServer.getRegions(tableName).get(0)).getMaxFlushedSeqId() > 3L;
                }
            });
        }
        ArrayList<Get> gets = new ArrayList<Get>(2);
        Get g0 = new Get(row);
        g0.addColumn(FAMILY, cols[0]);
        gets.add(g0);
        Get g2 = new Get(row);
        g2.addColumn(FAMILY, cols[3]);
        gets.add(g2);
        Result[] results = t.get(gets);
        TestCase.assertEquals((int)2, (int)results.length);
        METRICS_ASSERT.assertCounterGt("exceptions", startingExceptions, (BaseSource)s);
        METRICS_ASSERT.assertCounterGt("exceptions.multiResponseTooLarge", startingMultiExceptions, (BaseSource)s);
    }
}

