/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.coprocessor.WALCoprocessor;
import org.apache.hadoop.hbase.coprocessor.WALCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.WALObserver;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestRegionObserverForAddingMutationsFromCoprocessors {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionObserverForAddingMutationsFromCoprocessors.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRegionObserverForAddingMutationsFromCoprocessors.class);
    private static HBaseTestingUtility util;
    private static final byte[] dummy;
    private static final byte[] row1;
    private static final byte[] row2;
    private static final byte[] row3;
    private static final byte[] test;
    @Rule
    public TestName name = new TestName();
    private TableName tableName;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.set("hbase.coprocessor.wal.classes", TestWALObserver.class.getName());
        util = new HBaseTestingUtility(conf);
        util.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        util.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        this.tableName = TableName.valueOf((String)this.name.getMethodName());
    }

    private void createTable(String coprocessor) throws IOException {
        HTableDescriptor htd = new HTableDescriptor(this.tableName).addFamily(new HColumnDescriptor(dummy)).addFamily(new HColumnDescriptor(test)).addCoprocessor(coprocessor);
        util.getAdmin().createTable((TableDescriptor)htd);
    }

    @Test
    public void testMulti() throws Exception {
        this.createTable(TestMultiMutationCoprocessor.class.getName());
        try (Table t = util.getConnection().getTable(this.tableName);){
            t.put(new Put(row1).addColumn(test, dummy, dummy));
            TestRegionObserverForAddingMutationsFromCoprocessors.assertRowCount(t, 3);
        }
    }

    @Test
    public void testCPMutationsAreWrittenToWALEdit() throws Exception {
        this.createTable(TestMultiMutationCoprocessor.class.getName());
        try (Table t = util.getConnection().getTable(this.tableName);){
            t.put(new Put(row1).addColumn(test, dummy, dummy));
            TestRegionObserverForAddingMutationsFromCoprocessors.assertRowCount(t, 3);
        }
        Assert.assertNotNull((Object)TestWALObserver.savedEdit);
        Assert.assertEquals((long)4L, (long)TestWALObserver.savedEdit.getCells().size());
    }

    private static void assertRowCount(Table t, int expected) throws IOException {
        try (ResultScanner scanner = t.getScanner(new Scan());){
            int i = 0;
            for (Result r : scanner) {
                LOG.info(r.toString());
                ++i;
            }
            Assert.assertEquals((long)expected, (long)i);
        }
    }

    @Test
    public void testDeleteCell() throws Exception {
        this.createTable(TestDeleteCellCoprocessor.class.getName());
        try (Table t = util.getConnection().getTable(this.tableName);){
            t.put((List)Lists.newArrayList((Object[])new Put[]{new Put(row1).addColumn(test, dummy, dummy), new Put(row2).addColumn(test, dummy, dummy), new Put(row3).addColumn(test, dummy, dummy)}));
            TestRegionObserverForAddingMutationsFromCoprocessors.assertRowCount(t, 3);
            t.delete(new Delete(test).addColumn(test, dummy));
            TestRegionObserverForAddingMutationsFromCoprocessors.assertRowCount(t, 1);
        }
    }

    @Test
    public void testDeleteFamily() throws Exception {
        this.createTable(TestDeleteFamilyCoprocessor.class.getName());
        try (Table t = util.getConnection().getTable(this.tableName);){
            t.put((List)Lists.newArrayList((Object[])new Put[]{new Put(row1).addColumn(test, dummy, dummy), new Put(row2).addColumn(test, dummy, dummy), new Put(row3).addColumn(test, dummy, dummy)}));
            TestRegionObserverForAddingMutationsFromCoprocessors.assertRowCount(t, 3);
            t.delete(new Delete(test).addFamily(test));
            TestRegionObserverForAddingMutationsFromCoprocessors.assertRowCount(t, 1);
        }
    }

    @Test
    public void testDeleteRow() throws Exception {
        this.createTable(TestDeleteRowCoprocessor.class.getName());
        try (Table t = util.getConnection().getTable(this.tableName);){
            t.put((List)Lists.newArrayList((Object[])new Put[]{new Put(row1).addColumn(test, dummy, dummy), new Put(row2).addColumn(test, dummy, dummy), new Put(row3).addColumn(test, dummy, dummy)}));
            TestRegionObserverForAddingMutationsFromCoprocessors.assertRowCount(t, 3);
            t.delete(new Delete(test).addColumn(test, dummy));
            TestRegionObserverForAddingMutationsFromCoprocessors.assertRowCount(t, 1);
        }
    }

    @Test
    public void testPutWithTTL() throws Exception {
        this.createTable(TestPutWithTTLCoprocessor.class.getName());
        try (Table t = util.getConnection().getTable(this.tableName);){
            t.put(new Put(row1).addColumn(test, dummy, dummy).setTTL(3000L));
            TestRegionObserverForAddingMutationsFromCoprocessors.assertRowCount(t, 2);
            Thread.sleep(5000L);
            TestRegionObserverForAddingMutationsFromCoprocessors.assertRowCount(t, 0);
        }
    }

    static {
        dummy = Bytes.toBytes((String)"dummy");
        row1 = Bytes.toBytes((String)"r1");
        row2 = Bytes.toBytes((String)"r2");
        row3 = Bytes.toBytes((String)"r3");
        test = Bytes.toBytes((String)"test");
    }

    public static class TestWALObserver
    implements WALCoprocessor,
    WALObserver {
        static WALEdit savedEdit = null;

        public Optional<WALObserver> getWALObserver() {
            return Optional.of(this);
        }

        public void postWALWrite(ObserverContext<? extends WALCoprocessorEnvironment> ctx, RegionInfo info, WALKey logKey, WALEdit logEdit) throws IOException {
            if (info.getTable().equals((Object)TableName.valueOf((String)"testCPMutationsAreWrittenToWALEdit"))) {
                savedEdit = logEdit;
            }
        }
    }

    public static class TestDeleteRowCoprocessor
    implements RegionCoprocessor,
    RegionObserver {
        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void preBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
            Mutation mut = (Mutation)miniBatchOp.getOperation(0);
            if (mut instanceof Delete) {
                List cells = (List)mut.getFamilyCellMap().get(test);
                Object[] deletes = new Delete[]{new Delete(row1, ((Cell)cells.get(0)).getTimestamp()), new Delete(row2, ((Cell)cells.get(0)).getTimestamp())};
                LOG.info("Deleting:" + Arrays.toString(deletes));
                miniBatchOp.addOperationsFromCP(0, (Mutation[])deletes);
            }
        }
    }

    public static class TestDeleteFamilyCoprocessor
    implements RegionCoprocessor,
    RegionObserver {
        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void preBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
            Mutation mut = (Mutation)miniBatchOp.getOperation(0);
            if (mut instanceof Delete) {
                List cells = (List)mut.getFamilyCellMap().get(test);
                Object[] deletes = new Delete[]{new Delete(row1).addFamily(test, ((Cell)cells.get(0)).getTimestamp()), new Delete(row2).addFamily(test, ((Cell)cells.get(0)).getTimestamp())};
                LOG.info("Deleting:" + Arrays.toString(deletes));
                miniBatchOp.addOperationsFromCP(0, (Mutation[])deletes);
            }
        }
    }

    public static class TestDeleteCellCoprocessor
    implements RegionCoprocessor,
    RegionObserver {
        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void preBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
            Mutation mut = (Mutation)miniBatchOp.getOperation(0);
            if (mut instanceof Delete) {
                List cells = (List)mut.getFamilyCellMap().get(test);
                Object[] deletes = new Delete[]{new Delete(row1).addColumns(test, dummy, ((Cell)cells.get(0)).getTimestamp()), new Delete(row2).addColumns(test, dummy, ((Cell)cells.get(0)).getTimestamp())};
                LOG.info("Deleting:" + Arrays.toString(deletes));
                miniBatchOp.addOperationsFromCP(0, (Mutation[])deletes);
            }
        }
    }

    public static class TestMultiMutationCoprocessor
    implements RegionCoprocessor,
    RegionObserver {
        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void preBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
            Mutation mut = (Mutation)miniBatchOp.getOperation(0);
            List cells = (List)mut.getFamilyCellMap().get(test);
            Object[] puts = new Put[]{new Put(row1).addColumn(test, dummy, ((Cell)cells.get(0)).getTimestamp(), Bytes.toBytes((String)"cpdummy")), new Put(row2).addColumn(test, dummy, ((Cell)cells.get(0)).getTimestamp(), dummy), new Put(row3).addColumn(test, dummy, ((Cell)cells.get(0)).getTimestamp(), dummy)};
            LOG.info("Putting:" + Arrays.toString(puts));
            miniBatchOp.addOperationsFromCP(0, (Mutation[])puts);
        }
    }

    public static class TestPutWithTTLCoprocessor
    implements RegionCoprocessor,
    RegionObserver {
        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void preBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
            Mutation mut = (Mutation)miniBatchOp.getOperation(0);
            List cells = (List)mut.getFamilyCellMap().get(test);
            Object[] puts = new Put[]{new Put(Bytes.toBytes((String)"cpPut")).addColumn(test, dummy, ((Cell)cells.get(0)).getTimestamp(), Bytes.toBytes((String)"cpdummy")).setTTL(mut.getTTL())};
            LOG.info("Putting:" + Arrays.toString(puts));
            miniBatchOp.addOperationsFromCP(0, (Mutation[])puts);
        }
    }
}

