/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.TestMasterMetrics;
import org.apache.hadoop.hbase.replication.ReplicationLoadSource;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.zookeeper.KeeperException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestGetReplicationLoad {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestGetReplicationLoad.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestGetReplicationLoad.class);
    private static MiniHBaseCluster cluster;
    private static HMaster master;
    private static HBaseTestingUtility TEST_UTIL;

    @BeforeClass
    public static void startCluster() throws Exception {
        LOG.info("Starting cluster");
        TEST_UTIL = new HBaseTestingUtility();
        StartMiniClusterOption option = StartMiniClusterOption.builder().masterClass(TestMasterMetrics.MyMaster.class).build();
        TEST_UTIL.startMiniCluster(option);
        cluster = TEST_UTIL.getHBaseCluster();
        LOG.info("Waiting for active/ready master");
        cluster.waitForActiveAndReadyMaster();
        master = cluster.getMaster();
    }

    @AfterClass
    public static void after() throws Exception {
        if (TEST_UTIL != null) {
            TEST_UTIL.shutdownMiniCluster();
        }
    }

    @Test
    public void testGetReplicationMetrics() throws Exception {
        String peer1 = "test1";
        String peer2 = "test2";
        String queueId = "1";
        long ageOfLastShippedOp = 2L;
        long replicationLag = 3L;
        long timeStampOfLastShippedOp = 4L;
        long timeStampOfNextToReplicate = 5L;
        long editsRead = 6L;
        long oPsShipped = 7L;
        int sizeOfLogQueue = 8;
        boolean recovered = false;
        boolean running = false;
        boolean editsSinceRestart = false;
        RegionServerStatusProtos.RegionServerReportRequest.Builder request = RegionServerStatusProtos.RegionServerReportRequest.newBuilder();
        ServerName serverName = cluster.getMaster(0).getServerName();
        request.setServer(ProtobufUtil.toServerName((ServerName)serverName));
        ClusterStatusProtos.ReplicationLoadSource rload1 = ClusterStatusProtos.ReplicationLoadSource.newBuilder().setPeerID(peer1).setAgeOfLastShippedOp(ageOfLastShippedOp).setReplicationLag(replicationLag).setTimeStampOfLastShippedOp(timeStampOfLastShippedOp).setSizeOfLogQueue(sizeOfLogQueue).setTimeStampOfNextToReplicate(timeStampOfNextToReplicate).setQueueId(queueId).setEditsRead(editsRead).setOPsShipped(oPsShipped).setRunning(running).setRecovered(recovered).setEditsSinceRestart(editsSinceRestart).build();
        ClusterStatusProtos.ReplicationLoadSource rload2 = ClusterStatusProtos.ReplicationLoadSource.newBuilder().setPeerID(peer2).setAgeOfLastShippedOp(ageOfLastShippedOp + 1L).setReplicationLag(replicationLag + 1L).setTimeStampOfLastShippedOp(timeStampOfLastShippedOp + 1L).setSizeOfLogQueue(sizeOfLogQueue + 1).setTimeStampOfNextToReplicate(timeStampOfNextToReplicate + 1L).setQueueId(queueId).setEditsRead(editsRead + 1L).setOPsShipped(oPsShipped + 1L).setRunning(running).setRecovered(recovered).setEditsSinceRestart(editsSinceRestart).build();
        ClusterStatusProtos.ServerLoad sl = ClusterStatusProtos.ServerLoad.newBuilder().addReplLoadSource(rload1).addReplLoadSource(rload2).build();
        request.setLoad(sl);
        master.getReplicationPeerManager().addPeer(peer1, ReplicationPeerConfig.newBuilder().setClusterKey("test").build(), true);
        master.getReplicationPeerManager().addPeer(peer2, ReplicationPeerConfig.newBuilder().setClusterKey("test").build(), true);
        master.getMasterRpcServices().regionServerReport(null, request.build());
        HashMap replicationLoad = master.getReplicationLoad(new ServerName[]{serverName});
        Assert.assertEquals((String)"peer size ", (long)2L, (long)replicationLoad.size());
        Assert.assertEquals((String)"load size ", (long)1L, (long)((List)replicationLoad.get(peer1)).size());
        Assert.assertEquals((String)"log queue size of peer1", (long)sizeOfLogQueue, (long)((ReplicationLoadSource)((Pair)((List)replicationLoad.get(peer1)).get(0)).getSecond()).getSizeOfLogQueue());
        Assert.assertEquals((String)"replication lag of peer2", (long)(replicationLag + 1L), (long)((ReplicationLoadSource)((Pair)((List)replicationLoad.get(peer2)).get(0)).getSecond()).getReplicationLag());
        master.stopMaster();
    }

    public static class MyMaster
    extends HMaster {
        public MyMaster(Configuration conf) throws IOException, KeeperException, InterruptedException {
            super(conf);
        }

        protected void tryRegionServerReport(long reportStartTime, long reportEndTime) {
        }
    }
}

