/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.http;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.hbase.ClearUserNamespacesAndTablesRule;
import org.apache.hadoop.hbase.ConnectionRule;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.MiniClusterRule;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncAdmin;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.client.hamcrest.BytesMatchers;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.http.MetaBrowser;
import org.apache.hadoop.hbase.master.http.RegionReplicaInfo;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.RegionSplitter;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.IterableUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.RuleChain;
import org.junit.rules.TestName;
import org.junit.rules.TestRule;
import org.mockito.Mockito;

@Category(value={MasterTests.class, MediumTests.class})
public class TestMetaBrowser {
    @ClassRule
    public static final HBaseClassTestRule testRule = HBaseClassTestRule.forClass(TestMetaBrowser.class);
    @ClassRule
    public static final MiniClusterRule miniClusterRule = MiniClusterRule.newBuilder().build();
    private final ConnectionRule connectionRule = ConnectionRule.createAsyncConnectionRule(miniClusterRule::createAsyncConnection);
    private final ClearUserNamespacesAndTablesRule clearUserNamespacesAndTablesRule = new ClearUserNamespacesAndTablesRule(this.connectionRule::getAsyncConnection);
    @Rule
    public TestRule rule = RuleChain.outerRule((TestRule)this.connectionRule).around((TestRule)this.clearUserNamespacesAndTablesRule);
    @Rule
    public TestName testNameRule = new TestName();
    private AsyncConnection connection;
    private AsyncAdmin admin;

    @Before
    public void before() {
        this.connection = this.connectionRule.getAsyncConnection();
        this.admin = this.connection.getAdmin();
    }

    @Test
    public void noFilters() {
        List rows;
        String namespaceName = this.testNameRule.getMethodName();
        TableName a = TableName.valueOf((String)"a");
        TableName b = TableName.valueOf((String)namespaceName, (String)"b");
        CompletableFuture.allOf(new CompletableFuture[]{this.createTable(a), this.createNamespace(namespaceName).thenCompose(_void -> this.createTable(b, 2))}).join();
        HttpServletRequest request = new MockRequestBuilder().build();
        try (MetaBrowser.Results results = new MetaBrowser(this.connection, request).getResults();){
            rows = IterableUtils.toList((Iterable)results);
        }
        MatcherAssert.assertThat((Object)rows, (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.hasProperty((String)"row", BytesMatchers.bytesAsStringBinary((Matcher<String>)Matchers.startsWith((String)(a + ",,")))), Matchers.hasProperty((String)"row", BytesMatchers.bytesAsStringBinary((Matcher<String>)Matchers.startsWith((String)"hbase:namespace,,"))), Matchers.hasProperty((String)"row", BytesMatchers.bytesAsStringBinary((Matcher<String>)Matchers.startsWith((String)(b + ",,")))), Matchers.hasProperty((String)"row", BytesMatchers.bytesAsStringBinary((Matcher<String>)Matchers.startsWith((String)(b + ",80000000"))))}));
    }

    @Test
    public void limit() {
        List rows;
        String tableName = this.testNameRule.getMethodName();
        this.createTable(TableName.valueOf((String)tableName), 8).join();
        HttpServletRequest request = new MockRequestBuilder().setLimit(5).build();
        try (MetaBrowser.Results results = new MetaBrowser(this.connection, request).getResults();){
            rows = IterableUtils.toList((Iterable)results);
        }
        MatcherAssert.assertThat((Object)rows, (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.hasProperty((String)"row", BytesMatchers.bytesAsStringBinary((Matcher<String>)Matchers.startsWith((String)"hbase:namespace,,"))), Matchers.hasProperty((String)"row", BytesMatchers.bytesAsStringBinary((Matcher<String>)Matchers.startsWith((String)(tableName + ",,")))), Matchers.hasProperty((String)"row", BytesMatchers.bytesAsStringBinary((Matcher<String>)Matchers.startsWith((String)(tableName + ",20000000")))), Matchers.hasProperty((String)"row", BytesMatchers.bytesAsStringBinary((Matcher<String>)Matchers.startsWith((String)(tableName + ",40000000")))), Matchers.hasProperty((String)"row", BytesMatchers.bytesAsStringBinary((Matcher<String>)Matchers.startsWith((String)(tableName + ",60000000"))))}));
    }

    @Test
    public void regionStateFilter() {
        List rows;
        String namespaceName = this.testNameRule.getMethodName();
        TableName foo = TableName.valueOf((String)namespaceName, (String)"foo");
        TableName bar = TableName.valueOf((String)namespaceName, (String)"bar");
        ((CompletableFuture)this.createNamespace(namespaceName).thenCompose(_void1 -> CompletableFuture.allOf(new CompletableFuture[]{this.createTable(foo, 2).thenCompose(_void2 -> this.admin.disableTable(foo)), this.createTable(bar, 2)}))).join();
        HttpServletRequest request = new MockRequestBuilder().setLimit(10000).setRegionState(RegionState.State.OPEN).setTable(namespaceName).build();
        try (MetaBrowser.Results results = new MetaBrowser(this.connection, request).getResults();){
            rows = IterableUtils.toList((Iterable)results);
        }
        MatcherAssert.assertThat((Object)rows, (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.hasProperty((String)"row", BytesMatchers.bytesAsStringBinary((Matcher<String>)Matchers.startsWith((String)(bar.toString() + ",,")))), Matchers.hasProperty((String)"row", BytesMatchers.bytesAsStringBinary((Matcher<String>)Matchers.startsWith((String)(bar.toString() + ",80000000"))))}));
    }

    @Test
    public void scanTableFilter() {
        List rows;
        String namespaceName = this.testNameRule.getMethodName();
        TableName a = TableName.valueOf((String)"a");
        TableName b = TableName.valueOf((String)namespaceName, (String)"b");
        CompletableFuture.allOf(new CompletableFuture[]{this.createTable(a), this.createNamespace(namespaceName).thenCompose(_void -> this.createTable(b, 2))}).join();
        HttpServletRequest request = new MockRequestBuilder().setTable(namespaceName).build();
        try (MetaBrowser.Results results = new MetaBrowser(this.connection, request).getResults();){
            rows = IterableUtils.toList((Iterable)results);
        }
        MatcherAssert.assertThat((Object)rows, (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.hasProperty((String)"row", BytesMatchers.bytesAsStringBinary((Matcher<String>)Matchers.startsWith((String)(b + ",,")))), Matchers.hasProperty((String)"row", BytesMatchers.bytesAsStringBinary((Matcher<String>)Matchers.startsWith((String)(b + ",80000000"))))}));
    }

    @Test
    public void paginateWithReplicas() {
        List rows3;
        List rows2;
        List rows1;
        String namespaceName = this.testNameRule.getMethodName();
        TableName a = TableName.valueOf((String)"a");
        TableName b = TableName.valueOf((String)namespaceName, (String)"b");
        CompletableFuture.allOf(new CompletableFuture[]{this.createTableWithReplicas(a, 2), this.createNamespace(namespaceName).thenCompose(_void -> this.createTable(b, 2))}).join();
        HttpServletRequest request1 = new MockRequestBuilder().setLimit(2).build();
        try (MetaBrowser.Results results = new MetaBrowser(this.connection, request1).getResults();){
            rows1 = IterableUtils.toList((Iterable)results);
        }
        MatcherAssert.assertThat((Object)rows1, (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.allOf((Matcher)Matchers.hasProperty((String)"regionName", BytesMatchers.bytesAsStringBinary((Matcher<String>)Matchers.startsWith((String)(a + ",,")))), (Matcher)Matchers.hasProperty((String)"replicaId", (Matcher)Matchers.equalTo((Object)0))), Matchers.allOf((Matcher)Matchers.hasProperty((String)"regionName", BytesMatchers.bytesAsStringBinary((Matcher<String>)Matchers.startsWith((String)(a + ",,")))), (Matcher)Matchers.hasProperty((String)"replicaId", (Matcher)Matchers.equalTo((Object)1)))}));
        HttpServletRequest request2 = new MockRequestBuilder().setLimit(2).setStart(MetaBrowser.buildStartParamFrom((byte[])((RegionReplicaInfo)rows1.get(rows1.size() - 1)).getRow())).build();
        try (MetaBrowser.Results results = new MetaBrowser(this.connection, request2).getResults();){
            rows2 = IterableUtils.toList((Iterable)results);
        }
        MatcherAssert.assertThat((Object)rows2, (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.hasProperty((String)"row", BytesMatchers.bytesAsStringBinary((Matcher<String>)Matchers.startsWith((String)"hbase:namespace,,"))), Matchers.hasProperty((String)"row", BytesMatchers.bytesAsStringBinary((Matcher<String>)Matchers.startsWith((String)(b + ",,"))))}));
        HttpServletRequest request3 = new MockRequestBuilder().setLimit(2).setStart(MetaBrowser.buildStartParamFrom((byte[])((RegionReplicaInfo)rows2.get(rows2.size() - 1)).getRow())).build();
        try (MetaBrowser.Results results = new MetaBrowser(this.connection, request3).getResults();){
            rows3 = IterableUtils.toList((Iterable)results);
        }
        MatcherAssert.assertThat((Object)rows3, (Matcher)Matchers.contains((Matcher)Matchers.hasProperty((String)"row", BytesMatchers.bytesAsStringBinary((Matcher<String>)Matchers.startsWith((String)(b + ",80000000"))))));
    }

    @Test
    public void paginateWithTableFilter() {
        List rows3;
        List rows2;
        List rows1;
        String namespaceName = this.testNameRule.getMethodName();
        TableName a = TableName.valueOf((String)"a");
        TableName b = TableName.valueOf((String)namespaceName, (String)"b");
        CompletableFuture.allOf(new CompletableFuture[]{this.createTable(a), this.createNamespace(namespaceName).thenCompose(_void -> this.createTable(b, 5))}).join();
        HttpServletRequest request1 = new MockRequestBuilder().setLimit(2).setTable(namespaceName).build();
        try (MetaBrowser.Results results = new MetaBrowser(this.connection, request1).getResults();){
            rows1 = IterableUtils.toList((Iterable)results);
        }
        MatcherAssert.assertThat((Object)rows1, (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.hasProperty((String)"row", BytesMatchers.bytesAsStringBinary((Matcher<String>)Matchers.startsWith((String)(b + ",,")))), Matchers.hasProperty((String)"row", BytesMatchers.bytesAsStringBinary((Matcher<String>)Matchers.startsWith((String)(b + ",33333333"))))}));
        HttpServletRequest request2 = new MockRequestBuilder().setLimit(2).setTable(namespaceName).setStart(MetaBrowser.buildStartParamFrom((byte[])((RegionReplicaInfo)rows1.get(rows1.size() - 1)).getRow())).build();
        try (MetaBrowser.Results results = new MetaBrowser(this.connection, request2).getResults();){
            rows2 = IterableUtils.toList((Iterable)results);
        }
        MatcherAssert.assertThat((Object)rows2, (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.hasProperty((String)"row", BytesMatchers.bytesAsStringBinary((Matcher<String>)Matchers.startsWith((String)(b + ",66666666")))), Matchers.hasProperty((String)"row", BytesMatchers.bytesAsStringBinary((Matcher<String>)Matchers.startsWith((String)(b + ",99999999"))))}));
        HttpServletRequest request3 = new MockRequestBuilder().setLimit(2).setTable(namespaceName).setStart(MetaBrowser.buildStartParamFrom((byte[])((RegionReplicaInfo)rows2.get(rows2.size() - 1)).getRow())).build();
        try (MetaBrowser.Results results = new MetaBrowser(this.connection, request3).getResults();){
            rows3 = IterableUtils.toList((Iterable)results);
        }
        MatcherAssert.assertThat((Object)rows3, (Matcher)Matchers.contains((Matcher)Matchers.hasProperty((String)"row", BytesMatchers.bytesAsStringBinary((Matcher<String>)Matchers.startsWith((String)(b + ",cccccccc"))))));
    }

    private ColumnFamilyDescriptor columnFamilyDescriptor() {
        return ColumnFamilyDescriptorBuilder.of((String)"f1");
    }

    private TableDescriptor tableDescriptor(TableName tableName) {
        return TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(this.columnFamilyDescriptor()).build();
    }

    private TableDescriptor tableDescriptor(TableName tableName, int replicaCount) {
        return TableDescriptorBuilder.newBuilder((TableName)tableName).setRegionReplication(replicaCount).setColumnFamily(this.columnFamilyDescriptor()).build();
    }

    private CompletableFuture<Void> createTable(TableName tableName) {
        return this.admin.createTable(this.tableDescriptor(tableName));
    }

    private CompletableFuture<Void> createTable(TableName tableName, int splitCount) {
        return this.admin.createTable(this.tableDescriptor(tableName), new RegionSplitter.HexStringSplit().split(splitCount));
    }

    private CompletableFuture<Void> createTableWithReplicas(TableName tableName, int replicaCount) {
        return this.admin.createTable(this.tableDescriptor(tableName, replicaCount));
    }

    private CompletableFuture<Void> createNamespace(String namespace) {
        NamespaceDescriptor descriptor = NamespaceDescriptor.create((String)namespace).build();
        return this.admin.createNamespace(descriptor);
    }

    static class MockRequestBuilder {
        private String limit = null;
        private String regionState = null;
        private String start = null;
        private String table = null;

        MockRequestBuilder() {
        }

        public MockRequestBuilder setLimit(int value) {
            this.limit = Integer.toString(value);
            return this;
        }

        public MockRequestBuilder setLimit(String value) {
            this.limit = value;
            return this;
        }

        public MockRequestBuilder setRegionState(RegionState.State value) {
            this.regionState = value.toString();
            return this;
        }

        public MockRequestBuilder setRegionState(String value) {
            this.regionState = value;
            return this;
        }

        public MockRequestBuilder setStart(String value) {
            this.start = value;
            return this;
        }

        public MockRequestBuilder setTable(String value) {
            this.table = value;
            return this;
        }

        public HttpServletRequest build() {
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getRequestURI()).thenReturn((Object)"/table.jsp");
            Mockito.when((Object)request.getParameter("name")).thenReturn((Object)"hbase%3Ameta");
            Mockito.when((Object)request.getParameter("scan_limit")).thenReturn((Object)this.limit);
            Mockito.when((Object)request.getParameter("scan_region_state")).thenReturn((Object)this.regionState);
            Mockito.when((Object)request.getParameter("scan_start")).thenReturn((Object)this.start);
            Mockito.when((Object)request.getParameter("scan_table")).thenReturn((Object)this.table);
            return request;
        }
    }
}

