/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.regionserver.Shipper;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.testclassification.CoprocessorTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class, CoprocessorTests.class})
public class TestCompactionWithShippingCoprocessor {
    private static final AtomicInteger SHIPPED_COUNT = new AtomicInteger();
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCompactionWithShippingCoprocessor.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] FAMILY = Bytes.toBytes((String)"testFamily");
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.client.retries.number", 0);
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCoprocScannersExtendingShipperGetShipped() throws Exception {
        int shippedCountBefore = SHIPPED_COUNT.get();
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Table table = TEST_UTIL.createTable(tableName, (byte[][])new byte[][]{FAMILY}, 1, 1024, CompactionObserver.class.getName());
        TEST_UTIL.loadTable(table, FAMILY);
        TEST_UTIL.flush();
        try {
            RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(tableName);
            String regionName = ((HRegionLocation)locator.getAllRegionLocations().get(0)).getRegion().getEncodedName();
            HRegion region = TEST_UTIL.getRSForFirstRegionInTable(tableName).getRegion(regionName);
            TEST_UTIL.compact(true);
            MatcherAssert.assertThat((Object)SHIPPED_COUNT.get(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(shippedCountBefore)));
        }
        finally {
            table.close();
        }
    }

    public static class ShippedObservingScanner
    implements InternalScanner,
    Shipper {
        protected final InternalScanner scanner;

        public ShippedObservingScanner(InternalScanner scanner) {
            this.scanner = scanner;
        }

        public boolean next(List<Cell> result, ScannerContext scannerContext) throws IOException {
            return this.scanner.next(result, scannerContext);
        }

        public void close() throws IOException {
            this.scanner.close();
        }

        public void shipped() throws IOException {
            if (this.scanner instanceof Shipper) {
                SHIPPED_COUNT.incrementAndGet();
                ((Shipper)this.scanner).shipped();
            }
        }
    }

    public static class CompactionObserver
    implements RegionCoprocessor,
    RegionObserver {
        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public InternalScanner preCompact(ObserverContext<RegionCoprocessorEnvironment> c, Store store, InternalScanner scanner, ScanType scanType, CompactionLifeCycleTracker tracker, CompactionRequest request) throws IOException {
            return new ShippedObservingScanner(scanner);
        }
    }
}

