/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ByteBufferKeyValue;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.exceptions.UnexpectedStateException;
import org.apache.hadoop.hbase.io.util.MemorySizeUtil;
import org.apache.hadoop.hbase.regionserver.Chunk;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.regionserver.DefaultMemStore;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MemStoreLABImpl;
import org.apache.hadoop.hbase.regionserver.MemStoreSnapshot;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestMemStoreChunkPool {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMemStoreChunkPool.class);
    private static final Configuration conf = new Configuration();
    private static ChunkCreator chunkCreator;
    private static boolean chunkPoolDisabledBeforeTest;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf.setBoolean("hbase.hregion.memstore.mslab.enabled", true);
        conf.setFloat("hbase.hregion.memstore.chunkpool.maxsize", 0.2f);
        chunkPoolDisabledBeforeTest = ChunkCreator.chunkPoolDisabled;
        ChunkCreator.chunkPoolDisabled = false;
        long globalMemStoreLimit = (long)((float)ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax() * MemorySizeUtil.getGlobalMemStoreHeapPercent((Configuration)conf, (boolean)false));
        chunkCreator = ChunkCreator.initialize((int)0x200000, (boolean)false, (long)globalMemStoreLimit, (float)0.2f, (float)0.0f, null, (float)0.1f);
        Assert.assertNotNull((Object)chunkCreator);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        ChunkCreator.chunkPoolDisabled = chunkPoolDisabledBeforeTest;
    }

    @After
    public void tearDown() throws Exception {
        chunkCreator.clearChunksInPool();
    }

    @Test
    public void testReusingChunks() {
        MemStoreLABImpl mslab = new MemStoreLABImpl(conf);
        int expectedOff = 0;
        ByteBuffer lastBuffer = null;
        byte[] rk = Bytes.toBytes((String)"r1");
        byte[] cf = Bytes.toBytes((String)"f");
        byte[] q = Bytes.toBytes((String)"q");
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        for (int i = 0; i < 100; ++i) {
            int valSize = ((Random)rand).nextInt(1000);
            KeyValue kv = new KeyValue(rk, cf, q, new byte[valSize]);
            int size = kv.getSerializedSize();
            ByteBufferKeyValue newKv = (ByteBufferKeyValue)mslab.copyCellInto((Cell)kv);
            if (newKv.getBuffer() != lastBuffer) {
                expectedOff = 4;
                lastBuffer = newKv.getBuffer();
            }
            Assert.assertEquals((long)expectedOff, (long)newKv.getOffset());
            Assert.assertTrue((String)"Allocation overruns buffer", (newKv.getOffset() + size <= newKv.getBuffer().capacity() ? 1 : 0) != 0);
            expectedOff += size;
        }
        mslab.close();
        int chunkCount = chunkCreator.getPoolSize();
        Assert.assertTrue((chunkCount > 0 ? 1 : 0) != 0);
        mslab = new MemStoreLABImpl(conf);
        KeyValue kv = new KeyValue(rk, cf, q, new byte[10]);
        mslab.copyCellInto((Cell)kv);
        Assert.assertEquals((long)(chunkCount - 1), (long)chunkCreator.getPoolSize());
    }

    @Test
    public void testPuttingBackChunksAfterFlushing() throws UnexpectedStateException {
        byte[] row = Bytes.toBytes((String)"testrow");
        byte[] fam = Bytes.toBytes((String)"testfamily");
        byte[] qf1 = Bytes.toBytes((String)"testqualifier1");
        byte[] qf2 = Bytes.toBytes((String)"testqualifier2");
        byte[] qf3 = Bytes.toBytes((String)"testqualifier3");
        byte[] qf4 = Bytes.toBytes((String)"testqualifier4");
        byte[] qf5 = Bytes.toBytes((String)"testqualifier5");
        byte[] val = Bytes.toBytes((String)"testval");
        DefaultMemStore memstore = new DefaultMemStore();
        memstore.add((Cell)new KeyValue(row, fam, qf1, val), null);
        memstore.add((Cell)new KeyValue(row, fam, qf2, val), null);
        memstore.add((Cell)new KeyValue(row, fam, qf3, val), null);
        MemStoreSnapshot snapshot = memstore.snapshot();
        Assert.assertEquals((long)3L, (long)memstore.getSnapshot().getCellsCount());
        Assert.assertEquals((long)0L, (long)memstore.getActive().getCellsCount());
        memstore.add((Cell)new KeyValue(row, fam, qf4, val), null);
        memstore.add((Cell)new KeyValue(row, fam, qf5, val), null);
        Assert.assertEquals((long)2L, (long)memstore.getActive().getCellsCount());
        for (KeyValueScanner scanner : snapshot.getScanners()) {
            scanner.close();
        }
        memstore.clearSnapshot(snapshot.getId());
        int chunkCount = chunkCreator.getPoolSize();
        Assert.assertTrue((chunkCount > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPuttingBackChunksWithOpeningScanner() throws IOException {
        byte[] row = Bytes.toBytes((String)"testrow");
        byte[] fam = Bytes.toBytes((String)"testfamily");
        byte[] qf1 = Bytes.toBytes((String)"testqualifier1");
        byte[] qf2 = Bytes.toBytes((String)"testqualifier2");
        byte[] qf3 = Bytes.toBytes((String)"testqualifier3");
        byte[] qf4 = Bytes.toBytes((String)"testqualifier4");
        byte[] qf5 = Bytes.toBytes((String)"testqualifier5");
        byte[] qf6 = Bytes.toBytes((String)"testqualifier6");
        byte[] qf7 = Bytes.toBytes((String)"testqualifier7");
        byte[] val = Bytes.toBytes((String)"testval");
        DefaultMemStore memstore = new DefaultMemStore();
        memstore.add((Cell)new KeyValue(row, fam, qf1, val), null);
        memstore.add((Cell)new KeyValue(row, fam, qf2, val), null);
        memstore.add((Cell)new KeyValue(row, fam, qf3, val), null);
        MemStoreSnapshot snapshot = memstore.snapshot();
        Assert.assertEquals((long)3L, (long)memstore.getSnapshot().getCellsCount());
        Assert.assertEquals((long)0L, (long)memstore.getActive().getCellsCount());
        memstore.add((Cell)new KeyValue(row, fam, qf4, val), null);
        memstore.add((Cell)new KeyValue(row, fam, qf5, val), null);
        Assert.assertEquals((long)2L, (long)memstore.getActive().getCellsCount());
        List scanners = memstore.getScanners(0L);
        for (KeyValueScanner scanner : snapshot.getScanners()) {
            scanner.close();
        }
        memstore.clearSnapshot(snapshot.getId());
        Assert.assertTrue((chunkCreator.getPoolSize() == 0 ? 1 : 0) != 0);
        for (KeyValueScanner scanner : scanners) {
            scanner.close();
        }
        Assert.assertTrue((chunkCreator.getPoolSize() > 0 ? 1 : 0) != 0);
        chunkCreator.clearChunksInPool();
        snapshot = memstore.snapshot();
        memstore.add((Cell)new KeyValue(row, fam, qf6, val), null);
        memstore.add((Cell)new KeyValue(row, fam, qf7, val), null);
        scanners = memstore.getScanners(0L);
        for (KeyValueScanner scanner : scanners) {
            scanner.close();
        }
        for (KeyValueScanner scanner : snapshot.getScanners()) {
            scanner.close();
        }
        memstore.clearSnapshot(snapshot.getId());
        Assert.assertTrue((chunkCreator.getPoolSize() > 0 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPutbackChunksMultiThreaded() throws Exception {
        int maxCount = 10;
        int initialCount = 5;
        int chunkSize = 40;
        int valSize = 7;
        ChunkCreator oldCreator = ChunkCreator.getInstance();
        ChunkCreator newCreator = new ChunkCreator(40, false, 400L, 1.0f, 0.5f, null, 0.0f);
        Assert.assertEquals((long)5L, (long)newCreator.getPoolSize());
        Assert.assertEquals((long)10L, (long)newCreator.getMaxCount());
        ChunkCreator.instance = newCreator;
        final KeyValue kv = new KeyValue(Bytes.toBytes((String)"r"), Bytes.toBytes((String)"f"), Bytes.toBytes((String)"q"), new byte[7]);
        final AtomicReference exceptionRef = new AtomicReference();
        try {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        MemStoreLABImpl memStoreLAB = new MemStoreLABImpl(conf);
                        for (int i = 0; i < 10; ++i) {
                            memStoreLAB.copyCellInto((Cell)kv);
                        }
                        memStoreLAB.close();
                    }
                    catch (Throwable execption) {
                        exceptionRef.set(execption);
                    }
                }
            };
            Thread t1 = new Thread(r);
            Thread t2 = new Thread(r);
            Thread t3 = new Thread(r);
            t1.start();
            t2.start();
            t3.start();
            t1.join();
            t2.join();
            t3.join();
            Assert.assertTrue((exceptionRef.get() == null ? 1 : 0) != 0);
            Assert.assertTrue((newCreator.getPoolSize() <= 10 && newCreator.getPoolSize() > 0 ? 1 : 0) != 0);
        }
        finally {
            ChunkCreator.instance = oldCreator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoIndexChunksPoolOrNoDataChunksPool() throws Exception {
        int maxCount = 10;
        int initialCount = 5;
        int newChunkSize = 40;
        int valSize = 7;
        ChunkCreator oldCreator = ChunkCreator.getInstance();
        try {
            ChunkCreator newCreator = new ChunkCreator(40, false, 400L, 1.0f, 0.5f, null, 0.0f);
            Assert.assertEquals((long)5L, (long)newCreator.getPoolSize());
            Assert.assertEquals((long)0L, (long)newCreator.getPoolSize(ChunkCreator.ChunkType.INDEX_CHUNK));
            Assert.assertEquals((long)10L, (long)newCreator.getMaxCount());
            Assert.assertEquals((long)0L, (long)newCreator.getMaxCount(ChunkCreator.ChunkType.INDEX_CHUNK));
            Assert.assertTrue((newCreator.getDataChunksPool() != null ? 1 : 0) != 0);
            Assert.assertTrue((newCreator.getIndexChunksPool() == null ? 1 : 0) != 0);
            ChunkCreator.instance = newCreator;
            KeyValue kv = new KeyValue(Bytes.toBytes((String)"r"), Bytes.toBytes((String)"f"), Bytes.toBytes((String)"q"), new byte[7]);
            MemStoreLABImpl memStoreLAB = new MemStoreLABImpl(conf);
            memStoreLAB.copyCellInto((Cell)kv);
            memStoreLAB.close();
            Assert.assertEquals((long)5L, (long)newCreator.getPoolSize());
            Assert.assertEquals((long)0L, (long)newCreator.getPoolSize(ChunkCreator.ChunkType.INDEX_CHUNK));
            Chunk dataChunk = newCreator.getChunk();
            Assert.assertTrue((boolean)dataChunk.isDataChunk());
            Assert.assertTrue((boolean)dataChunk.isFromPool());
            Assert.assertEquals((long)4L, (long)newCreator.getPoolSize());
            Assert.assertEquals((long)0L, (long)newCreator.getPoolSize(ChunkCreator.ChunkType.INDEX_CHUNK));
            newCreator.putbackChunks(Collections.singleton(dataChunk.getId()));
            Assert.assertEquals((long)5L, (long)newCreator.getPoolSize());
            Assert.assertEquals((long)0L, (long)newCreator.getPoolSize(ChunkCreator.ChunkType.INDEX_CHUNK));
            try {
                newCreator.getChunk(ChunkCreator.ChunkType.INDEX_CHUNK);
                Assert.fail();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            Chunk jumboChunk = newCreator.getJumboChunk(50);
            Assert.assertTrue((boolean)jumboChunk.isJumbo());
            Assert.assertTrue((!jumboChunk.isFromPool() ? 1 : 0) != 0);
            Assert.assertEquals((long)5L, (long)newCreator.getPoolSize());
            Assert.assertEquals((long)0L, (long)newCreator.getPoolSize(ChunkCreator.ChunkType.INDEX_CHUNK));
            newCreator = new ChunkCreator(40, false, 400L, 0.0f, 0.5f, null, 0.0f);
            Assert.assertEquals((long)0L, (long)newCreator.getPoolSize());
            Assert.assertEquals((long)0L, (long)newCreator.getPoolSize(ChunkCreator.ChunkType.INDEX_CHUNK));
            Assert.assertEquals((long)0L, (long)newCreator.getMaxCount());
            Assert.assertEquals((long)0L, (long)newCreator.getMaxCount(ChunkCreator.ChunkType.INDEX_CHUNK));
            Assert.assertTrue((newCreator.getDataChunksPool() == null ? 1 : 0) != 0);
            Assert.assertTrue((newCreator.getIndexChunksPool() == null ? 1 : 0) != 0);
            ChunkCreator.instance = newCreator;
            memStoreLAB = new MemStoreLABImpl(conf);
            memStoreLAB.copyCellInto((Cell)kv);
            memStoreLAB.close();
            Assert.assertEquals((long)0L, (long)newCreator.getPoolSize());
            Assert.assertEquals((long)0L, (long)newCreator.getPoolSize(ChunkCreator.ChunkType.INDEX_CHUNK));
            dataChunk = newCreator.getChunk();
            Assert.assertTrue((boolean)dataChunk.isDataChunk());
            Assert.assertTrue((!dataChunk.isFromPool() ? 1 : 0) != 0);
            Assert.assertEquals((long)0L, (long)newCreator.getPoolSize());
            Assert.assertEquals((long)0L, (long)newCreator.getPoolSize(ChunkCreator.ChunkType.INDEX_CHUNK));
            try {
                newCreator.getChunk(ChunkCreator.ChunkType.INDEX_CHUNK);
                Assert.fail();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            jumboChunk = newCreator.getJumboChunk(50);
            Assert.assertTrue((boolean)jumboChunk.isJumbo());
            Assert.assertTrue((!jumboChunk.isFromPool() ? 1 : 0) != 0);
            Assert.assertEquals((long)0L, (long)newCreator.getPoolSize());
            Assert.assertEquals((long)0L, (long)newCreator.getPoolSize(ChunkCreator.ChunkType.INDEX_CHUNK));
            newCreator = new ChunkCreator(40, false, 400L, 1.0f, 0.5f, null, 1.0f);
            Assert.assertEquals((long)0L, (long)newCreator.getPoolSize());
            Assert.assertEquals((long)5L, (long)newCreator.getPoolSize(ChunkCreator.ChunkType.INDEX_CHUNK));
            Assert.assertEquals((long)0L, (long)newCreator.getMaxCount());
            Assert.assertEquals((long)10L, (long)newCreator.getMaxCount(ChunkCreator.ChunkType.INDEX_CHUNK));
            Assert.assertTrue((newCreator.getDataChunksPool() == null ? 1 : 0) != 0);
            Assert.assertTrue((newCreator.getIndexChunksPool() != null ? 1 : 0) != 0);
            Assert.assertEquals((long)newCreator.getChunkSize(ChunkCreator.ChunkType.DATA_CHUNK), (long)newCreator.getChunkSize(ChunkCreator.ChunkType.INDEX_CHUNK));
            ChunkCreator.instance = newCreator;
            memStoreLAB = new MemStoreLABImpl(conf);
            memStoreLAB.copyCellInto((Cell)kv);
            memStoreLAB.close();
            Assert.assertEquals((long)0L, (long)newCreator.getPoolSize());
            Assert.assertEquals((long)5L, (long)newCreator.getPoolSize(ChunkCreator.ChunkType.INDEX_CHUNK));
            dataChunk = newCreator.getChunk();
            Assert.assertTrue((boolean)dataChunk.isDataChunk());
            Assert.assertTrue((!dataChunk.isFromPool() ? 1 : 0) != 0);
            Assert.assertEquals((long)0L, (long)newCreator.getPoolSize());
            Assert.assertEquals((long)5L, (long)newCreator.getPoolSize(ChunkCreator.ChunkType.INDEX_CHUNK));
            Chunk indexChunk = newCreator.getChunk(ChunkCreator.ChunkType.INDEX_CHUNK);
            Assert.assertEquals((long)0L, (long)newCreator.getPoolSize());
            Assert.assertEquals((long)4L, (long)newCreator.getPoolSize(ChunkCreator.ChunkType.INDEX_CHUNK));
            Assert.assertTrue((boolean)indexChunk.isIndexChunk());
            Assert.assertTrue((boolean)indexChunk.isFromPool());
            newCreator.putbackChunks(Collections.singleton(indexChunk.getId()));
            Assert.assertEquals((long)0L, (long)newCreator.getPoolSize());
            Assert.assertEquals((long)5L, (long)newCreator.getPoolSize(ChunkCreator.ChunkType.INDEX_CHUNK));
            jumboChunk = newCreator.getJumboChunk(50);
            Assert.assertTrue((boolean)jumboChunk.isJumbo());
            Assert.assertTrue((!jumboChunk.isFromPool() ? 1 : 0) != 0);
            Assert.assertEquals((long)0L, (long)newCreator.getPoolSize());
            Assert.assertEquals((long)5L, (long)newCreator.getPoolSize(ChunkCreator.ChunkType.INDEX_CHUNK));
        }
        finally {
            ChunkCreator.instance = oldCreator;
        }
        Assert.assertTrue((ChunkCreator.getInstance().getDataChunksPool() != null ? 1 : 0) != 0);
        Assert.assertTrue((ChunkCreator.getInstance().getIndexChunksPool() != null ? 1 : 0) != 0);
        Chunk dataChunk = ChunkCreator.getInstance().getChunk();
        Assert.assertTrue((boolean)dataChunk.isDataChunk());
        Assert.assertTrue((boolean)dataChunk.isFromPool());
        Chunk indexChunk = ChunkCreator.getInstance().getChunk(ChunkCreator.ChunkType.INDEX_CHUNK);
        Assert.assertTrue((boolean)indexChunk.isIndexChunk());
        Assert.assertTrue((boolean)indexChunk.isFromPool());
        Chunk jumboChunk = ChunkCreator.getInstance().getJumboChunk(ChunkCreator.getInstance().getChunkSize() + 10);
        Assert.assertTrue((boolean)jumboChunk.isJumbo());
        Assert.assertTrue((!jumboChunk.isFromPool() ? 1 : 0) != 0);
    }
}

