/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.security.visibility.ExpressionExpander;
import org.apache.hadoop.hbase.security.visibility.expression.ExpressionNode;
import org.apache.hadoop.hbase.security.visibility.expression.LeafExpressionNode;
import org.apache.hadoop.hbase.security.visibility.expression.NonLeafExpressionNode;
import org.apache.hadoop.hbase.security.visibility.expression.Operator;
import org.apache.hadoop.hbase.testclassification.SecurityTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SecurityTests.class, SmallTests.class})
public class TestExpressionExpander {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestExpressionExpander.class);

    @Test
    public void testPositiveCases() throws Exception {
        ExpressionExpander expander = new ExpressionExpander();
        NonLeafExpressionNode exp1 = new NonLeafExpressionNode(Operator.NOT, new ExpressionNode[]{new LeafExpressionNode("a")});
        ExpressionNode result = expander.expand((ExpressionNode)exp1);
        Assert.assertTrue((boolean)(result instanceof NonLeafExpressionNode));
        NonLeafExpressionNode nlResult = (NonLeafExpressionNode)result;
        Assert.assertEquals((Object)Operator.NOT, (Object)nlResult.getOperator());
        Assert.assertEquals((Object)"a", (Object)((LeafExpressionNode)nlResult.getChildExps().get(0)).getIdentifier());
        NonLeafExpressionNode exp2 = new NonLeafExpressionNode(Operator.OR, new ExpressionNode[]{new LeafExpressionNode("a"), new LeafExpressionNode("b")});
        result = expander.expand((ExpressionNode)exp2);
        Assert.assertTrue((boolean)(result instanceof NonLeafExpressionNode));
        nlResult = (NonLeafExpressionNode)result;
        Assert.assertEquals((Object)Operator.OR, (Object)nlResult.getOperator());
        Assert.assertEquals((long)2L, (long)nlResult.getChildExps().size());
        Assert.assertEquals((Object)"a", (Object)((LeafExpressionNode)nlResult.getChildExps().get(0)).getIdentifier());
        Assert.assertEquals((Object)"b", (Object)((LeafExpressionNode)nlResult.getChildExps().get(1)).getIdentifier());
        NonLeafExpressionNode exp3 = new NonLeafExpressionNode(Operator.AND, new ExpressionNode[]{new LeafExpressionNode("a"), new LeafExpressionNode("b")});
        result = expander.expand((ExpressionNode)exp3);
        Assert.assertTrue((boolean)(result instanceof NonLeafExpressionNode));
        nlResult = (NonLeafExpressionNode)result;
        Assert.assertEquals((Object)Operator.AND, (Object)nlResult.getOperator());
        Assert.assertEquals((long)2L, (long)nlResult.getChildExps().size());
        Assert.assertEquals((Object)"a", (Object)((LeafExpressionNode)nlResult.getChildExps().get(0)).getIdentifier());
        Assert.assertEquals((Object)"b", (Object)((LeafExpressionNode)nlResult.getChildExps().get(1)).getIdentifier());
        NonLeafExpressionNode exp4 = new NonLeafExpressionNode(Operator.OR, new ExpressionNode[]{new NonLeafExpressionNode(Operator.OR, new ExpressionNode[]{new LeafExpressionNode("a"), new LeafExpressionNode("b")}), new LeafExpressionNode("c")});
        result = expander.expand((ExpressionNode)exp4);
        Assert.assertTrue((boolean)(result instanceof NonLeafExpressionNode));
        nlResult = (NonLeafExpressionNode)result;
        Assert.assertEquals((Object)Operator.OR, (Object)nlResult.getOperator());
        Assert.assertEquals((long)3L, (long)nlResult.getChildExps().size());
        Assert.assertEquals((Object)"a", (Object)((LeafExpressionNode)nlResult.getChildExps().get(0)).getIdentifier());
        Assert.assertEquals((Object)"b", (Object)((LeafExpressionNode)nlResult.getChildExps().get(1)).getIdentifier());
        Assert.assertEquals((Object)"c", (Object)((LeafExpressionNode)nlResult.getChildExps().get(2)).getIdentifier());
        NonLeafExpressionNode exp5 = new NonLeafExpressionNode(Operator.AND, new ExpressionNode[]{new NonLeafExpressionNode(Operator.AND, new ExpressionNode[]{new LeafExpressionNode("a"), new LeafExpressionNode("b")}), new LeafExpressionNode("c")});
        result = expander.expand((ExpressionNode)exp5);
        Assert.assertTrue((boolean)(result instanceof NonLeafExpressionNode));
        nlResult = (NonLeafExpressionNode)result;
        Assert.assertEquals((Object)Operator.AND, (Object)nlResult.getOperator());
        Assert.assertEquals((long)3L, (long)nlResult.getChildExps().size());
        Assert.assertEquals((Object)"a", (Object)((LeafExpressionNode)nlResult.getChildExps().get(0)).getIdentifier());
        Assert.assertEquals((Object)"b", (Object)((LeafExpressionNode)nlResult.getChildExps().get(1)).getIdentifier());
        Assert.assertEquals((Object)"c", (Object)((LeafExpressionNode)nlResult.getChildExps().get(2)).getIdentifier());
        NonLeafExpressionNode exp6 = new NonLeafExpressionNode(Operator.AND, new ExpressionNode[]{new NonLeafExpressionNode(Operator.OR, new ExpressionNode[]{new LeafExpressionNode("a"), new LeafExpressionNode("b")}), new LeafExpressionNode("c")});
        result = expander.expand((ExpressionNode)exp6);
        Assert.assertTrue((boolean)(result instanceof NonLeafExpressionNode));
        nlResult = (NonLeafExpressionNode)result;
        Assert.assertEquals((Object)Operator.OR, (Object)nlResult.getOperator());
        Assert.assertEquals((long)2L, (long)nlResult.getChildExps().size());
        NonLeafExpressionNode temp = (NonLeafExpressionNode)nlResult.getChildExps().get(0);
        Assert.assertEquals((Object)Operator.AND, (Object)temp.getOperator());
        Assert.assertEquals((long)2L, (long)temp.getChildExps().size());
        Assert.assertEquals((Object)"a", (Object)((LeafExpressionNode)temp.getChildExps().get(0)).getIdentifier());
        Assert.assertEquals((Object)"c", (Object)((LeafExpressionNode)temp.getChildExps().get(1)).getIdentifier());
        temp = (NonLeafExpressionNode)nlResult.getChildExps().get(1);
        Assert.assertEquals((Object)Operator.AND, (Object)temp.getOperator());
        Assert.assertEquals((long)2L, (long)temp.getChildExps().size());
        Assert.assertEquals((Object)"b", (Object)((LeafExpressionNode)temp.getChildExps().get(0)).getIdentifier());
        Assert.assertEquals((Object)"c", (Object)((LeafExpressionNode)temp.getChildExps().get(1)).getIdentifier());
        NonLeafExpressionNode exp7 = new NonLeafExpressionNode(Operator.OR, new ExpressionNode[]{new NonLeafExpressionNode(Operator.AND, new ExpressionNode[]{new LeafExpressionNode("a"), new LeafExpressionNode("b")}), new LeafExpressionNode("c")});
        result = expander.expand((ExpressionNode)exp7);
        Assert.assertTrue((boolean)(result instanceof NonLeafExpressionNode));
        nlResult = (NonLeafExpressionNode)result;
        Assert.assertEquals((Object)Operator.OR, (Object)nlResult.getOperator());
        Assert.assertEquals((long)2L, (long)nlResult.getChildExps().size());
        Assert.assertEquals((Object)"c", (Object)((LeafExpressionNode)nlResult.getChildExps().get(1)).getIdentifier());
        nlResult = (NonLeafExpressionNode)nlResult.getChildExps().get(0);
        Assert.assertEquals((Object)Operator.AND, (Object)nlResult.getOperator());
        Assert.assertEquals((long)2L, (long)nlResult.getChildExps().size());
        Assert.assertEquals((Object)"a", (Object)((LeafExpressionNode)nlResult.getChildExps().get(0)).getIdentifier());
        Assert.assertEquals((Object)"b", (Object)((LeafExpressionNode)nlResult.getChildExps().get(1)).getIdentifier());
        NonLeafExpressionNode exp8 = new NonLeafExpressionNode(Operator.AND);
        exp8.addChildExp((ExpressionNode)new NonLeafExpressionNode(Operator.OR, new ExpressionNode[]{new NonLeafExpressionNode(Operator.AND, new ExpressionNode[]{new LeafExpressionNode("a"), new LeafExpressionNode("b")}), new LeafExpressionNode("c")}));
        exp8.addChildExp((ExpressionNode)new LeafExpressionNode("d"));
        result = expander.expand((ExpressionNode)exp8);
        Assert.assertTrue((boolean)(result instanceof NonLeafExpressionNode));
        nlResult = (NonLeafExpressionNode)result;
        Assert.assertEquals((Object)Operator.OR, (Object)nlResult.getOperator());
        Assert.assertEquals((long)2L, (long)nlResult.getChildExps().size());
        temp = (NonLeafExpressionNode)nlResult.getChildExps().get(1);
        Assert.assertEquals((Object)Operator.AND, (Object)temp.getOperator());
        Assert.assertEquals((long)2L, (long)temp.getChildExps().size());
        Assert.assertEquals((Object)"c", (Object)((LeafExpressionNode)temp.getChildExps().get(0)).getIdentifier());
        Assert.assertEquals((Object)"d", (Object)((LeafExpressionNode)temp.getChildExps().get(1)).getIdentifier());
        temp = (NonLeafExpressionNode)nlResult.getChildExps().get(0);
        Assert.assertEquals((Object)Operator.AND, (Object)temp.getOperator());
        Assert.assertEquals((long)2L, (long)temp.getChildExps().size());
        Assert.assertEquals((Object)"d", (Object)((LeafExpressionNode)temp.getChildExps().get(1)).getIdentifier());
        temp = (NonLeafExpressionNode)temp.getChildExps().get(0);
        Assert.assertEquals((Object)Operator.AND, (Object)temp.getOperator());
        Assert.assertEquals((long)2L, (long)temp.getChildExps().size());
        Assert.assertEquals((Object)"a", (Object)((LeafExpressionNode)temp.getChildExps().get(0)).getIdentifier());
        Assert.assertEquals((Object)"b", (Object)((LeafExpressionNode)temp.getChildExps().get(1)).getIdentifier());
        NonLeafExpressionNode exp9 = new NonLeafExpressionNode(Operator.OR);
        exp9.addChildExp((ExpressionNode)new NonLeafExpressionNode(Operator.OR, new ExpressionNode[]{new LeafExpressionNode("a"), new LeafExpressionNode("b")}));
        exp9.addChildExp((ExpressionNode)new NonLeafExpressionNode(Operator.OR, new ExpressionNode[]{new LeafExpressionNode("c"), new LeafExpressionNode("d")}));
        result = expander.expand((ExpressionNode)exp9);
        Assert.assertTrue((boolean)(result instanceof NonLeafExpressionNode));
        nlResult = (NonLeafExpressionNode)result;
        Assert.assertEquals((Object)Operator.OR, (Object)nlResult.getOperator());
        Assert.assertEquals((long)4L, (long)nlResult.getChildExps().size());
        Assert.assertEquals((Object)"a", (Object)((LeafExpressionNode)nlResult.getChildExps().get(0)).getIdentifier());
        Assert.assertEquals((Object)"b", (Object)((LeafExpressionNode)nlResult.getChildExps().get(1)).getIdentifier());
        Assert.assertEquals((Object)"c", (Object)((LeafExpressionNode)nlResult.getChildExps().get(2)).getIdentifier());
        Assert.assertEquals((Object)"d", (Object)((LeafExpressionNode)nlResult.getChildExps().get(3)).getIdentifier());
        NonLeafExpressionNode exp10 = new NonLeafExpressionNode(Operator.AND);
        exp10.addChildExp((ExpressionNode)new NonLeafExpressionNode(Operator.AND, new ExpressionNode[]{new LeafExpressionNode("a"), new LeafExpressionNode("b")}));
        exp10.addChildExp((ExpressionNode)new NonLeafExpressionNode(Operator.AND, new ExpressionNode[]{new LeafExpressionNode("c"), new LeafExpressionNode("d")}));
        result = expander.expand((ExpressionNode)exp10);
        Assert.assertTrue((boolean)(result instanceof NonLeafExpressionNode));
        nlResult = (NonLeafExpressionNode)result;
        Assert.assertEquals((Object)Operator.AND, (Object)nlResult.getOperator());
        Assert.assertEquals((long)4L, (long)nlResult.getChildExps().size());
        Assert.assertEquals((Object)"a", (Object)((LeafExpressionNode)nlResult.getChildExps().get(0)).getIdentifier());
        Assert.assertEquals((Object)"b", (Object)((LeafExpressionNode)nlResult.getChildExps().get(1)).getIdentifier());
        Assert.assertEquals((Object)"c", (Object)((LeafExpressionNode)nlResult.getChildExps().get(2)).getIdentifier());
        Assert.assertEquals((Object)"d", (Object)((LeafExpressionNode)nlResult.getChildExps().get(3)).getIdentifier());
        NonLeafExpressionNode exp11 = new NonLeafExpressionNode(Operator.AND);
        exp11.addChildExp((ExpressionNode)new NonLeafExpressionNode(Operator.OR, new ExpressionNode[]{new LeafExpressionNode("a"), new LeafExpressionNode("b")}));
        exp11.addChildExp((ExpressionNode)new NonLeafExpressionNode(Operator.OR, new ExpressionNode[]{new LeafExpressionNode("c"), new LeafExpressionNode("d")}));
        result = expander.expand((ExpressionNode)exp11);
        Assert.assertTrue((boolean)(result instanceof NonLeafExpressionNode));
        nlResult = (NonLeafExpressionNode)result;
        Assert.assertEquals((Object)Operator.OR, (Object)nlResult.getOperator());
        Assert.assertEquals((long)4L, (long)nlResult.getChildExps().size());
        temp = (NonLeafExpressionNode)nlResult.getChildExps().get(0);
        Assert.assertEquals((Object)Operator.AND, (Object)temp.getOperator());
        Assert.assertEquals((long)2L, (long)temp.getChildExps().size());
        Assert.assertEquals((Object)"a", (Object)((LeafExpressionNode)temp.getChildExps().get(0)).getIdentifier());
        Assert.assertEquals((Object)"c", (Object)((LeafExpressionNode)temp.getChildExps().get(1)).getIdentifier());
        temp = (NonLeafExpressionNode)nlResult.getChildExps().get(1);
        Assert.assertEquals((Object)Operator.AND, (Object)temp.getOperator());
        Assert.assertEquals((long)2L, (long)temp.getChildExps().size());
        Assert.assertEquals((Object)"a", (Object)((LeafExpressionNode)temp.getChildExps().get(0)).getIdentifier());
        Assert.assertEquals((Object)"d", (Object)((LeafExpressionNode)temp.getChildExps().get(1)).getIdentifier());
        temp = (NonLeafExpressionNode)nlResult.getChildExps().get(2);
        Assert.assertEquals((Object)Operator.AND, (Object)temp.getOperator());
        Assert.assertEquals((long)2L, (long)temp.getChildExps().size());
        Assert.assertEquals((Object)"b", (Object)((LeafExpressionNode)temp.getChildExps().get(0)).getIdentifier());
        Assert.assertEquals((Object)"c", (Object)((LeafExpressionNode)temp.getChildExps().get(1)).getIdentifier());
        temp = (NonLeafExpressionNode)nlResult.getChildExps().get(3);
        Assert.assertEquals((Object)Operator.AND, (Object)temp.getOperator());
        Assert.assertEquals((long)2L, (long)temp.getChildExps().size());
        Assert.assertEquals((Object)"b", (Object)((LeafExpressionNode)temp.getChildExps().get(0)).getIdentifier());
        Assert.assertEquals((Object)"d", (Object)((LeafExpressionNode)temp.getChildExps().get(1)).getIdentifier());
        NonLeafExpressionNode exp12 = new NonLeafExpressionNode(Operator.AND);
        NonLeafExpressionNode tempExp1 = new NonLeafExpressionNode(Operator.OR, new ExpressionNode[]{new LeafExpressionNode("a"), new LeafExpressionNode("b")});
        NonLeafExpressionNode tempExp2 = new NonLeafExpressionNode(Operator.OR, new ExpressionNode[]{tempExp1, new LeafExpressionNode("c")});
        NonLeafExpressionNode tempExp3 = new NonLeafExpressionNode(Operator.OR, new ExpressionNode[]{tempExp2, new LeafExpressionNode("d")});
        exp12.addChildExp((ExpressionNode)tempExp3);
        exp12.addChildExp((ExpressionNode)new LeafExpressionNode("e"));
        result = expander.expand((ExpressionNode)exp12);
        Assert.assertTrue((boolean)(result instanceof NonLeafExpressionNode));
        nlResult = (NonLeafExpressionNode)result;
        Assert.assertEquals((Object)Operator.OR, (Object)nlResult.getOperator());
        Assert.assertEquals((long)4L, (long)nlResult.getChildExps().size());
        temp = (NonLeafExpressionNode)nlResult.getChildExps().get(0);
        Assert.assertEquals((Object)Operator.AND, (Object)temp.getOperator());
        Assert.assertEquals((long)2L, (long)temp.getChildExps().size());
        Assert.assertEquals((Object)"a", (Object)((LeafExpressionNode)temp.getChildExps().get(0)).getIdentifier());
        Assert.assertEquals((Object)"e", (Object)((LeafExpressionNode)temp.getChildExps().get(1)).getIdentifier());
        temp = (NonLeafExpressionNode)nlResult.getChildExps().get(1);
        Assert.assertEquals((Object)Operator.AND, (Object)temp.getOperator());
        Assert.assertEquals((long)2L, (long)temp.getChildExps().size());
        Assert.assertEquals((Object)"b", (Object)((LeafExpressionNode)temp.getChildExps().get(0)).getIdentifier());
        Assert.assertEquals((Object)"e", (Object)((LeafExpressionNode)temp.getChildExps().get(1)).getIdentifier());
        temp = (NonLeafExpressionNode)nlResult.getChildExps().get(2);
        Assert.assertEquals((Object)Operator.AND, (Object)temp.getOperator());
        Assert.assertEquals((long)2L, (long)temp.getChildExps().size());
        Assert.assertEquals((Object)"c", (Object)((LeafExpressionNode)temp.getChildExps().get(0)).getIdentifier());
        Assert.assertEquals((Object)"e", (Object)((LeafExpressionNode)temp.getChildExps().get(1)).getIdentifier());
        temp = (NonLeafExpressionNode)nlResult.getChildExps().get(3);
        Assert.assertEquals((Object)Operator.AND, (Object)temp.getOperator());
        Assert.assertEquals((long)2L, (long)temp.getChildExps().size());
        Assert.assertEquals((Object)"d", (Object)((LeafExpressionNode)temp.getChildExps().get(0)).getIdentifier());
        Assert.assertEquals((Object)"e", (Object)((LeafExpressionNode)temp.getChildExps().get(1)).getIdentifier());
        NonLeafExpressionNode exp13 = new NonLeafExpressionNode(Operator.AND, new ExpressionNode[]{new NonLeafExpressionNode(Operator.OR, new ExpressionNode[]{new LeafExpressionNode("a"), new LeafExpressionNode("b"), new LeafExpressionNode("c")}), new LeafExpressionNode("d")});
        result = expander.expand((ExpressionNode)exp13);
        Assert.assertTrue((boolean)(result instanceof NonLeafExpressionNode));
        nlResult = (NonLeafExpressionNode)result;
        Assert.assertEquals((Object)Operator.OR, (Object)nlResult.getOperator());
        Assert.assertEquals((long)3L, (long)nlResult.getChildExps().size());
        temp = (NonLeafExpressionNode)nlResult.getChildExps().get(0);
        Assert.assertEquals((Object)Operator.AND, (Object)temp.getOperator());
        Assert.assertEquals((long)2L, (long)temp.getChildExps().size());
        Assert.assertEquals((Object)"a", (Object)((LeafExpressionNode)temp.getChildExps().get(0)).getIdentifier());
        Assert.assertEquals((Object)"d", (Object)((LeafExpressionNode)temp.getChildExps().get(1)).getIdentifier());
        temp = (NonLeafExpressionNode)nlResult.getChildExps().get(1);
        Assert.assertEquals((Object)Operator.AND, (Object)temp.getOperator());
        Assert.assertEquals((long)2L, (long)temp.getChildExps().size());
        Assert.assertEquals((Object)"b", (Object)((LeafExpressionNode)temp.getChildExps().get(0)).getIdentifier());
        Assert.assertEquals((Object)"d", (Object)((LeafExpressionNode)temp.getChildExps().get(1)).getIdentifier());
        temp = (NonLeafExpressionNode)nlResult.getChildExps().get(2);
        Assert.assertEquals((Object)Operator.AND, (Object)temp.getOperator());
        Assert.assertEquals((long)2L, (long)temp.getChildExps().size());
        Assert.assertEquals((Object)"c", (Object)((LeafExpressionNode)temp.getChildExps().get(0)).getIdentifier());
        Assert.assertEquals((Object)"d", (Object)((LeafExpressionNode)temp.getChildExps().get(1)).getIdentifier());
        NonLeafExpressionNode exp15 = new NonLeafExpressionNode(Operator.AND);
        NonLeafExpressionNode temp1 = new NonLeafExpressionNode(Operator.AND);
        temp1.addChildExp((ExpressionNode)new NonLeafExpressionNode(Operator.OR, new ExpressionNode[]{new LeafExpressionNode("a"), new LeafExpressionNode("b")}));
        temp1.addChildExp((ExpressionNode)new NonLeafExpressionNode(Operator.OR, new ExpressionNode[]{new LeafExpressionNode("c"), new LeafExpressionNode("d")}));
        exp15.addChildExp((ExpressionNode)temp1);
        exp15.addChildExp((ExpressionNode)new NonLeafExpressionNode(Operator.OR, new ExpressionNode[]{new LeafExpressionNode("e"), new LeafExpressionNode("f")}));
        result = expander.expand((ExpressionNode)exp15);
        Assert.assertTrue((boolean)(result instanceof NonLeafExpressionNode));
        nlResult = (NonLeafExpressionNode)result;
        Assert.assertEquals((Object)Operator.OR, (Object)nlResult.getOperator());
        Assert.assertEquals((long)8L, (long)nlResult.getChildExps().size());
        temp = (NonLeafExpressionNode)nlResult.getChildExps().get(0);
        Assert.assertEquals((Object)Operator.AND, (Object)temp.getOperator());
        Assert.assertEquals((long)2L, (long)temp.getChildExps().size());
        Assert.assertEquals((Object)"e", (Object)((LeafExpressionNode)temp.getChildExps().get(1)).getIdentifier());
        temp = (NonLeafExpressionNode)temp.getChildExps().get(0);
        Assert.assertEquals((Object)Operator.AND, (Object)temp.getOperator());
        Assert.assertEquals((long)2L, (long)temp.getChildExps().size());
        Assert.assertEquals((Object)"a", (Object)((LeafExpressionNode)temp.getChildExps().get(0)).getIdentifier());
        Assert.assertEquals((Object)"c", (Object)((LeafExpressionNode)temp.getChildExps().get(1)).getIdentifier());
        temp = (NonLeafExpressionNode)nlResult.getChildExps().get(1);
        Assert.assertEquals((Object)Operator.AND, (Object)temp.getOperator());
        Assert.assertEquals((long)2L, (long)temp.getChildExps().size());
        Assert.assertEquals((Object)"f", (Object)((LeafExpressionNode)temp.getChildExps().get(1)).getIdentifier());
        temp = (NonLeafExpressionNode)temp.getChildExps().get(0);
        Assert.assertEquals((Object)Operator.AND, (Object)temp.getOperator());
        Assert.assertEquals((long)2L, (long)temp.getChildExps().size());
        Assert.assertEquals((Object)"a", (Object)((LeafExpressionNode)temp.getChildExps().get(0)).getIdentifier());
        Assert.assertEquals((Object)"c", (Object)((LeafExpressionNode)temp.getChildExps().get(1)).getIdentifier());
        temp = (NonLeafExpressionNode)nlResult.getChildExps().get(2);
        Assert.assertEquals((Object)Operator.AND, (Object)temp.getOperator());
        Assert.assertEquals((long)2L, (long)temp.getChildExps().size());
        Assert.assertEquals((Object)"e", (Object)((LeafExpressionNode)temp.getChildExps().get(1)).getIdentifier());
        temp = (NonLeafExpressionNode)temp.getChildExps().get(0);
        Assert.assertEquals((Object)Operator.AND, (Object)temp.getOperator());
        Assert.assertEquals((long)2L, (long)temp.getChildExps().size());
        Assert.assertEquals((Object)"a", (Object)((LeafExpressionNode)temp.getChildExps().get(0)).getIdentifier());
        Assert.assertEquals((Object)"d", (Object)((LeafExpressionNode)temp.getChildExps().get(1)).getIdentifier());
        temp = (NonLeafExpressionNode)nlResult.getChildExps().get(3);
        Assert.assertEquals((Object)Operator.AND, (Object)temp.getOperator());
        Assert.assertEquals((long)2L, (long)temp.getChildExps().size());
        Assert.assertEquals((Object)"f", (Object)((LeafExpressionNode)temp.getChildExps().get(1)).getIdentifier());
        temp = (NonLeafExpressionNode)temp.getChildExps().get(0);
        Assert.assertEquals((Object)Operator.AND, (Object)temp.getOperator());
        Assert.assertEquals((long)2L, (long)temp.getChildExps().size());
        Assert.assertEquals((Object)"a", (Object)((LeafExpressionNode)temp.getChildExps().get(0)).getIdentifier());
        Assert.assertEquals((Object)"d", (Object)((LeafExpressionNode)temp.getChildExps().get(1)).getIdentifier());
        temp = (NonLeafExpressionNode)nlResult.getChildExps().get(4);
        Assert.assertEquals((Object)Operator.AND, (Object)temp.getOperator());
        Assert.assertEquals((long)2L, (long)temp.getChildExps().size());
        Assert.assertEquals((Object)"e", (Object)((LeafExpressionNode)temp.getChildExps().get(1)).getIdentifier());
        temp = (NonLeafExpressionNode)temp.getChildExps().get(0);
        Assert.assertEquals((Object)Operator.AND, (Object)temp.getOperator());
        Assert.assertEquals((long)2L, (long)temp.getChildExps().size());
        Assert.assertEquals((Object)"b", (Object)((LeafExpressionNode)temp.getChildExps().get(0)).getIdentifier());
        Assert.assertEquals((Object)"c", (Object)((LeafExpressionNode)temp.getChildExps().get(1)).getIdentifier());
        temp = (NonLeafExpressionNode)nlResult.getChildExps().get(5);
        Assert.assertEquals((Object)Operator.AND, (Object)temp.getOperator());
        Assert.assertEquals((long)2L, (long)temp.getChildExps().size());
        Assert.assertEquals((Object)"f", (Object)((LeafExpressionNode)temp.getChildExps().get(1)).getIdentifier());
        temp = (NonLeafExpressionNode)temp.getChildExps().get(0);
        Assert.assertEquals((Object)Operator.AND, (Object)temp.getOperator());
        Assert.assertEquals((long)2L, (long)temp.getChildExps().size());
        Assert.assertEquals((Object)"b", (Object)((LeafExpressionNode)temp.getChildExps().get(0)).getIdentifier());
        Assert.assertEquals((Object)"c", (Object)((LeafExpressionNode)temp.getChildExps().get(1)).getIdentifier());
        temp = (NonLeafExpressionNode)nlResult.getChildExps().get(6);
        Assert.assertEquals((Object)Operator.AND, (Object)temp.getOperator());
        Assert.assertEquals((long)2L, (long)temp.getChildExps().size());
        Assert.assertEquals((Object)"e", (Object)((LeafExpressionNode)temp.getChildExps().get(1)).getIdentifier());
        temp = (NonLeafExpressionNode)temp.getChildExps().get(0);
        Assert.assertEquals((Object)Operator.AND, (Object)temp.getOperator());
        Assert.assertEquals((long)2L, (long)temp.getChildExps().size());
        Assert.assertEquals((Object)"b", (Object)((LeafExpressionNode)temp.getChildExps().get(0)).getIdentifier());
        Assert.assertEquals((Object)"d", (Object)((LeafExpressionNode)temp.getChildExps().get(1)).getIdentifier());
        temp = (NonLeafExpressionNode)nlResult.getChildExps().get(7);
        Assert.assertEquals((Object)Operator.AND, (Object)temp.getOperator());
        Assert.assertEquals((long)2L, (long)temp.getChildExps().size());
        Assert.assertEquals((Object)"f", (Object)((LeafExpressionNode)temp.getChildExps().get(1)).getIdentifier());
        temp = (NonLeafExpressionNode)temp.getChildExps().get(0);
        Assert.assertEquals((Object)Operator.AND, (Object)temp.getOperator());
        Assert.assertEquals((long)2L, (long)temp.getChildExps().size());
        Assert.assertEquals((Object)"b", (Object)((LeafExpressionNode)temp.getChildExps().get(0)).getIdentifier());
        Assert.assertEquals((Object)"d", (Object)((LeafExpressionNode)temp.getChildExps().get(1)).getIdentifier());
        NonLeafExpressionNode exp16 = new NonLeafExpressionNode(Operator.NOT, new ExpressionNode[]{new NonLeafExpressionNode(Operator.OR, new ExpressionNode[]{new LeafExpressionNode("a"), new LeafExpressionNode("b")})});
        result = expander.expand((ExpressionNode)exp16);
        Assert.assertTrue((boolean)(result instanceof NonLeafExpressionNode));
        nlResult = (NonLeafExpressionNode)result;
        Assert.assertEquals((Object)Operator.AND, (Object)nlResult.getOperator());
        Assert.assertEquals((long)2L, (long)nlResult.getChildExps().size());
        temp = (NonLeafExpressionNode)nlResult.getChildExps().get(0);
        Assert.assertEquals((Object)Operator.NOT, (Object)temp.getOperator());
        Assert.assertEquals((Object)"a", (Object)((LeafExpressionNode)temp.getChildExps().get(0)).getIdentifier());
        temp = (NonLeafExpressionNode)nlResult.getChildExps().get(1);
        Assert.assertEquals((Object)Operator.NOT, (Object)temp.getOperator());
        Assert.assertEquals((Object)"b", (Object)((LeafExpressionNode)temp.getChildExps().get(0)).getIdentifier());
    }
}

