/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MapReduceTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MapReduceTests.class, LargeTests.class})
public class TestHBaseMRTestingUtility {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHBaseMRTestingUtility.class);

    @Test
    public void testMRYarnConfigsPopulation() throws IOException {
        HashMap<String, String> dummyProps = new HashMap<String, String>();
        dummyProps.put("mapreduce.jobtracker.address", "dummyhost:11234");
        dummyProps.put("yarn.resourcemanager.address", "dummyhost:11235");
        dummyProps.put("mapreduce.jobhistory.address", "dummyhost:11236");
        dummyProps.put("yarn.resourcemanager.scheduler.address", "dummyhost:11237");
        dummyProps.put("mapreduce.jobhistory.webapp.address", "dummyhost:11238");
        dummyProps.put("yarn.resourcemanager.webapp.address", "dummyhost:11239");
        HBaseTestingUtility hbt = new HBaseTestingUtility();
        for (Map.Entry entry : dummyProps.entrySet()) {
            hbt.getConfiguration().set((String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry entry : dummyProps.entrySet()) {
            Assert.assertTrue((String)("The Configuration for key " + (String)entry.getKey() + " and value: " + (String)entry.getValue() + " is not populated correctly"), (boolean)hbt.getConfiguration().get((String)entry.getKey()).equals(entry.getValue()));
        }
        hbt.startMiniMapReduceCluster();
        for (Map.Entry entry : dummyProps.entrySet()) {
            Assert.assertFalse((String)("The MR prop: " + (String)entry.getValue() + " is not overwritten when map reduce minicluster is started"), (boolean)hbt.getConfiguration().get((String)entry.getKey()).equals(entry.getValue()));
        }
        hbt.shutdownMiniMapReduceCluster();
    }
}

