/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2.store;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureUtil;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStore;
import org.apache.hadoop.hbase.procedure2.store.ProcedureTree;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, SmallTests.class})
public class TestProcedureTree {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestProcedureTree.class);

    private TestProcedure createProc(long procId, long parentProcId) {
        TestProcedure proc = new TestProcedure();
        proc.setProcId(procId);
        if (parentProcId != -1L) {
            proc.setParentProcId(parentProcId);
        }
        return proc;
    }

    private List<ProcedureProtos.Procedure> toProtos(TestProcedure ... procs) {
        return Arrays.stream(procs).map(p -> {
            try {
                return ProcedureUtil.convertToProtoProcedure((Procedure)p);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }).collect(Collectors.toList());
    }

    private List<TestProcedure> getProcs(ProcedureStore.ProcedureIterator iter) throws IOException {
        ArrayList<TestProcedure> procs = new ArrayList<TestProcedure>();
        while (iter.hasNext()) {
            procs.add((TestProcedure)iter.next());
        }
        return procs;
    }

    @Test
    public void testMissingStackId() throws IOException {
        TestProcedure proc0 = this.createProc(1L, -1L);
        proc0.addStackIndex(0);
        TestProcedure proc1 = this.createProc(2L, 1L);
        proc1.addStackIndex(1);
        TestProcedure proc2 = this.createProc(3L, 2L);
        proc2.addStackIndex(3);
        ProcedureTree tree = ProcedureTree.build(this.toProtos(proc0, proc1, proc2));
        List<TestProcedure> validProcs = this.getProcs(tree.getValidProcs());
        Assert.assertEquals((long)0L, (long)validProcs.size());
        List<TestProcedure> corruptedProcs = this.getProcs(tree.getCorruptedProcs());
        Assert.assertEquals((long)3L, (long)corruptedProcs.size());
        Assert.assertEquals((long)1L, (long)corruptedProcs.get(0).getProcId());
        Assert.assertEquals((long)2L, (long)corruptedProcs.get(1).getProcId());
        Assert.assertEquals((long)3L, (long)corruptedProcs.get(2).getProcId());
    }

    @Test
    public void testDuplicatedStackId() throws IOException {
        TestProcedure proc0 = this.createProc(1L, -1L);
        proc0.addStackIndex(0);
        TestProcedure proc1 = this.createProc(2L, 1L);
        proc1.addStackIndex(1);
        TestProcedure proc2 = this.createProc(3L, 2L);
        proc2.addStackIndex(1);
        ProcedureTree tree = ProcedureTree.build(this.toProtos(proc0, proc1, proc2));
        List<TestProcedure> validProcs = this.getProcs(tree.getValidProcs());
        Assert.assertEquals((long)0L, (long)validProcs.size());
        List<TestProcedure> corruptedProcs = this.getProcs(tree.getCorruptedProcs());
        Assert.assertEquals((long)3L, (long)corruptedProcs.size());
        Assert.assertEquals((long)1L, (long)corruptedProcs.get(0).getProcId());
        Assert.assertEquals((long)2L, (long)corruptedProcs.get(1).getProcId());
        Assert.assertEquals((long)3L, (long)corruptedProcs.get(2).getProcId());
    }

    @Test
    public void testOrphan() throws IOException {
        TestProcedure proc0 = this.createProc(1L, -1L);
        proc0.addStackIndex(0);
        TestProcedure proc1 = this.createProc(2L, 1L);
        proc1.addStackIndex(1);
        TestProcedure proc2 = this.createProc(3L, -1L);
        proc2.addStackIndex(0);
        TestProcedure proc3 = this.createProc(5L, 4L);
        proc3.addStackIndex(1);
        ProcedureTree tree = ProcedureTree.build(this.toProtos(proc0, proc1, proc2, proc3));
        List<TestProcedure> validProcs = this.getProcs(tree.getValidProcs());
        Assert.assertEquals((long)3L, (long)validProcs.size());
        List<TestProcedure> corruptedProcs = this.getProcs(tree.getCorruptedProcs());
        Assert.assertEquals((long)1L, (long)corruptedProcs.size());
        Assert.assertEquals((long)5L, (long)corruptedProcs.get(0).getProcId());
        Assert.assertEquals((long)4L, (long)corruptedProcs.get(0).getParentProcId());
    }

    public static final class TestProcedure
    extends Procedure<Void> {
        public void setProcId(long procId) {
            super.setProcId(procId);
        }

        public void setParentProcId(long parentProcId) {
            super.setParentProcId(parentProcId);
        }

        public synchronized void addStackIndex(int index) {
            super.addStackIndex(index);
        }

        protected Procedure<Void>[] execute(Void env) throws ProcedureYieldException, ProcedureSuspendedException, InterruptedException {
            return null;
        }

        protected void rollback(Void env) throws IOException, InterruptedException {
        }

        protected boolean abort(Void env) {
            return false;
        }

        protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        }

        protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        }
    }
}

