/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.asyncfs;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.io.asyncfs.AsyncFSTestBase;
import org.apache.hadoop.hbase.io.asyncfs.FanOutOneBlockAsyncDFSOutput;
import org.apache.hadoop.hbase.io.asyncfs.FanOutOneBlockAsyncDFSOutputHelper;
import org.apache.hadoop.hbase.io.asyncfs.monitor.StreamSlowMonitor;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.DummyDFSOutputStream;
import org.apache.hbase.thirdparty.io.netty.channel.Channel;
import org.apache.hbase.thirdparty.io.netty.channel.EventLoop;
import org.apache.hbase.thirdparty.io.netty.channel.EventLoopGroup;
import org.apache.hbase.thirdparty.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.hbase.thirdparty.io.netty.channel.socket.nio.NioSocketChannel;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.MockedConstruction;
import org.mockito.Mockito;

@Category(value={MiscTests.class, MediumTests.class})
public class TestLeaseRenewal
extends AsyncFSTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestLeaseRenewal.class);
    private static DistributedFileSystem FS;
    private static EventLoopGroup EVENT_LOOP_GROUP;
    private static Class<? extends Channel> CHANNEL_CLASS;
    private static StreamSlowMonitor MONITOR;

    @BeforeClass
    public static void setUp() throws Exception {
        TestLeaseRenewal.startMiniDFSCluster(3);
        FS = CLUSTER.getFileSystem();
        EVENT_LOOP_GROUP = new NioEventLoopGroup();
        CHANNEL_CLASS = NioSocketChannel.class;
        MONITOR = StreamSlowMonitor.create((Configuration)UTIL.getConfiguration(), (String)"testMonitor");
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (EVENT_LOOP_GROUP != null) {
            EVENT_LOOP_GROUP.shutdownGracefully().get();
        }
        TestLeaseRenewal.shutdownMiniDFSCluster();
    }

    private FanOutOneBlockAsyncDFSOutput create(String file) throws IllegalArgumentException, IOException {
        EventLoop eventLoop = EVENT_LOOP_GROUP.next();
        return FanOutOneBlockAsyncDFSOutputHelper.createOutput((DistributedFileSystem)FS, (Path)new Path("/test_lease_renew"), (boolean)true, (boolean)false, (short)3, (long)FS.getDefaultBlockSize(), (EventLoopGroup)eventLoop, CHANNEL_CLASS, (StreamSlowMonitor)MONITOR, (boolean)true);
    }

    @Test
    public void testLeaseRenew() throws IOException {
        DFSClient client = FS.getClient();
        Assert.assertFalse((boolean)client.renewLease());
        FanOutOneBlockAsyncDFSOutput out = this.create("/test_lease_renew");
        Assert.assertTrue((boolean)client.renewLease());
        client.closeAllFilesBeingWritten(false);
        Assert.assertTrue((boolean)out.isClosed());
        Assert.assertFalse((boolean)client.renewLease());
        out = this.create("/test_lease_renew");
        Assert.assertTrue((boolean)client.renewLease());
        client.closeAllFilesBeingWritten(true);
        Assert.assertTrue((boolean)out.isClosed());
    }

    private Optional<Method> getUniqKeyMethod() {
        try {
            return Optional.of(DFSOutputStream.class.getMethod("getUniqKey", new Class[0]));
        }
        catch (NoSuchMethodException e) {
            return Optional.empty();
        }
    }

    @Test
    public void testEnsureMethodsCalledWhenLeaseRenewal() throws Exception {
        try (MockedConstruction mocked = Mockito.mockConstruction(DummyDFSOutputStream.class);
             FanOutOneBlockAsyncDFSOutput out = this.create("/methods_for_lease_renewal");){
            DummyDFSOutputStream dummy = (DummyDFSOutputStream)mocked.constructed().get(0);
            Assert.assertTrue((boolean)FS.getClient().renewLease());
            Optional<Method> getUniqKeyMethod = this.getUniqKeyMethod();
            if (getUniqKeyMethod.isPresent()) {
                getUniqKeyMethod.get().invoke(Mockito.verify((Object)dummy), new Object[0]);
                Method getNamespaceMethod = DFSOutputStream.class.getMethod("getNamespace", new Class[0]);
                getNamespaceMethod.invoke(Mockito.verify((Object)dummy), new Object[0]);
            } else {
                ((DummyDFSOutputStream)Mockito.verify((Object)dummy)).getFileId();
            }
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{dummy});
        }
    }

    private void verifyGetUniqKey(DummyDFSOutputStream dummy) throws Exception {
        Optional<Method> getUniqKeyMethod = this.getUniqKeyMethod();
        if (getUniqKeyMethod.isPresent()) {
            getUniqKeyMethod.get().invoke(Mockito.verify((Object)dummy), new Object[0]);
        } else {
            ((DummyDFSOutputStream)Mockito.verify((Object)dummy)).getFileId();
        }
    }

    @Test
    public void testEnsureMethodsCalledWhenClosing() throws Exception {
        try (MockedConstruction mocked = Mockito.mockConstruction(DummyDFSOutputStream.class);
             FanOutOneBlockAsyncDFSOutput out = this.create("/methods_for_closing");){
            DummyDFSOutputStream dummy = (DummyDFSOutputStream)mocked.constructed().get(0);
            this.verifyGetUniqKey(dummy);
            FS.getClient().closeAllFilesBeingWritten(false);
            ((DummyDFSOutputStream)Mockito.verify((Object)dummy)).close();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{dummy});
        }
    }

    @Test
    public void testEnsureMethodsCalledWhenAborting() throws Exception {
        try (MockedConstruction mocked = Mockito.mockConstruction(DummyDFSOutputStream.class);
             FanOutOneBlockAsyncDFSOutput out = this.create("/methods_for_aborting");){
            DummyDFSOutputStream dummy = (DummyDFSOutputStream)mocked.constructed().get(0);
            this.verifyGetUniqKey(dummy);
            FS.getClient().closeAllFilesBeingWritten(true);
            ((DummyDFSOutputStream)Mockito.verify((Object)dummy)).abort();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{dummy});
        }
    }
}

