/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassFinder {
    private static final Logger LOG = LoggerFactory.getLogger(ClassFinder.class);
    private static String CLASS_EXT = ".class";
    private ResourcePathFilter resourcePathFilter;
    private FileNameFilter fileNameFilter;
    private ClassFilter classFilter;
    private FileFilter fileFilter;
    private ClassLoader classLoader;

    public ClassFinder(ClassLoader classLoader) {
        this(null, null, null, classLoader);
    }

    public ClassFinder(ResourcePathFilter resourcePathFilter, FileNameFilter fileNameFilter, ClassFilter classFilter) {
        this(resourcePathFilter, fileNameFilter, classFilter, ClassLoader.getSystemClassLoader());
    }

    public ClassFinder(ResourcePathFilter resourcePathFilter, FileNameFilter fileNameFilter, ClassFilter classFilter, ClassLoader classLoader) {
        this.resourcePathFilter = resourcePathFilter;
        this.classFilter = classFilter;
        this.fileNameFilter = fileNameFilter;
        this.fileFilter = new FileFilterWithName(fileNameFilter);
        this.classLoader = classLoader;
    }

    public Set<Class<?>> findClasses(boolean proceedOnExceptions) throws ClassNotFoundException, IOException, LinkageError {
        return this.findClasses(this.getClass().getPackage().getName(), proceedOnExceptions);
    }

    public Set<Class<?>> findClasses(String packageName, boolean proceedOnExceptions) throws ClassNotFoundException, IOException, LinkageError {
        String path = packageName.replace('.', '/');
        Pattern jarResourceRe = Pattern.compile("^file:(.+\\.jar)!/" + path + "$");
        Enumeration<URL> resources = this.classLoader.getResources(path);
        ArrayList<File> dirs = new ArrayList<File>();
        ArrayList<String> jars = new ArrayList<String>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            String resourcePath = resource.getFile();
            Matcher matcher = jarResourceRe.matcher(resourcePath);
            boolean isJar = matcher.find();
            String string = resourcePath = isJar ? matcher.group(1) : resourcePath;
            if (null != this.resourcePathFilter && !this.resourcePathFilter.isCandidatePath(resourcePath, isJar)) continue;
            LOG.debug("Looking in " + resourcePath + "; isJar=" + isJar);
            if (isJar) {
                jars.add(resourcePath);
                continue;
            }
            dirs.add(new File(resourcePath));
        }
        HashSet classes = new HashSet();
        for (File directory : dirs) {
            classes.addAll(this.findClassesFromFiles(directory, packageName, proceedOnExceptions));
        }
        for (String jarFileName : jars) {
            classes.addAll(this.findClassesFromJar(jarFileName, packageName, proceedOnExceptions));
        }
        return classes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Class<?>> findClassesFromJar(String jarFileName, String packageName, boolean proceedOnExceptions) throws IOException, ClassNotFoundException, LinkageError {
        JarInputStream jarFile;
        try {
            jarFile = new JarInputStream(new FileInputStream(jarFileName));
        }
        catch (IOException ioEx) {
            LOG.warn("Failed to look for classes in " + jarFileName + ": " + ioEx);
            throw ioEx;
        }
        HashSet classes = new HashSet();
        try {
            while (true) {
                Class<?> c;
                String fileName;
                JarEntry entry;
                try {
                    entry = jarFile.getNextJarEntry();
                }
                catch (IOException ioEx) {
                    if (!proceedOnExceptions) {
                        throw ioEx;
                    }
                    LOG.warn("Failed to get next entry from " + jarFileName + ": " + ioEx);
                    break;
                }
                if (entry == null) break;
                String className = entry.getName();
                if (!className.endsWith(CLASS_EXT)) continue;
                int ix = className.lastIndexOf(47);
                String string = fileName = ix >= 0 ? className.substring(ix + 1) : className;
                if (null != this.fileNameFilter && !this.fileNameFilter.isCandidateFile(fileName, className) || !(className = className.substring(0, className.length() - CLASS_EXT.length()).replace('/', '.')).startsWith(packageName) || (c = this.makeClass(className, proceedOnExceptions)) == null || classes.add(c)) continue;
                LOG.warn("Ignoring duplicate class " + className);
            }
            HashSet hashSet = classes;
            return hashSet;
        }
        finally {
            jarFile.close();
        }
    }

    private Set<Class<?>> findClassesFromFiles(File baseDirectory, String packageName, boolean proceedOnExceptions) throws ClassNotFoundException, LinkageError {
        HashSet classes = new HashSet();
        if (!baseDirectory.exists()) {
            LOG.warn(baseDirectory.getAbsolutePath() + " does not exist");
            return classes;
        }
        File[] files = baseDirectory.listFiles(this.fileFilter);
        if (files == null) {
            LOG.warn("Failed to get files from " + baseDirectory.getAbsolutePath());
            return classes;
        }
        for (File file : files) {
            String fileName = file.getName();
            if (file.isDirectory()) {
                classes.addAll(this.findClassesFromFiles(file, packageName + "." + fileName, proceedOnExceptions));
                continue;
            }
            String className = packageName + '.' + fileName.substring(0, fileName.length() - CLASS_EXT.length());
            Class<?> c = this.makeClass(className, proceedOnExceptions);
            if (c == null || classes.add(c)) continue;
            LOG.warn("Ignoring duplicate class " + className);
        }
        return classes;
    }

    private Class<?> makeClass(String className, boolean proceedOnExceptions) throws ClassNotFoundException, LinkageError {
        try {
            Class<?> c = Class.forName(className, false, this.classLoader);
            boolean isCandidateClass = null == this.classFilter || this.classFilter.isCandidateClass(c);
            return isCandidateClass ? c : null;
        }
        catch (ClassNotFoundException | LinkageError exception) {
            if (!proceedOnExceptions) {
                throw exception;
            }
            LOG.debug("Failed to instantiate or check " + className + ": " + exception);
            return null;
        }
    }

    private static class FileFilterWithName
    implements FileFilter {
        private FileNameFilter nameFilter;

        public FileFilterWithName(FileNameFilter nameFilter) {
            this.nameFilter = nameFilter;
        }

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().endsWith(CLASS_EXT) && (null == this.nameFilter || this.nameFilter.isCandidateFile(file.getName(), file.getAbsolutePath()));
        }
    }

    public static class And
    implements ClassFilter,
    ResourcePathFilter {
        ClassFilter[] classFilters;
        ResourcePathFilter[] resourcePathFilters;

        public And(ClassFilter ... classFilters) {
            this.classFilters = classFilters;
        }

        public And(ResourcePathFilter ... resourcePathFilters) {
            this.resourcePathFilters = resourcePathFilters;
        }

        @Override
        public boolean isCandidateClass(Class<?> c) {
            for (ClassFilter filter : this.classFilters) {
                if (filter.isCandidateClass(c)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isCandidatePath(String resourcePath, boolean isJar) {
            for (ResourcePathFilter filter : this.resourcePathFilters) {
                if (filter.isCandidatePath(resourcePath, isJar)) continue;
                return false;
            }
            return true;
        }
    }

    public static class Not
    implements ResourcePathFilter,
    FileNameFilter,
    ClassFilter {
        private ResourcePathFilter resourcePathFilter;
        private FileNameFilter fileNameFilter;
        private ClassFilter classFilter;

        public Not(ResourcePathFilter resourcePathFilter) {
            this.resourcePathFilter = resourcePathFilter;
        }

        public Not(FileNameFilter fileNameFilter) {
            this.fileNameFilter = fileNameFilter;
        }

        public Not(ClassFilter classFilter) {
            this.classFilter = classFilter;
        }

        @Override
        public boolean isCandidatePath(String resourcePath, boolean isJar) {
            return !this.resourcePathFilter.isCandidatePath(resourcePath, isJar);
        }

        @Override
        public boolean isCandidateFile(String fileName, String absFilePath) {
            return !this.fileNameFilter.isCandidateFile(fileName, absFilePath);
        }

        @Override
        public boolean isCandidateClass(Class<?> c) {
            return !this.classFilter.isCandidateClass(c);
        }
    }

    public static interface ClassFilter {
        public boolean isCandidateClass(Class<?> var1);
    }

    public static interface FileNameFilter {
        public boolean isCandidateFile(String var1, String var2);
    }

    public static interface ResourcePathFilter {
        public boolean isCandidatePath(String var1, boolean var2);
    }
}

