/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.hbase.JUnitResourceCheckers;
import org.apache.hadoop.hbase.ResourceChecker;
import org.apache.hadoop.hbase.TestSecurityManager;
import org.apache.hadoop.hbase.TimedOutTestsListener;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterables;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.yetus.audience.InterfaceAudience;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class HBaseJupiterExtension
implements InvocationInterceptor,
BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseJupiterExtension.class);
    private static final SecurityManager securityManager = new TestSecurityManager();
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{HBaseJupiterExtension.class});
    private static final Map<String, Duration> TAG_TO_TIMEOUT = ImmutableMap.of((Object)"org.apache.hadoop.hbase.testclassification.SmallTests", (Object)Duration.ofMinutes(3L), (Object)"org.apache.hadoop.hbase.testclassification.MediumTests", (Object)Duration.ofMinutes(6L), (Object)"org.apache.hadoop.hbase.testclassification.LargeTests", (Object)Duration.ofMinutes(13L), (Object)"org.apache.hadoop.hbase.testclassification.IntegrationTests", (Object)Duration.ZERO);
    private static final String EXECUTOR = "executor";
    private static final String DEADLINE = "deadline";
    private static final String RESOURCE_CHECK = "rc";

    private Duration pickTimeout(ExtensionContext ctx) {
        Set<String> timeoutTags = TAG_TO_TIMEOUT.keySet();
        Sets.SetView timeoutTag = Sets.intersection(timeoutTags, (Set)ctx.getTags());
        if (timeoutTag.isEmpty()) {
            Assertions.fail((String)("Test class " + ctx.getDisplayName() + " does not have any of the following scale tags " + timeoutTags));
        }
        if (timeoutTag.size() > 1) {
            Assertions.fail((String)("Test class " + ctx.getDisplayName() + " has multiple scale tags " + timeoutTag));
        }
        return TAG_TO_TIMEOUT.get(Iterables.getOnlyElement((Iterable)timeoutTag));
    }

    public void beforeAll(ExtensionContext ctx) throws Exception {
        System.setSecurityManager(securityManager);
        Duration timeout = this.pickTimeout(ctx);
        if (timeout.isZero() || timeout.isNegative()) {
            LOG.info("No timeout for {}", (Object)ctx.getDisplayName());
            return;
        }
        Instant deadline = Instant.now().plus(timeout);
        LOG.info("Timeout for {} is {}, it should be finished before {}", new Object[]{ctx.getDisplayName(), timeout, deadline});
        ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("HBase-Test-" + ctx.getDisplayName() + "-Main-Thread").build());
        ExtensionContext.Store store = ctx.getStore(NAMESPACE);
        store.put((Object)EXECUTOR, (Object)executor);
        store.put((Object)DEADLINE, (Object)deadline);
    }

    public void afterAll(ExtensionContext ctx) throws Exception {
        ExtensionContext.Store store = ctx.getStore(NAMESPACE);
        ExecutorService executor = (ExecutorService)store.remove((Object)EXECUTOR, ExecutorService.class);
        if (executor != null) {
            executor.shutdownNow();
        }
        store.remove((Object)DEADLINE);
        System.setSecurityManager(null);
    }

    private <T> T runWithTimeout(InvocationInterceptor.Invocation<T> invocation, ExtensionContext ctx, String name) throws Throwable {
        ExtensionContext.Store store = ctx.getStore(NAMESPACE);
        ExecutorService executor = (ExecutorService)store.get((Object)EXECUTOR, ExecutorService.class);
        if (executor == null) {
            return (T)invocation.proceed();
        }
        Instant deadline = (Instant)store.get((Object)DEADLINE, Instant.class);
        Instant now = Instant.now();
        if (!now.isBefore(deadline)) {
            Assertions.fail((String)("Test " + name + " timed out, deadline is " + deadline));
            return null;
        }
        Duration remaining = Duration.between(now, deadline);
        LOG.info("remaining timeout for {} is {}", (Object)name, (Object)remaining);
        Future<Object> future = executor.submit(() -> {
            try {
                return invocation.proceed();
            }
            catch (Throwable t) {
                throw ExceptionUtils.throwAsUncheckedException((Throwable)t);
            }
        });
        try {
            return (T)future.get(remaining.toNanos(), TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            Assertions.fail((String)("Test " + name + " interrupted"));
            return null;
        }
        catch (ExecutionException e) {
            throw ExceptionUtils.throwAsUncheckedException((Throwable)e.getCause());
        }
        catch (TimeoutException e) {
            this.printThreadDump();
            throw new JUnitException("Test " + name + " timed out, deadline is " + deadline, (Throwable)e);
        }
    }

    private void printThreadDump() {
        LOG.info("====> TEST TIMED OUT. PRINTING THREAD DUMP. <====");
        LOG.info(TimedOutTestsListener.buildThreadDiagnosticString());
    }

    public void interceptBeforeAllMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.runWithTimeout(invocation, extensionContext, extensionContext.getDisplayName() + ".beforeAll");
    }

    public void interceptBeforeEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.runWithTimeout(invocation, extensionContext, extensionContext.getDisplayName() + ".beforeEach");
    }

    public void interceptTestMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.runWithTimeout(invocation, extensionContext, extensionContext.getDisplayName());
    }

    public void interceptAfterEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.runWithTimeout(invocation, extensionContext, extensionContext.getDisplayName() + ".afterEach");
    }

    public void interceptAfterAllMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.runWithTimeout(invocation, extensionContext, extensionContext.getDisplayName() + ".afterAll");
    }

    public <T> T interceptTestClassConstructor(InvocationInterceptor.Invocation<T> invocation, ReflectiveInvocationContext<Constructor<T>> invocationContext, ExtensionContext extensionContext) throws Throwable {
        return this.runWithTimeout(invocation, extensionContext, extensionContext.getDisplayName() + ".constructor");
    }

    public void beforeEach(ExtensionContext ctx) throws Exception {
        ResourceChecker rc = new ResourceChecker(ctx.getDisplayName());
        JUnitResourceCheckers.addResourceAnalyzer(rc);
        ExtensionContext.Store store = ctx.getStore(NAMESPACE);
        store.put((Object)RESOURCE_CHECK, (Object)rc);
        rc.start();
    }

    public void afterEach(ExtensionContext ctx) throws Exception {
        ExtensionContext.Store store = ctx.getStore(NAMESPACE);
        ResourceChecker rc = (ResourceChecker)store.remove((Object)RESOURCE_CHECK, ResourceChecker.class);
        if (rc != null) {
            rc.end();
        }
    }
}

