/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.ResourceChecker;
import org.apache.hadoop.hbase.util.JVM;

public final class JUnitResourceCheckers {
    private JUnitResourceCheckers() {
    }

    public static void addResourceAnalyzer(ResourceChecker rc) {
        rc.addResourceAnalyzer(new ThreadResourceAnalyzer());
        rc.addResourceAnalyzer(new OpenFileDescriptorResourceAnalyzer());
        rc.addResourceAnalyzer(new MaxFileDescriptorResourceAnalyzer());
        rc.addResourceAnalyzer(new SystemLoadAverageResourceAnalyzer());
        rc.addResourceAnalyzer(new ProcessCountResourceAnalyzer());
        rc.addResourceAnalyzer(new AvailableMemoryMBResourceAnalyzer());
    }

    private static class AvailableMemoryMBResourceAnalyzer
    extends ResourceChecker.ResourceAnalyzer {
        private AvailableMemoryMBResourceAnalyzer() {
        }

        @Override
        public int getVal(ResourceChecker.Phase phase) {
            if (!JVM.isUnix()) {
                return 0;
            }
            return (int)(new JVM().getFreeMemory() / 0x100000L);
        }
    }

    private static class ProcessCountResourceAnalyzer
    extends ResourceChecker.ResourceAnalyzer {
        private ProcessCountResourceAnalyzer() {
        }

        @Override
        public int getVal(ResourceChecker.Phase phase) {
            if (!JVM.isUnix()) {
                return 0;
            }
            return new JVM().getNumberOfRunningProcess();
        }
    }

    private static class SystemLoadAverageResourceAnalyzer
    extends ResourceChecker.ResourceAnalyzer {
        private SystemLoadAverageResourceAnalyzer() {
        }

        @Override
        public int getVal(ResourceChecker.Phase phase) {
            if (!JVM.isUnix()) {
                return 0;
            }
            return (int)(new JVM().getSystemLoadAverage() * 100.0);
        }
    }

    private static class MaxFileDescriptorResourceAnalyzer
    extends ResourceChecker.ResourceAnalyzer {
        private MaxFileDescriptorResourceAnalyzer() {
        }

        @Override
        public int getVal(ResourceChecker.Phase phase) {
            if (!JVM.isUnix()) {
                return 0;
            }
            JVM jvm = new JVM();
            return (int)jvm.getMaxFileDescriptorCount();
        }
    }

    private static class OpenFileDescriptorResourceAnalyzer
    extends ResourceChecker.ResourceAnalyzer {
        private OpenFileDescriptorResourceAnalyzer() {
        }

        @Override
        public int getVal(ResourceChecker.Phase phase) {
            if (!JVM.isUnix()) {
                return 0;
            }
            JVM jvm = new JVM();
            return (int)jvm.getOpenFileDescriptorCount();
        }

        @Override
        public int getMax() {
            return 1024;
        }
    }

    private static class ThreadResourceAnalyzer
    extends ResourceChecker.ResourceAnalyzer {
        private Set<String> initialThreadNames = new HashSet<String>();
        private List<String> stringsToLog = null;

        private ThreadResourceAnalyzer() {
        }

        @Override
        public int getVal(ResourceChecker.Phase phase) {
            Map<Thread, StackTraceElement[]> stackTraces;
            block4: {
                block3: {
                    stackTraces = Thread.getAllStackTraces();
                    if (phase != ResourceChecker.Phase.INITIAL) break block3;
                    this.stringsToLog = null;
                    for (Thread t : stackTraces.keySet()) {
                        this.initialThreadNames.add(t.getName());
                    }
                    break block4;
                }
                if (phase != ResourceChecker.Phase.END || stackTraces.size() <= this.initialThreadNames.size()) break block4;
                this.stringsToLog = new ArrayList<String>();
                for (Thread t : stackTraces.keySet()) {
                    StackTraceElement[] stackElements;
                    if (this.initialThreadNames.contains(t.getName())) continue;
                    this.stringsToLog.add("\nPotentially hanging thread: " + t.getName() + "\n");
                    for (StackTraceElement ele : stackElements = stackTraces.get(t)) {
                        this.stringsToLog.add("\t" + ele + "\n");
                    }
                }
            }
            return stackTraces.size();
        }

        @Override
        public int getMax() {
            return 500;
        }

        @Override
        public List<String> getStringsToLog() {
            return this.stringsToLog;
        }
    }
}

