/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.client.BlockReportOptions;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeStatus;
import org.apache.hadoop.hdfs.protocol.UnregisteredNodeException;
import org.apache.hadoop.hdfs.protocolPB.DatanodeLifelineProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdfs.server.common.DataNodeLockManager;
import org.apache.hadoop.hdfs.server.common.IncorrectVersionException;
import org.apache.hadoop.hdfs.server.datanode.BPOfferService;
import org.apache.hadoop.hdfs.server.datanode.BPServiceActorAction;
import org.apache.hadoop.hdfs.server.datanode.BPServiceActorActionException;
import org.apache.hadoop.hdfs.server.datanode.DNConf;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeFaultInjector;
import org.apache.hadoop.hdfs.server.datanode.IncrementalBlockReportManager;
import org.apache.hadoop.hdfs.server.protocol.BlockReportContext;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.DisallowedDatanodeException;
import org.apache.hadoop.hdfs.server.protocol.HeartbeatResponse;
import org.apache.hadoop.hdfs.server.protocol.InvalidBlockReportLeaseException;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.SlowDiskReports;
import org.apache.hadoop.hdfs.server.protocol.SlowPeerReports;
import org.apache.hadoop.hdfs.server.protocol.StorageBlockReport;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.hdfs.server.protocol.VolumeFailureSummary;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.thirdparty.com.google.common.base.Joiner;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.VersionInfo;
import org.apache.hadoop.util.VersionUtil;
import org.slf4j.Logger;

@InterfaceAudience.Private
class BPServiceActor
implements Runnable {
    static final Logger LOG = DataNode.LOG;
    final InetSocketAddress nnAddr;
    HAServiceProtocol.HAServiceState state;
    final BPOfferService bpos;
    volatile long lastCacheReport = 0L;
    private final Scheduler scheduler;
    Thread bpThread;
    DatanodeProtocolClientSideTranslatorPB bpNamenode;
    private String serviceId = null;
    private String nnId = null;
    private volatile RunningState runningState = RunningState.CONNECTING;
    private volatile boolean shouldServiceRun = true;
    private volatile boolean isSlownode = false;
    private final DataNode dn;
    private final DNConf dnConf;
    private long prevBlockReportId;
    private long fullBlockReportLeaseId;
    private final SortedSet<Integer> blockReportSizes = Collections.synchronizedSortedSet(new TreeSet());
    private final int maxDataLength;
    private final IncrementalBlockReportManager ibrManager;
    private DatanodeRegistration bpRegistration;
    final LinkedList<BPServiceActorAction> bpThreadQueue = new LinkedList();
    private final CommandProcessingThread commandProcessingThread;
    private final CountDownLatch initialRegistrationComplete;
    private final LifelineSender lifelineSender;

    BPServiceActor(String serviceId, String nnId, InetSocketAddress nnAddr, InetSocketAddress lifelineNnAddr, BPOfferService bpos) {
        this.bpos = bpos;
        this.dn = bpos.getDataNode();
        this.nnAddr = nnAddr;
        this.lifelineSender = lifelineNnAddr != null ? new LifelineSender(lifelineNnAddr) : null;
        this.initialRegistrationComplete = lifelineNnAddr != null ? new CountDownLatch(1) : null;
        this.dnConf = this.dn.getDnConf();
        this.ibrManager = new IncrementalBlockReportManager(this.dnConf.ibrInterval, this.dn.getMetrics());
        this.prevBlockReportId = ThreadLocalRandom.current().nextLong();
        this.fullBlockReportLeaseId = 0L;
        this.scheduler = new Scheduler(this.dnConf.heartBeatInterval, this.dnConf.getLifelineIntervalMs(), this.dnConf.blockReportInterval, this.dnConf.outliersReportIntervalMs);
        this.maxDataLength = this.dnConf.getMaxDataLength();
        if (serviceId != null) {
            this.serviceId = serviceId;
        }
        if (nnId != null) {
            this.nnId = nnId;
        }
        this.commandProcessingThread = new CommandProcessingThread(this);
        this.commandProcessingThread.start();
    }

    public DatanodeRegistration getBpRegistration() {
        return this.bpRegistration;
    }

    IncrementalBlockReportManager getIbrManager() {
        return this.ibrManager;
    }

    boolean isAlive() {
        if (!this.shouldServiceRun || !this.bpThread.isAlive()) {
            return false;
        }
        return this.runningState == RunningState.RUNNING || this.runningState == RunningState.CONNECTING;
    }

    String getRunningState() {
        return this.runningState.toString();
    }

    public String toString() {
        return this.bpos.toString() + " service to " + this.nnAddr;
    }

    InetSocketAddress getNNSocketAddress() {
        return this.nnAddr;
    }

    private String getNameNodeAddress() {
        return NetUtils.getHostPortString((InetSocketAddress)this.getNNSocketAddress());
    }

    Map<String, String> getActorInfoMap() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("NamenodeAddress", this.getNameNodeAddress());
        info.put("NamenodeHaState", this.state != null ? this.state.toString() : "Unknown");
        info.put("BlockPoolID", this.bpos.getBlockPoolId());
        info.put("ActorState", this.getRunningState());
        info.put("LastHeartbeat", String.valueOf(this.getScheduler().getLastHearbeatTime()));
        info.put("LastHeartbeatResponseTime", String.valueOf(this.getScheduler().getLastHeartbeatResponseTime()));
        info.put("LastBlockReport", String.valueOf(this.getScheduler().getLastBlockReportTime()));
        info.put("maxBlockReportSize", String.valueOf(this.getMaxBlockReportSize()));
        info.put("maxDataLength", String.valueOf(this.maxDataLength));
        info.put("isSlownode", String.valueOf(this.isSlownode));
        return info;
    }

    @VisibleForTesting
    void setNameNode(DatanodeProtocolClientSideTranslatorPB dnProtocol) {
        this.bpNamenode = dnProtocol;
    }

    @VisibleForTesting
    String getNnId() {
        return this.nnId;
    }

    @VisibleForTesting
    DatanodeProtocolClientSideTranslatorPB getNameNodeProxy() {
        return this.bpNamenode;
    }

    @VisibleForTesting
    void setLifelineNameNode(DatanodeLifelineProtocolClientSideTranslatorPB dnLifelineProtocol) {
        this.lifelineSender.lifelineNamenode = dnLifelineProtocol;
    }

    @VisibleForTesting
    DatanodeLifelineProtocolClientSideTranslatorPB getLifelineNameNodeProxy() {
        return this.lifelineSender.lifelineNamenode;
    }

    @VisibleForTesting
    NamespaceInfo retrieveNamespaceInfo() throws IOException {
        NamespaceInfo nsInfo = null;
        while (this.shouldRun()) {
            try {
                nsInfo = this.bpNamenode.versionRequest();
                LOG.debug(this + " received versionRequest response: " + nsInfo);
                break;
            }
            catch (SocketTimeoutException e) {
                LOG.warn("Problem connecting to server: " + this.nnAddr);
            }
            catch (IOException e) {
                LOG.warn("Problem connecting to server: " + this.nnAddr);
            }
            this.sleepAndLogInterrupts(5000, "requesting version info from NN");
        }
        if (nsInfo == null) {
            throw new IOException("DN shut down before block pool connected");
        }
        this.checkNNVersion(nsInfo);
        return nsInfo;
    }

    private void checkNNVersion(NamespaceInfo nsInfo) throws IncorrectVersionException {
        String minimumNameNodeVersion;
        String nnVersion = nsInfo.getSoftwareVersion();
        if (VersionUtil.compareVersions((String)nnVersion, (String)(minimumNameNodeVersion = this.dnConf.getMinimumNameNodeVersion())) < 0) {
            IncorrectVersionException ive = new IncorrectVersionException(minimumNameNodeVersion, nnVersion, "NameNode", "DataNode");
            LOG.warn(ive.getMessage());
            throw ive;
        }
        String dnVersion = VersionInfo.getVersion();
        if (!nnVersion.equals(dnVersion)) {
            LOG.info("Reported NameNode version '" + nnVersion + "' does not match DataNode version '" + dnVersion + "' but is within acceptable limits. Note: This is normal during a rolling upgrade.");
        }
    }

    private void connectToNNAndHandshake() throws IOException {
        this.bpNamenode = this.dn.connectToNN(this.nnAddr);
        NamespaceInfo nsInfo = this.retrieveNamespaceInfo();
        this.dn.getDataSetLockManager().addLock(DataNodeLockManager.LockLevel.BLOCK_POOl, nsInfo.getBlockPoolID());
        this.bpos.verifyAndSetNamespaceInfo(this, nsInfo);
        this.bpThread.setName(this.formatThreadName("heartbeating", this.nnAddr));
        this.register(nsInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void triggerBlockReportForTests() {
        IncrementalBlockReportManager incrementalBlockReportManager = this.ibrManager;
        synchronized (incrementalBlockReportManager) {
            this.scheduler.scheduleHeartbeat();
            long oldBlockReportTime = this.scheduler.getNextBlockReportTime();
            this.scheduler.forceFullBlockReportNow();
            this.ibrManager.notifyAll();
            while (oldBlockReportTime == this.scheduler.getNextBlockReportTime()) {
                try {
                    this.ibrManager.wait(100L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void triggerHeartbeatForTests() {
        IncrementalBlockReportManager incrementalBlockReportManager = this.ibrManager;
        synchronized (incrementalBlockReportManager) {
            long nextHeartbeatTime = this.scheduler.scheduleHeartbeat();
            this.ibrManager.notifyAll();
            while (nextHeartbeatTime - this.scheduler.nextHeartbeatTime >= 0L) {
                try {
                    this.ibrManager.wait(100L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }

    private int getMaxBlockReportSize() {
        int maxBlockReportSize = 0;
        if (!this.blockReportSizes.isEmpty()) {
            maxBlockReportSize = this.blockReportSizes.last();
        }
        return maxBlockReportSize;
    }

    private long generateUniqueBlockReportId() {
        ++this.prevBlockReportId;
        while (this.prevBlockReportId == 0L) {
            this.prevBlockReportId = ThreadLocalRandom.current().nextLong();
        }
        return this.prevBlockReportId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<DatanodeCommand> blockReport(long fullBrLeaseId) throws IOException {
        ArrayList<DatanodeCommand> cmds = new ArrayList<DatanodeCommand>();
        this.ibrManager.sendIBRs(this.bpNamenode, this.bpRegistration, this.bpos.getBlockPoolId(), this.getRpcMetricSuffix());
        long brCreateStartTime = Time.monotonicNow();
        Map<DatanodeStorage, BlockListAsLongs> perVolumeBlockLists = this.dn.getFSDataset().getBlockReports(this.bpos.getBlockPoolId());
        int i = 0;
        int totalBlockCount = 0;
        StorageBlockReport[] reports = new StorageBlockReport[perVolumeBlockLists.size()];
        for (Map.Entry<DatanodeStorage, BlockListAsLongs> kvPair : perVolumeBlockLists.entrySet()) {
            BlockListAsLongs blockList = kvPair.getValue();
            reports[i++] = new StorageBlockReport(kvPair.getKey(), blockList);
            totalBlockCount += blockList.getNumberOfBlocks();
        }
        int numReportsSent = 0;
        int numRPCs = 0;
        boolean success = false;
        long brSendStartTime = Time.monotonicNow();
        long reportId = this.generateUniqueBlockReportId();
        boolean useBlocksBuffer = this.bpRegistration.getNamespaceInfo().isCapabilitySupported(NamespaceInfo.Capability.STORAGE_BLOCK_REPORT_BUFFERS);
        this.blockReportSizes.clear();
        try {
            if ((long)totalBlockCount < this.dnConf.blockReportSplitThreshold) {
                DatanodeCommand cmd = this.bpNamenode.blockReport(this.bpRegistration, this.bpos.getBlockPoolId(), reports, new BlockReportContext(1, 0, reportId, fullBrLeaseId));
                this.blockReportSizes.add(this.calculateBlockReportPBSize(useBlocksBuffer, reports));
                numRPCs = 1;
                numReportsSent = reports.length;
                if (cmd != null) {
                    cmds.add(cmd);
                }
            } else {
                for (int r = 0; r < reports.length; ++r) {
                    StorageBlockReport[] singleReport = new StorageBlockReport[]{reports[r]};
                    DatanodeCommand cmd = this.bpNamenode.blockReport(this.bpRegistration, this.bpos.getBlockPoolId(), singleReport, new BlockReportContext(reports.length, r, reportId, fullBrLeaseId));
                    this.blockReportSizes.add(this.calculateBlockReportPBSize(useBlocksBuffer, singleReport));
                    ++numReportsSent;
                    ++numRPCs;
                    if (cmd == null) continue;
                    cmds.add(cmd);
                }
            }
            success = true;
        }
        catch (Throwable throwable) {
            long brSendCost = Time.monotonicNow() - brSendStartTime;
            long brCreateCost = brSendStartTime - brCreateStartTime;
            this.dn.getMetrics().addBlockReport(brSendCost, this.getRpcMetricSuffix());
            int nCmds = cmds.size();
            LOG.info((success ? "S" : "Uns") + "uccessfully sent block report 0x" + Long.toHexString(reportId) + " with lease ID 0x" + Long.toHexString(fullBrLeaseId) + " to namenode: " + this.nnAddr + ",  containing " + reports.length + " storage report(s), of which we sent " + numReportsSent + ". The reports had " + totalBlockCount + " total blocks and used " + numRPCs + " RPC(s). This took " + brCreateCost + " msecs to generate and " + brSendCost + " msecs for RPC and NN processing. Got back " + (nCmds == 0 ? "no commands" : (nCmds == 1 ? "one command: " + cmds.get(0) : nCmds + " commands: " + Joiner.on((String)"; ").join(cmds))) + ".");
            throw throwable;
        }
        long brSendCost = Time.monotonicNow() - brSendStartTime;
        long brCreateCost = brSendStartTime - brCreateStartTime;
        this.dn.getMetrics().addBlockReport(brSendCost, this.getRpcMetricSuffix());
        int nCmds = cmds.size();
        LOG.info((success ? "S" : "Uns") + "uccessfully sent block report 0x" + Long.toHexString(reportId) + " with lease ID 0x" + Long.toHexString(fullBrLeaseId) + " to namenode: " + this.nnAddr + ",  containing " + reports.length + " storage report(s), of which we sent " + numReportsSent + ". The reports had " + totalBlockCount + " total blocks and used " + numRPCs + " RPC(s). This took " + brCreateCost + " msecs to generate and " + brSendCost + " msecs for RPC and NN processing. Got back " + (nCmds == 0 ? "no commands" : (nCmds == 1 ? "one command: " + cmds.get(0) : nCmds + " commands: " + Joiner.on((String)"; ").join(cmds))) + ".");
        this.scheduler.updateLastBlockReportTime(Time.monotonicNow());
        this.scheduler.scheduleNextBlockReport();
        return cmds.size() == 0 ? null : cmds;
    }

    private String getRpcMetricSuffix() {
        if (this.serviceId == null && this.nnId == null) {
            return null;
        }
        if (this.serviceId == null && this.nnId != null) {
            return this.nnId;
        }
        if (this.serviceId != null && this.nnId == null) {
            return this.serviceId;
        }
        return this.serviceId + "-" + this.nnId;
    }

    DatanodeCommand cacheReport() throws IOException {
        if (this.dn.getFSDataset().getCacheCapacity() == 0L) {
            return null;
        }
        DatanodeCommand cmd = null;
        long startTime = Time.monotonicNow();
        if (startTime - this.lastCacheReport > this.dnConf.cacheReportInterval) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sending cacheReport from service actor: " + this);
            }
            this.lastCacheReport = startTime;
            String bpid = this.bpos.getBlockPoolId();
            List<Long> blockIds = this.dn.getFSDataset().getCacheReport(bpid);
            long createTime = Time.monotonicNow();
            cmd = this.bpNamenode.cacheReport(this.bpRegistration, bpid, blockIds);
            long sendTime = Time.monotonicNow();
            long createCost = createTime - startTime;
            long sendCost = sendTime - createTime;
            this.dn.getMetrics().addCacheReport(sendCost);
            if (LOG.isDebugEnabled()) {
                LOG.debug("CacheReport of " + blockIds.size() + " block(s) took " + createCost + " msecs to generate and " + sendCost + " msecs for RPC and NN processing");
            }
        }
        return cmd;
    }

    private int calculateBlockReportPBSize(boolean useBlocksBuffer, StorageBlockReport[] reports) {
        int reportSize = 0;
        for (StorageBlockReport r : reports) {
            if (useBlocksBuffer) {
                reportSize += r.getBlocks().getBlocksBuffer().size();
                continue;
            }
            reportSize += 10 * r.getBlocks().getBlockListAsLongs().length;
        }
        return reportSize;
    }

    HeartbeatResponse sendHeartBeat(boolean requestBlockReportLease) throws IOException {
        this.scheduler.scheduleNextHeartbeat();
        StorageReport[] reports = this.dn.getFSDataset().getStorageReports(this.bpos.getBlockPoolId());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending heartbeat with " + reports.length + " storage reports from service actor: " + this);
        }
        long now = Time.monotonicNow();
        this.scheduler.updateLastHeartbeatTime(now);
        VolumeFailureSummary volumeFailureSummary = this.dn.getFSDataset().getVolumeFailureSummary();
        int numFailedVolumes = volumeFailureSummary != null ? volumeFailureSummary.getFailedStorageLocations().length : 0;
        boolean outliersReportDue = this.scheduler.isOutliersReportDue(now);
        SlowPeerReports slowPeers = outliersReportDue && this.dnConf.peerStatsEnabled && this.dn.getPeerMetrics() != null ? SlowPeerReports.create(this.dn.getPeerMetrics().getOutliers()) : SlowPeerReports.EMPTY_REPORT;
        SlowDiskReports slowDisks = outliersReportDue && this.dnConf.diskStatsEnabled && this.dn.getDiskMetrics() != null ? SlowDiskReports.create(this.dn.getDiskMetrics().getDiskOutliersStats()) : SlowDiskReports.EMPTY_REPORT;
        HeartbeatResponse response = this.bpNamenode.sendHeartbeat(this.bpRegistration, reports, this.dn.getFSDataset().getCacheCapacity(), this.dn.getFSDataset().getCacheUsed(), this.dn.getXmitsInProgress(), this.dn.getActiveTransferThreadCount(), numFailedVolumes, volumeFailureSummary, requestBlockReportLease, slowPeers, slowDisks);
        this.scheduler.updateLastHeartbeatResponseTime(Time.monotonicNow());
        if (outliersReportDue) {
            this.scheduler.scheduleNextOutlierReport();
        }
        return response;
    }

    @VisibleForTesting
    void sendLifelineForTests() throws IOException {
        this.lifelineSender.sendLifeline();
    }

    void start() {
        if (this.bpThread != null && this.bpThread.isAlive()) {
            return;
        }
        this.bpThread = new Thread(this);
        this.bpThread.setDaemon(true);
        if (this.lifelineSender != null) {
            this.lifelineSender.start();
        }
        this.bpThread.start();
    }

    private String formatThreadName(String action, InetSocketAddress addr) {
        String bpId = this.bpos.getBlockPoolId(true);
        String prefix = bpId != null ? bpId : this.bpos.getNameserviceId();
        return prefix + " " + action + " to " + addr;
    }

    void stop() {
        this.shouldServiceRun = false;
        if (this.lifelineSender != null) {
            this.lifelineSender.stop();
        }
        if (this.bpThread != null) {
            this.bpThread.interrupt();
        }
        if (this.commandProcessingThread != null) {
            this.commandProcessingThread.interrupt();
        }
    }

    void join() {
        try {
            if (this.lifelineSender != null) {
                this.lifelineSender.join();
            }
            if (this.bpThread != null) {
                this.bpThread.join();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private synchronized void cleanUp() {
        this.shouldServiceRun = false;
        IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{this.bpNamenode});
        IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{this.lifelineSender});
        this.bpos.shutdownActor(this);
    }

    private void handleRollingUpgradeStatus(HeartbeatResponse resp) throws IOException {
        RollingUpgradeStatus rollingUpgradeStatus = resp.getRollingUpdateStatus();
        if (rollingUpgradeStatus != null && rollingUpgradeStatus.getBlockPoolId().compareTo(this.bpos.getBlockPoolId()) != 0) {
            LOG.error("Invalid BlockPoolId " + rollingUpgradeStatus.getBlockPoolId() + " in HeartbeatResponse. Expected " + this.bpos.getBlockPoolId());
        } else {
            this.bpos.signalRollingUpgrade(rollingUpgradeStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void offerService() throws Exception {
        LOG.info("For namenode " + this.nnAddr + " using BLOCKREPORT_INTERVAL of " + this.dnConf.blockReportInterval + "msecs CACHEREPORT_INTERVAL of " + this.dnConf.cacheReportInterval + "msecs Initial delay: " + this.dnConf.initialBlockReportDelayMs + "msecs; heartBeatInterval=" + this.dnConf.heartBeatInterval + (this.lifelineSender != null ? "; lifelineIntervalMs=" + this.dnConf.getLifelineIntervalMs() : ""));
        while (this.shouldRun()) {
            try {
                DataNodeFaultInjector.get().startOfferService();
                long startTime = this.scheduler.monotonicNow();
                boolean sendHeartbeat = this.scheduler.isHeartbeatDue(startTime);
                LOG.debug("BP offer service run start time: {}, sendHeartbeat: {}", (Object)startTime, (Object)sendHeartbeat);
                HeartbeatResponse resp = null;
                if (sendHeartbeat) {
                    boolean requestBlockReportLease;
                    boolean bl = requestBlockReportLease = this.fullBlockReportLeaseId == 0L && this.scheduler.isBlockReportDue(startTime);
                    if (!this.dn.areHeartbeatsDisabledForTests()) {
                        LOG.debug("Before sending heartbeat to namenode {}, the state of the namenode known to datanode so far is {}", (Object)this.getNameNodeAddress(), (Object)this.state);
                        resp = this.sendHeartBeat(requestBlockReportLease);
                        assert (resp != null);
                        if (resp.getFullBlockReportLeaseId() != 0L) {
                            if (this.fullBlockReportLeaseId != 0L) {
                                LOG.warn(this.nnAddr + " sent back a full block report lease ID of 0x" + Long.toHexString(resp.getFullBlockReportLeaseId()) + ", but we already have a lease ID of 0x" + Long.toHexString(this.fullBlockReportLeaseId) + ". Overwriting old lease ID.");
                            }
                            this.fullBlockReportLeaseId = resp.getFullBlockReportLeaseId();
                        }
                        this.dn.getMetrics().addHeartbeat(this.scheduler.monotonicNow() - startTime, this.getRpcMetricSuffix());
                        this.bpos.updateActorStatesFromHeartbeat(this, resp.getNameNodeHaState());
                        HAServiceProtocol.HAServiceState stateFromResp = resp.getNameNodeHaState().getState();
                        if (this.state != stateFromResp) {
                            LOG.info("After receiving heartbeat response, updating state of namenode {} to {}", (Object)this.getNameNodeAddress(), (Object)stateFromResp);
                        }
                        this.state = stateFromResp;
                        if (this.state == HAServiceProtocol.HAServiceState.ACTIVE) {
                            this.handleRollingUpgradeStatus(resp);
                        }
                        this.commandProcessingThread.enqueue(resp.getCommands());
                        this.isSlownode = resp.getIsSlownode();
                    }
                }
                if (!this.dn.areIBRDisabledForTests() && (this.ibrManager.sendImmediately() || sendHeartbeat)) {
                    this.ibrManager.sendIBRs(this.bpNamenode, this.bpRegistration, this.bpos.getBlockPoolId(), this.getRpcMetricSuffix());
                }
                List<DatanodeCommand> cmds = null;
                boolean forceFullBr = this.scheduler.forceFullBlockReport.getAndSet(false);
                if (forceFullBr) {
                    LOG.info("Forcing a full block report to " + this.nnAddr);
                }
                if (this.fullBlockReportLeaseId != 0L || forceFullBr) {
                    cmds = this.blockReport(this.fullBlockReportLeaseId);
                    this.fullBlockReportLeaseId = 0L;
                }
                this.commandProcessingThread.enqueue(cmds);
                if (!this.dn.areCacheReportsDisabledForTests()) {
                    DatanodeCommand cmd = this.cacheReport();
                    this.commandProcessingThread.enqueue(cmd);
                }
                if (sendHeartbeat) {
                    this.dn.getMetrics().addHeartbeatTotal(this.scheduler.monotonicNow() - startTime, this.getRpcMetricSuffix());
                }
                this.ibrManager.waitTillNextIBR(this.scheduler.getHeartbeatWaitTime());
            }
            catch (RemoteException re) {
                String reClass = re.getClassName();
                if (UnregisteredNodeException.class.getName().equals(reClass) || DisallowedDatanodeException.class.getName().equals(reClass) || IncorrectVersionException.class.getName().equals(reClass)) {
                    LOG.warn(this + " is shutting down", (Throwable)re);
                    this.shouldServiceRun = false;
                    return;
                }
                if (InvalidBlockReportLeaseException.class.getName().equals(reClass)) {
                    this.fullBlockReportLeaseId = 0L;
                }
                LOG.warn("RemoteException in offerService", (Throwable)re);
                this.sleepAfterException();
            }
            catch (IOException e) {
                LOG.warn("IOException in offerService", (Throwable)e);
                this.sleepAfterException();
            }
            finally {
                DataNodeFaultInjector.get().endOfferService();
            }
            this.processQueueMessages();
        }
    }

    private void sleepAfterException() {
        try {
            long sleepTime = Math.min(1000L, this.dnConf.heartBeatInterval);
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException ie) {
            LOG.info("BPServiceActor {} is interrupted", (Object)this);
            Thread.currentThread().interrupt();
        }
    }

    void register(NamespaceInfo nsInfo) throws IOException {
        DatanodeRegistration newBpRegistration = this.bpos.createRegistration();
        LOG.info("{} beginning handshake with NN: {}.", (Object)this, (Object)this.nnAddr);
        while (this.shouldRun()) {
            try {
                newBpRegistration = this.bpNamenode.registerDatanode(newBpRegistration);
                newBpRegistration.setNamespaceInfo(nsInfo);
                this.bpRegistration = newBpRegistration;
                break;
            }
            catch (EOFException e) {
                LOG.info("Problem connecting to server: {} : {}.", (Object)this.nnAddr, (Object)e.getLocalizedMessage());
            }
            catch (SocketTimeoutException e) {
                LOG.info("Problem connecting to server: {}.", (Object)this.nnAddr);
            }
            catch (RemoteException e) {
                LOG.warn("RemoteException in register to server: {}.", (Object)this.nnAddr, (Object)e);
                throw e;
            }
            catch (IOException e) {
                LOG.warn("Problem connecting to server: {}.", (Object)this.nnAddr);
            }
            this.sleepAndLogInterrupts(1000, "connecting to server");
        }
        if (this.bpRegistration == null) {
            throw new IOException("DN shut down before block pool registered");
        }
        LOG.info("{} successfully registered with NN: {}.", (Object)this, (Object)this.nnAddr);
        this.bpos.registrationSucceeded(this, this.bpRegistration);
        this.fullBlockReportLeaseId = 0L;
        this.scheduler.scheduleBlockReport(this.dnConf.initialBlockReportDelayMs, true);
    }

    private void sleepAndLogInterrupts(int millis, String stateString) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ie) {
            LOG.info("BPOfferService " + this + " interrupted while " + stateString);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        LOG.info(this + " starting to offer service");
        try {
            while (true) {
                try {
                    this.connectToNNAndHandshake();
                }
                catch (IOException ioe) {
                    this.runningState = RunningState.INIT_FAILED;
                    if (!this.shouldRetryInit()) {
                        this.runningState = RunningState.FAILED;
                        LOG.error("Initialization failed for " + this + ". Exiting. ", (Throwable)ioe);
                        LOG.warn("Ending block pool service for: " + this);
                        this.cleanUp();
                        return;
                    }
                    LOG.error("Initialization failed for " + this + " " + ioe.getLocalizedMessage());
                    this.sleepAndLogInterrupts(5000, "initializing");
                    continue;
                }
                break;
            }
            this.runningState = RunningState.RUNNING;
            if (this.initialRegistrationComplete != null) {
                this.initialRegistrationComplete.countDown();
            }
        }
        catch (Throwable ex) {
            LOG.warn("Unexpected exception in block pool " + this, ex);
            this.runningState = RunningState.FAILED;
            return;
        }
        finally {
            LOG.warn("Ending block pool service for: " + this);
            this.cleanUp();
        }
        while (true) {
            if (!this.shouldRun()) {
                this.runningState = RunningState.EXITED;
                return;
            }
            try {
                this.offerService();
            }
            catch (Exception ex) {
                LOG.error("Exception in BPOfferService for " + this, (Throwable)ex);
                this.sleepAndLogInterrupts(5000, "offering service");
                continue;
            }
            break;
        }
    }

    private boolean shouldRetryInit() {
        return this.shouldRun() && this.bpos.shouldRetryInit();
    }

    private boolean shouldRun() {
        return this.shouldServiceRun && this.dn.shouldRun();
    }

    void reportRemoteBadBlock(DatanodeInfo dnInfo, ExtendedBlock block) throws IOException {
        LocatedBlock lb = new LocatedBlock(block, new DatanodeInfo[]{dnInfo});
        this.bpNamenode.reportBadBlocks(new LocatedBlock[]{lb});
    }

    void reRegister() throws IOException {
        if (this.shouldRun()) {
            NamespaceInfo nsInfo = this.retrieveNamespaceInfo();
            if (this.state == HAServiceProtocol.HAServiceState.STANDBY || this.state == HAServiceProtocol.HAServiceState.OBSERVER) {
                this.ibrManager.clearIBRs();
            }
            this.register(nsInfo);
            this.scheduler.scheduleHeartbeat();
            DataNodeFaultInjector.get().blockUtilSendFullBlockReport();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void triggerBlockReport(BlockReportOptions options) {
        if (options.isIncremental()) {
            LOG.info(this.bpos.toString() + ": scheduling an incremental block report to namenode: " + this.nnAddr + ".");
            this.ibrManager.triggerIBR(true);
        } else {
            LOG.info(this.bpos.toString() + ": scheduling a full block report to namenode: " + this.nnAddr + ".");
            IncrementalBlockReportManager incrementalBlockReportManager = this.ibrManager;
            synchronized (incrementalBlockReportManager) {
                this.scheduler.forceFullBlockReportNow();
                this.ibrManager.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bpThreadEnqueue(BPServiceActorAction action) {
        LinkedList<BPServiceActorAction> linkedList = this.bpThreadQueue;
        synchronized (linkedList) {
            if (!this.bpThreadQueue.contains(action)) {
                this.bpThreadQueue.add(action);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processQueueMessages() {
        LinkedList<BPServiceActorAction> duplicateQueue;
        LinkedList<BPServiceActorAction> linkedList = this.bpThreadQueue;
        synchronized (linkedList) {
            duplicateQueue = new LinkedList<BPServiceActorAction>(this.bpThreadQueue);
            this.bpThreadQueue.clear();
        }
        while (!duplicateQueue.isEmpty()) {
            BPServiceActorAction actionItem = duplicateQueue.remove();
            try {
                LOG.debug("BPServiceActor ( {} ) processing queued messages. Action item: {}", (Object)this, (Object)actionItem);
                actionItem.reportTo(this.bpNamenode, this.bpRegistration);
            }
            catch (BPServiceActorActionException baae) {
                LOG.warn(baae.getMessage() + this.nnAddr, (Throwable)baae);
                this.bpThreadEnqueue(actionItem);
            }
        }
    }

    Scheduler getScheduler() {
        return this.scheduler;
    }

    @VisibleForTesting
    void stopCommandProcessingThread() {
        if (this.commandProcessingThread != null) {
            this.commandProcessingThread.interrupt();
        }
    }

    boolean isSlownode() {
        return this.isSlownode;
    }

    class CommandProcessingThread
    extends Thread {
        private final BPServiceActor actor;
        private final BlockingQueue<Runnable> queue;

        CommandProcessingThread(BPServiceActor actor) {
            super("Command processor");
            this.actor = actor;
            this.queue = new LinkedBlockingQueue<Runnable>();
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                this.processQueue();
            }
            catch (Throwable t) {
                LOG.error("{} encountered fatal exception and exit.", (Object)this.getName(), (Object)t);
                BPServiceActor.this.runningState = RunningState.FAILED;
            }
            finally {
                LOG.warn("Ending command processor service for: " + this);
                BPServiceActor.this.shouldServiceRun = false;
            }
        }

        private void processQueue() {
            while (BPServiceActor.this.shouldRun()) {
                try {
                    Runnable action = this.queue.take();
                    action.run();
                    BPServiceActor.this.dn.getMetrics().incrActorCmdQueueLength(-1);
                    BPServiceActor.this.dn.getMetrics().incrNumProcessedCommands();
                }
                catch (InterruptedException e) {
                    LOG.error("{} encountered interrupt and exit.", (Object)this.getName());
                    Thread.currentThread().interrupt();
                    if (!Thread.interrupted()) continue;
                    break;
                }
            }
            BPServiceActor.this.dn.getMetrics().incrActorCmdQueueLength(-1 * this.queue.size());
            this.queue.clear();
        }

        private boolean processCommand(DatanodeCommand[] cmds) {
            if (cmds != null) {
                long startProcessCommands = Time.monotonicNow();
                for (DatanodeCommand cmd : cmds) {
                    try {
                        if (BPServiceActor.this.bpos.processCommandFromActor(cmd, this.actor)) continue;
                        return false;
                    }
                    catch (RemoteException re) {
                        String reClass = re.getClassName();
                        if (!UnregisteredNodeException.class.getName().equals(reClass) && !DisallowedDatanodeException.class.getName().equals(reClass) && !IncorrectVersionException.class.getName().equals(reClass)) continue;
                        LOG.warn("{} is shutting down", (Object)this, (Object)re);
                        BPServiceActor.this.shouldServiceRun = false;
                        return false;
                    }
                    catch (IOException ioe) {
                        LOG.warn("Error processing datanode Command", (Throwable)ioe);
                    }
                }
                long processCommandsMs = Time.monotonicNow() - startProcessCommands;
                if (cmds.length > 0) {
                    BPServiceActor.this.dn.getMetrics().addNumProcessedCommands(processCommandsMs);
                }
                if (processCommandsMs > BPServiceActor.this.dnConf.getProcessCommandsThresholdMs()) {
                    LOG.warn("Took {} ms to process {} commands from NN", (Object)processCommandsMs, (Object)cmds.length);
                }
            }
            return true;
        }

        void enqueue(DatanodeCommand cmd) throws InterruptedException {
            if (cmd == null) {
                return;
            }
            this.queue.put(() -> this.processCommand(new DatanodeCommand[]{cmd}));
            BPServiceActor.this.dn.getMetrics().incrActorCmdQueueLength(1);
        }

        void enqueue(List<DatanodeCommand> cmds) throws InterruptedException {
            if (cmds == null) {
                return;
            }
            this.queue.put(() -> this.processCommand(cmds.toArray(new DatanodeCommand[cmds.size()])));
            BPServiceActor.this.dn.getMetrics().incrActorCmdQueueLength(1);
        }

        void enqueue(DatanodeCommand[] cmds) throws InterruptedException {
            this.queue.put(() -> this.processCommand(cmds));
            BPServiceActor.this.dn.getMetrics().incrActorCmdQueueLength(1);
        }
    }

    static class Scheduler {
        private final AtomicLong nextBlockReportTime = new AtomicLong(this.monotonicNow());
        @VisibleForTesting
        volatile long nextHeartbeatTime = this.monotonicNow();
        @VisibleForTesting
        volatile long nextLifelineTime;
        @VisibleForTesting
        volatile long lastBlockReportTime = this.monotonicNow();
        @VisibleForTesting
        volatile long lastHeartbeatTime = this.monotonicNow();
        @VisibleForTesting
        private volatile long lastHeartbeatResponseTime = -1L;
        @VisibleForTesting
        boolean resetBlockReportTime = true;
        @VisibleForTesting
        volatile long nextOutliersReportTime = this.monotonicNow();
        private final AtomicBoolean forceFullBlockReport = new AtomicBoolean(false);
        private final long heartbeatIntervalMs;
        private final long lifelineIntervalMs;
        private volatile long blockReportIntervalMs;
        private volatile long outliersReportIntervalMs;

        Scheduler(long heartbeatIntervalMs, long lifelineIntervalMs, long blockReportIntervalMs, long outliersReportIntervalMs) {
            this.heartbeatIntervalMs = heartbeatIntervalMs;
            this.lifelineIntervalMs = lifelineIntervalMs;
            this.blockReportIntervalMs = blockReportIntervalMs;
            this.outliersReportIntervalMs = outliersReportIntervalMs;
            this.scheduleNextLifeline(this.nextHeartbeatTime);
        }

        long scheduleHeartbeat() {
            this.nextHeartbeatTime = this.monotonicNow();
            this.scheduleNextLifeline(this.nextHeartbeatTime);
            return this.nextHeartbeatTime;
        }

        long scheduleNextHeartbeat() {
            this.nextHeartbeatTime = this.monotonicNow() + this.heartbeatIntervalMs;
            this.scheduleNextLifeline(this.nextHeartbeatTime);
            return this.nextHeartbeatTime;
        }

        void updateLastHeartbeatTime(long heartbeatTime) {
            this.lastHeartbeatTime = heartbeatTime;
        }

        void updateLastHeartbeatResponseTime(long heartbeatTime) {
            this.lastHeartbeatResponseTime = heartbeatTime;
        }

        void updateLastBlockReportTime(long blockReportTime) {
            this.lastBlockReportTime = blockReportTime;
        }

        void scheduleNextOutlierReport() {
            this.nextOutliersReportTime = this.monotonicNow() + this.outliersReportIntervalMs;
        }

        long getLastHearbeatTime() {
            return (this.monotonicNow() - this.lastHeartbeatTime) / 1000L;
        }

        private long getLastHeartbeatResponseTime() {
            return (this.monotonicNow() - this.lastHeartbeatResponseTime) / 1000L;
        }

        long getLastBlockReportTime() {
            return (this.monotonicNow() - this.lastBlockReportTime) / 1000L;
        }

        long scheduleNextLifeline(long baseTime) {
            this.nextLifelineTime = baseTime + this.lifelineIntervalMs;
            return this.nextLifelineTime;
        }

        boolean isHeartbeatDue(long startTime) {
            return this.nextHeartbeatTime - startTime <= 0L;
        }

        boolean isLifelineDue(long startTime) {
            return this.nextLifelineTime - startTime <= 0L;
        }

        boolean isBlockReportDue(long curTime) {
            return this.nextBlockReportTime.get() - curTime <= 0L;
        }

        boolean isOutliersReportDue(long curTime) {
            return this.nextOutliersReportTime - curTime <= 0L;
        }

        void forceFullBlockReportNow() {
            this.forceFullBlockReport.set(true);
            this.resetBlockReportTime = true;
        }

        long scheduleBlockReport(long delay, boolean isRegistration) {
            if (delay > 0L) {
                this.nextBlockReportTime.getAndSet(this.monotonicNow() + (long)ThreadLocalRandom.current().nextInt((int)delay));
            } else {
                this.nextBlockReportTime.getAndSet(this.monotonicNow());
            }
            this.resetBlockReportTime = isRegistration;
            return this.nextBlockReportTime.get();
        }

        void scheduleNextBlockReport() {
            if (this.resetBlockReportTime) {
                this.nextBlockReportTime.getAndSet(this.monotonicNow() + (long)ThreadLocalRandom.current().nextInt((int)this.blockReportIntervalMs));
                this.resetBlockReportTime = false;
            } else {
                long factor = (this.monotonicNow() - this.nextBlockReportTime.get() + this.blockReportIntervalMs) / this.blockReportIntervalMs;
                if (factor != 0L) {
                    this.nextBlockReportTime.getAndAdd(factor * this.blockReportIntervalMs);
                } else {
                    this.nextBlockReportTime.getAndAdd(this.blockReportIntervalMs);
                }
            }
        }

        long getHeartbeatWaitTime() {
            return this.nextHeartbeatTime - this.monotonicNow();
        }

        long getLifelineWaitTime() {
            long waitTime = this.nextLifelineTime - this.monotonicNow();
            return waitTime > 0L ? waitTime : 0L;
        }

        @VisibleForTesting
        long getNextBlockReportTime() {
            return this.nextBlockReportTime.get();
        }

        @VisibleForTesting
        void setNextBlockReportTime(long nextBlockReportTime) {
            this.nextBlockReportTime.getAndSet(nextBlockReportTime);
        }

        long getBlockReportIntervalMs() {
            return this.blockReportIntervalMs;
        }

        void setBlockReportIntervalMs(long intervalMs) {
            Preconditions.checkArgument((intervalMs > 0L ? 1 : 0) != 0, (Object)"dfs.blockreport.intervalMsec should be larger than 0");
            this.blockReportIntervalMs = intervalMs;
        }

        void setOutliersReportIntervalMs(long intervalMs) {
            Preconditions.checkArgument((intervalMs > 0L ? 1 : 0) != 0, (Object)"dfs.datanode.outliers.report.interval should be larger than 0");
            this.outliersReportIntervalMs = intervalMs;
        }

        @VisibleForTesting
        long getOutliersReportIntervalMs() {
            return this.outliersReportIntervalMs;
        }

        @VisibleForTesting
        public long monotonicNow() {
            return Time.monotonicNow();
        }
    }

    private final class LifelineSender
    implements Runnable,
    Closeable {
        private final InetSocketAddress lifelineNnAddr;
        private Thread lifelineThread;
        private DatanodeLifelineProtocolClientSideTranslatorPB lifelineNamenode;

        public LifelineSender(InetSocketAddress lifelineNnAddr) {
            this.lifelineNnAddr = lifelineNnAddr;
        }

        @Override
        public void close() {
            this.stop();
            try {
                this.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{this.lifelineNamenode});
        }

        @Override
        public void run() {
            while (BPServiceActor.this.shouldRun()) {
                try {
                    BPServiceActor.this.initialRegistrationComplete.await();
                    break;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            while (BPServiceActor.this.shouldRun()) {
                try {
                    if (this.lifelineNamenode == null) {
                        this.lifelineNamenode = BPServiceActor.this.dn.connectToLifelineNN(this.lifelineNnAddr);
                    }
                    this.sendLifelineIfDue();
                    Thread.sleep(BPServiceActor.this.scheduler.getLifelineWaitTime());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (IOException e) {
                    LOG.warn("IOException in LifelineSender for " + BPServiceActor.this, (Throwable)e);
                }
            }
            LOG.info("LifelineSender for " + BPServiceActor.this + " exiting.");
        }

        public void start() {
            this.lifelineThread = new Thread((Runnable)this, BPServiceActor.this.formatThreadName("lifeline", this.lifelineNnAddr));
            this.lifelineThread.setDaemon(true);
            this.lifelineThread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread thread, Throwable t) {
                    LOG.error(thread + " terminating on unexpected exception", t);
                }
            });
            this.lifelineThread.start();
        }

        public void stop() {
            if (this.lifelineThread != null) {
                this.lifelineThread.interrupt();
            }
        }

        public void join() throws InterruptedException {
            if (this.lifelineThread != null) {
                this.lifelineThread.join();
            }
        }

        private void sendLifelineIfDue() throws IOException {
            long startTime = BPServiceActor.this.scheduler.monotonicNow();
            if (!BPServiceActor.this.scheduler.isLifelineDue(startTime)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Skipping sending lifeline for " + BPServiceActor.this + ", because it is not due.");
                }
                return;
            }
            if (BPServiceActor.this.dn.areHeartbeatsDisabledForTests()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Skipping sending lifeline for " + BPServiceActor.this + ", because heartbeats are disabled for tests.");
                }
                return;
            }
            this.sendLifeline();
            BPServiceActor.this.dn.getMetrics().addLifeline(BPServiceActor.this.scheduler.monotonicNow() - startTime, BPServiceActor.this.getRpcMetricSuffix());
            BPServiceActor.this.scheduler.scheduleNextLifeline(BPServiceActor.this.scheduler.monotonicNow());
        }

        private void sendLifeline() throws IOException {
            VolumeFailureSummary volumeFailureSummary;
            StorageReport[] reports = BPServiceActor.this.dn.getFSDataset().getStorageReports(BPServiceActor.this.bpos.getBlockPoolId());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sending lifeline with " + reports.length + " storage  reports from service actor: " + BPServiceActor.this);
            }
            int numFailedVolumes = (volumeFailureSummary = BPServiceActor.this.dn.getFSDataset().getVolumeFailureSummary()) != null ? volumeFailureSummary.getFailedStorageLocations().length : 0;
            this.lifelineNamenode.sendLifeline(BPServiceActor.this.bpRegistration, reports, BPServiceActor.this.dn.getFSDataset().getCacheCapacity(), BPServiceActor.this.dn.getFSDataset().getCacheUsed(), BPServiceActor.this.dn.getXmitsInProgress(), BPServiceActor.this.dn.getXceiverCount(), numFailedVolumes, volumeFailureSummary);
        }
    }

    static enum RunningState {
        CONNECTING,
        INIT_FAILED,
        RUNNING,
        EXITED,
        FAILED;

    }
}

