/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.namequeues;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ipc.RpcCall;
import org.apache.hadoop.hbase.ipc.RpcCallback;
import org.apache.hadoop.hbase.namequeues.NamedQueuePayload;
import org.apache.hadoop.hbase.namequeues.NamedQueueRecorder;
import org.apache.hadoop.hbase.namequeues.RpcLogDetails;
import org.apache.hadoop.hbase.namequeues.request.NamedQueueGetRequest;
import org.apache.hadoop.hbase.namequeues.response.NamedQueueGetResponse;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.TooSlowLog;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.Uninterruptibles;
import org.apache.hbase.thirdparty.com.google.protobuf.BlockingService;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.hbase.thirdparty.com.google.protobuf.Descriptors;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestNamedQueueRecorder {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestNamedQueueRecorder.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestNamedQueueRecorder.class);
    private static final HBaseTestingUtility HBASE_TESTING_UTILITY = new HBaseTestingUtility();
    private NamedQueueRecorder namedQueueRecorder;
    private static int i = 0;

    private static Configuration applySlowLogRecorderConf(int eventSize) {
        Configuration conf = HBASE_TESTING_UTILITY.getConfiguration();
        conf.setBoolean("hbase.regionserver.slowlog.buffer.enabled", true);
        conf.setInt("hbase.regionserver.slowlog.ringbuffer.size", eventSize);
        return conf;
    }

    private boolean confirmPayloadParams(int i, int j, List<TooSlowLog.SlowLogPayload> slowLogPayloads) {
        boolean isClientExpected = slowLogPayloads.get(i).getClientAddress().equals("client_" + j);
        boolean isUserExpected = slowLogPayloads.get(i).getUserName().equals("userName_" + j);
        boolean isClassExpected = slowLogPayloads.get(i).getServerClass().equals("class_" + j);
        return isClassExpected && isClientExpected && isUserExpected;
    }

    @Test
    public void testOnlieSlowLogConsumption() throws Exception {
        RpcLogDetails rpcLogDetails;
        int i;
        Configuration conf = TestNamedQueueRecorder.applySlowLogRecorderConf(8);
        Constructor constructor = NamedQueueRecorder.class.getDeclaredConstructor(Configuration.class);
        constructor.setAccessible(true);
        this.namedQueueRecorder = (NamedQueueRecorder)constructor.newInstance(conf);
        AdminProtos.SlowLogResponseRequest request = AdminProtos.SlowLogResponseRequest.newBuilder().setLimit(15).build();
        this.namedQueueRecorder.clearNamedQueue(NamedQueuePayload.NamedQueueEvent.SLOW_LOG);
        Assert.assertEquals((long)this.getSlowLogPayloads(request).size(), (long)0L);
        LOG.debug("Initially ringbuffer of Slow Log records is empty");
        for (i = 0; i < 5; ++i) {
            RpcLogDetails rpcLogDetails2 = TestNamedQueueRecorder.getRpcLogDetails("userName_" + (i + 1), "client_" + (i + 1), "class_" + (i + 1));
            this.namedQueueRecorder.addRecord((NamedQueuePayload)rpcLogDetails2);
        }
        Assert.assertNotEquals((long)-1L, (long)HBASE_TESTING_UTILITY.waitFor(3000L, () -> this.getSlowLogPayloads(request).size() == 5));
        List<TooSlowLog.SlowLogPayload> slowLogPayloads = this.getSlowLogPayloads(request);
        Assert.assertTrue((boolean)this.confirmPayloadParams(0, 5, slowLogPayloads));
        Assert.assertTrue((boolean)this.confirmPayloadParams(1, 4, slowLogPayloads));
        Assert.assertTrue((boolean)this.confirmPayloadParams(2, 3, slowLogPayloads));
        Assert.assertTrue((boolean)this.confirmPayloadParams(3, 2, slowLogPayloads));
        Assert.assertTrue((boolean)this.confirmPayloadParams(4, 1, slowLogPayloads));
        while (i < 7) {
            rpcLogDetails = TestNamedQueueRecorder.getRpcLogDetails("userName_" + (i + 1), "client_" + (i + 1), "class_" + (i + 1));
            this.namedQueueRecorder.addRecord((NamedQueuePayload)rpcLogDetails);
            ++i;
        }
        Assert.assertNotEquals((long)-1L, (long)HBASE_TESTING_UTILITY.waitFor(3000L, () -> this.getSlowLogPayloads(request).size() == 7));
        Assert.assertNotEquals((long)-1L, (long)HBASE_TESTING_UTILITY.waitFor(3000L, () -> {
            List<TooSlowLog.SlowLogPayload> slowLogPayloadsList = this.getSlowLogPayloads(request);
            return slowLogPayloadsList.size() == 7 && this.confirmPayloadParams(0, 7, slowLogPayloadsList) && this.confirmPayloadParams(5, 2, slowLogPayloadsList) && this.confirmPayloadParams(6, 1, slowLogPayloadsList);
        }));
        while (i < 10) {
            rpcLogDetails = TestNamedQueueRecorder.getRpcLogDetails("userName_" + (i + 1), "client_" + (i + 1), "class_" + (i + 1));
            this.namedQueueRecorder.addRecord((NamedQueuePayload)rpcLogDetails);
            ++i;
        }
        Assert.assertNotEquals((long)-1L, (long)HBASE_TESTING_UTILITY.waitFor(3000L, () -> this.getSlowLogPayloads(request).size() == 8));
        Assert.assertNotEquals((long)-1L, (long)HBASE_TESTING_UTILITY.waitFor(3000L, () -> {
            List<TooSlowLog.SlowLogPayload> slowLogPayloadsList = this.getSlowLogPayloads(request);
            return slowLogPayloadsList.size() == 8 && this.confirmPayloadParams(7, 3, slowLogPayloadsList) && this.confirmPayloadParams(0, 10, slowLogPayloadsList) && this.confirmPayloadParams(1, 9, slowLogPayloadsList);
        }));
        while (i < 14) {
            rpcLogDetails = TestNamedQueueRecorder.getRpcLogDetails("userName_" + (i + 1), "client_" + (i + 1), "class_" + (i + 1));
            this.namedQueueRecorder.addRecord((NamedQueuePayload)rpcLogDetails);
            ++i;
        }
        Assert.assertNotEquals((long)-1L, (long)HBASE_TESTING_UTILITY.waitFor(3000L, () -> this.getSlowLogPayloads(request).size() == 8));
        Assert.assertNotEquals((long)-1L, (long)HBASE_TESTING_UTILITY.waitFor(3000L, () -> {
            List<TooSlowLog.SlowLogPayload> slowLogPayloadsList = this.getSlowLogPayloads(request);
            return slowLogPayloadsList.size() == 8 && this.confirmPayloadParams(0, 14, slowLogPayloadsList) && this.confirmPayloadParams(1, 13, slowLogPayloadsList) && this.confirmPayloadParams(2, 12, slowLogPayloadsList) && this.confirmPayloadParams(3, 11, slowLogPayloadsList);
        }));
        AdminProtos.SlowLogResponseRequest largeLogRequest = AdminProtos.SlowLogResponseRequest.newBuilder().setLimit(15).setLogType(AdminProtos.SlowLogResponseRequest.LogType.LARGE_LOG).build();
        Assert.assertNotEquals((long)-1L, (long)HBASE_TESTING_UTILITY.waitFor(3000L, () -> {
            List<TooSlowLog.SlowLogPayload> slowLogPayloadsList = this.getSlowLogPayloads(largeLogRequest);
            return slowLogPayloadsList.size() == 8 && this.confirmPayloadParams(0, 14, slowLogPayloadsList) && this.confirmPayloadParams(1, 13, slowLogPayloadsList) && this.confirmPayloadParams(2, 12, slowLogPayloadsList) && this.confirmPayloadParams(3, 11, slowLogPayloadsList);
        }));
        Assert.assertNotEquals((long)-1L, (long)HBASE_TESTING_UTILITY.waitFor(3000L, () -> {
            boolean isRingBufferCleaned = this.namedQueueRecorder.clearNamedQueue(NamedQueuePayload.NamedQueueEvent.SLOW_LOG);
            LOG.debug("cleared the ringbuffer of Online Slow Log records");
            List<TooSlowLog.SlowLogPayload> slowLogPayloadsList = this.getSlowLogPayloads(request);
            return slowLogPayloadsList.size() == 0 && isRingBufferCleaned;
        }));
    }

    private List<TooSlowLog.SlowLogPayload> getSlowLogPayloads(AdminProtos.SlowLogResponseRequest request) {
        NamedQueueGetRequest namedQueueGetRequest = new NamedQueueGetRequest();
        namedQueueGetRequest.setNamedQueueEvent(0);
        namedQueueGetRequest.setSlowLogResponseRequest(request);
        NamedQueueGetResponse namedQueueGetResponse = this.namedQueueRecorder.getNamedQueueRecords(namedQueueGetRequest);
        return namedQueueGetResponse == null ? Collections.emptyList() : namedQueueGetResponse.getSlowLogPayloads();
    }

    @Test
    public void testOnlineSlowLogWithHighRecords() throws Exception {
        Configuration conf = TestNamedQueueRecorder.applySlowLogRecorderConf(14);
        Constructor constructor = NamedQueueRecorder.class.getDeclaredConstructor(Configuration.class);
        constructor.setAccessible(true);
        this.namedQueueRecorder = (NamedQueueRecorder)constructor.newInstance(conf);
        AdminProtos.SlowLogResponseRequest request = AdminProtos.SlowLogResponseRequest.newBuilder().setLimit(154).build();
        Assert.assertEquals((long)this.getSlowLogPayloads(request).size(), (long)0L);
        LOG.debug("Initially ringbuffer of Slow Log records is empty");
        for (int i = 0; i < 154; ++i) {
            RpcLogDetails rpcLogDetails = TestNamedQueueRecorder.getRpcLogDetails("userName_" + (i + 1), "client_" + (i + 1), "class_" + (i + 1));
            this.namedQueueRecorder.addRecord((NamedQueuePayload)rpcLogDetails);
        }
        LOG.debug("Added 14 * 11 records, ringbuffer should only provide latest 14 records");
        Assert.assertNotEquals((long)-1L, (long)HBASE_TESTING_UTILITY.waitFor(3000L, () -> this.getSlowLogPayloads(request).size() == 14));
        Assert.assertNotEquals((long)-1L, (long)HBASE_TESTING_UTILITY.waitFor(3000L, () -> {
            List<TooSlowLog.SlowLogPayload> slowLogPayloads = this.getSlowLogPayloads(request);
            return slowLogPayloads.size() == 14 && this.confirmPayloadParams(0, 154, slowLogPayloads) && this.confirmPayloadParams(1, 153, slowLogPayloads) && this.confirmPayloadParams(2, 152, slowLogPayloads) && this.confirmPayloadParams(3, 151, slowLogPayloads) && this.confirmPayloadParams(4, 150, slowLogPayloads) && this.confirmPayloadParams(5, 149, slowLogPayloads) && this.confirmPayloadParams(6, 148, slowLogPayloads) && this.confirmPayloadParams(7, 147, slowLogPayloads) && this.confirmPayloadParams(8, 146, slowLogPayloads) && this.confirmPayloadParams(9, 145, slowLogPayloads) && this.confirmPayloadParams(10, 144, slowLogPayloads) && this.confirmPayloadParams(11, 143, slowLogPayloads) && this.confirmPayloadParams(12, 142, slowLogPayloads) && this.confirmPayloadParams(13, 141, slowLogPayloads);
        }));
        boolean isRingBufferCleaned = this.namedQueueRecorder.clearNamedQueue(NamedQueuePayload.NamedQueueEvent.SLOW_LOG);
        Assert.assertTrue((boolean)isRingBufferCleaned);
        LOG.debug("cleared the ringbuffer of Online Slow Log records");
        List<TooSlowLog.SlowLogPayload> slowLogPayloads = this.getSlowLogPayloads(request);
        Assert.assertEquals((long)slowLogPayloads.size(), (long)0L);
    }

    @Test
    public void testOnlineSlowLogWithDefaultDisableConfig() throws Exception {
        Configuration conf = HBASE_TESTING_UTILITY.getConfiguration();
        conf.unset("hbase.regionserver.slowlog.buffer.enabled");
        Constructor constructor = NamedQueueRecorder.class.getDeclaredConstructor(Configuration.class);
        constructor.setAccessible(true);
        this.namedQueueRecorder = (NamedQueueRecorder)constructor.newInstance(conf);
        AdminProtos.SlowLogResponseRequest request = AdminProtos.SlowLogResponseRequest.newBuilder().build();
        Assert.assertEquals((long)this.getSlowLogPayloads(request).size(), (long)0L);
        LOG.debug("Initially ringbuffer of Slow Log records is empty");
        for (int i = 0; i < 300; ++i) {
            RpcLogDetails rpcLogDetails = TestNamedQueueRecorder.getRpcLogDetails("userName_" + (i + 1), "client_" + (i + 1), "class_" + (i + 1));
            this.namedQueueRecorder.addRecord((NamedQueuePayload)rpcLogDetails);
        }
        Assert.assertNotEquals((long)-1L, (long)HBASE_TESTING_UTILITY.waitFor(3000L, () -> {
            List<TooSlowLog.SlowLogPayload> slowLogPayloads = this.getSlowLogPayloads(request);
            return slowLogPayloads.size() == 0;
        }));
    }

    @Test
    public void testOnlineSlowLogWithDisableConfig() throws Exception {
        Configuration conf = HBASE_TESTING_UTILITY.getConfiguration();
        conf.setBoolean("hbase.regionserver.slowlog.buffer.enabled", false);
        Constructor constructor = NamedQueueRecorder.class.getDeclaredConstructor(Configuration.class);
        constructor.setAccessible(true);
        this.namedQueueRecorder = (NamedQueueRecorder)constructor.newInstance(conf);
        AdminProtos.SlowLogResponseRequest request = AdminProtos.SlowLogResponseRequest.newBuilder().build();
        Assert.assertEquals((long)this.getSlowLogPayloads(request).size(), (long)0L);
        LOG.debug("Initially ringbuffer of Slow Log records is empty");
        for (int i = 0; i < 300; ++i) {
            RpcLogDetails rpcLogDetails = TestNamedQueueRecorder.getRpcLogDetails("userName_" + (i + 1), "client_" + (i + 1), "class_" + (i + 1));
            this.namedQueueRecorder.addRecord((NamedQueuePayload)rpcLogDetails);
        }
        Assert.assertNotEquals((long)-1L, (long)HBASE_TESTING_UTILITY.waitFor(3000L, () -> {
            List<TooSlowLog.SlowLogPayload> slowLogPayloads = this.getSlowLogPayloads(request);
            return slowLogPayloads.size() == 0;
        }));
        conf.setBoolean("hbase.regionserver.slowlog.buffer.enabled", true);
    }

    @Test
    public void testSlowLogFilters() throws Exception {
        Configuration conf = TestNamedQueueRecorder.applySlowLogRecorderConf(30);
        Constructor constructor = NamedQueueRecorder.class.getDeclaredConstructor(Configuration.class);
        constructor.setAccessible(true);
        this.namedQueueRecorder = (NamedQueueRecorder)constructor.newInstance(conf);
        AdminProtos.SlowLogResponseRequest request = AdminProtos.SlowLogResponseRequest.newBuilder().setLimit(15).setUserName("userName_87").build();
        Assert.assertEquals((long)this.getSlowLogPayloads(request).size(), (long)0L);
        LOG.debug("Initially ringbuffer of Slow Log records is empty");
        for (int i = 0; i < 100; ++i) {
            RpcLogDetails rpcLogDetails = TestNamedQueueRecorder.getRpcLogDetails("userName_" + (i + 1), "client_" + (i + 1), "class_" + (i + 1));
            this.namedQueueRecorder.addRecord((NamedQueuePayload)rpcLogDetails);
        }
        LOG.debug("Added 100 records, ringbuffer should only 1 record with matching filter");
        Assert.assertNotEquals((long)-1L, (long)HBASE_TESTING_UTILITY.waitFor(3000L, () -> this.getSlowLogPayloads(request).size() == 1));
        AdminProtos.SlowLogResponseRequest requestClient = AdminProtos.SlowLogResponseRequest.newBuilder().setLimit(15).setClientAddress("client_85").build();
        Assert.assertNotEquals((long)-1L, (long)HBASE_TESTING_UTILITY.waitFor(3000L, () -> this.getSlowLogPayloads(requestClient).size() == 1));
        AdminProtos.SlowLogResponseRequest requestSlowLog = AdminProtos.SlowLogResponseRequest.newBuilder().setLimit(15).build();
        Assert.assertNotEquals((long)-1L, (long)HBASE_TESTING_UTILITY.waitFor(3000L, () -> this.getSlowLogPayloads(requestSlowLog).size() == 15));
    }

    @Test
    public void testSlowLogFilterWithClientAddress() throws Exception {
        Configuration conf = TestNamedQueueRecorder.applySlowLogRecorderConf(10);
        Constructor constructor = NamedQueueRecorder.class.getDeclaredConstructor(Configuration.class);
        constructor.setAccessible(true);
        this.namedQueueRecorder = (NamedQueueRecorder)constructor.newInstance(conf);
        AdminProtos.SlowLogResponseRequest request = AdminProtos.SlowLogResponseRequest.newBuilder().build();
        Assert.assertEquals((long)this.getSlowLogPayloads(request).size(), (long)0L);
        String[] clientAddressArray = new String[]{"[127:1:1:1:1:1:1:1]:1", "[127:1:1:1:1:1:1:1]:2", "[127:1:1:1:1:1:1:1]:3", "127.0.0.1:1", "127.0.0.1:2"};
        for (int i = 0; i < 10; ++i) {
            boolean isLargeLog;
            boolean isSlowLog;
            if (i % 2 == 0) {
                isSlowLog = true;
                isLargeLog = false;
            } else {
                isSlowLog = false;
                isLargeLog = true;
            }
            RpcLogDetails rpcLogDetails = this.getRpcLogDetails("userName_" + (i + 1), clientAddressArray[i % 5], "class_" + (i + 1), isSlowLog, isLargeLog);
            this.namedQueueRecorder.addRecord((NamedQueuePayload)rpcLogDetails);
        }
        AdminProtos.SlowLogResponseRequest largeLogRequestIPv6WithPort = AdminProtos.SlowLogResponseRequest.newBuilder().setLogType(AdminProtos.SlowLogResponseRequest.LogType.LARGE_LOG).setClientAddress("[127:1:1:1:1:1:1:1]:2").build();
        Assert.assertNotEquals((long)-1L, (long)HBASE_TESTING_UTILITY.waitFor(3000L, () -> this.getSlowLogPayloads(largeLogRequestIPv6WithPort).size() == 1));
        AdminProtos.SlowLogResponseRequest largeLogRequestIPv6WithoutPort = AdminProtos.SlowLogResponseRequest.newBuilder().setLogType(AdminProtos.SlowLogResponseRequest.LogType.LARGE_LOG).setClientAddress("[127:1:1:1:1:1:1:1]").build();
        Assert.assertNotEquals((long)-1L, (long)HBASE_TESTING_UTILITY.waitFor(3000L, () -> this.getSlowLogPayloads(largeLogRequestIPv6WithoutPort).size() == 3));
        AdminProtos.SlowLogResponseRequest largeLogRequestIPv4WithPort = AdminProtos.SlowLogResponseRequest.newBuilder().setLogType(AdminProtos.SlowLogResponseRequest.LogType.LARGE_LOG).setClientAddress("127.0.0.1:1").build();
        Assert.assertNotEquals((long)-1L, (long)HBASE_TESTING_UTILITY.waitFor(3000L, () -> this.getSlowLogPayloads(largeLogRequestIPv4WithPort).size() == 1));
        AdminProtos.SlowLogResponseRequest largeLogRequestIPv4WithoutPort = AdminProtos.SlowLogResponseRequest.newBuilder().setLogType(AdminProtos.SlowLogResponseRequest.LogType.LARGE_LOG).setClientAddress("127.0.0.1").build();
        Assert.assertNotEquals((long)-1L, (long)HBASE_TESTING_UTILITY.waitFor(3000L, () -> this.getSlowLogPayloads(largeLogRequestIPv4WithoutPort).size() == 2));
    }

    @Test
    public void testConcurrentSlowLogEvents() throws Exception {
        Configuration conf = TestNamedQueueRecorder.applySlowLogRecorderConf(50000);
        Constructor constructor = NamedQueueRecorder.class.getDeclaredConstructor(Configuration.class);
        constructor.setAccessible(true);
        this.namedQueueRecorder = (NamedQueueRecorder)constructor.newInstance(conf);
        AdminProtos.SlowLogResponseRequest request = AdminProtos.SlowLogResponseRequest.newBuilder().setLimit(500000).build();
        AdminProtos.SlowLogResponseRequest largeLogRequest = AdminProtos.SlowLogResponseRequest.newBuilder().setLimit(500000).setLogType(AdminProtos.SlowLogResponseRequest.LogType.LARGE_LOG).build();
        Assert.assertEquals((long)this.getSlowLogPayloads(request).size(), (long)0L);
        LOG.debug("Initially ringbuffer of Slow Log records is empty");
        for (int j = 0; j < 1000; ++j) {
            CompletableFuture.runAsync(() -> {
                for (int i = 0; i < 3500; ++i) {
                    RpcLogDetails rpcLogDetails = TestNamedQueueRecorder.getRpcLogDetails("userName_" + (i + 1), "client_" + (i + 1), "class_" + (i + 1));
                    this.namedQueueRecorder.addRecord((NamedQueuePayload)rpcLogDetails);
                }
            });
        }
        Uninterruptibles.sleepUninterruptibly((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
        Assert.assertNotEquals((long)-1L, (long)HBASE_TESTING_UTILITY.waitFor(5000L, () -> this.getSlowLogPayloads(request).size() > 10000));
        Assert.assertNotEquals((long)-1L, (long)HBASE_TESTING_UTILITY.waitFor(5000L, () -> this.getSlowLogPayloads(largeLogRequest).size() > 10000));
    }

    @Test
    public void testSlowLargeLogEvents() throws Exception {
        Configuration conf = TestNamedQueueRecorder.applySlowLogRecorderConf(28);
        Constructor constructor = NamedQueueRecorder.class.getDeclaredConstructor(Configuration.class);
        constructor.setAccessible(true);
        this.namedQueueRecorder = (NamedQueueRecorder)constructor.newInstance(conf);
        AdminProtos.SlowLogResponseRequest request = AdminProtos.SlowLogResponseRequest.newBuilder().setLimit(154).build();
        Assert.assertEquals((long)this.getSlowLogPayloads(request).size(), (long)0L);
        LOG.debug("Initially ringbuffer of Slow Log records is empty");
        for (int i = 0; i < 154; ++i) {
            boolean isLargeLog;
            boolean isSlowLog;
            if (i % 2 == 0) {
                isSlowLog = true;
                isLargeLog = false;
            } else {
                isSlowLog = false;
                isLargeLog = true;
            }
            RpcLogDetails rpcLogDetails = this.getRpcLogDetails("userName_" + (i + 1), "client_" + (i + 1), "class_" + (i + 1), isSlowLog, isLargeLog);
            this.namedQueueRecorder.addRecord((NamedQueuePayload)rpcLogDetails);
        }
        LOG.debug("Added 14 * 11 records, ringbuffer should only provide latest 14 records");
        Assert.assertNotEquals((long)-1L, (long)HBASE_TESTING_UTILITY.waitFor(3000L, () -> this.getSlowLogPayloads(request).size() == 14));
        Assert.assertNotEquals((long)-1L, (long)HBASE_TESTING_UTILITY.waitFor(3000L, () -> {
            List<TooSlowLog.SlowLogPayload> slowLogPayloads = this.getSlowLogPayloads(request);
            return slowLogPayloads.size() == 14 && this.confirmPayloadParams(0, 153, slowLogPayloads) && this.confirmPayloadParams(1, 151, slowLogPayloads) && this.confirmPayloadParams(2, 149, slowLogPayloads) && this.confirmPayloadParams(3, 147, slowLogPayloads) && this.confirmPayloadParams(4, 145, slowLogPayloads) && this.confirmPayloadParams(5, 143, slowLogPayloads) && this.confirmPayloadParams(6, 141, slowLogPayloads) && this.confirmPayloadParams(7, 139, slowLogPayloads) && this.confirmPayloadParams(8, 137, slowLogPayloads) && this.confirmPayloadParams(9, 135, slowLogPayloads) && this.confirmPayloadParams(10, 133, slowLogPayloads) && this.confirmPayloadParams(11, 131, slowLogPayloads) && this.confirmPayloadParams(12, 129, slowLogPayloads) && this.confirmPayloadParams(13, 127, slowLogPayloads);
        }));
        AdminProtos.SlowLogResponseRequest largeLogRequest = AdminProtos.SlowLogResponseRequest.newBuilder().setLimit(154).setLogType(AdminProtos.SlowLogResponseRequest.LogType.LARGE_LOG).build();
        Assert.assertNotEquals((long)-1L, (long)HBASE_TESTING_UTILITY.waitFor(3000L, () -> this.getSlowLogPayloads(largeLogRequest).size() == 14));
        Assert.assertNotEquals((long)-1L, (long)HBASE_TESTING_UTILITY.waitFor(3000L, () -> {
            List<TooSlowLog.SlowLogPayload> largeLogPayloads = this.getSlowLogPayloads(largeLogRequest);
            return largeLogPayloads.size() == 14 && this.confirmPayloadParams(0, 154, largeLogPayloads) && this.confirmPayloadParams(1, 152, largeLogPayloads) && this.confirmPayloadParams(2, 150, largeLogPayloads) && this.confirmPayloadParams(3, 148, largeLogPayloads) && this.confirmPayloadParams(4, 146, largeLogPayloads) && this.confirmPayloadParams(5, 144, largeLogPayloads) && this.confirmPayloadParams(6, 142, largeLogPayloads) && this.confirmPayloadParams(7, 140, largeLogPayloads) && this.confirmPayloadParams(8, 138, largeLogPayloads) && this.confirmPayloadParams(9, 136, largeLogPayloads) && this.confirmPayloadParams(10, 134, largeLogPayloads) && this.confirmPayloadParams(11, 132, largeLogPayloads) && this.confirmPayloadParams(12, 130, largeLogPayloads) && this.confirmPayloadParams(13, 128, largeLogPayloads);
        }));
    }

    @Test
    public void testSlowLogMixedFilters() throws Exception {
        Configuration conf = TestNamedQueueRecorder.applySlowLogRecorderConf(30);
        Constructor constructor = NamedQueueRecorder.class.getDeclaredConstructor(Configuration.class);
        constructor.setAccessible(true);
        this.namedQueueRecorder = (NamedQueueRecorder)constructor.newInstance(conf);
        AdminProtos.SlowLogResponseRequest request = AdminProtos.SlowLogResponseRequest.newBuilder().setLimit(15).setUserName("userName_87").setClientAddress("client_88").build();
        Assert.assertEquals((long)this.getSlowLogPayloads(request).size(), (long)0L);
        for (int i = 0; i < 100; ++i) {
            RpcLogDetails rpcLogDetails = TestNamedQueueRecorder.getRpcLogDetails("userName_" + (i + 1), "client_" + (i + 1), "class_" + (i + 1));
            this.namedQueueRecorder.addRecord((NamedQueuePayload)rpcLogDetails);
        }
        Assert.assertNotEquals((long)-1L, (long)HBASE_TESTING_UTILITY.waitFor(3000L, () -> this.getSlowLogPayloads(request).size() == 2));
        AdminProtos.SlowLogResponseRequest request2 = AdminProtos.SlowLogResponseRequest.newBuilder().setLimit(15).setUserName("userName_1").setClientAddress("client_2").build();
        Assert.assertEquals((long)0L, (long)this.getSlowLogPayloads(request2).size());
        AdminProtos.SlowLogResponseRequest request3 = AdminProtos.SlowLogResponseRequest.newBuilder().setLimit(15).setUserName("userName_87").setClientAddress("client_88").setFilterByOperator(AdminProtos.SlowLogResponseRequest.FilterByOperator.AND).build();
        Assert.assertEquals((long)0L, (long)this.getSlowLogPayloads(request3).size());
        AdminProtos.SlowLogResponseRequest request4 = AdminProtos.SlowLogResponseRequest.newBuilder().setLimit(15).setUserName("userName_87").setClientAddress("client_87").setFilterByOperator(AdminProtos.SlowLogResponseRequest.FilterByOperator.AND).build();
        Assert.assertEquals((long)1L, (long)this.getSlowLogPayloads(request4).size());
        AdminProtos.SlowLogResponseRequest request5 = AdminProtos.SlowLogResponseRequest.newBuilder().setLimit(15).setUserName("userName_88").setClientAddress("client_89").setFilterByOperator(AdminProtos.SlowLogResponseRequest.FilterByOperator.OR).build();
        Assert.assertEquals((long)2L, (long)this.getSlowLogPayloads(request5).size());
        AdminProtos.SlowLogResponseRequest requestSlowLog = AdminProtos.SlowLogResponseRequest.newBuilder().setLimit(15).build();
        Assert.assertNotEquals((long)-1L, (long)HBASE_TESTING_UTILITY.waitFor(3000L, () -> this.getSlowLogPayloads(requestSlowLog).size() == 15));
    }

    static RpcLogDetails getRpcLogDetails(String userName, String clientAddress, String className) {
        RpcCall rpcCall = TestNamedQueueRecorder.getRpcCall(userName);
        return new RpcLogDetails(rpcCall, rpcCall.getParam(), clientAddress, 0L, className, true, true);
    }

    private RpcLogDetails getRpcLogDetails(String userName, String clientAddress, String className, boolean isSlowLog, boolean isLargeLog) {
        RpcCall rpcCall = TestNamedQueueRecorder.getRpcCall(userName);
        return new RpcLogDetails(rpcCall, rpcCall.getParam(), clientAddress, 0L, className, isSlowLog, isLargeLog);
    }

    private static RpcCall getRpcCall(final String userName) {
        RpcCall rpcCall = new RpcCall(){

            public BlockingService getService() {
                return null;
            }

            public Descriptors.MethodDescriptor getMethod() {
                return null;
            }

            public Message getParam() {
                return TestNamedQueueRecorder.getMessage();
            }

            public CellScanner getCellScanner() {
                return null;
            }

            public long getReceiveTime() {
                return 0L;
            }

            public long getStartTime() {
                return 0L;
            }

            public void setStartTime(long startTime) {
            }

            public int getTimeout() {
                return 0;
            }

            public int getPriority() {
                return 0;
            }

            public long getDeadline() {
                return 0L;
            }

            public long getSize() {
                return 0L;
            }

            public RPCProtos.RequestHeader getHeader() {
                return null;
            }

            public int getRemotePort() {
                return 0;
            }

            public void setResponse(Message param, CellScanner cells, Throwable errorThrowable, String error) {
            }

            public void sendResponseIfReady() throws IOException {
            }

            public void cleanup() {
            }

            public String toShortString() {
                return null;
            }

            public long disconnectSince() {
                return 0L;
            }

            public boolean isClientCellBlockSupported() {
                return false;
            }

            public Optional<User> getRequestUser() {
                return TestNamedQueueRecorder.getUser(userName);
            }

            public InetAddress getRemoteAddress() {
                return null;
            }

            public HBaseProtos.VersionInfo getClientVersionInfo() {
                return null;
            }

            public void setCallBack(RpcCallback callback) {
            }

            public boolean isRetryImmediatelySupported() {
                return false;
            }

            public long getResponseCellSize() {
                return 0L;
            }

            public void incrementResponseCellSize(long cellSize) {
            }

            public long getResponseBlockSize() {
                return 0L;
            }

            public void incrementResponseBlockSize(long blockSize) {
            }

            public long getResponseExceptionSize() {
                return 0L;
            }

            public void incrementResponseExceptionSize(long exceptionSize) {
            }
        };
        return rpcCall;
    }

    private static Message getMessage() {
        i = (i + 1) % 3;
        ClientProtos.ScanRequest message = null;
        switch (i) {
            case 0: {
                message = ClientProtos.ScanRequest.newBuilder().setRegion(HBaseProtos.RegionSpecifier.newBuilder().setValue(ByteString.copyFromUtf8((String)"region1")).setType(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME).build()).build();
                break;
            }
            case 1: {
                message = ClientProtos.MutateRequest.newBuilder().setRegion(HBaseProtos.RegionSpecifier.newBuilder().setValue(ByteString.copyFromUtf8((String)"region2")).setType(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME)).setMutation(ClientProtos.MutationProto.newBuilder().setRow(ByteString.copyFromUtf8((String)"row123")).build()).build();
                break;
            }
            case 2: {
                message = ClientProtos.GetRequest.newBuilder().setRegion(HBaseProtos.RegionSpecifier.newBuilder().setValue(ByteString.copyFromUtf8((String)"region2")).setType(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME)).setGet(ClientProtos.Get.newBuilder().setRow(ByteString.copyFromUtf8((String)"row123")).build()).build();
                break;
            }
            default: {
                throw new RuntimeException("Not supposed to get here?");
            }
        }
        return message;
    }

    private static Optional<User> getUser(final String userName) {
        return Optional.of(new User(){

            public String getShortName() {
                return userName;
            }

            public <T> T runAs(PrivilegedAction<T> action) {
                return null;
            }

            public <T> T runAs(PrivilegedExceptionAction<T> action) {
                return null;
            }
        });
    }
}

