/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2.store.region;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.region.MasterRegion;
import org.apache.hadoop.hbase.procedure2.store.LeaseRecovery;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStore;
import org.apache.hadoop.hbase.procedure2.store.region.RegionProcedureStore;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.mockito.Mockito;

final class RegionProcedureStoreTestHelper {
    private RegionProcedureStoreTestHelper() {
    }

    static Server mockServer(Configuration conf) {
        Server server = (Server)Mockito.mock(Server.class);
        Mockito.when((Object)server.getConfiguration()).thenReturn((Object)conf);
        Mockito.when((Object)server.getServerName()).thenReturn((Object)ServerName.valueOf((String)"localhost", (int)12345, (long)EnvironmentEdgeManager.currentTime()));
        return server;
    }

    static RegionProcedureStore createStore(Server server, MasterRegion region, ProcedureStore.ProcedureLoader loader) throws IOException {
        RegionProcedureStore store = new RegionProcedureStore(server, region, new LeaseRecovery(){

            public void recoverFileLease(FileSystem fs, Path path) throws IOException {
            }
        });
        store.start(1);
        store.recoverLease();
        store.load(loader);
        return store;
    }
}

