/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.wal.EntryBuffers;
import org.apache.hadoop.hbase.wal.RecoveredEditsOutputSink;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALSplitter;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestRecoveredEditsOutputSink {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRecoveredEditsOutputSink.class);
    private static WALFactory wals;
    private static FileSystem fs;
    private static Path rootDir;
    private static final HBaseTestingUtility TEST_UTIL;
    private static RecoveredEditsOutputSink outputSink;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.set("hbase.wal.provider", "filesystem");
        rootDir = TEST_UTIL.createRootDir();
        fs = CommonFSUtils.getRootDirFileSystem((Configuration)conf);
        wals = new WALFactory(conf, "testRecoveredEditsOutputSinkWALFactory");
        WALSplitter splitter = new WALSplitter(wals, conf, rootDir, fs, rootDir, fs);
        WALSplitter.PipelineController pipelineController = new WALSplitter.PipelineController();
        EntryBuffers sink = new EntryBuffers(pipelineController, 0x100000L);
        outputSink = new RecoveredEditsOutputSink(splitter, pipelineController, sink, 3);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        wals.close();
        fs.delete(rootDir, true);
    }

    @Test
    public void testCloseSuccess() throws IOException {
        RecoveredEditsOutputSink spyOutputSink = (RecoveredEditsOutputSink)Mockito.spy((Object)outputSink);
        spyOutputSink.close();
        ((RecoveredEditsOutputSink)Mockito.verify((Object)spyOutputSink, (VerificationMode)Mockito.times((int)1))).finishWriterThreads(false);
        ((RecoveredEditsOutputSink)Mockito.verify((Object)spyOutputSink, (VerificationMode)Mockito.times((int)1))).closeWriters(true);
    }

    @Test
    public void testCloseWALSplitInterrupted() throws IOException {
        RecoveredEditsOutputSink spyOutputSink = (RecoveredEditsOutputSink)Mockito.spy((Object)outputSink);
        ((RecoveredEditsOutputSink)Mockito.doThrow((Throwable[])new Throwable[]{new InterruptedIOException()}).when((Object)spyOutputSink)).finishWriterThreads(false);
        Assert.assertThrows(InterruptedIOException.class, () -> ((RecoveredEditsOutputSink)spyOutputSink).close());
        ((RecoveredEditsOutputSink)Mockito.verify((Object)spyOutputSink, (VerificationMode)Mockito.times((int)1))).finishWriterThreads(false);
        ((RecoveredEditsOutputSink)Mockito.verify((Object)spyOutputSink, (VerificationMode)Mockito.times((int)1))).closeWriters(false);
    }

    @Test
    public void testCloseWALFinishWriterThreadsFailed() throws IOException {
        RecoveredEditsOutputSink spyOutputSink = (RecoveredEditsOutputSink)Mockito.spy((Object)outputSink);
        ((RecoveredEditsOutputSink)Mockito.doReturn((Object)false).when((Object)spyOutputSink)).finishWriterThreads(false);
        spyOutputSink.close();
        ((RecoveredEditsOutputSink)Mockito.verify((Object)spyOutputSink, (VerificationMode)Mockito.times((int)1))).finishWriterThreads(false);
        ((RecoveredEditsOutputSink)Mockito.verify((Object)spyOutputSink, (VerificationMode)Mockito.times((int)1))).closeWriters(false);
    }

    static {
        TEST_UTIL = new HBaseTestingUtility();
    }
}

