/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.utils;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.hadoop.yarn.exceptions.YarnException;

public abstract class FederationMethodWrapper {
    private Object[] params;
    private Class<?>[] types;
    private String methodName;

    public FederationMethodWrapper(Class<?>[] pTypes, Object ... pParams) throws IOException {
        if (pParams.length != pTypes.length) {
            throw new IOException("Invalid parameters for method.");
        }
        this.params = pParams;
        this.types = Arrays.copyOf(pTypes, pTypes.length);
    }

    public Object[] getParams() {
        return Arrays.copyOf(this.params, this.params.length);
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public Class<?>[] getTypes() {
        return Arrays.copyOf(this.types, this.types.length);
    }

    protected abstract <R> Collection<R> invokeConcurrent(Class<R> var1) throws YarnException;
}

