/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.AuthUtil;
import org.apache.hadoop.hbase.security.User;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class Superusers {
    private static final Logger LOG = LoggerFactory.getLogger(Superusers.class);
    public static final String SUPERUSER_CONF_KEY = "hbase.superuser";
    private static ImmutableSet<String> superUsers;
    private static ImmutableSet<String> superGroups;
    private static User systemUser;

    private Superusers() {
    }

    public static void initialize(Configuration conf) throws IOException {
        String[] superUserList;
        ImmutableSet.Builder superUsersBuilder = ImmutableSet.builder();
        ImmutableSet.Builder superGroupsBuilder = ImmutableSet.builder();
        systemUser = User.getCurrent();
        if (systemUser == null) {
            throw new IllegalStateException("Unable to obtain the current user, authorization checks for internal operations will not work correctly!");
        }
        String currentUser = systemUser.getShortName();
        LOG.trace("Current user name is {}", (Object)currentUser);
        superUsersBuilder.add(currentUser);
        for (String name : superUserList = conf.getStrings(SUPERUSER_CONF_KEY, new String[0])) {
            if (AuthUtil.isGroupPrincipal(name)) {
                superGroupsBuilder.add(name);
                continue;
            }
            superUsersBuilder.add(name);
        }
        superUsers = superUsersBuilder.build();
        superGroups = superGroupsBuilder.build();
    }

    public static boolean isSuperUser(User user) {
        if (superUsers == null) {
            throw new IllegalStateException("Super users/super groups lists have not been initialized properly.");
        }
        if (user == null) {
            throw new IllegalArgumentException("Null user passed for super user check");
        }
        if (superUsers.contains(user.getShortName())) {
            return true;
        }
        for (String group : user.getGroupNames()) {
            if (!superGroups.contains(AuthUtil.toGroupEntry(group))) continue;
            return true;
        }
        return false;
    }

    public static boolean isSuperUser(String user) {
        return superUsers.contains(user) || superGroups.contains(user);
    }

    @SuppressWarnings(value={"MS_EXPOSE_REP"}, justification="immutable")
    public static Collection<String> getSuperUsers() {
        return superUsers;
    }

    @SuppressWarnings(value={"MS_EXPOSE_REP"}, justification="immutable")
    public static Collection<String> getSuperGroups() {
        return superGroups;
    }

    @SuppressWarnings(value={"MS_EXPOSE_REP"}, justification="by design")
    public static User getSystemUser() {
        return systemUser;
    }
}

