/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.zookeeper.server.command;

import java.io.PrintWriter;
import java.util.List;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.server.DataTree;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.server.ServerCnxn;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.server.command.AbstractFourLetterCommand;

public class DigestCommand
extends AbstractFourLetterCommand {
    public DigestCommand(PrintWriter pw, ServerCnxn serverCnxn) {
        super(pw, serverCnxn);
    }

    @Override
    public void commandRun() {
        if (!this.isZKServerRunning()) {
            this.pw.print("This ZooKeeper instance is not currently serving requests");
        } else {
            List<DataTree.ZxidDigest> digestLog = this.zkServer.getZKDatabase().getDataTree().getDigestLog();
            for (DataTree.ZxidDigest zd : digestLog) {
                this.pw.println(Long.toHexString(zd.getZxid()) + ": " + zd.getDigest());
            }
        }
    }
}

