/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.connector.payload.pipeconsensus.request;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public enum PipeConsensusRequestType {
    TRANSFER_TABLET_INSERT_NODE(100),
    TRANSFER_TS_FILE_PIECE(101),
    TRANSFER_TS_FILE_SEAL(102),
    TRANSFER_TABLET_BATCH(103),
    TRANSFER_TABLET_BINARY(104),
    TRANSFER_TS_FILE_PIECE_WITH_MOD(105),
    TRANSFER_TS_FILE_SEAL_WITH_MOD(106);

    private final short type;
    private static final Map<Short, PipeConsensusRequestType> TYPE_MAP;

    private PipeConsensusRequestType(short type) {
        this.type = type;
    }

    public short getType() {
        return this.type;
    }

    public static boolean isValidatedRequestType(short type) {
        return TYPE_MAP.containsKey(type);
    }

    public static PipeConsensusRequestType valueOf(short type) {
        return TYPE_MAP.get(type);
    }

    static {
        TYPE_MAP = Arrays.stream(PipeConsensusRequestType.values()).collect(HashMap::new, (typeMap, PipeConsensusRequestType2) -> typeMap.put(PipeConsensusRequestType2.getType(), PipeConsensusRequestType2), HashMap::putAll);
    }
}

