/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.agent.task;

import java.util.Map;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeException;
import org.apache.iotdb.commons.pipe.agent.plugin.builtin.BuiltinPipePlugin;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.agent.task.progress.PipeEventCommitManager;
import org.apache.iotdb.commons.pipe.agent.task.subtask.PipeAbstractConnectorSubtask;
import org.apache.iotdb.commons.pipe.config.plugin.configuraion.PipeTaskRuntimeConfiguration;
import org.apache.iotdb.commons.pipe.config.plugin.env.PipeTaskExtractorRuntimeEnvironment;
import org.apache.iotdb.commons.pipe.config.plugin.env.PipeTaskRuntimeEnvironment;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.event.ProgressReportEvent;
import org.apache.iotdb.confignode.manager.pipe.agent.PipeConfigNodeAgent;
import org.apache.iotdb.confignode.manager.pipe.metric.sink.PipeConfigRegionConnectorMetrics;
import org.apache.iotdb.db.protocol.client.ConfigNodeInfo;
import org.apache.iotdb.pipe.api.PipeExtractor;
import org.apache.iotdb.pipe.api.PipeProcessor;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeConnectorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeExtractorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeProcessorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeRuntimeEnvironment;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeConfigNodeSubtask
extends PipeAbstractConnectorSubtask {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeConfigNodeSubtask.class);
    private final String pipeName;
    private final PipeTaskMeta pipeTaskMeta;
    private PipeExtractor extractor;
    private PipeProcessor processor;

    public PipeConfigNodeSubtask(String pipeName, long creationTime, Map<String, String> extractorAttributes, Map<String, String> processorAttributes, Map<String, String> connectorAttributes, PipeTaskMeta pipeTaskMeta) throws Exception {
        super(pipeName + "_" + creationTime, creationTime, null);
        this.pipeName = pipeName;
        this.pipeTaskMeta = pipeTaskMeta;
        this.initExtractor(extractorAttributes);
        this.initProcessor(processorAttributes);
        this.initConnector(connectorAttributes);
        PipeConfigRegionConnectorMetrics.getInstance().register(this);
        PipeEventCommitManager.getInstance().register(pipeName, creationTime, ConfigNodeInfo.CONFIG_REGION_ID.getId(), pipeName + "_" + creationTime);
    }

    private void initExtractor(Map<String, String> extractorAttributes) throws Exception {
        PipeParameters extractorParameters = new PipeParameters(extractorAttributes);
        this.extractor = PipeConfigNodeAgent.plugin().reflectExtractor(extractorParameters);
        try {
            this.extractor.validate(new PipeParameterValidator(extractorParameters));
            PipeTaskRuntimeConfiguration runtimeConfiguration = new PipeTaskRuntimeConfiguration((PipeRuntimeEnvironment)new PipeTaskExtractorRuntimeEnvironment(this.pipeName, this.creationTime, ConfigNodeInfo.CONFIG_REGION_ID.getId(), this.pipeTaskMeta));
            this.extractor.customize(extractorParameters, (PipeExtractorRuntimeConfiguration)runtimeConfiguration);
        }
        catch (Exception e) {
            try {
                this.extractor.close();
            }
            catch (Exception closeException) {
                LOGGER.warn("Failed to close extractor after failed to initialize extractor. Ignore this exception.", (Throwable)closeException);
            }
            throw e;
        }
    }

    private void initProcessor(Map<String, String> processorAttributes) {
        PipeParameters processorParameters = new PipeParameters(processorAttributes);
        PipeTaskRuntimeConfiguration runtimeConfiguration = new PipeTaskRuntimeConfiguration((PipeRuntimeEnvironment)new PipeTaskRuntimeEnvironment(this.pipeName, this.creationTime, ConfigNodeInfo.CONFIG_REGION_ID.getId()));
        this.processor = PipeConfigNodeAgent.plugin().getConfiguredProcessor(processorParameters.getStringOrDefault("processor", BuiltinPipePlugin.DO_NOTHING_PROCESSOR.getPipePluginName()), processorParameters, (PipeProcessorRuntimeConfiguration)runtimeConfiguration);
    }

    private void initConnector(Map<String, String> connectorAttributes) throws Exception {
        PipeParameters connectorParameters = new PipeParameters(connectorAttributes);
        this.outputPipeConnector = PipeConfigNodeAgent.plugin().reflectConnector(connectorParameters);
        try {
            this.outputPipeConnector.validate(new PipeParameterValidator(connectorParameters));
            PipeTaskRuntimeConfiguration runtimeConfiguration = new PipeTaskRuntimeConfiguration((PipeRuntimeEnvironment)new PipeTaskRuntimeEnvironment(this.pipeName, this.creationTime, ConfigNodeInfo.CONFIG_REGION_ID.getId()));
            this.outputPipeConnector.customize(connectorParameters, (PipeConnectorRuntimeConfiguration)runtimeConfiguration);
            this.outputPipeConnector.handshake();
        }
        catch (Exception e) {
            try {
                this.outputPipeConnector.close();
            }
            catch (Exception closeException) {
                LOGGER.warn("Failed to close connector after failed to initialize connector. Ignore this exception.", (Throwable)closeException);
            }
            throw e;
        }
    }

    protected boolean executeOnce() throws Exception {
        if (this.isClosed.get()) {
            return false;
        }
        Event event = this.lastEvent != null ? this.lastEvent : this.extractor.supply();
        this.setLastEvent(event);
        try {
            if (event == null) {
                return false;
            }
            if (!(event instanceof ProgressReportEvent)) {
                this.outputPipeConnector.transfer(event);
                PipeConfigRegionConnectorMetrics.getInstance().markConfigEvent(this.taskID);
            }
            this.decreaseReferenceCountAndReleaseLastEvent(event, true);
        }
        catch (PipeException e) {
            this.setLastExceptionEvent(event);
            if (!this.isClosed.get()) {
                throw e;
            }
            LOGGER.info("{} in pipe transfer, ignored because pipe is dropped.", (Object)((Object)((Object)e)).getClass().getSimpleName(), (Object)e);
            this.clearReferenceCountAndReleaseLastEvent(event);
        }
        catch (Exception e) {
            this.setLastExceptionEvent(event);
            if (!this.isClosed.get()) {
                throw new PipeException(String.format("Exception in pipe transfer, subtask: %s, last event: %s", this.taskID, this.lastEvent), (Throwable)e);
            }
            LOGGER.info("Exception in pipe transfer, ignored because pipe is dropped.", (Throwable)e);
            this.clearReferenceCountAndReleaseLastEvent(event);
        }
        return true;
    }

    public void close() {
        this.isClosed.set(true);
        PipeEventCommitManager.getInstance().deregister(this.pipeName, this.creationTime, ConfigNodeInfo.CONFIG_REGION_ID.getId());
        PipeConfigRegionConnectorMetrics.getInstance().deregister(this.taskID);
        try {
            this.extractor.close();
        }
        catch (Exception e) {
            LOGGER.info("Error occurred during closing PipeExtractor.", (Throwable)e);
        }
        try {
            this.processor.close();
        }
        catch (Exception e) {
            LOGGER.info("Error occurred during closing PipeProcessor.", (Throwable)e);
        }
        try {
            this.outputPipeConnector.close();
        }
        catch (Exception e) {
            LOGGER.info("Error occurred during closing PipeConnector.", (Throwable)e);
        }
        finally {
            super.close();
        }
    }

    protected String getRootCause(Throwable throwable) {
        return throwable != null ? throwable.getMessage() : null;
    }

    protected void report(EnrichedEvent event, PipeRuntimeException exception) {
        PipeConfigNodeAgent.runtime().report(event, exception);
    }

    public String getPipeName() {
        return this.pipeName;
    }
}

