/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.receiver.protocol;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.pipe.connector.payload.airgap.AirGapPseudoTPipeTransferRequest;
import org.apache.iotdb.commons.pipe.connector.payload.thrift.request.PipeRequestType;
import org.apache.iotdb.commons.pipe.connector.payload.thrift.request.PipeTransferCompressedReq;
import org.apache.iotdb.commons.pipe.connector.payload.thrift.request.PipeTransferFileSealReqV1;
import org.apache.iotdb.commons.pipe.connector.payload.thrift.request.PipeTransferFileSealReqV2;
import org.apache.iotdb.commons.pipe.datastructure.pattern.IoTDBPipePattern;
import org.apache.iotdb.commons.pipe.receiver.IoTDBFileReceiver;
import org.apache.iotdb.commons.pipe.receiver.PipeReceiverStatusHandler;
import org.apache.iotdb.commons.utils.StatusUtils;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.confignode.consensus.request.write.auth.AuthorPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.DatabaseSchemaPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.DeleteDatabasePlan;
import org.apache.iotdb.confignode.consensus.request.write.database.SetTTLPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeDeactivateTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeDeleteLogicalViewPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeDeleteTimeSeriesPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeEnrichedPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeUnsetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.CommitSetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.ExtendSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.trigger.DeleteTriggerInTablePlan;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.manager.pipe.connector.payload.PipeTransferConfigNodeHandshakeV1Req;
import org.apache.iotdb.confignode.manager.pipe.connector.payload.PipeTransferConfigNodeHandshakeV2Req;
import org.apache.iotdb.confignode.manager.pipe.connector.payload.PipeTransferConfigPlanReq;
import org.apache.iotdb.confignode.manager.pipe.connector.payload.PipeTransferConfigSnapshotPieceReq;
import org.apache.iotdb.confignode.manager.pipe.connector.payload.PipeTransferConfigSnapshotSealReq;
import org.apache.iotdb.confignode.manager.pipe.event.PipeConfigRegionSnapshotEvent;
import org.apache.iotdb.confignode.manager.pipe.extractor.IoTDBConfigRegionExtractor;
import org.apache.iotdb.confignode.manager.pipe.metric.receiver.PipeConfigNodeReceiverMetrics;
import org.apache.iotdb.confignode.manager.pipe.receiver.visitor.PipeConfigPhysicalPlanExceptionVisitor;
import org.apache.iotdb.confignode.manager.pipe.receiver.visitor.PipeConfigPhysicalPlanTSStatusVisitor;
import org.apache.iotdb.confignode.persistence.schema.CNPhysicalPlanGenerator;
import org.apache.iotdb.confignode.persistence.schema.CNSnapshotFileType;
import org.apache.iotdb.confignode.persistence.schema.ConfignodeSnapshotParser;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseSchema;
import org.apache.iotdb.confignode.rpc.thrift.TDeleteDatabasesReq;
import org.apache.iotdb.confignode.rpc.thrift.TDeleteLogicalViewReq;
import org.apache.iotdb.confignode.rpc.thrift.TDeleteTimeSeriesReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropTriggerReq;
import org.apache.iotdb.confignode.rpc.thrift.TSetSchemaTemplateReq;
import org.apache.iotdb.confignode.rpc.thrift.TUnsetSchemaTemplateReq;
import org.apache.iotdb.confignode.service.ConfigNode;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.db.protocol.session.IClientSession;
import org.apache.iotdb.db.protocol.session.SessionManager;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBConfigNodeReceiver
extends IoTDBFileReceiver {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBConfigNodeReceiver.class);
    private static final SessionManager SESSION_MANAGER = SessionManager.getInstance();
    private static final AtomicInteger QUERY_ID_GENERATOR = new AtomicInteger(0);
    private static final PipeConfigPhysicalPlanTSStatusVisitor STATUS_VISITOR = new PipeConfigPhysicalPlanTSStatusVisitor();
    private static final PipeConfigPhysicalPlanExceptionVisitor EXCEPTION_VISITOR = new PipeConfigPhysicalPlanExceptionVisitor();
    private final ConfigManager configManager = ConfigNode.getInstance().getConfigManager();

    public TPipeTransferResp receive(TPipeTransferReq req) {
        try {
            short rawRequestType = req.getType();
            if (PipeRequestType.isValidatedRequestType((short)rawRequestType)) {
                PipeRequestType type = PipeRequestType.valueOf((short)rawRequestType);
                if (this.needHandshake(type)) {
                    return new TPipeTransferResp(new TSStatus(TSStatusCode.PIPE_CONFIG_RECEIVER_HANDSHAKE_NEEDED.getStatusCode()).setMessage("The receiver ConfigNode has set up a new receiver and the sender must re-send its handshake request."));
                }
                long startTime = System.nanoTime();
                switch (type) {
                    case HANDSHAKE_CONFIGNODE_V1: {
                        TPipeTransferResp resp = this.handleTransferHandshakeV1(PipeTransferConfigNodeHandshakeV1Req.fromTPipeTransferReq(req));
                        PipeConfigNodeReceiverMetrics.getInstance().recordHandshakeConfigNodeV1Timer(System.nanoTime() - startTime);
                        return resp;
                    }
                    case HANDSHAKE_CONFIGNODE_V2: {
                        TPipeTransferResp resp = this.handleTransferHandshakeV2(PipeTransferConfigNodeHandshakeV2Req.fromTPipeTransferReq(req));
                        PipeConfigNodeReceiverMetrics.getInstance().recordHandshakeConfigNodeV2Timer(System.nanoTime() - startTime);
                        return resp;
                    }
                    case TRANSFER_CONFIG_PLAN: {
                        TPipeTransferResp resp = this.handleTransferConfigPlan(PipeTransferConfigPlanReq.fromTPipeTransferReq(req));
                        PipeConfigNodeReceiverMetrics.getInstance().recordTransferConfigPlanTimer(System.nanoTime() - startTime);
                        return resp;
                    }
                    case TRANSFER_CONFIG_SNAPSHOT_PIECE: {
                        TPipeTransferResp resp = this.handleTransferFilePiece(PipeTransferConfigSnapshotPieceReq.fromTPipeTransferReq(req), req instanceof AirGapPseudoTPipeTransferRequest, false);
                        PipeConfigNodeReceiverMetrics.getInstance().recordTransferConfigSnapshotPieceTimer(System.nanoTime() - startTime);
                        return resp;
                    }
                    case TRANSFER_CONFIG_SNAPSHOT_SEAL: {
                        TPipeTransferResp resp = this.handleTransferFileSealV2(PipeTransferConfigSnapshotSealReq.fromTPipeTransferReq(req));
                        PipeConfigNodeReceiverMetrics.getInstance().recordTransferConfigSnapshotSealTimer(System.nanoTime() - startTime);
                        return resp;
                    }
                    case TRANSFER_COMPRESSED: {
                        return this.receive(PipeTransferCompressedReq.fromTPipeTransferReq((TPipeTransferReq)req));
                    }
                }
            }
            TSStatus status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_TYPE_ERROR, (String)String.format("Unsupported PipeRequestType on ConfigNode %s.", rawRequestType));
            LOGGER.warn("Receiver id = {}: Unsupported PipeRequestType on ConfigNode, response status = {}.", (Object)this.receiverId.get(), (Object)status);
            return new TPipeTransferResp(status);
        }
        catch (Exception e) {
            String error = "Exception encountered while handling pipe transfer request. Root cause: " + e.getMessage();
            LOGGER.warn("Receiver id = {}: {}", new Object[]{this.receiverId.get(), error, e});
            return new TPipeTransferResp(RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_ERROR, (String)error));
        }
    }

    private boolean needHandshake(PipeRequestType type) {
        return Objects.isNull(this.receiverFileDirWithIdSuffix.get()) && type != PipeRequestType.HANDSHAKE_CONFIGNODE_V1 && type != PipeRequestType.HANDSHAKE_CONFIGNODE_V2;
    }

    private TPipeTransferResp handleTransferConfigPlan(PipeTransferConfigPlanReq req) throws IOException {
        return new TPipeTransferResp(this.executePlanAndClassifyExceptions(ConfigPhysicalPlan.Factory.create(req.body)));
    }

    private TSStatus executePlanAndClassifyExceptions(ConfigPhysicalPlan plan) {
        TSStatus result;
        try {
            result = this.checkPermission(plan);
            if (result.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                LOGGER.warn("Receiver id = {}: Permission check failed while executing plan {}: {}", new Object[]{this.receiverId.get(), plan, result});
                return result;
            }
            result = this.executePlan(plan);
            if (result.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                LOGGER.warn("Receiver id = {}: Failure status encountered while executing plan {}: {}", new Object[]{this.receiverId.get(), plan, result});
                result = (TSStatus)STATUS_VISITOR.process(plan, result);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Receiver id = {}: Exception encountered while executing plan {}: ", new Object[]{this.receiverId.get(), plan, e});
            result = (TSStatus)EXCEPTION_VISITOR.process(plan, e);
        }
        return result;
    }

    private TSStatus checkPermission(ConfigPhysicalPlan plan) {
        switch (plan.getType()) {
            case CreateDatabase: 
            case AlterDatabase: 
            case DeleteDatabase: {
                return this.configManager.checkUserPrivileges(this.username, Collections.emptyList(), PrivilegeType.MANAGE_DATABASE.ordinal()).getStatus();
            }
            case ExtendSchemaTemplate: {
                return this.configManager.checkUserPrivileges(this.username, Collections.emptyList(), PrivilegeType.EXTEND_TEMPLATE.ordinal()).getStatus();
            }
            case CreateSchemaTemplate: 
            case CommitSetSchemaTemplate: 
            case PipeUnsetTemplate: {
                return CommonDescriptor.getInstance().getConfig().getAdminName().equals(this.username) ? StatusUtils.OK : new TSStatus(TSStatusCode.NO_PERMISSION.getStatusCode()).setMessage("Only the admin user can perform this operation");
            }
            case PipeDeleteTimeSeries: {
                return this.configManager.checkUserPrivileges(this.username, new ArrayList<PartialPath>(PathPatternTree.deserialize((ByteBuffer)((PipeDeleteTimeSeriesPlan)plan).getPatternTreeBytes()).getAllPathPatterns()), PrivilegeType.WRITE_SCHEMA.ordinal()).getStatus();
            }
            case PipeDeleteLogicalView: {
                return this.configManager.checkUserPrivileges(this.username, new ArrayList<PartialPath>(PathPatternTree.deserialize((ByteBuffer)((PipeDeleteLogicalViewPlan)plan).getPatternTreeBytes()).getAllPathPatterns()), PrivilegeType.WRITE_SCHEMA.ordinal()).getStatus();
            }
            case PipeDeactivateTemplate: {
                return this.configManager.checkUserPrivileges(this.username, new ArrayList<PartialPath>(((PipeDeactivateTemplatePlan)plan).getTemplateSetInfo().keySet()), PrivilegeType.WRITE_SCHEMA.ordinal()).getStatus();
            }
            case SetTTL: {
                return Objects.equals(this.configManager.getTTLManager().getAllTTL().get(String.join((CharSequence)String.valueOf('.'), ((SetTTLPlan)plan).getPathPattern())), ((SetTTLPlan)plan).getTTL()) ? StatusUtils.OK : this.configManager.checkUserPrivileges(this.username, ((SetTTLPlan)plan).isDataBase() ? Collections.emptyList() : Collections.singletonList(new PartialPath(((SetTTLPlan)plan).getPathPattern())), ((SetTTLPlan)plan).isDataBase() ? PrivilegeType.MANAGE_DATABASE.ordinal() : PrivilegeType.WRITE_SCHEMA.ordinal()).getStatus();
            }
            case UpdateTriggerStateInTable: 
            case DeleteTriggerInTable: {
                return this.configManager.checkUserPrivileges(this.username, Collections.emptyList(), PrivilegeType.USE_TRIGGER.ordinal()).getStatus();
            }
            case GrantRole: 
            case GrantUser: 
            case RevokeUser: 
            case RevokeRole: {
                for (int permission : ((AuthorPlan)plan).getPermissions()) {
                    TSStatus status = this.configManager.checkUserPrivilegeGrantOpt(this.username, PrivilegeType.isPathRelevant((int)permission) ? ((AuthorPlan)plan).getNodeNameList() : Collections.emptyList(), permission).getStatus();
                    if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
                    return status;
                }
                return StatusUtils.OK;
            }
            case UpdateUser: {
                return ((AuthorPlan)plan).getUserName().equals(this.username) ? StatusUtils.OK : this.configManager.checkUserPrivileges(this.username, Collections.emptyList(), PrivilegeType.MANAGE_USER.ordinal()).getStatus();
            }
            case CreateUser: 
            case CreateUserWithRawPassword: 
            case DropUser: {
                return this.configManager.checkUserPrivileges(this.username, Collections.emptyList(), PrivilegeType.MANAGE_USER.ordinal()).getStatus();
            }
            case CreateRole: 
            case DropRole: 
            case GrantRoleToUser: 
            case RevokeRoleFromUser: {
                return this.configManager.checkUserPrivileges(this.username, Collections.emptyList(), PrivilegeType.MANAGE_ROLE.ordinal()).getStatus();
            }
        }
        return StatusUtils.OK;
    }

    private TSStatus executePlan(ConfigPhysicalPlan plan) throws ConsensusException {
        switch (plan.getType()) {
            case CreateDatabase: {
                TDatabaseSchema schema = ((DatabaseSchemaPlan)plan).getSchema();
                schema.setSchemaReplicationFactor(ConfigNodeDescriptor.getInstance().getConf().getSchemaReplicationFactor());
                schema.setDataReplicationFactor(ConfigNodeDescriptor.getInstance().getConf().getDataReplicationFactor());
                schema.setTimePartitionInterval(CommonDescriptor.getInstance().getConfig().getTimePartitionInterval());
                schema.setMinSchemaRegionGroupNum(ConfigNodeDescriptor.getInstance().getConf().getDefaultSchemaRegionGroupNumPerDatabase());
                schema.setMinDataRegionGroupNum(ConfigNodeDescriptor.getInstance().getConf().getDefaultDataRegionGroupNumPerDatabase());
                schema.setMaxSchemaRegionGroupNum(schema.getMinSchemaRegionGroupNum());
                schema.setMaxDataRegionGroupNum(schema.getMinDataRegionGroupNum());
                return this.configManager.getClusterSchemaManager().setDatabase((DatabaseSchemaPlan)plan, true);
            }
            case AlterDatabase: {
                return this.configManager.getClusterSchemaManager().alterDatabase((DatabaseSchemaPlan)plan, true);
            }
            case DeleteDatabase: {
                return this.configManager.deleteDatabases(new TDeleteDatabasesReq(Collections.singletonList(((DeleteDatabasePlan)plan).getName())).setIsGeneratedByPipe(true));
            }
            case ExtendSchemaTemplate: {
                return this.configManager.getClusterSchemaManager().extendSchemaTemplate(((ExtendSchemaTemplatePlan)plan).getTemplateExtendInfo(), true);
            }
            case CommitSetSchemaTemplate: {
                return this.configManager.setSchemaTemplate(new TSetSchemaTemplateReq(this.generatePseudoQueryId(), ((CommitSetSchemaTemplatePlan)plan).getName(), ((CommitSetSchemaTemplatePlan)plan).getPath()).setIsGeneratedByPipe(true));
            }
            case PipeUnsetTemplate: {
                return this.configManager.unsetSchemaTemplate(new TUnsetSchemaTemplateReq(this.generatePseudoQueryId(), ((PipeUnsetSchemaTemplatePlan)plan).getName(), ((PipeUnsetSchemaTemplatePlan)plan).getPath()).setIsGeneratedByPipe(true));
            }
            case PipeDeleteTimeSeries: {
                return this.configManager.deleteTimeSeries(new TDeleteTimeSeriesReq(this.generatePseudoQueryId(), ((PipeDeleteTimeSeriesPlan)plan).getPatternTreeBytes()).setIsGeneratedByPipe(true));
            }
            case PipeDeleteLogicalView: {
                return this.configManager.deleteLogicalView(new TDeleteLogicalViewReq(this.generatePseudoQueryId(), ((PipeDeleteLogicalViewPlan)plan).getPatternTreeBytes()).setIsGeneratedByPipe(true));
            }
            case PipeDeactivateTemplate: {
                return this.configManager.getProcedureManager().deactivateTemplate(this.generatePseudoQueryId(), ((PipeDeactivateTemplatePlan)plan).getTemplateSetInfo(), true);
            }
            case UpdateTriggerStateInTable: {
                return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            }
            case DeleteTriggerInTable: {
                return this.configManager.dropTrigger(new TDropTriggerReq(((DeleteTriggerInTablePlan)plan).getTriggerName()).setIsGeneratedByPipe(true));
            }
            case SetTTL: {
                return ((SetTTLPlan)plan).getTTL() == -1L ? this.configManager.getTTLManager().unsetTTL((SetTTLPlan)plan, true) : this.configManager.getTTLManager().setTTL((SetTTLPlan)plan, true);
            }
            case GrantRole: 
            case GrantUser: 
            case RevokeUser: 
            case RevokeRole: 
            case UpdateUser: 
            case DropUser: 
            case DropRole: 
            case GrantRoleToUser: 
            case RevokeRoleFromUser: {
                return this.configManager.getPermissionManager().operatePermission((AuthorPlan)plan, true);
            }
        }
        return this.configManager.getConsensusManager().write(new PipeEnrichedPlan(plan));
    }

    private String generatePseudoQueryId() {
        return "pipe_" + System.currentTimeMillis() + "_" + QUERY_ID_GENERATOR.getAndIncrement();
    }

    protected String getClusterId() {
        return ConfigNode.getInstance().getConfigManager().getClusterManager().getClusterId();
    }

    protected TSStatus tryLogin() {
        return StatusUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    protected String getReceiverFileBaseDir() {
        return ConfigNodeDescriptor.getInstance().getConf().getPipeReceiverFileDir();
    }

    protected String getSenderHost() {
        IClientSession session = SESSION_MANAGER.getCurrSession();
        return session != null ? session.getClientAddress() : "unknown";
    }

    protected String getSenderPort() {
        IClientSession session = SESSION_MANAGER.getCurrSession();
        return session != null ? String.valueOf(session.getClientPort()) : "unknown";
    }

    protected TSStatus loadFileV1(PipeTransferFileSealReqV1 req, String fileAbsolutePath) {
        throw new UnsupportedOperationException("IoTDBConfigNodeReceiver does not support load file V1.");
    }

    protected TSStatus loadFileV2(PipeTransferFileSealReqV2 req, List<String> fileAbsolutePaths) throws IOException {
        Map parameters = req.getParameters();
        CNPhysicalPlanGenerator generator = ConfignodeSnapshotParser.translate2PhysicalPlan(Paths.get(fileAbsolutePaths.get(0), new String[0]), fileAbsolutePaths.size() > 1 ? Paths.get(fileAbsolutePaths.get(1), new String[0]) : null, CNSnapshotFileType.deserialize(Byte.parseByte((String)parameters.get("fileType"))));
        if (Objects.isNull(generator)) {
            throw new IOException(String.format("The config region snapshots %s cannot be parsed.", fileAbsolutePaths));
        }
        Set<ConfigPhysicalPlanType> executionTypes = PipeConfigRegionSnapshotEvent.getConfigPhysicalPlanTypeSet((String)parameters.get("Type"));
        IoTDBPipePattern pattern = new IoTDBPipePattern((String)parameters.get("PathPattern"));
        ArrayList results = new ArrayList();
        while (generator.hasNext()) {
            ((Optional)IoTDBConfigRegionExtractor.PATTERN_PARSE_VISITOR.process(generator.next(), pattern)).filter(configPhysicalPlan -> executionTypes.contains((Object)configPhysicalPlan.getType())).ifPresent(configPhysicalPlan -> results.add(this.executePlanAndClassifyExceptions((ConfigPhysicalPlan)configPhysicalPlan)));
        }
        return PipeReceiverStatusHandler.getPriorStatus(results);
    }

    protected void closeSession() {
    }
}

