/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.rpc.subscription.payload.poll;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollPayload;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.write.record.Tablet;

public class TabletsPayload
implements SubscriptionPollPayload {
    private transient List<Tablet> tablets = new ArrayList<Tablet>();
    private transient int nextOffset;

    public TabletsPayload() {
    }

    public TabletsPayload(List<Tablet> tablets, int nextOffset) {
        this.tablets = tablets;
        this.nextOffset = nextOffset;
    }

    public List<Tablet> getTablets() {
        return this.tablets;
    }

    public int getNextOffset() {
        return this.nextOffset;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)this.tablets.size(), (OutputStream)stream);
        for (Tablet tablet : this.tablets) {
            tablet.serialize(stream);
        }
        ReadWriteIOUtils.write((int)this.nextOffset, (OutputStream)stream);
    }

    @Override
    public SubscriptionPollPayload deserialize(ByteBuffer buffer) {
        ArrayList<Tablet> tablets = new ArrayList<Tablet>();
        int size = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        for (int i = 0; i < size; ++i) {
            tablets.add(Tablet.deserialize((ByteBuffer)buffer));
        }
        this.tablets = tablets;
        this.nextOffset = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TabletsPayload that = (TabletsPayload)obj;
        return Objects.equals(this.tablets, that.tablets) && Objects.equals(this.nextOffset, that.nextOffset);
    }

    public int hashCode() {
        return Objects.hash(this.tablets, this.nextOffset);
    }

    public String toString() {
        return "TabletsPayload{size of tablets=" + this.tablets.size() + ", nextOffset=" + this.nextOffset + "}";
    }
}

