/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tool.backup;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.tool.data.AbstractDataTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBDataBackTool {
    static Map<String, String> mm = new HashMap<String, String>();
    static Map<String, String> cpmm = new HashMap<String, String>();
    static String type = "";
    static String nodeTypeParam = "";
    static String targetDirParam = "";
    static String targetDataDirParam = "";
    static String targetWalDirParam = "";
    static String remoteDnDataDir = "";
    static AtomicInteger fileCount = new AtomicInteger(0);
    static AtomicInteger targetFileCount = new AtomicInteger(0);
    static AtomicInteger processFileCount = new AtomicInteger(0);
    static final String filename = "backup.log";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDataTool.class);
    private static final IoTDBDescriptor ioTDBDescriptor = IoTDBDescriptor.getInstance();
    static String sourcePath = System.getProperty("IOTDB_HOME", null);
    static boolean IS_OBJECT_STORAGE = false;
    static String DEFAULT_DN_DATA_DIRS = "data" + File.separator + "datanode" + File.separator + "data";
    static String DEFAULT_DN_SYSTEM_DIR = "data" + File.separator + "datanode" + File.separator + "system";
    static String DEFAULT_DN_CONSENSUS_DIR = "data" + File.separator + "datanode" + File.separator + "consensus";
    static String DEFAULT_DN_WAL_DIRS = "data" + File.separator + "datanode" + File.separator + "wal";
    static String DEFAULT_DN_TRACING_DIR = "data" + File.separator + "datanode" + File.separator + "tracing";
    static String DEFAULT_CN_SYSTEM_DIR = "data" + File.separator + "confignode" + File.separator + "system";
    static String DEFAULT_CN_CONSENSUS_DIR = "data" + File.separator + "confignode" + File.separator + "consensus";

    private static void argsParse(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-quick")) {
                type = "quick";
                continue;
            }
            if (args[i].equalsIgnoreCase("-node") && i + 1 < args.length) {
                nodeTypeParam = args[i + 1];
                continue;
            }
            if (args[i].equalsIgnoreCase("-targetdir") && i + 1 < args.length) {
                targetDirParam = args[i + 1];
                continue;
            }
            if (args[i].equalsIgnoreCase("-targetdatadir") && i + 1 < args.length) {
                targetDataDirParam = args[i + 1];
                continue;
            }
            if (!args[i].equalsIgnoreCase("-targetwaldir") || i + 1 >= args.length) continue;
            targetWalDirParam = args[i + 1];
        }
    }

    public static boolean vaildParam(String dnDataDirs, String dnWalDirs) {
        boolean isVaild = true;
        if (type == null || type.trim().length() == 0 || !type.equals("quick")) {
            if (targetDirParam.isEmpty()) {
                LOGGER.error(" -targetdir cannot be empty\uff0c The backup folder must be specified");
                isVaild = false;
            } else if (IoTDBDataBackTool.isRelativePath(targetDirParam)) {
                LOGGER.error("-targetdir parameter exception, please use absolute path");
                isVaild = false;
            }
            if (!targetDataDirParam.isEmpty()) {
                if (!IoTDBDataBackTool.matchPattern(targetDataDirParam, dnDataDirs)) {
                    LOGGER.error("-targetdatadir parameter exception, the number of original paths does not match the number of specified paths");
                    isVaild = false;
                }
                if (IoTDBDataBackTool.targetPathVild(targetDataDirParam)) {
                    LOGGER.error("-targetdatadir parameter exception, please use absolute path");
                    isVaild = false;
                }
            }
            if (!targetWalDirParam.isEmpty()) {
                if (!IoTDBDataBackTool.matchPattern(targetWalDirParam, dnWalDirs)) {
                    LOGGER.error("-targetwaldir parameter exception, the number of original paths does not match the number of specified paths");
                    isVaild = false;
                }
                if (IoTDBDataBackTool.targetPathVild(targetWalDirParam)) {
                    LOGGER.error("-targetwaldir parameter exception, please use absolute path");
                    isVaild = false;
                }
            }
        }
        return isVaild;
    }

    public static void main(String[] args) throws IOException {
        System.setProperty("IOTDB_HOME", System.getenv("IOTDB_HOME"));
        IoTDBDataBackTool.argsParse(args);
        File sourceDir = new File(sourcePath);
        Properties properties = IoTDBDataBackTool.getProperties("iotdb-system.properties");
        IoTDBDataBackTool.initDataNodeProperties(properties);
        IoTDBDataBackTool.initConfigNodeProperties(properties);
        StringBuilder targetDirString = new StringBuilder();
        HashMap<String, String> copyMap = new HashMap<String, String>();
        HashMap<String, String> dnDataDirsMap = new HashMap<String, String>();
        HashMap<String, String> cnMapProperties = new HashMap<String, String>();
        HashMap<String, String> dnMapProperties = new HashMap<String, String>();
        processFileCount.set(IoTDBDataBackTool.readFileData(filename));
        if (type != null && type.equals("quick")) {
            targetDirString.append(sourceDir.getParent()).append(File.separatorChar).append("iotdb_backup");
            File targetDir = new File(targetDirString.toString());
            if (targetDir.exists()) {
                LOGGER.error("The backup folder already exists:{}", (Object)targetDirString);
                System.exit(0);
            }
            if (nodeTypeParam.equalsIgnoreCase("confignode")) {
                if (!targetDir.exists()) {
                    targetDir.mkdirs();
                }
                IoTDBDataBackTool.countConfigNodeFile(targetDirString.toString(), copyMap, cnMapProperties);
                IoTDBDataBackTool.countNodeBack(targetDirString.toString(), copyMap);
                for (Map.Entry entry : copyMap.entrySet()) {
                    IoTDBDataBackTool.countFiles((String)entry.getKey());
                }
                IoTDBDataBackTool.ioTDBDataBack(copyMap, dnDataDirsMap);
                IoTDBDataBackTool.propertiesFileUpdate(targetDirString.toString() + File.separatorChar + "conf" + File.separatorChar + "iotdb-system.properties", cnMapProperties);
            } else if (nodeTypeParam.equalsIgnoreCase("datanode")) {
                IoTDBDataBackTool.countDataNodeFile(targetDirString.toString(), copyMap, dnDataDirsMap, dnMapProperties);
                IoTDBDataBackTool.countNodeBack(targetDirString.toString(), copyMap);
                IoTDBDataBackTool.checkQuickMode(dnDataDirsMap);
                if (!targetDir.exists()) {
                    targetDir.mkdirs();
                }
                for (Map.Entry entry : copyMap.entrySet()) {
                    IoTDBDataBackTool.countFiles((String)entry.getKey());
                }
                for (Map.Entry entry : dnDataDirsMap.entrySet()) {
                    IoTDBDataBackTool.countFiles((String)entry.getKey());
                }
                IoTDBDataBackTool.ioTDBDataBack(copyMap, dnDataDirsMap);
                IoTDBDataBackTool.propertiesFileUpdate(targetDirString.toString() + File.separatorChar + "conf" + File.separatorChar + "iotdb-system.properties", dnMapProperties);
            } else if (nodeTypeParam.equalsIgnoreCase("all") || nodeTypeParam.isEmpty()) {
                IoTDBDataBackTool.countConfigNodeFile(targetDirString.toString(), copyMap, cnMapProperties);
                IoTDBDataBackTool.countDataNodeFile(targetDirString.toString(), copyMap, dnDataDirsMap, dnMapProperties);
                IoTDBDataBackTool.countNodeBack(targetDirString.toString(), copyMap);
                IoTDBDataBackTool.checkQuickMode(dnDataDirsMap);
                if (!targetDir.exists()) {
                    targetDir.mkdirs();
                }
                for (Map.Entry entry : copyMap.entrySet()) {
                    IoTDBDataBackTool.countFiles((String)entry.getKey());
                }
                for (Map.Entry entry : dnDataDirsMap.entrySet()) {
                    IoTDBDataBackTool.countFiles((String)entry.getKey());
                }
                IoTDBDataBackTool.ioTDBDataBack(copyMap, dnDataDirsMap);
                IoTDBDataBackTool.propertiesFileUpdate(targetDirString.toString() + File.separatorChar + "conf" + File.separatorChar + "iotdb-system.properties", cnMapProperties);
                IoTDBDataBackTool.propertiesFileUpdate(targetDirString.toString() + File.separatorChar + "conf" + File.separatorChar + "iotdb-system.properties", dnMapProperties);
            }
        } else {
            if (targetDirParam != null && targetDirParam.length() > 0) {
                targetDirString.append(targetDirParam);
                File targetDir = new File(targetDirString.toString());
                if (!targetDir.exists()) {
                    targetDir.mkdirs();
                }
            }
            if (nodeTypeParam.equalsIgnoreCase("confignode")) {
                IoTDBDataBackTool.countConfigNodeFile(targetDirString.toString(), copyMap, cnMapProperties);
                IoTDBDataBackTool.countNodeBack(targetDirString.toString(), copyMap);
                for (Map.Entry entry : copyMap.entrySet()) {
                    IoTDBDataBackTool.countFiles((String)entry.getKey());
                }
                IoTDBDataBackTool.isDirectoryInsideOrSame(copyMap);
                IoTDBDataBackTool.ioTDBDataBack(copyMap, dnDataDirsMap);
                IoTDBDataBackTool.propertiesFileUpdate(targetDirString.toString() + File.separatorChar + "conf" + File.separatorChar + "iotdb-system.properties", cnMapProperties);
            } else if (nodeTypeParam.equalsIgnoreCase("datanode")) {
                IoTDBDataBackTool.countNodeBack(targetDirString.toString(), copyMap);
                IoTDBDataBackTool.countDataNodeFile(targetDirString.toString(), copyMap, dnDataDirsMap, dnMapProperties);
                for (Map.Entry entry : copyMap.entrySet()) {
                    IoTDBDataBackTool.countFiles((String)entry.getKey());
                }
                for (Map.Entry entry : dnDataDirsMap.entrySet()) {
                    IoTDBDataBackTool.countFiles((String)entry.getKey());
                }
                IoTDBDataBackTool.isDirectoryInsideOrSame(copyMap);
                IoTDBDataBackTool.isDirectoryInsideOrSame(dnDataDirsMap);
                IoTDBDataBackTool.ioTDBDataBack(copyMap, dnDataDirsMap);
                IoTDBDataBackTool.propertiesFileUpdate(targetDirString.toString() + File.separatorChar + "conf" + File.separatorChar + "iotdb-system.properties", dnMapProperties);
            } else if (nodeTypeParam.equalsIgnoreCase("all") || nodeTypeParam.isEmpty()) {
                IoTDBDataBackTool.countNodeBack(targetDirString.toString(), copyMap);
                IoTDBDataBackTool.countConfigNodeFile(targetDirString.toString(), copyMap, cnMapProperties);
                IoTDBDataBackTool.countDataNodeFile(targetDirString.toString(), copyMap, dnDataDirsMap, dnMapProperties);
                for (Map.Entry entry : copyMap.entrySet()) {
                    IoTDBDataBackTool.countFiles((String)entry.getKey());
                }
                for (Map.Entry entry : dnDataDirsMap.entrySet()) {
                    IoTDBDataBackTool.countFiles((String)entry.getKey());
                }
                IoTDBDataBackTool.isDirectoryInsideOrSame(copyMap);
                IoTDBDataBackTool.isDirectoryInsideOrSame(dnDataDirsMap);
                IoTDBDataBackTool.ioTDBDataBack(copyMap, dnDataDirsMap);
                IoTDBDataBackTool.propertiesFileUpdate(targetDirString.toString() + File.separatorChar + "conf" + File.separatorChar + "iotdb-system.properties", cnMapProperties);
                IoTDBDataBackTool.propertiesFileUpdate(targetDirString.toString() + File.separatorChar + "conf" + File.separatorChar + "iotdb-system.properties", dnMapProperties);
            }
        }
        LOGGER.info("all operations are complete");
        IoTDBDataBackTool.delFile(filename);
    }

    private static void checkQuickMode(Map<String, String> dnDataDirsMap) {
        for (Map.Entry<String, String> entry : dnDataDirsMap.entrySet()) {
            File backupDir = new File(entry.getValue());
            if (!backupDir.exists()) continue;
            LOGGER.error("The backup folder already exists:{}", (Object)entry.getValue());
            System.exit(0);
        }
    }

    private static void isDirectoryInsideOrSame(Map<String, String> copyMap) {
        for (Map.Entry<String, String> sourceEntry : copyMap.entrySet()) {
            for (Map.Entry<String, String> targetEntry : copyMap.entrySet()) {
                Path normalizedParentPath;
                File file = new File(sourceEntry.getKey());
                if (!file.exists()) continue;
                Path targetPath = Paths.get(targetEntry.getValue(), new String[0]);
                Path parentPath = Paths.get(sourceEntry.getKey(), new String[0]);
                Path normalizedTargetPath = targetPath.normalize();
                if (!normalizedTargetPath.startsWith(normalizedParentPath = parentPath.normalize()) && !normalizedTargetPath.equals(normalizedParentPath)) continue;
                if (targetDirParam.length() > 0 && targetDataDirParam.length() > 0 && targetWalDirParam.length() > 0) {
                    LOGGER.error("The directory to be backed up cannot be in the source directory, please check:{},{},{}", new Object[]{targetDirParam, targetDataDirParam, targetWalDirParam});
                    System.exit(0);
                    continue;
                }
                if (targetDirParam.length() > 0 && targetDataDirParam.length() > 0) {
                    LOGGER.error("The directory to be backed up cannot be in the source directory, please check:{},{}", (Object)targetDirParam, (Object)targetDataDirParam);
                    System.exit(0);
                    continue;
                }
                if (targetDirParam.length() > 0 && targetWalDirParam.length() > 0) {
                    LOGGER.error("The directory to be backed up cannot be in the source directory, please check:{},{}", (Object)targetDirParam, (Object)targetWalDirParam);
                    System.exit(0);
                    continue;
                }
                if (targetDirParam.length() <= 0) continue;
                LOGGER.error("The directory to be backed up cannot be in the source directory, please check:{}", (Object)targetDirParam);
                System.exit(0);
            }
        }
    }

    private static void ioTDBDataBack(Map<String, String> copyMap, Map<String, String> dnDataDirsMap) {
        File targetFile;
        File file;
        for (Map.Entry<String, String> entry : copyMap.entrySet()) {
            file = new File(entry.getKey());
            if (file.isDirectory()) {
                IoTDBDataBackTool.compareAndcopyDirectory(file, new File(entry.getValue()));
                continue;
            }
            if (!file.exists()) continue;
            targetFile = new File(entry.getValue());
            try {
                Files.copy(file.toPath(), targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                targetFileCount.incrementAndGet();
            }
            catch (IOException e) {
                LOGGER.error("copy file error", (Throwable)e);
            }
        }
        for (Map.Entry<String, String> entry : dnDataDirsMap.entrySet()) {
            file = new File(entry.getKey());
            if (file.isDirectory()) {
                IoTDBDataBackTool.compareAndLinkDirectory(file, new File(entry.getValue()));
                continue;
            }
            if (!file.exists()) continue;
            targetFile = new File(entry.getValue());
            try {
                Files.copy(file.toPath(), targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                targetFileCount.incrementAndGet();
            }
            catch (IOException e) {
                LOGGER.error("copy file error", (Throwable)e);
            }
        }
    }

    private static void countNodeBack(String targetDirString, Map<String, String> copyMap) {
        File sourceDir = new File(sourcePath);
        Properties properties = IoTDBDataBackTool.getProperties("iotdb-system.properties");
        IoTDBDataBackTool.initDataNodeProperties(properties);
        IoTDBDataBackTool.initConfigNodeProperties(properties);
        copyMap.put(sourceDir.getAbsolutePath() + File.separatorChar + ".env", targetDirString + File.separatorChar + ".env");
        copyMap.put(sourceDir.getAbsolutePath() + File.separatorChar + "conf", targetDirString + File.separatorChar + "conf");
        copyMap.put(sourceDir.getAbsolutePath() + File.separatorChar + "ext", targetDirString + File.separatorChar + "ext");
        copyMap.put(sourceDir.getAbsolutePath() + File.separatorChar + "licenses", targetDirString + File.separatorChar + "licenses");
        copyMap.put(sourceDir.getAbsolutePath() + File.separatorChar + "tools", targetDirString + File.separatorChar + "tools");
        copyMap.put(sourceDir.getAbsolutePath() + File.separatorChar + "sbin", targetDirString + File.separatorChar + "sbin");
        copyMap.put(sourceDir.getAbsolutePath() + File.separatorChar + "LICENSE", targetDirString + File.separatorChar + "LICENSE");
        copyMap.put(sourceDir.getAbsolutePath() + File.separatorChar + "NOTICE", targetDirString + File.separatorChar + "NOTICE");
        copyMap.put(sourceDir.getAbsolutePath() + File.separatorChar + "README.md", targetDirString + File.separatorChar + "README.md");
        copyMap.put(sourceDir.getAbsolutePath() + File.separatorChar + "README_ZH.md", targetDirString + File.separatorChar + "README_ZH.md");
        copyMap.put(sourceDir.getAbsolutePath() + File.separatorChar + File.separatorChar + "RELEASE_NOTES.md", targetDirString + File.separatorChar + "RELEASE_NOTES.md");
        copyMap.put(sourceDir.getAbsolutePath() + File.separatorChar + "activation", targetDirString + File.separatorChar + "activation");
        copyMap.put(sourceDir.getAbsolutePath() + File.separatorChar + "lib", targetDirString + File.separatorChar + "lib");
    }

    private static void countDataNodeFile(String targetDirString, Map<String, String> copyMap, Map<String, String> dnDataDirsMap, Map<String, String> dnMapProperties) {
        String dnDataDirs;
        Properties dataProperties = IoTDBDataBackTool.getProperties("iotdb-system.properties");
        IoTDBDataBackTool.initDataNodeProperties(dataProperties);
        String dnSystemDir = dataProperties.getProperty("dn_system_dir");
        String dnConsensusDir = dataProperties.getProperty("dn_consensus_dir");
        String dnTracingDir = dataProperties.getProperty("dn_tracing_dir");
        String dnWalDirs = dataProperties.getProperty("dn_wal_dirs");
        String dnDataDirAll = dnDataDirs = dataProperties.getProperty("dn_data_dirs");
        dnDataDirs = IoTDBDataBackTool.isObjectStorage(dnDataDirs);
        remoteDnDataDir = dnDataDirAll.replaceAll(dnDataDirs, "");
        dnSystemDir = IoTDBDataBackTool.pathHandler(dnSystemDir);
        dnConsensusDir = IoTDBDataBackTool.pathHandler(dnConsensusDir);
        dnTracingDir = IoTDBDataBackTool.pathHandler(dnTracingDir);
        dnWalDirs = IoTDBDataBackTool.pathHandler(dnWalDirs);
        dnDataDirs = IoTDBDataBackTool.pathHandler(dnDataDirs);
        String bakDnSystemDir = targetDirString + File.separatorChar + DEFAULT_DN_SYSTEM_DIR;
        String bakDnConsensusDir = targetDirString + File.separatorChar + DEFAULT_DN_CONSENSUS_DIR;
        String bakDnTracingDir = targetDirString + File.separatorChar + DEFAULT_DN_TRACING_DIR;
        String bakDnWalDirs = targetDirString + File.separatorChar + DEFAULT_DN_WAL_DIRS;
        if (type.equals("quick")) {
            targetDirParam = targetDirString;
            targetWalDirParam = IoTDBDataBackTool.sourceWalCoverTargetWalDirsHandler(dnWalDirs, bakDnWalDirs);
        }
        targetWalDirParam = targetWalDirParam.isEmpty() ? IoTDBDataBackTool.sourceWalCoverTargetWalDirsHandler(dnWalDirs, bakDnWalDirs) : IoTDBDataBackTool.getCreateDnDataPathString(dnWalDirs, targetWalDirParam, "wal");
        if (targetDataDirParam.isEmpty()) {
            targetDataDirParam = targetDirParam + File.separatorChar + "data" + File.separatorChar + "datanode" + File.separatorChar + "data";
        }
        if (!IoTDBDataBackTool.vaildParam(dnDataDirs, dnWalDirs)) {
            System.exit(0);
        }
        String targetDnDataDirs = IoTDBDataBackTool.getCreateDnDataPathString(dnDataDirs, targetDataDirParam, "data");
        Map<String, String> dnSystemDirMap = IoTDBDataBackTool.getCreatePathMapping(Objects.requireNonNull(dnSystemDir), bakDnSystemDir, "system");
        dnDataDirsMap.putAll(IoTDBDataBackTool.getCreatePathMapping(dnDataDirs, targetDnDataDirs, "data"));
        Map<String, String> dnConsensusDirMap = IoTDBDataBackTool.getCreatePathMapping(Objects.requireNonNull(dnConsensusDir), bakDnConsensusDir, "consensus");
        Map<String, String> dnTracingDirMap = IoTDBDataBackTool.getCreatePathMapping(dnTracingDir, bakDnTracingDir, "tracing");
        Map<String, String> dnWalDirsMap = IoTDBDataBackTool.getCreatePathMapping(dnWalDirs, targetWalDirParam, "wal");
        copyMap.putAll(dnSystemDirMap);
        copyMap.putAll(dnConsensusDirMap);
        copyMap.putAll(dnWalDirsMap);
        copyMap.putAll(dnTracingDirMap);
        dnMapProperties.put("dn_system_dir", bakDnSystemDir);
        dnMapProperties.put("dn_data_dirs", targetDnDataDirs + remoteDnDataDir);
        dnMapProperties.put("dn_wal_dirs", targetWalDirParam);
        dnMapProperties.put("dn_tracing_dir", bakDnTracingDir);
        dnMapProperties.put("dn_consensus_dir", bakDnConsensusDir);
    }

    private static String isObjectStorage(String dnDataDirs) {
        StringBuilder tmpDnDataDirs = new StringBuilder();
        String[] patternDirs = dnDataDirs.split(";");
        for (int i = 0; i < patternDirs.length; ++i) {
            String patternDir = patternDirs[i];
            String[] subPatternDirs = patternDir.split(",");
            for (int c = 0; c < subPatternDirs.length; ++c) {
                if (c == subPatternDirs.length - 1 && i == patternDirs.length - 1) {
                    if (subPatternDirs[c].equals("OBJECT_STORAGE")) {
                        IS_OBJECT_STORAGE = true;
                        continue;
                    }
                    tmpDnDataDirs.append(subPatternDirs[c]);
                    continue;
                }
                tmpDnDataDirs.append(subPatternDirs[c]);
                if (subPatternDirs.length > 1 && c < subPatternDirs.length - 1) {
                    tmpDnDataDirs.append(",");
                    continue;
                }
                if (patternDirs.length <= 1 || i >= patternDirs.length - 1) continue;
                tmpDnDataDirs.append(";");
            }
        }
        if (IS_OBJECT_STORAGE) {
            return tmpDnDataDirs.toString().substring(0, tmpDnDataDirs.toString().length() - 1);
        }
        return tmpDnDataDirs.toString();
    }

    private static void countConfigNodeFile(String targetDirString, Map<String, String> copyMap, Map<String, String> cnMapProperties) {
        Properties configProperties = IoTDBDataBackTool.getProperties("iotdb-system.properties");
        IoTDBDataBackTool.initConfigNodeProperties(configProperties);
        String bakCnSystemDir = targetDirString + File.separatorChar + DEFAULT_CN_SYSTEM_DIR;
        String bakCnConsensusDir = targetDirString + File.separatorChar + DEFAULT_CN_CONSENSUS_DIR;
        String cnSystemDir = configProperties.getProperty("cn_system_dir");
        String cnConsensusDir = configProperties.getProperty("cn_consensus_dir");
        cnSystemDir = IoTDBDataBackTool.pathHandler(cnSystemDir);
        cnConsensusDir = IoTDBDataBackTool.pathHandler(cnConsensusDir);
        Map<String, String> cnSystemDirMap = IoTDBDataBackTool.getCreatePathMapping(cnSystemDir, bakCnSystemDir, "system");
        Map<String, String> cnConsensusDirMap = IoTDBDataBackTool.getCreatePathMapping(cnConsensusDir, bakCnConsensusDir, "consensus");
        copyMap.putAll(cnSystemDirMap);
        copyMap.putAll(cnConsensusDirMap);
        cnMapProperties.put("cn_system_dir", bakCnSystemDir);
        cnMapProperties.put("cn_consensus_dir", bakCnConsensusDir);
    }

    private static String pathHandler(String pathsList) {
        StringBuilder pathStrb = new StringBuilder();
        String[] pathList = pathsList.split(";");
        for (int t = 0; t < pathList.length; ++t) {
            String paths = pathList[t];
            String[] dirList = paths.split(",");
            for (int i = 0; i < dirList.length; ++i) {
                if (IoTDBDataBackTool.isRelativePath(dirList[i])) {
                    if (i == 0) {
                        pathStrb.append(sourcePath).append(File.separatorChar).append(dirList[i]);
                        continue;
                    }
                    pathStrb.append(",");
                    pathStrb.append(sourcePath).append(File.separatorChar).append(dirList[i]);
                    continue;
                }
                if (i == 0) {
                    pathStrb.append(dirList[i]);
                    continue;
                }
                pathStrb.append(",");
                pathStrb.append(dirList[i]);
            }
            if (t >= pathList.length - 1) continue;
            pathStrb.append(";");
        }
        return pathStrb.toString();
    }

    private static boolean isRelativePath(String path) {
        Path p = Paths.get(path, new String[0]);
        return !p.isAbsolute();
    }

    public static String sourceWalCoverTargetWalDirsHandler(String dnDirs, String targetDirs) {
        String[] sourcePathList = dnDirs.split(",");
        StringBuilder subTargetDataDir = new StringBuilder();
        for (int i = 0; i < sourcePathList.length; ++i) {
            if (i == sourcePathList.length - 1) {
                if (sourcePathList.length == 1) {
                    subTargetDataDir.append(targetDirs);
                    continue;
                }
                subTargetDataDir.append(targetDirs).append(File.separatorChar).append("wal").append(i + 1);
                continue;
            }
            subTargetDataDir.append(targetDirs).append(File.separatorChar).append("wal").append(i + 1).append(",");
        }
        return subTargetDataDir.toString();
    }

    public static void propertiesFileUpdate(String sourcePropertiesPath, Map<String, String> mapProperties) {
        for (Map.Entry<String, String> entry : mapProperties.entrySet()) {
            IoTDBDataBackTool.propertiesFileUpdate(sourcePropertiesPath, entry.getKey(), entry.getValue());
        }
    }

    public static String getCreateDnDataPathString(String resourcePath, String targetPath, String dirType) {
        String[] sourcePathsList = resourcePath.split(";");
        String[] targetPathsList = targetPath.split(";");
        StringBuilder pathStrb = new StringBuilder();
        if (sourcePathsList.length != targetPathsList.length) {
            int num = 1;
            for (int i = 0; i < sourcePathsList.length; ++i) {
                String[] sourcePathArray = sourcePathsList[i].split(",");
                for (int j = 0; j < sourcePathArray.length; ++j) {
                    String newPath = targetPathsList[0];
                    newPath = sourcePathsList.length == 1 && targetPathsList.length == 1 && sourcePathArray.length == 1 ? newPath + File.separatorChar + dirType : newPath + File.separatorChar + dirType + num;
                    pathStrb.append(newPath);
                    if (j < sourcePathArray.length - 1) {
                        pathStrb.append(",");
                    }
                    ++num;
                }
                if (i >= sourcePathsList.length - 1) continue;
                pathStrb.append(";");
            }
        } else {
            int num = 1;
            for (int i = 0; i < sourcePathsList.length; ++i) {
                int j;
                String[] targetPathArray;
                String[] sourcePathArray = sourcePathsList[i].split(",");
                if (sourcePathArray.length != (targetPathArray = targetPathsList[i].split(",")).length) {
                    if (targetPathArray.length == 1) {
                        for (j = 0; j < sourcePathArray.length; ++j) {
                            String newPath = sourcePathsList.length == 1 && targetPathsList.length == 1 && sourcePathArray.length == 1 ? targetPathArray[0] + File.separatorChar + dirType : targetPathArray[0] + File.separatorChar + dirType + num;
                            pathStrb.append(newPath);
                            if (j < sourcePathArray.length - 1) {
                                pathStrb.append(",");
                            }
                            ++num;
                        }
                    } else {
                        for (j = 0; j < sourcePathArray.length; ++j) {
                            pathStrb.append(targetPathArray[j]);
                            if (j >= sourcePathArray.length - 1) continue;
                            pathStrb.append(",");
                        }
                    }
                } else {
                    for (j = 0; j < sourcePathArray.length; ++j) {
                        pathStrb.append(targetPathArray[j]);
                        if (j >= sourcePathArray.length - 1) continue;
                        pathStrb.append(",");
                    }
                }
                if (sourcePathsList.length <= 1 || i >= sourcePathsList.length - 1) continue;
                pathStrb.append(";");
            }
        }
        return pathStrb.toString();
    }

    public static Map<String, String> getCreatePathMapping(String resourcePath, String targetPath, String dirType) {
        String[] targetPathsList;
        HashMap<String, String> map = new HashMap<String, String>();
        String[] sourcePathsList = resourcePath.split(";");
        if (sourcePathsList.length != (targetPathsList = targetPath.split(";")).length) {
            int num = 1;
            for (int i = 0; i < sourcePathsList.length; ++i) {
                String[] sourcePathArray = sourcePathsList[i].split(",");
                for (int j = 0; j < sourcePathArray.length; ++j) {
                    String newPath = targetPathsList[0];
                    newPath = sourcePathsList.length == 1 && targetPathsList.length == 1 && sourcePathArray.length == 1 ? newPath + File.separatorChar + dirType : newPath + File.separatorChar + dirType + num;
                    IoTDBDataBackTool.createDirectory(newPath);
                    map.put(sourcePathArray[j], newPath);
                    ++num;
                }
            }
        } else {
            int num = 1;
            for (int i = 0; i < sourcePathsList.length; ++i) {
                int j;
                String[] targetPathArray;
                String[] sourcePathArray = sourcePathsList[i].split(",");
                if (sourcePathArray.length != (targetPathArray = targetPathsList[i].split(",")).length) {
                    if (targetPathArray.length == 1) {
                        for (j = 0; j < sourcePathArray.length; ++j) {
                            String newPath = sourcePathsList.length == 1 && targetPathsList.length == 1 && sourcePathArray.length == 1 ? targetPathArray[0] + File.separatorChar + dirType : targetPathArray[0] + File.separatorChar + dirType + num;
                            IoTDBDataBackTool.createDirectory(newPath);
                            map.put(sourcePathArray[j], newPath);
                            ++num;
                        }
                        continue;
                    }
                    for (j = 0; j < sourcePathArray.length; ++j) {
                        map.put(sourcePathArray[j], targetPathArray[j]);
                    }
                    continue;
                }
                for (j = 0; j < sourcePathArray.length; ++j) {
                    map.put(sourcePathArray[j], targetPathArray[j]);
                }
            }
        }
        return map;
    }

    public static boolean matchPattern(String input, String pattern) {
        if (input.contains(";") && pattern.contains(";")) {
            String[] patternDirs;
            String[] inputDirs = input.split(";");
            if (inputDirs.length != (patternDirs = pattern.split(";")).length) {
                return false;
            }
            for (int i = 0; i < inputDirs.length; ++i) {
                String inputDir = inputDirs[i];
                String patternDir = patternDirs[i];
                if (IoTDBDataBackTool.matchDirectory(inputDir, patternDir)) continue;
                return false;
            }
            return true;
        }
        if (pattern.contains(";") && !input.contains(";")) {
            return !input.contains(",");
        }
        if (!pattern.contains(";") && input.contains(";")) {
            return false;
        }
        return IoTDBDataBackTool.matchDirectory(input, pattern);
    }

    public static boolean targetPathVild(String pattern) {
        String[] patternDirs = pattern.split(";");
        for (int i = 0; i < patternDirs.length; ++i) {
            String[] subPatternDirs;
            String patternDir = patternDirs[i];
            for (String subPatternDir : subPatternDirs = patternDir.split(",")) {
                if (!IoTDBDataBackTool.isRelativePath(subPatternDir)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean matchDirectory(String inputDir, String patternDir) {
        String[] patternLevels;
        String[] inputLevels = inputDir.split(",");
        return inputLevels.length == (patternLevels = patternDir.split(",")).length || patternLevels.length == 1;
    }

    private static void initDataNodeProperties(Properties properties) {
        if (properties.getProperty("dn_system_dir") == null) {
            properties.setProperty("dn_system_dir", DEFAULT_DN_SYSTEM_DIR);
        }
        if (properties.getProperty("dn_consensus_dir") == null) {
            properties.setProperty("dn_consensus_dir", DEFAULT_DN_CONSENSUS_DIR);
        }
        if (properties.getProperty("dn_data_dirs") == null) {
            properties.setProperty("dn_data_dirs", DEFAULT_DN_DATA_DIRS);
        }
        if (properties.getProperty("dn_tracing_dir") == null) {
            properties.setProperty("dn_tracing_dir", DEFAULT_DN_TRACING_DIR);
        }
        if (properties.getProperty("dn_wal_dirs") == null) {
            properties.setProperty("dn_wal_dirs", DEFAULT_DN_WAL_DIRS);
        }
    }

    private static void initConfigNodeProperties(Properties properties) {
        if (properties.getProperty("cn_system_dir") == null) {
            properties.setProperty("cn_system_dir", DEFAULT_CN_SYSTEM_DIR);
        }
        if (properties.getProperty("cn_consensus_dir") == null) {
            properties.setProperty("cn_consensus_dir", DEFAULT_CN_CONSENSUS_DIR);
        }
    }

    private static Properties getProperties(String configName) {
        URL url = IoTDBDescriptor.getPropsUrl((String)configName);
        Properties properties = new Properties();
        if (url != null) {
            try (InputStream inputStream = url.openStream();){
                LOGGER.info("Start to read config file {}", (Object)url);
                properties.load(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return properties;
    }

    private static boolean filesAreEqual(Path file1, Path file2) throws IOException {
        long size2;
        long size1 = Files.size(file1);
        return size1 == (size2 = Files.size(file2));
    }

    public static void compareAndcopyDirectory(final File sourceDirectory, final File targetDirectory) {
        try {
            Files.walkFileTree(sourceDirectory.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path targetFile = targetDirectory.toPath().resolve(sourceDirectory.toPath().relativize(file));
                    if (Files.exists(file, new LinkOption[0])) {
                        cpmm.put(file.toFile().getAbsolutePath(), "1");
                        targetFileCount.incrementAndGet();
                        if (!Files.exists(targetFile, new LinkOption[0]) || !IoTDBDataBackTool.filesAreEqual(file, targetFile)) {
                            Files.copy(file, targetFile, StandardCopyOption.REPLACE_EXISTING);
                        }
                    }
                    if (processFileCount.get() > targetFileCount.get()) {
                        IoTDBDataBackTool.writeFileData(IoTDBDataBackTool.filename, processFileCount.get());
                        LOGGER.info("total file number:" + fileCount + ",verify the number of files:" + targetFileCount);
                    } else {
                        IoTDBDataBackTool.writeFileData(IoTDBDataBackTool.filename, targetFileCount.get());
                        LOGGER.info("total file number:" + fileCount + ",backup file number:" + targetFileCount);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    Path targetDir = targetDirectory.toPath().resolve(sourceDirectory.toPath().relativize(dir));
                    if (!Files.exists(targetDir, new LinkOption[0])) {
                        Files.createDirectories(targetDir, new FileAttribute[0]);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            LOGGER.error("copy file error {}", (Object)sourceDirectory, (Object)e);
        }
    }

    public static void createDirectory(String directoryPath) {
        File directory = new File(directoryPath);
        if (!directory.exists()) {
            boolean created = directory.mkdirs();
            if (created) {
                LOGGER.info("Directory created successfully:{}", (Object)directoryPath);
            } else {
                LOGGER.error("Failed to create directory:{}", (Object)directoryPath);
            }
        }
    }

    public static void compareAndLinkDirectory(final File sourceDirectory, final File targetDirectory) {
        try {
            Files.walkFileTree(sourceDirectory.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path targetFile = targetDirectory.toPath().resolve(sourceDirectory.toPath().relativize(file));
                    if (Files.exists(file, new LinkOption[0])) {
                        cpmm.put(file.toFile().getAbsolutePath(), "1");
                        targetFileCount.incrementAndGet();
                        if (!Files.exists(targetFile, new LinkOption[0]) || !IoTDBDataBackTool.filesAreEqual(file, targetFile)) {
                            try {
                                Files.createLink(targetFile, file);
                            }
                            catch (IOException | UnsupportedOperationException e) {
                                LOGGER.debug("link file error {}", (Throwable)e);
                                try {
                                    Files.copy(file, targetFile, StandardCopyOption.REPLACE_EXISTING);
                                }
                                catch (IOException ex) {
                                    targetFileCount.decrementAndGet();
                                    LOGGER.error("copy file error {}", (Throwable)ex);
                                }
                            }
                        }
                    }
                    if (processFileCount.get() > targetFileCount.get()) {
                        IoTDBDataBackTool.writeFileData(IoTDBDataBackTool.filename, processFileCount.get());
                        LOGGER.info("total file number:" + fileCount + ",verify the number of files:" + targetFileCount);
                    } else {
                        IoTDBDataBackTool.writeFileData(IoTDBDataBackTool.filename, targetFileCount.get());
                        LOGGER.info("total file number:" + fileCount + ",backup file number:" + targetFileCount);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    Path targetDir = targetDirectory.toPath().resolve(sourceDirectory.toPath().relativize(dir));
                    if (!Files.exists(targetDir, new LinkOption[0])) {
                        Files.createDirectories(targetDir, new FileAttribute[0]);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String formatPathForOS(String path) {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            return path.replace("\\", "\\\\");
        }
        return path;
    }

    public static void propertiesFileUpdate(String filePath, String key, String newValue) {
        try {
            ArrayList<String> lines;
            newValue = IoTDBDataBackTool.formatPathForOS(newValue);
            FileInputStream fileInputStream = new FileInputStream(filePath);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(fileInputStream));){
                String line;
                lines = new ArrayList<String>();
                while ((line = reader.readLine()) != null) {
                    lines.add(line);
                }
            }
            boolean keyFound = false;
            for (int i = 0; i < lines.size(); ++i) {
                int equalsIndex;
                String propertyKey;
                String currentLine = (String)lines.get(i);
                if ((currentLine = currentLine.trim()).startsWith("#") && currentLine.substring(1).trim().equals(key) || !currentLine.contains("=") || !(propertyKey = currentLine.substring(0, equalsIndex = currentLine.indexOf("=")).trim()).equals(key)) continue;
                lines.set(i, propertyKey + "=" + newValue);
                keyFound = true;
                break;
            }
            if (!keyFound) {
                lines.add(key + "=" + newValue);
            }
            FileOutputStream fileOutputStream = new FileOutputStream(filePath);
            PrintWriter printWriter = new PrintWriter(fileOutputStream);
            for (String fileLine : lines) {
                printWriter.println(fileLine);
            }
            printWriter.close();
            fileOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static int countFiles(String directoryPath) {
        IoTDBDataBackTool.countFilesRecursively(new File(directoryPath), fileCount);
        return fileCount.get();
    }

    private static void countFilesRecursively(File file, AtomicInteger fileCount) {
        if (file.isDirectory() && file.exists()) {
            File[] files = file.listFiles();
            if (files != null) {
                for (File subFile : files) {
                    IoTDBDataBackTool.countFilesRecursively(subFile, fileCount);
                }
            }
        } else if (file.exists()) {
            mm.put(file.getAbsolutePath(), "1");
            fileCount.incrementAndGet();
        }
    }

    public static int readFileData(String filename) {
        filename = sourcePath + File.separatorChar + "logs" + File.separatorChar + filename;
        IoTDBDataBackTool.createFile(filename);
        try {
            Path filePath = Paths.get(filename, new String[0]);
            List<String> lines = Files.readAllLines(filePath, StandardCharsets.UTF_8);
            if (!lines.isEmpty()) {
                return Integer.parseInt(lines.get(0));
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to read data from file: {}", (Object)filename, (Object)e);
        }
        return 0;
    }

    public static void delFile(String filename) throws IOException {
        filename = sourcePath + File.separatorChar + "logs" + File.separatorChar + filename;
        File file = new File(filename);
        if (file.exists()) {
            Files.delete(file.toPath());
        }
    }

    public static void writeFileData(String filename, int data) {
        filename = sourcePath + File.separatorChar + "logs" + File.separatorChar + filename;
        Path filePath = Paths.get(filename, new String[0]);
        try {
            Files.write(filePath, Integer.toString(data).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            LOGGER.error("Failed to write data to file: {}", (Object)filename, (Object)e);
        }
    }

    public static void createFile(String filename) {
        Path filePath = Paths.get(filename, new String[0]);
        if (!Files.exists(filePath, new LinkOption[0])) {
            try {
                Files.createFile(filePath, new FileAttribute[0]);
            }
            catch (IOException e) {
                LOGGER.error("Failed to create file: {}", (Object)filename, (Object)e);
            }
        }
    }
}

