/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.aggregation.timerangeiterator;

import org.apache.iotdb.db.queryengine.execution.aggregation.timerangeiterator.ITimeRangeIterator;
import org.apache.tsfile.read.common.TimeRange;

public class PreAggrWindowIterator
implements ITimeRangeIterator {
    private final long startTime;
    private final long endTime;
    private final long interval;
    private final long slidingStep;
    private final boolean isAscending;
    private final boolean leftCRightO;
    private long curInterval;
    private long curSlidingStep;
    private boolean isIntervalCyclicChange = false;
    private int intervalCnt = 0;
    private TimeRange curTimeRange;
    private boolean hasCachedTimeRange;

    public PreAggrWindowIterator(long startTime, long endTime, long interval, long slidingStep, boolean isAscending, boolean leftCRightO) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.interval = interval;
        this.slidingStep = slidingStep;
        this.isAscending = isAscending;
        this.leftCRightO = leftCRightO;
        this.initIntervalAndStep();
    }

    @Override
    public TimeRange getFirstTimeRange() {
        if (this.isAscending) {
            return this.getLeftmostTimeRange();
        }
        return this.getRightmostTimeRange();
    }

    private TimeRange getLeftmostTimeRange() {
        long retEndTime = Math.min(this.startTime + this.curInterval, this.endTime);
        this.updateIntervalAndStep();
        return new TimeRange(this.startTime, retEndTime);
    }

    private TimeRange getRightmostTimeRange() {
        long intervalNum = (long)Math.ceil((double)(this.endTime - this.startTime) / (double)this.slidingStep);
        long retStartTime = this.slidingStep * (intervalNum - 1L) + this.startTime;
        if (this.isIntervalCyclicChange && this.endTime - retStartTime > this.interval % this.slidingStep) {
            retStartTime += this.interval % this.slidingStep;
            this.updateIntervalAndStep();
        }
        long retEndTime = Math.min(retStartTime + this.curInterval, this.endTime);
        this.updateIntervalAndStep();
        return new TimeRange(retStartTime, retEndTime);
    }

    @Override
    public boolean hasNextTimeRange() {
        long retStartTime;
        if (this.hasCachedTimeRange) {
            return true;
        }
        if (this.curTimeRange == null) {
            this.curTimeRange = this.getFirstTimeRange();
            this.hasCachedTimeRange = true;
            return true;
        }
        long curStartTime = this.curTimeRange.getMin();
        if (this.isAscending ? (retStartTime = curStartTime + this.curSlidingStep) >= this.endTime : (retStartTime = curStartTime - this.curSlidingStep) < this.startTime) {
            return false;
        }
        long retEndTime = Math.min(retStartTime + this.curInterval, this.endTime);
        this.updateIntervalAndStep();
        this.curTimeRange = new TimeRange(retStartTime, retEndTime);
        this.hasCachedTimeRange = true;
        return true;
    }

    @Override
    public TimeRange nextTimeRange() {
        if (this.hasCachedTimeRange || this.hasNextTimeRange()) {
            this.hasCachedTimeRange = false;
            return this.getFinalTimeRange(this.curTimeRange, this.leftCRightO);
        }
        return null;
    }

    private void initIntervalAndStep() {
        if (this.slidingStep >= this.interval) {
            this.curInterval = this.interval;
            this.curSlidingStep = this.slidingStep;
        } else if (this.interval % this.slidingStep == 0L) {
            this.curInterval = this.slidingStep;
            this.curSlidingStep = this.slidingStep;
        } else {
            this.isIntervalCyclicChange = true;
            this.curSlidingStep = this.curInterval = this.interval % this.slidingStep;
        }
    }

    private void updateIntervalAndStep() {
        if (!this.isIntervalCyclicChange) {
            return;
        }
        if (this.isAscending) {
            this.curSlidingStep = this.curInterval;
        }
        ++this.intervalCnt;
        this.curInterval = (this.intervalCnt & 1) == 1 ? this.slidingStep - this.interval % this.slidingStep : this.interval % this.slidingStep;
        if (!this.isAscending) {
            this.curSlidingStep = this.curInterval;
        }
    }

    @Override
    public boolean isAscending() {
        return this.isAscending;
    }

    @Override
    public long currentOutputTime() {
        return this.leftCRightO ? this.curTimeRange.getMin() : this.curTimeRange.getMax();
    }

    @Override
    public long getTotalIntervalNum() {
        long queryRange = this.endTime - this.startTime;
        if (this.slidingStep >= this.interval || this.interval % this.slidingStep == 0L) {
            return (long)Math.ceil((double)queryRange / (double)this.slidingStep);
        }
        long interval1 = this.interval % this.slidingStep;
        long interval2 = this.slidingStep - this.interval % this.slidingStep;
        long intervalNum = Math.floorDiv(queryRange, interval1 + interval2);
        long tmpStartTime = this.startTime + intervalNum * (interval1 + interval2);
        if (tmpStartTime + interval1 > this.endTime) {
            return intervalNum * 2L + 1L;
        }
        return intervalNum * 2L + 2L;
    }
}

