/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.unary.scalar;

import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.unary.UnaryColumnTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.utils.BytesUtils;

public class SubStringFunctionColumnTransformer
extends UnaryColumnTransformer {
    private int beginPosition;
    private int endPosition;
    public static final String EMPTY_STRING = "";

    public SubStringFunctionColumnTransformer(Type returnType, ColumnTransformer childColumnTransformer, int beginPosition, int length) {
        super(returnType, childColumnTransformer);
        this.endPosition = length == Integer.MAX_VALUE ? Integer.MAX_VALUE : beginPosition + length - 1;
        this.beginPosition = beginPosition > 0 ? beginPosition - 1 : 0;
    }

    @Override
    protected void doTransform(Column column, ColumnBuilder columnBuilder) {
        int n = column.getPositionCount();
        for (int i = 0; i < n; ++i) {
            if (!column.isNull(i)) {
                String currentValue = column.getBinary(i).getStringValue(TSFileConfig.STRING_CHARSET);
                currentValue = this.beginPosition >= currentValue.length() || this.endPosition < 0 ? EMPTY_STRING : (this.endPosition >= currentValue.length() ? currentValue.substring(this.beginPosition) : currentValue.substring(this.beginPosition, this.endPosition));
                columnBuilder.writeBinary(BytesUtils.valueOf((String)currentValue));
                continue;
            }
            columnBuilder.appendNull();
        }
    }
}

