/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.datastructure;

import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.read.common.block.column.TimeColumn;

public class TVColumns {
    private boolean isConstant;
    private TimeColumn timeColumn;
    private Column valueColumn;

    public TVColumns(TimeColumn timeColumn, Column valueColumn) {
        this.timeColumn = timeColumn;
        this.valueColumn = valueColumn;
        this.isConstant = false;
    }

    public TVColumns(Column valueColumn) {
        this.valueColumn = valueColumn;
        this.isConstant = true;
    }

    public int getPositionCount() {
        return this.valueColumn.getPositionCount();
    }

    public long getTimeByIndex(int index) {
        if (this.isConstant) {
            throw new UnsupportedOperationException();
        }
        return this.timeColumn.getLong(index);
    }

    public long getEndTime() {
        if (this.isConstant) {
            throw new UnsupportedOperationException();
        }
        return this.timeColumn.getEndTime();
    }

    public Column getValueColumn() {
        return this.valueColumn;
    }

    public Column getTimeColumn() {
        if (this.isConstant) {
            throw new UnsupportedOperationException();
        }
        return this.timeColumn;
    }

    public boolean isConstant() {
        return this.isConstant;
    }
}

