/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.load.limiter;

import com.google.common.util.concurrent.AtomicDouble;
import com.google.common.util.concurrent.RateLimiter;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.storageengine.load.metrics.LoadTsFileCostMetricsSet;

public class LoadTsFileRateLimiter {
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private final AtomicDouble throughputBytesPerSecond = new AtomicDouble(CONFIG.getLoadWriteThroughputBytesPerSecond());
    private final RateLimiter loadWriteRateLimiter;

    public void acquire(long bytes) {
        LoadTsFileCostMetricsSet.getInstance().recordDiskIO(bytes);
        if (this.reloadParams()) {
            return;
        }
        while (bytes > 0L) {
            if (bytes > Integer.MAX_VALUE) {
                this.tryAcquireWithRateCheck(Integer.MAX_VALUE);
                bytes -= Integer.MAX_VALUE;
                continue;
            }
            this.tryAcquireWithRateCheck((int)bytes);
            return;
        }
    }

    private void tryAcquireWithRateCheck(int bytes) {
        while (!this.loadWriteRateLimiter.tryAcquire(bytes, (long)PipeConfig.getInstance().getRateLimiterHotReloadCheckIntervalMs(), TimeUnit.MILLISECONDS)) {
            if (!this.reloadParams()) continue;
            return;
        }
    }

    private boolean reloadParams() {
        double throughputBytesPerSecondLimit = CONFIG.getLoadWriteThroughputBytesPerSecond();
        if (this.throughputBytesPerSecond.get() != throughputBytesPerSecondLimit) {
            this.throughputBytesPerSecond.set(throughputBytesPerSecondLimit);
            this.loadWriteRateLimiter.setRate(throughputBytesPerSecondLimit <= 0.0 ? Double.MAX_VALUE : throughputBytesPerSecondLimit);
        }
        return throughputBytesPerSecondLimit <= 0.0;
    }

    private LoadTsFileRateLimiter() {
        double throughputBytesPerSecondLimit = this.throughputBytesPerSecond.get();
        this.loadWriteRateLimiter = throughputBytesPerSecondLimit <= 0.0 ? RateLimiter.create((double)Double.MAX_VALUE) : RateLimiter.create((double)throughputBytesPerSecondLimit);
    }

    public static LoadTsFileRateLimiter getInstance() {
        return LoadTsFileRateLimiterHolder.INSTANCE;
    }

    private static class LoadTsFileRateLimiterHolder {
        private static final LoadTsFileRateLimiter INSTANCE = new LoadTsFileRateLimiter();

        private LoadTsFileRateLimiterHolder() {
        }
    }
}

