/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.factory.map.primitive.ImmutableObjectCharMapFactory;
import org.eclipse.collections.api.map.primitive.ImmutableObjectCharMap;
import org.eclipse.collections.api.map.primitive.MutableObjectCharMap;
import org.eclipse.collections.api.map.primitive.ObjectCharMap;
import org.eclipse.collections.impl.factory.primitive.ObjectCharMaps;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableObjectCharEmptyMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableObjectCharHashMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableObjectCharSingletonMap;

public class ImmutableObjectCharMapFactoryImpl
implements ImmutableObjectCharMapFactory {
    public static final ImmutableObjectCharMapFactory INSTANCE = new ImmutableObjectCharMapFactoryImpl();

    @Override
    public <K> ImmutableObjectCharMap<K> empty() {
        return ImmutableObjectCharEmptyMap.INSTANCE;
    }

    @Override
    public <K> ImmutableObjectCharMap<K> of() {
        return this.empty();
    }

    @Override
    public <K> ImmutableObjectCharMap<K> with() {
        return this.empty();
    }

    @Override
    public <K> ImmutableObjectCharMap<K> of(K key, char value) {
        return this.with(key, value);
    }

    @Override
    public <K> ImmutableObjectCharMap<K> with(K key, char value) {
        return new ImmutableObjectCharSingletonMap<K>(key, value);
    }

    @Override
    public <K> ImmutableObjectCharMap<K> ofAll(ObjectCharMap<? extends K> map) {
        return this.withAll(map);
    }

    @Override
    public <K> ImmutableObjectCharMap<K> withAll(ObjectCharMap<? extends K> map) {
        if (map instanceof ImmutableObjectCharMap) {
            return (ImmutableObjectCharMap)map;
        }
        if (map.isEmpty()) {
            return this.with();
        }
        if (map.size() == 1) {
            Object[] array = new Object[1];
            map.forEachKey(each -> {
                array[0] = each;
            });
            return new ImmutableObjectCharSingletonMap<Object>(array[0], map.get(array[0]));
        }
        return new ImmutableObjectCharHashMap<K>(map);
    }

    @Override
    public <T, K> ImmutableObjectCharMap<K> from(Iterable<T> iterable, Function<? super T, ? extends K> keyFunction, CharFunction<? super T> valueFunction) {
        MutableObjectCharMap<K> map = ObjectCharMaps.mutable.from(iterable, keyFunction, valueFunction);
        return map.toImmutable();
    }
}

