/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server.logging.error;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.net.SocketAddress;
import java.util.function.Function;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.http.server.HttpServerInfos;
import reactor.netty.http.server.logging.error.BaseErrorLogHandler;
import reactor.netty.http.server.logging.error.DefaultErrorLogArgProvider;
import reactor.netty.http.server.logging.error.DefaultErrorLogEvent;
import reactor.netty.http.server.logging.error.ErrorLog;
import reactor.netty.http.server.logging.error.ErrorLogArgProvider;
import reactor.util.annotation.Nullable;

public final class DefaultErrorLogHandler
extends BaseErrorLogHandler {
    private DefaultErrorLogArgProvider errorLogArgProvider;

    public DefaultErrorLogHandler(@Nullable Function<ErrorLogArgProvider, ErrorLog> errorLog) {
        super(errorLog);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (this.errorLogArgProvider == null) {
            ChannelOperations ops = ChannelOperations.get((Channel)ctx.channel());
            SocketAddress remoteAddress = ops instanceof HttpServerInfos ? ((HttpServerInfos)ops).connectionRemoteAddress() : ctx.channel().remoteAddress();
            this.errorLogArgProvider = new DefaultErrorLogArgProvider(remoteAddress);
        } else {
            this.errorLogArgProvider.clear();
        }
        this.errorLogArgProvider.applyConnectionInfo(ctx.channel());
        this.errorLogArgProvider.applyThrowable(cause);
        ErrorLog log = (ErrorLog)this.errorLog.apply(this.errorLogArgProvider);
        if (log != null) {
            log.log();
        }
        ctx.fireExceptionCaught(cause);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (evt instanceof DefaultErrorLogEvent) {
            this.exceptionCaught(ctx, ((DefaultErrorLogEvent)evt).cause());
        }
        ctx.fireUserEventTriggered(evt);
    }
}

