/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.sink.protocol.opcua;

import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.iotdb.commons.pipe.config.constant.PipeSinkConstant;
import org.apache.iotdb.db.pipe.sink.protocol.opcua.OpcUaKeyStoreLoader;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.api.config.OpcUaServerConfig;
import org.eclipse.milo.opcua.sdk.server.identity.CompositeValidator;
import org.eclipse.milo.opcua.sdk.server.identity.IdentityValidator;
import org.eclipse.milo.opcua.sdk.server.identity.UsernameIdentityValidator;
import org.eclipse.milo.opcua.sdk.server.identity.X509IdentityValidator;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.ServerTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.util.HostnameUtil;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaRuntimeException;
import org.eclipse.milo.opcua.stack.core.security.CertificateManager;
import org.eclipse.milo.opcua.stack.core.security.DefaultCertificateManager;
import org.eclipse.milo.opcua.stack.core.security.DefaultTrustListManager;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.security.TrustListManager;
import org.eclipse.milo.opcua.stack.core.transport.TransportProfile;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MessageSecurityMode;
import org.eclipse.milo.opcua.stack.core.types.structured.BuildInfo;
import org.eclipse.milo.opcua.stack.core.types.structured.UserTokenPolicy;
import org.eclipse.milo.opcua.stack.core.util.CertificateUtil;
import org.eclipse.milo.opcua.stack.core.util.SelfSignedCertificateGenerator;
import org.eclipse.milo.opcua.stack.core.util.SelfSignedHttpsCertificateBuilder;
import org.eclipse.milo.opcua.stack.server.EndpointConfiguration;
import org.eclipse.milo.opcua.stack.server.security.DefaultServerCertificateValidator;
import org.eclipse.milo.opcua.stack.server.security.ServerCertificateValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpcUaServerBuilder
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpcUaServerBuilder.class);
    private static final String WILD_CARD_ADDRESS = "0.0.0.0";
    private int tcpBindPort = 12686;
    private int httpsBindPort = 8443;
    private String user = "root";
    private String password = "root";
    private Path securityDir = Paths.get(PipeSinkConstant.CONNECTOR_OPC_UA_SECURITY_DIR_DEFAULT_VALUE, new String[0]);
    private boolean enableAnonymousAccess = true;
    private DefaultTrustListManager trustListManager;

    OpcUaServerBuilder() {
    }

    OpcUaServerBuilder setTcpBindPort(int tcpBindPort) {
        this.tcpBindPort = tcpBindPort;
        return this;
    }

    OpcUaServerBuilder setHttpsBindPort(int httpsBindPort) {
        this.httpsBindPort = httpsBindPort;
        return this;
    }

    OpcUaServerBuilder setUser(String user) {
        this.user = user;
        return this;
    }

    OpcUaServerBuilder setPassword(String password) {
        this.password = password;
        return this;
    }

    OpcUaServerBuilder setSecurityDir(String securityDir) {
        this.securityDir = Paths.get(securityDir, new String[0]);
        return this;
    }

    OpcUaServerBuilder setEnableAnonymousAccess(boolean enableAnonymousAccess) {
        this.enableAnonymousAccess = enableAnonymousAccess;
        return this;
    }

    OpcUaServer build() throws Exception {
        Files.createDirectories(this.securityDir, new FileAttribute[0]);
        if (!Files.exists(this.securityDir, new LinkOption[0])) {
            throw new PipeException("Unable to create security dir: " + this.securityDir);
        }
        File pkiDir = this.securityDir.resolve("pki").toFile();
        LoggerFactory.getLogger(OpcUaServerBuilder.class).info("Security dir: {}", (Object)this.securityDir.toAbsolutePath());
        LoggerFactory.getLogger(OpcUaServerBuilder.class).info("Security pki dir: {}", (Object)pkiDir.getAbsolutePath());
        OpcUaKeyStoreLoader loader = new OpcUaKeyStoreLoader().load(this.securityDir, this.password.toCharArray());
        DefaultCertificateManager certificateManager = new DefaultCertificateManager(loader.getServerKeyPair(), loader.getServerCertificate());
        this.trustListManager = new DefaultTrustListManager(pkiDir);
        LOGGER.info("Certificate directory is: {}, Please move certificates from the reject dir to the trusted directory to allow encrypted access", (Object)pkiDir.getAbsolutePath());
        KeyPair httpsKeyPair = SelfSignedCertificateGenerator.generateRsaKeyPair((int)2048);
        SelfSignedHttpsCertificateBuilder httpsCertificateBuilder = new SelfSignedHttpsCertificateBuilder(httpsKeyPair);
        httpsCertificateBuilder.setCommonName(HostnameUtil.getHostname());
        HostnameUtil.getHostnames((String)WILD_CARD_ADDRESS).forEach(arg_0 -> ((SelfSignedHttpsCertificateBuilder)httpsCertificateBuilder).addDnsName(arg_0));
        X509Certificate httpsCertificate = httpsCertificateBuilder.build();
        DefaultServerCertificateValidator certificateValidator = new DefaultServerCertificateValidator((TrustListManager)this.trustListManager);
        UsernameIdentityValidator identityValidator = new UsernameIdentityValidator(this.enableAnonymousAccess, authChallenge -> authChallenge.getUsername().equals(this.user) && authChallenge.getPassword().equals(this.password));
        X509IdentityValidator x509IdentityValidator = new X509IdentityValidator(c -> true);
        X509Certificate certificate = (X509Certificate)certificateManager.getCertificates().stream().findFirst().orElseThrow(() -> new UaRuntimeException(0x80890000L, "No certificate found"));
        String applicationUri = (String)CertificateUtil.getSanUri((X509Certificate)certificate).orElseThrow(() -> new UaRuntimeException(0x80890000L, "Certificate is missing the application URI"));
        Set<EndpointConfiguration> endpointConfigurations = this.createEndpointConfigurations(certificate, this.tcpBindPort, this.httpsBindPort);
        OpcUaServerConfig serverConfig = OpcUaServerConfig.builder().setApplicationUri(applicationUri).setApplicationName(LocalizedText.english((String)"Apache IoTDB OPC UA server")).setEndpoints(endpointConfigurations).setBuildInfo(new BuildInfo("urn:apache:iotdb:opc-ua-server", "apache", "Apache IoTDB OPC UA server", OpcUaServer.SDK_VERSION, "", DateTime.now())).setCertificateManager((CertificateManager)certificateManager).setTrustListManager((TrustListManager)this.trustListManager).setCertificateValidator((ServerCertificateValidator)certificateValidator).setHttpsKeyPair(httpsKeyPair).setHttpsCertificateChain(new X509Certificate[]{httpsCertificate}).setIdentityValidator((IdentityValidator)new CompositeValidator(new IdentityValidator[]{identityValidator, x509IdentityValidator})).setProductUri("urn:apache:iotdb:opc-ua-server").build();
        OpcUaServer server = new OpcUaServer(serverConfig);
        UaNode serverNode = server.getAddressSpaceManager().getManagedNode(Identifiers.Server).orElse(null);
        if (serverNode instanceof ServerTypeNode) {
            ((ServerTypeNode)serverNode).setEventNotifier(Unsigned.ubyte((int)1));
        }
        return server;
    }

    private Set<EndpointConfiguration> createEndpointConfigurations(X509Certificate certificate, int tcpBindPort, int httpsBindPort) {
        LinkedHashSet<EndpointConfiguration> endpointConfigurations = new LinkedHashSet<EndpointConfiguration>();
        ArrayList bindAddresses = Lists.newArrayList();
        bindAddresses.add(WILD_CARD_ADDRESS);
        LinkedHashSet<String> hostnames = new LinkedHashSet<String>();
        hostnames.add(HostnameUtil.getHostname());
        hostnames.addAll(HostnameUtil.getHostnames((String)WILD_CARD_ADDRESS));
        for (String bindAddress : bindAddresses) {
            for (String hostname : hostnames) {
                EndpointConfiguration.Builder builder = EndpointConfiguration.newBuilder().setBindAddress(bindAddress).setHostname(hostname).setPath("/iotdb").setCertificate(certificate).addTokenPolicies(new UserTokenPolicy[]{OpcUaServerConfig.USER_TOKEN_POLICY_ANONYMOUS, OpcUaServerConfig.USER_TOKEN_POLICY_USERNAME, OpcUaServerConfig.USER_TOKEN_POLICY_X509});
                EndpointConfiguration.Builder noSecurityBuilder = builder.copy().setSecurityPolicy(SecurityPolicy.None).setSecurityMode(MessageSecurityMode.None);
                endpointConfigurations.add(this.buildTcpEndpoint(noSecurityBuilder, tcpBindPort));
                endpointConfigurations.add(this.buildHttpsEndpoint(noSecurityBuilder, httpsBindPort));
                endpointConfigurations.add(this.buildTcpEndpoint(builder.copy().setSecurityPolicy(SecurityPolicy.Basic256Sha256).setSecurityMode(MessageSecurityMode.SignAndEncrypt), tcpBindPort));
                endpointConfigurations.add(this.buildHttpsEndpoint(builder.copy().setSecurityPolicy(SecurityPolicy.Basic256Sha256).setSecurityMode(MessageSecurityMode.Sign), httpsBindPort));
                EndpointConfiguration.Builder discoveryBuilder = builder.copy().setPath("/iotdb/discovery").setSecurityPolicy(SecurityPolicy.None).setSecurityMode(MessageSecurityMode.None);
                endpointConfigurations.add(this.buildTcpEndpoint(discoveryBuilder, tcpBindPort));
                endpointConfigurations.add(this.buildHttpsEndpoint(discoveryBuilder, httpsBindPort));
            }
        }
        return endpointConfigurations;
    }

    private EndpointConfiguration buildTcpEndpoint(EndpointConfiguration.Builder base, int tcpBindPort) {
        return base.copy().setTransportProfile(TransportProfile.TCP_UASC_UABINARY).setBindPort(tcpBindPort).build();
    }

    private EndpointConfiguration buildHttpsEndpoint(EndpointConfiguration.Builder base, int httpsBindPort) {
        return base.copy().setTransportProfile(TransportProfile.HTTPS_UABINARY).setBindPort(httpsBindPort).build();
    }

    void checkEquals(String user, String password, Path securityDir, boolean enableAnonymousAccess) {
        this.checkEquals("user", this.user, user);
        this.checkEquals("password", this.password, password);
        this.checkEquals("security dir", FileSystems.getDefault().getPath(this.securityDir.toAbsolutePath().toString(), new String[0]), FileSystems.getDefault().getPath(securityDir.toAbsolutePath().toString(), new String[0]));
        this.checkEquals("enableAnonymousAccess option", this.enableAnonymousAccess, enableAnonymousAccess);
    }

    private void checkEquals(String attrName, Object thisAttr, Object thatAttr) {
        if (!Objects.equals(thisAttr, thatAttr)) {
            throw new PipeException(String.format("The existing server with tcp port %s and https port %s's %s %s conflicts to the new %s %s, reject reusing.", this.tcpBindPort, this.httpsBindPort, attrName, thisAttr, attrName, thatAttr));
        }
    }

    @Override
    public void close() {
        if (Objects.nonNull(this.trustListManager)) {
            try {
                this.trustListManager.close();
            }
            catch (IOException e) {
                LOGGER.warn("Failed to close trustListManager, because {}.", (Object)e.getMessage());
            }
        }
    }
}

