/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.input;

import java.util.List;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.transformation.api.YieldableState;
import org.apache.iotdb.db.queryengine.transformation.dag.input.IUDFInputDataSet;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;

public class TsBlockInputDataSet
implements IUDFInputDataSet {
    private final Operator operator;
    private final List<TSDataType> dataTypes;
    private TsBlock tsBlock;

    public TsBlockInputDataSet(Operator operator, List<TSDataType> dataTypes) {
        this.operator = operator;
        this.dataTypes = dataTypes;
    }

    @Override
    public List<TSDataType> getDataTypes() {
        return this.dataTypes;
    }

    @Override
    public YieldableState yield() throws Exception {
        if (this.tsBlock == null) {
            if (this.operator.isBlocked() != Operator.NOT_BLOCKED) {
                return YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA;
            }
            if (!this.operator.hasNextWithTimer()) {
                return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
            }
            this.tsBlock = this.operator.nextWithTimer();
            if (this.tsBlock == null) {
                return YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA;
            }
        }
        return YieldableState.YIELDABLE;
    }

    @Override
    public Column[] currentBlock() {
        Column[] rows = this.tsBlock.getAllColumns();
        this.tsBlock = null;
        return rows;
    }
}

