/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.vertx.ws;

import io.vertx.core.http.WebSocketBase;
import java.util.concurrent.CompletableFuture;
import org.apache.servicecomb.common.rest.filter.HttpServerFilter;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.foundation.vertx.http.HttpServletRequestEx;
import org.apache.servicecomb.foundation.vertx.http.HttpServletResponseEx;
import org.apache.servicecomb.foundation.vertx.http.VertxServerRequestToHttpServletRequest;
import org.apache.servicecomb.swagger.invocation.InvocationType;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.ws.AbstractBaseWebSocket;
import org.apache.servicecomb.swagger.invocation.ws.ServerWebSocket;
import org.apache.servicecomb.swagger.invocation.ws.WebSocketPipe;
import org.apache.servicecomb.transport.rest.vertx.ws.VertxWebSocketAdaptor;

public class WebSocketHandshakeServerFilter
implements HttpServerFilter {
    public static final String WEBSOCKET_PIPE_CONTEXT_KEY = "x-scb-websocket-pipe";

    public int getOrder() {
        return 0;
    }

    public boolean enabledForTransport(String transport) {
        return "websocket".equals(transport);
    }

    public Response afterReceiveRequest(Invocation invocation, HttpServletRequestEx requestEx) {
        if (invocation.isEdge() && invocation.getLocalContext(WEBSOCKET_PIPE_CONTEXT_KEY) == null) {
            WebSocketPipe webSocketPipe = new WebSocketPipe(invocation.getTraceId());
            invocation.addLocalContext(WEBSOCKET_PIPE_CONTEXT_KEY, (Object)webSocketPipe);
            invocation.addLocalContext("scb-client-websocket", (Object)webSocketPipe.getClientWebSocket());
        }
        return null;
    }

    public CompletableFuture<Void> beforeSendResponseAsync(Invocation invocation, HttpServletResponseEx responseEx) {
        Response response;
        Object result;
        if (invocation == null) {
            return CompletableFuture.completedFuture(null);
        }
        if ("websocket".equals(invocation.getProviderTransportName()) && invocation.getRequestEx() instanceof VertxServerRequestToHttpServletRequest && (result = (response = (Response)responseEx.getAttribute("servicecomb-invocation-hanlder-response")).getResult()) instanceof ServerWebSocket) {
            ((VertxServerRequestToHttpServletRequest)invocation.getRequestEx()).toWebSocket().whenComplete((ws, t) -> new VertxWebSocketAdaptor(invocation, InvocationType.PRODUCER, invocation.getOperationMeta().getExecutor(), (AbstractBaseWebSocket)((ServerWebSocket)result), (WebSocketBase)ws));
        }
        return super.beforeSendResponseAsync(invocation, responseEx);
    }
}

