/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.filter;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.servicecomb.common.rest.filter.HttpServerFilter;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.foundation.vertx.http.HttpServletResponseEx;

public class HttpServerFilterBeforeSendResponseExecutor {
    private final List<HttpServerFilter> httpServerFilters;
    private final Invocation invocation;
    private final HttpServletResponseEx responseEx;
    private int currentIndex;
    private final CompletableFuture<Void> future = new CompletableFuture();

    public HttpServerFilterBeforeSendResponseExecutor(List<HttpServerFilter> httpServerFilters, Invocation invocation, HttpServletResponseEx responseEx) {
        this.httpServerFilters = httpServerFilters;
        this.invocation = invocation;
        this.responseEx = responseEx;
    }

    public CompletableFuture<Void> run() {
        this.doRun();
        return this.future;
    }

    protected CompletableFuture<Void> safeInvoke(HttpServerFilter httpServerFilter) {
        try {
            String providerTransportName;
            String string = providerTransportName = this.invocation == null ? null : this.invocation.getProviderTransportName();
            if (httpServerFilter.enabled() && httpServerFilter.enabledForTransport(providerTransportName)) {
                CompletableFuture<Void> future = httpServerFilter.beforeSendResponseAsync(this.invocation, this.responseEx);
                if (future == null) {
                    future = new CompletableFuture();
                    future.completeExceptionally(new IllegalStateException("HttpServerFilter beforeSendResponseAsync can not return null. Class=" + httpServerFilter.getClass().getName()));
                }
                return future;
            }
            CompletableFuture<Void> eFuture = new CompletableFuture<Void>();
            eFuture.complete(null);
            return eFuture;
        }
        catch (Throwable e) {
            CompletableFuture<Void> eFuture = new CompletableFuture<Void>();
            eFuture.completeExceptionally(e);
            return eFuture;
        }
    }

    protected void doRun() {
        if (this.currentIndex == this.httpServerFilters.size()) {
            this.future.complete(null);
            return;
        }
        HttpServerFilter httpServerFilter = this.httpServerFilters.get(this.currentIndex);
        ++this.currentIndex;
        CompletableFuture<Void> stepFuture = this.safeInvoke(httpServerFilter);
        stepFuture.whenComplete((v, e) -> {
            if (e == null) {
                this.doRun();
                return;
            }
            this.future.completeExceptionally((Throwable)e);
        });
    }
}

